/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import com.zipow.annotate.ISAnnotateDraw;
import us.zoom.videomeetings.R;

public class SpolightCtl
extends ISAnnotateDraw {
    private Point mSpotPoint = new Point();
    private Bitmap mSpotBitmap = null;

    public SpolightCtl(int penSize, int penColor, int alpha) {
    }

    @Override
    public void setResources(Resources res) {
        this.mSpotBitmap = BitmapFactory.decodeResource((Resources)res, (int)R.drawable.zm_share_spot);
    }

    @Override
    public void draw(Canvas canvas) {
        if (canvas == null || this.mSpotBitmap == null || this.mSpotBitmap.getWidth() <= 0 || this.mSpotBitmap.getWidth() <= 0) {
            return;
        }
        if (this.mSpotPoint != null) {
            float xRadioSize = this.mSpotBitmap.getWidth() / 2;
            float left = (float)this.mSpotPoint.x - xRadioSize;
            float right = (float)this.mSpotPoint.x + xRadioSize;
            if (right > (float)canvas.getWidth()) {
                left = canvas.getWidth() - this.mSpotBitmap.getWidth();
            }
            if (left < 0.0f) {
                left = 0.0f;
            }
            float yRadioSize = this.mSpotBitmap.getHeight() / 2;
            float top = (float)this.mSpotPoint.y - yRadioSize;
            float bottom = (float)this.mSpotPoint.y + yRadioSize;
            if (bottom > (float)canvas.getHeight()) {
                top = canvas.getHeight() - this.mSpotBitmap.getHeight();
            }
            if (top < 0.0f) {
                top = 0.0f;
            }
            canvas.drawBitmap(this.mSpotBitmap, left, top, null);
        }
    }

    @Override
    public void touchDown(float x, float y) {
        this.mSpotPoint.set((int)x, (int)y);
    }

    @Override
    public void touchMove(float x, float y) {
        this.mSpotPoint.set((int)x, (int)y);
    }

    @Override
    public void touchUp(float x, float y) {
        this.mSpotPoint.set((int)x, (int)y);
    }
}

