/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.ISAnnotateDraw;
import java.util.List;

public class PolygonCtl
extends ISAnnotateDraw {
    private Path m_path = new Path();
    private Paint mPaint = new Paint();
    private AnnoToolType m_type = AnnoToolType.ANNO_TOOL_NONE_DRAWING;

    public PolygonCtl(float penSize, int penColor, int alpha) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(penColor);
        this.mPaint.setAlpha(alpha);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.MITER);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(penSize);
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            canvas.drawPath(this.m_path, this.mPaint);
        }
    }

    @Override
    public void touchDown(float x, float y) {
    }

    @Override
    public void touchMove(float x, float y) {
    }

    @Override
    public void touchUp(float x, float y) {
    }

    @Override
    public void setToolType(AnnoToolType type) {
        this.m_type = type;
        if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_STAMP_ARROW == this.m_type || AnnoToolType.ANNO_TOOL_TYPE_ARROW == this.m_type) {
            this.mPaint.setStyle(Paint.Style.FILL);
        }
    }

    @Override
    public void setAnnoPoints(List<AnnoPoint> annoPoints) {
        for (int i = 0; i < annoPoints.size(); ++i) {
            int x = annoPoints.get(i).getX();
            int y = annoPoints.get(i).getY();
            if (AnnoToolType.ANNO_TOOL_TYPE_AUTO_STAMP_X == this.m_type) {
                if (i % 2 != 1) {
                    this.m_path.moveTo((float)x, (float)y);
                    continue;
                }
                this.m_path.lineTo((float)x, (float)y);
                continue;
            }
            if (0 == i) {
                this.m_path.moveTo((float)x, (float)y);
                continue;
            }
            this.m_path.lineTo((float)x, (float)y);
        }
    }
}

