/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.ISAnnotateDraw;
import java.util.List;

public class EraserCtl
extends ISAnnotateDraw {
    private Path m_path = new Path();
    private Paint mPaint = new Paint();
    private float mX = 0.0f;
    private float mY = 0.0f;
    private static final float TOUCH_TOLERANCE = 20.0f;

    public EraserCtl(float penSize, int penColor, int alpha) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(12.0f);
        this.mPaint.setColor(Color.argb((int)255, (int)150, (int)255, (int)255));
        this.mPaint.setAlpha(200);
    }

    @Override
    public void cleanAll() {
        this.m_path.reset();
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            canvas.drawPath(this.m_path, this.mPaint);
        }
    }

    @Override
    public void touchDown(float x, float y) {
        this.m_path.moveTo(x, y);
        this.m_path.lineTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    @Override
    public void touchMove(float x, float y) {
        this.m_path.reset();
        this.m_path.moveTo(x, y);
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 20.0f || dy >= 20.0f) {
            this.m_path.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.mX = x;
            this.mY = y;
        }
    }

    @Override
    public void touchUp(float x, float y) {
        this.m_path.reset();
    }

    @Override
    public void setAnnoPoints(List<AnnoPoint> annoPoints) {
    }
}

