/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.TextPaint;
import android.text.TextUtils;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.ISAnnotateDraw;
import java.util.List;

public class ArrowCtl
extends ISAnnotateDraw {
    private Path m_path = new Path();
    Paint titlePaint = new Paint();
    private Paint mPaint = new Paint();
    private int m_titlePosX = 0;
    private int m_titlePosY = 0;
    private String m_title = "";
    private int m_titleWidth = 0;

    public ArrowCtl(float penSize, int penColor, int alpha) {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(penColor);
        this.mPaint.setAlpha(alpha);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeJoin(Paint.Join.MITER);
        this.mPaint.setStrokeWidth(penSize);
        int r = Color.red((int)penColor);
        int g = Color.green((int)penColor);
        int b = Color.green((int)penColor);
        int y = (66 * r + 129 * g + 25 * b + 128 >> 8) + 16;
        if (y > 128) {
            this.titlePaint.setColor(-16777216);
        } else {
            this.titlePaint.setColor(-1);
        }
        this.titlePaint.setTextSize(10.0f);
        this.titlePaint.setAntiAlias(true);
        this.titlePaint.setDither(true);
        this.titlePaint.setAlpha(alpha);
        this.titlePaint.setStyle(Paint.Style.FILL);
        this.titlePaint.setStrokeJoin(Paint.Join.MITER);
        this.titlePaint.setStrokeWidth(penSize);
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            canvas.drawPath(this.m_path, this.mPaint);
            this.m_title = TextUtils.ellipsize((CharSequence)this.m_title, (TextPaint)new TextPaint(this.titlePaint), (float)this.m_titleWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
            canvas.drawText(this.m_title, (float)this.m_titlePosX, (float)this.m_titlePosY, this.titlePaint);
        }
    }

    @Override
    public void touchDown(float x, float y) {
    }

    @Override
    public void touchMove(float x, float y) {
    }

    @Override
    public void touchUp(float x, float y) {
    }

    @Override
    public void setAnnoPoints(List<AnnoPoint> annoPoints) {
        for (int i = 0; i < annoPoints.size(); ++i) {
            int x = annoPoints.get(i).getX();
            int y = annoPoints.get(i).getY();
            if (0 == i) {
                this.m_path.moveTo((float)x, (float)y);
                continue;
            }
            this.m_path.lineTo((float)x, (float)y);
        }
    }

    @Override
    public void setArrowData(int titleLeft, int titleTop, int titleRight, int titleBottom, String title) {
        this.m_title = title;
        this.m_titleWidth = titleRight - titleLeft;
        this.m_titlePosX = titleLeft + (titleRight - titleLeft) / 2;
        Paint.FontMetrics fontMetrics = this.titlePaint.getFontMetrics();
        float top = fontMetrics.top;
        float bottom = fontMetrics.bottom;
        int y = titleBottom - (titleBottom - titleTop) / 2;
        this.m_titlePosY = (int)((float)y - top / 2.0f - bottom / 2.0f);
    }

    @Override
    public void setTextSize(int textSize) {
        this.titlePaint.setTextSize((float)textSize);
        this.titlePaint.setTextAlign(Paint.Align.CENTER);
    }
}

