/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.zipow.annotate.AnnoDrawObj;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.AnnotateTextData;
import com.zipow.annotate.ArrowCtl;
import com.zipow.annotate.AutoArrow;
import com.zipow.annotate.AutoShapeCtl;
import com.zipow.annotate.EraserCtl;
import com.zipow.annotate.FillPathCtl;
import com.zipow.annotate.ISAnnotateDraw;
import com.zipow.annotate.PenCtl;
import com.zipow.annotate.PolygonCtl;
import com.zipow.annotate.SpolightCtl;
import com.zipow.annotate.TextCtl;
import com.zipow.annotate.ZoomAnnotate;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.share.IDrawingViewListener;
import com.zipow.videobox.share.ZMDrawObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;

public class AnnotateView
extends SurfaceView
implements SurfaceHolder.Callback,
ZoomAnnotate.IZoomAnnotateUIListener {
    private ISAnnotateDraw m_curAnnoTool = null;
    private ISAnnotateDraw m_annoTool = null;
    private ISAnnotateDraw m_spolightTool = null;
    private GestureDetector m_gestureDetector;
    private List<String> m_myDrawList;
    private Runnable m_drawRunnable;
    private Runnable m_clearAndDrawRunnable;
    private int m_statusBarHeight = 0;
    private int m_width = 2;
    private int m_hLLineWidth = 12;
    private int m_hLLineAlpha = 97;
    private int m_color = ZMDrawObject.DFT_CLR;
    private int m_alpha = 255;
    private float m_scale = 1.0f;
    private float m_dpiScale = 2.0f;
    private float m_offsetX = 0.0f;
    private float m_offsetY = 0.0f;
    private Canvas m_backgroundCanvas;
    private Canvas m_spolightCanvas;
    private Paint m_bitmapPaint = null;
    private Path m_annoFillPath = null;
    private Bitmap m_backgroundImage = null;
    private Bitmap m_spolightImage = null;
    private float m_startX = 0.0f;
    private float m_startY = 0.0f;
    private float m_curX = 0.0f;
    private float m_curY = 0.0f;
    private float m_transformX = 0.0f;
    private float m_transformY = 0.0f;
    private boolean m_isUp = true;
    private boolean m_bChangToEraser = false;
    private boolean m_bPresenter = false;
    private boolean m_bEditStatus = false;
    private Handler m_Handler = new Handler();
    private boolean m_bInit = false;
    private boolean m_bShareScreen = false;
    private boolean m_bDrawFinished = true;
    private List<AnnoDrawObj> m_annoDrawObjList;
    private HashSet<IDrawingViewListener> m_listeners;
    private AnnoToolType m_curToolType = AnnoToolType.ANNO_TOOL_TYPE_PEN;
    private SurfaceHolder m_surfaceHolder = null;
    private static final int DEFAULT_FONT_TEXT_SIZE = 10;
    private static final String TAG = AnnotateView.class.getSimpleName();

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.drawFaceView();
        this.onRepaint();
        this.onLongPressed(false);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public AnnotateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AnnotateView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.initRunnable();
        this.m_bitmapPaint = new Paint(1);
        this.m_spolightTool = new SpolightCtl(0, 0, 0);
        this.m_spolightTool.setResources(this.getResources());
        this.m_annoDrawObjList = new ArrayList<AnnoDrawObj>();
        this.m_myDrawList = new ArrayList<String>();
        this.m_listeners = new HashSet();
        this.m_curAnnoTool = this.getAnnoTool(this.m_curToolType, this.m_width, this.m_color, this.m_alpha);
        this.m_surfaceHolder = this.getHolder();
        this.m_surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.m_surfaceHolder.setFormat(-2);
        this.setZOrderOnTop(true);
        this.m_gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GuestureListener());
        this.m_gestureDetector.setIsLongpressEnabled(true);
    }

    public boolean isAnnotateInit() {
        return this.m_bInit;
    }

    private void initRunnable() {
        this.m_drawRunnable = new Runnable(){

            @Override
            public void run() {
                AnnotateView.this.clear();
            }
        };
    }

    private void startTimer(Runnable runnable, int delayMillis) {
        this.m_Handler.removeCallbacks(runnable);
        this.m_Handler.postDelayed(runnable, (long)delayMillis);
    }

    public void setIsPresenter(boolean bPresenter) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            this.m_bPresenter = bPresenter;
            if (this.m_bPresenter) {
                this.m_scale = 1.0f;
            }
            this.m_isUp = true;
            mgr.setIsPresenter(this.m_bPresenter);
            ZoomShareData.getInstance().setIsPresenter(this.m_bPresenter);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (UiModeUtil.isInDesktopMode((Context)this.getContext())) {
            int width = right - left;
            int height = bottom - top;
            this.initBackgroundCanvasSize(width, height);
            if (AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT == this.m_curToolType) {
                this.initSpolightCanvasSize(width, height);
            }
        }
    }

    public void startAnnotation(boolean bShareScreen) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            this.m_bShareScreen = bShareScreen;
            this.m_statusBarHeight = this.m_bShareScreen ? this.getStatusBarHeight() : 0;
            this.m_dpiScale = mgr.getPrimaryDpiScale();
            long nativeHandle = mgr.getNativeHandle();
            long viewHandle = ZoomShareData.getInstance().getViewHandle();
            if (nativeHandle != 0L && (this.m_bPresenter || !this.m_bPresenter && viewHandle != 0L)) {
                mgr.addListener(this);
                this.setCurAnnoTool(this.m_curToolType);
                this.setToolWidth(this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER ? this.m_hLLineWidth : this.m_width, false);
                this.setToolColor(this.m_color);
                this.m_bInit = true;
            }
        }
    }

    public void stopAnnotation() {
        this.setEditModel(false);
        this.clear();
        this.destroyBackgroundCanvas();
        this.destroySpolightCanvas();
        this.m_bInit = false;
        this.m_bPresenter = false;
        this.m_myDrawList.clear();
        this.m_annoDrawObjList.clear();
        this.m_bDrawFinished = true;
    }

    private void destroyBackgroundCanvas() {
        if (this.m_backgroundImage != null) {
            this.m_backgroundImage.recycle();
            this.m_backgroundImage = null;
        }
        this.m_backgroundCanvas = null;
    }

    private void destroySpolightCanvas() {
        if (this.m_spolightImage != null) {
            this.m_spolightImage.recycle();
            this.m_spolightImage = null;
        }
        this.m_spolightCanvas = null;
    }

    public void setScaleAndOffsetValue(float scale, float offsetX, float offsetY) {
        this.m_scale = scale;
        this.m_offsetX = offsetX;
        this.m_offsetY = offsetY;
    }

    public void registerUpdateListener(IDrawingViewListener listener) {
        if (listener == null) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public void unRegisterUpdateListener(IDrawingViewListener listener) {
        if (listener == null) {
            return;
        }
        this.m_listeners.remove(listener);
    }

    public void clearUpdateListener() {
        this.m_listeners.clear();
    }

    public void initBackgroundCanvasSize(int width, int height) {
        if (width <= 0 || width > 5000 || height <= 0 || height > 5000) {
            return;
        }
        if (null != this.m_backgroundImage) {
            if (this.m_backgroundImage.getWidth() != width || this.m_backgroundImage.getHeight() != height) {
                this.destroyBackgroundCanvas();
            } else {
                return;
            }
        }
        if (null == this.m_backgroundImage) {
            try {
                this.m_backgroundImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.m_backgroundCanvas = new Canvas(this.m_backgroundImage);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
    }

    private void initSpolightCanvasSize(int width, int height) {
        if (width <= 0 || width > 5000 || height <= 0 || height > 5000) {
            return;
        }
        if (null != this.m_spolightImage) {
            if (this.m_spolightImage.getWidth() != width || this.m_spolightImage.getHeight() != height) {
                this.destroySpolightCanvas();
            } else {
                return;
            }
        }
        if (null == this.m_spolightImage) {
            try {
                this.m_spolightImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                this.m_spolightCanvas = new Canvas(this.m_spolightImage);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
    }

    public void setCurAnnoTool(AnnoToolType type) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            if (null != this.m_spolightImage && this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT && this.m_curToolType != type) {
                this.m_bChangToEraser = true;
                this.m_spolightImage.eraseColor(0);
                this.drawFaceView();
                this.onRepaint();
                this.destroySpolightCanvas();
            } else if (null != this.m_backgroundImage && AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT == type) {
                this.initSpolightCanvasSize(this.m_backgroundImage.getWidth(), this.m_backgroundImage.getHeight());
            }
            this.m_curToolType = type;
            if (type == AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER) {
                this.setToolWidth(this.m_hLLineWidth, false);
            } else {
                this.setToolWidth(this.m_width, false);
            }
            mgr.setAnnoTool(type.ordinal());
        }
    }

    public void undo() {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            mgr.undo();
        }
    }

    public void redo() {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            mgr.redo();
        }
    }

    public void doneButtonClicked() {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            mgr.touchDown(0.0f, 0.0f);
        }
    }

    public float getPrimaryDpiScale() {
        ZoomAnnotate obj = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != obj) {
            return obj.getPrimaryDpiScale();
        }
        return 1.0f;
    }

    public void editTextDidEndEditing(short[] textShortArray, AnnotateTextData textData) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            mgr.editTextDidEndEditing(textShortArray, textData);
        }
    }

    public void setToolColor(int color) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        this.m_color = color;
        int alpha = this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER ? this.m_hLLineAlpha : this.m_alpha;
        color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        mgr.setAnnoColor(color);
    }

    public void setToolWidth(int width, boolean updateAllWidth) {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            if (updateAllWidth) {
                this.m_width = this.m_hLLineWidth = width;
            } else if (this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER) {
                this.m_hLLineWidth = width;
            } else {
                this.m_width = width;
            }
            mgr.setAnnoWidth(width);
        }
    }

    public void setHighlightToolWidth(int width) {
        this.m_hLLineWidth = width;
    }

    public int getCurrentWidth() {
        int width;
        switch (this.m_curToolType) {
            case ANNO_TOOL_TYPE_HIGHLIGHTER: {
                width = this.m_hLLineWidth;
                break;
            }
            default: {
                width = this.m_width;
            }
        }
        return width;
    }

    public int getCurrentColor() {
        return this.m_color;
    }

    public ISAnnotateDraw getAnnoTool(AnnoToolType type, float width, int color, int alpha) {
        switch (type) {
            case ANNO_TOOL_TYPE_SPOTLIGHT: {
                this.m_annoTool = this.m_spolightTool;
                if (null == this.m_spolightImage) break;
                this.m_spolightImage.eraseColor(0);
                this.drawFaceView();
                this.onRepaint();
                break;
            }
            case ANNO_TOOL_TYPE_PEN: {
                this.m_annoTool = new PenCtl(width, color, alpha);
                break;
            }
            case ANNO_TOOL_TYPE_HIGHLIGHTER: {
                this.m_annoTool = new PenCtl(width, color, alpha);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_LINE: 
            case ANNO_TOOL_TYPE_AUTO_ELLIPSE: 
            case ANNO_TOOL_TYPE_AUTO_ELLIPSE_SEMI_FILL: 
            case ANNO_TOOL_TYPE_AUTO_ELLIPSE_FILL: 
            case ANNO_TOOL_TYPE_AUTO_RECTANGLE: 
            case ANNO_TOOL_TYPE_AUTO_RECTANGLE_SEMI_FILL: 
            case ANNO_TOOL_TYPE_AUTO_RECTANGLE_FILL: {
                this.m_annoTool = new AutoShapeCtl(width, color, alpha);
                this.m_annoTool.setToolType(type);
                break;
            }
            case ANNO_TOOL_TYPE_ARROW: {
                this.m_annoTool = new ArrowCtl(width, color, alpha);
                this.m_annoTool.setToolType(type);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_STAMP_ARROW: 
            case ANNO_TOOL_TYPE_AUTO_STAMP_X: 
            case ANNO_TOOL_TYPE_AUTO_STAMP_CHECK: 
            case ANNO_TOOL_TYPE_AUTO_DIAMOND: {
                this.m_annoTool = new PolygonCtl(width, color, alpha);
                break;
            }
            case ANNO_TOOL_TYPE_MULTI_THICKNESS_PEN: 
            case ANNO_TOOL_TYPE_MULTI_THICKNESS_ERASER: {
                this.m_annoTool = new FillPathCtl(width, color, alpha);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_ARROW2: {
                this.m_annoTool = new AutoArrow(width, color, 128);
                this.m_annoTool.setToolType(type);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_ARROW1: 
            case ANNO_TOOL_TYPE_AUTO_DOUBLE_ARROW: {
                this.m_annoTool = new AutoArrow(width, color, alpha);
                this.m_annoTool.setToolType(type);
                break;
            }
            case ANNO_TOOL_TYPE_ERASER: {
                this.m_annoTool = new EraserCtl(width, color, alpha);
                break;
            }
            case ANNO_TOOL_TYPE_TEXTBOX: {
                this.m_annoTool = new TextCtl(width, color, alpha);
                break;
            }
            default: {
                this.m_annoTool = new PenCtl(width, color, alpha);
            }
        }
        return this.m_annoTool;
    }

    public AnnoToolType getCurAnnoToolType() {
        return this.m_curToolType;
    }

    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        if (this.m_backgroundImage != null) {
            canvas.drawBitmap(this.m_backgroundImage, 0.0f, 0.0f, null);
        }
        if (null != this.m_spolightImage && this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT) {
            canvas.drawBitmap(this.m_spolightImage, 0.0f, 0.0f, null);
        }
    }

    private void onRepaint() {
        for (IDrawingViewListener listener : this.m_listeners) {
            listener.onRepaint();
        }
    }

    private boolean onLongPressed(boolean bLongClieked) {
        if (!this.m_bPresenter || AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX == this.m_curToolType) {
            return false;
        }
        for (IDrawingViewListener listener : this.m_listeners) {
            listener.onLongPressed(bLongClieked);
        }
        return true;
    }

    public void setEditModel(boolean bEidt) {
        this.m_bEditStatus = bEidt;
        if (!this.m_bEditStatus && !this.m_bPresenter) {
            this.clear();
        }
    }

    public void eraserAll() {
        this.clear();
        ZoomAnnotate obj = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != obj) {
            obj.clearAll();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int y;
        Rect annoRect = new Rect(0, 0, 0, 0);
        this.getDrawingRect(annoRect);
        if (!this.m_bEditStatus || !this.m_bInit) {
            return false;
        }
        int x = (int)event.getX();
        if (annoRect.contains(x, y = (int)event.getY())) {
            this.m_curX = event.getX();
            this.m_curY = event.getY();
        } else if (event.getAction() == 2 || event.getAction() == 0) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.touchDown();
                break;
            }
            case 2: {
                this.touchMove(event);
                break;
            }
            case 1: {
                this.touchUp();
                this.onRepaint();
            }
        }
        this.drawFaceView();
        this.m_gestureDetector.onTouchEvent(event);
        return true;
    }

    private void touchDown() {
        ZoomAnnotate obj = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != obj) {
            this.m_startX = this.m_curX;
            this.m_startY = this.m_curY;
            this.m_transformX = (this.m_curX + this.m_offsetX) * this.m_scale;
            this.m_transformY = (this.m_curY + this.m_offsetY) * this.m_scale + (float)this.m_statusBarHeight;
            obj.touchDown(this.m_transformX, this.m_transformY);
            this.m_curAnnoTool = this.getAnnoTool(this.m_curToolType, this.getCurToolWidth(), this.m_color, this.getCurToolAlpha());
            if (null != this.m_curAnnoTool && AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX != this.m_curToolType) {
                this.m_curAnnoTool.touchDown(this.m_curX, this.m_curY);
            }
        }
    }

    private void touchMove(MotionEvent ev) {
        ZoomAnnotate obj = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != obj) {
            if (this.m_bPresenter) {
                float offsetX = Math.abs(this.m_curX - this.m_startX);
                float offsetY = Math.abs(this.m_curY - this.m_startY);
                int px = UIUtil.dip2px((Context)this.getContext(), (float)10.0f);
                if (offsetX >= (float)px || offsetY >= (float)px) {
                    this.onLongPressed(false);
                }
            }
            if (null == this.m_curAnnoTool) {
                return;
            }
            int historySize = ev.getHistorySize();
            for (int h = 0; h < historySize; ++h) {
                int x = (int)ev.getHistoricalX(0, h);
                int y = (int)ev.getHistoricalY(0, h);
                if (AnnoToolType.ANNO_TOOL_TYPE_ERASER != this.m_curToolType) {
                    this.m_curAnnoTool.touchMove(x, y);
                }
                obj.touchMove(((float)x + this.m_offsetX) * this.m_scale, ((float)y + this.m_offsetY) * this.m_scale + (float)this.m_statusBarHeight);
            }
            int x = (int)ev.getX(0);
            int y = (int)ev.getY(0);
            this.m_isUp = false;
            this.m_curAnnoTool.touchMove(x, y);
            obj.touchMove(((float)x + this.m_offsetX) * this.m_scale, ((float)y + this.m_offsetY) * this.m_scale + (float)this.m_statusBarHeight);
        }
    }

    private void touchUp() {
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            this.m_isUp = true;
            if (null == this.m_curAnnoTool || null == this.m_backgroundCanvas) {
                return;
            }
            float pointX = (this.m_curX + this.m_offsetX) * this.m_scale;
            float pointY = (this.m_curY + this.m_offsetY) * this.m_scale + (float)this.m_statusBarHeight;
            this.addMyDrawPointToList((int)pointX, (int)pointY);
            mgr.touchUp(pointX, pointY);
            this.m_curAnnoTool.touchUp(this.m_curX, this.m_curY);
            if (AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT == this.m_curToolType && null != this.m_spolightCanvas) {
                this.m_curAnnoTool.draw(this.m_spolightCanvas);
            } else {
                this.m_curAnnoTool.draw(this.m_backgroundCanvas);
            }
            this.m_curX = 0.0f;
            this.m_curY = 0.0f;
            if (!this.m_bPresenter && AnnoToolType.ANNO_TOOL_TYPE_ERASER != this.m_curToolType) {
                this.startTimer(this.m_drawRunnable, 2500);
            }
        }
    }

    private float getCurToolWidth() {
        int toolWidth = this.m_width;
        switch (this.m_curToolType) {
            case ANNO_TOOL_TYPE_HIGHLIGHTER: {
                toolWidth = this.m_hLLineWidth;
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_ARROW2: {
                toolWidth = 2;
                break;
            }
            default: {
                toolWidth = this.m_width;
            }
        }
        return (float)toolWidth / this.m_scale * this.m_dpiScale;
    }

    private int getCurToolAlpha() {
        if (this.m_curToolType == AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER) {
            return this.m_hLLineAlpha;
        }
        return this.m_alpha;
    }

    private void drawFaceView() {
        if (null == this.m_backgroundImage || null == this.m_curAnnoTool || null == this.m_bitmapPaint || null == this.m_surfaceHolder) {
            return;
        }
        Canvas canvas = null;
        try {
            canvas = this.m_surfaceHolder.lockCanvas();
            if (null != canvas) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                canvas.drawBitmap(this.m_backgroundImage, 0.0f, 0.0f, this.m_bitmapPaint);
                if (AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT == this.m_curToolType && null != this.m_spolightImage) {
                    if (!this.m_isUp) {
                        this.m_spolightImage.eraseColor(0);
                    }
                    canvas.drawBitmap(this.m_spolightImage, 0.0f, 0.0f, this.m_bitmapPaint);
                }
                if (!this.m_isUp && !this.m_bChangToEraser) {
                    this.m_curAnnoTool.draw(canvas);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (canvas != null) {
                this.m_surfaceHolder.unlockCanvasAndPost(canvas);
            }
        }
        this.m_bChangToEraser = false;
    }

    public void clear() {
        if (!this.m_isUp && this.m_bEditStatus && AnnoToolType.ANNO_TOOL_TYPE_ERASER != this.m_curToolType) {
            return;
        }
        if (null != this.m_spolightImage) {
            this.m_spolightImage.eraseColor(0);
        }
        if (null != this.m_backgroundCanvas) {
            this.m_backgroundCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        this.drawFaceView();
    }

    public void drawPolyline(int width, int color, int alpha, List<AnnoPoint> annoPoints) {
        AnnoToolType type = alpha < 255 ? AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER : AnnoToolType.ANNO_TOOL_TYPE_PEN;
        ISAnnotateDraw attendeeTool = this.getAnnoTool(type, width, color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color)), alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        for (int i = 0; i < annoPoints.size(); ++i) {
            float x = annoPoints.get(i).getX();
            float y = annoPoints.get(i).getY();
            if (0 == i) {
                attendeeTool.touchDown(x, y);
                continue;
            }
            if (annoPoints.size() - 1 != i) {
                attendeeTool.touchMove(x, y);
                continue;
            }
            attendeeTool.touchMove(x, y);
            attendeeTool.touchUp(x, y);
            attendeeTool.draw(this.m_backgroundCanvas);
        }
    }

    public void drawAutoShape(int width, int color, int alpha, float startX, float startY, float endX, float endY, int toolType) {
        color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        AnnoToolType type = AnnoToolType.values()[toolType];
        ISAnnotateDraw attendeeTool = this.getAnnoTool(type, width, color, alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        attendeeTool.setToolType(type);
        attendeeTool.touchDown(startX, startY);
        attendeeTool.touchMove(endX, endY);
        attendeeTool.touchUp(endX, endY);
        attendeeTool.draw(this.m_backgroundCanvas);
    }

    public void strokeAutoShapeArrow(int width, int color, int alpha, int toolType, List<AnnoPoint> annoPoints) {
        color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        AnnoToolType type = AnnoToolType.values()[toolType];
        ISAnnotateDraw attendeeTool = this.getAnnoTool(type, width, color, alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        attendeeTool.setToolType(type);
        attendeeTool.setAnnoPoints(annoPoints);
        attendeeTool.draw(this.m_backgroundCanvas);
    }

    public void fillPolygon(int width, int color, int alpha, int toolType, List<AnnoPoint> annoPoints) {
        color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        AnnoToolType type = AnnoToolType.values()[toolType];
        ISAnnotateDraw attendeeTool = this.getAnnoTool(type, width, color, alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        attendeeTool.setToolType(type);
        attendeeTool.setAnnoPoints(annoPoints);
        attendeeTool.draw(this.m_backgroundCanvas);
    }

    public void fillAnnoPath(Path path, int color, int alpha, int toolType) {
        color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        AnnoToolType type = AnnoToolType.values()[toolType];
        ISAnnotateDraw attendeeTool = this.getAnnoTool(type, 4.0f, color, alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        attendeeTool.draw(this.m_backgroundCanvas, path);
    }

    public void drawArrow(int width, int color, int alpha, int titleLeft, int titleTop, int titleRight, int titleBottom, String title, int textSize, List<AnnoPoint> annoPoints) {
        ISAnnotateDraw attendeeTool = this.getAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_ARROW, width, color = Color.argb((int)alpha, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color)), alpha);
        if (null == attendeeTool || null == this.m_backgroundCanvas) {
            return;
        }
        attendeeTool.setArrowData(titleLeft, titleTop, titleRight, titleBottom, title);
        attendeeTool.setAnnoPoints(annoPoints);
        attendeeTool.setTextSize(textSize);
        attendeeTool.draw(this.m_backgroundCanvas);
    }

    public void drawText(String text, int left, int top, int color, boolean isBold, boolean isItalic, int fontSize) {
        if (null == text) {
            return;
        }
        color = Color.argb((int)255, (int)Color.blue((int)color), (int)Color.green((int)color), (int)Color.red((int)color));
        ISAnnotateDraw attendeeTool = this.getAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX, this.m_width, color, 255);
        attendeeTool.setTextData(text, left, top, isBold, isItalic, fontSize);
        attendeeTool.draw(this.m_backgroundCanvas);
    }

    public String adjustText(String receiveText, float textPosX, float endPosX, int size) {
        String[] receiveList = receiveText.split("\n");
        ArrayList<String> strList = new ArrayList<String>();
        for (int index = 0; index < receiveList.length; ++index) {
            String text = receiveList[index];
            String newString = "";
            for (int i = 0; i < text.length(); ++i) {
                newString = newString + text.charAt(i);
                float curStringPos = textPosX + (float)AnnotateView.GetTextWidth(newString, size);
                float textFrameWidth = UIUtil.getDisplayWidth((Context)this.getContext());
                if (textFrameWidth > endPosX) {
                    textFrameWidth = endPosX;
                }
                if (!(curStringPos > textFrameWidth)) continue;
                newString = newString.substring(0, i);
                strList.add(newString);
                int lastIndex = text.length();
                text = text.substring(i, lastIndex);
                i = -1;
                newString = "";
            }
            if (newString.trim().isEmpty()) continue;
            strList.add(newString);
        }
        String newString = "";
        for (int i = 0; i < strList.size(); ++i) {
            newString = i != strList.size() - 1 ? newString + (String)strList.get(i) + "\n" : newString + (String)strList.get(i);
        }
        return newString;
    }

    public static int GetTextWidth(String text, float Size) {
        TextPaint FontPaint = new TextPaint();
        FontPaint.setTextSize(Size);
        return (int)FontPaint.measureText(text);
    }

    private void addMyDrawPointToList(int endX, int endY) {
        if (this.m_bShareScreen) {
            String pointStr = String.valueOf((int)this.m_transformX) + String.valueOf((int)this.m_transformY) + String.valueOf(endX) + String.valueOf(endY);
            this.m_myDrawList.add(pointStr);
        }
    }

    private boolean checkIsMyDraw(ArrayList<String> list) {
        String start = list.get(0).trim().replace(",", "");
        String last = list.get(list.size() - 1).trim().replace(",", "");
        String receivePointStr = start + last;
        return this.m_myDrawList.contains(receivePointStr);
    }

    private boolean checkIsMyDraw(int startX, int startY, int endX, int endY) {
        String receivePointStr = String.valueOf(startX) + String.valueOf(startY) + String.valueOf(endX) + String.valueOf(endY);
        return this.m_myDrawList.contains(receivePointStr);
    }

    @Override
    public void clearAllAnnodateData() {
        if (!this.m_bDrawFinished) {
            this.m_annoDrawObjList.clear();
        }
    }

    @Override
    public void addDrawObjToList(Bundle data) {
        int endY;
        int endX;
        int startY;
        int startX;
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (data.isEmpty() || null == mgr) {
            return;
        }
        AnnoDrawObj obj = new AnnoDrawObj();
        ArrayList list = data.getStringArrayList(mgr.KEY_TOOL_LIST);
        obj.annoPoints = new ArrayList<AnnoPoint>();
        int scal = 1;
        if (null != list && !list.isEmpty()) {
            if (this.m_bShareScreen && !this.checkIsMyDraw(list) && ZoomShareData.getInstance().getIsHDPI()) {
                scal = 2;
            }
            for (int i = 0; i < list.size(); ++i) {
                String[] point = ((String)list.get(i)).toString().split(",");
                if (null == point) continue;
                int pointX = Integer.parseInt(point[0]) * scal;
                int pointY = Integer.parseInt(point[1]) * scal - this.m_statusBarHeight;
                AnnoPoint annoPoint = new AnnoPoint(pointX, pointY);
                obj.annoPoints.add(annoPoint);
            }
        } else if (this.m_bShareScreen && !this.checkIsMyDraw(startX = (int)data.getFloat(mgr.KEY_TOOL_START_X), startY = (int)data.getFloat(mgr.KEY_TOOL_START_Y), endX = (int)data.getFloat(mgr.KEY_TOOL_END_X), endY = (int)data.getFloat(mgr.KEY_TOOL_END_Y)) && ZoomShareData.getInstance().getIsHDPI()) {
            scal = 2;
        }
        obj.toolType = data.getInt(mgr.KEY_TOOL_TYPE);
        obj.width = data.getInt(mgr.KEY_TOOL_WIDTH);
        if (obj.toolType != AnnoToolType.ANNO_TOOL_TYPE_AUTO_ARROW2.ordinal()) {
            obj.width *= scal;
        }
        obj.color = data.getInt(mgr.KEY_TOOL_COLOR);
        obj.alpha = data.getInt(mgr.KEY_TOOL_ALPHA);
        obj.startX = data.getFloat(mgr.KEY_TOOL_START_X) * (float)scal;
        obj.startY = data.getFloat(mgr.KEY_TOOL_START_Y) * (float)scal - (float)this.m_statusBarHeight;
        obj.endX = data.getFloat(mgr.KEY_TOOL_END_X) * (float)scal;
        obj.endY = data.getFloat(mgr.KEY_TOOL_END_Y) * (float)scal - (float)this.m_statusBarHeight;
        obj.text = data.getString(mgr.KEY_TOOL_TEXT);
        obj.fontSize = data.getInt(mgr.KEY_TOOL_FONT_SIZE);
        obj.fontSize = obj.fontSize == 0 ? 10 * scal : (obj.fontSize *= scal);
        short[] textShortArray = data.getShortArray(mgr.KEY_TOOL_TEXT_SHORT_LIST);
        if (null != textShortArray && textShortArray.length > 0) {
            String text = "";
            for (int i = 0; i < textShortArray.length; ++i) {
                short sh = textShortArray[i];
                text = sh == 13 ? text + "\n" : text + (char)sh;
                obj.text = this.adjustText(text, obj.startX, obj.endX, obj.fontSize);
            }
            obj.isBold = data.getBoolean(mgr.KEY_TOOL_BOLD);
            obj.isItalic = data.getBoolean(mgr.KEY_TOOL_ITALIC);
        }
        if ((AnnoToolType.ANNO_TOOL_TYPE_MULTI_THICKNESS_PEN == AnnoToolType.values()[obj.toolType] || AnnoToolType.ANNO_TOOL_TYPE_MULTI_THICKNESS_ERASER == AnnoToolType.values()[obj.toolType]) && null != this.m_annoFillPath) {
            obj.path = this.m_annoFillPath;
        }
        this.m_annoDrawObjList.add(obj);
    }

    @Override
    public void clearAndDrawAllPath() {
        if (null != this.m_clearAndDrawRunnable) {
            this.removeCallbacks(this.m_clearAndDrawRunnable);
        }
        this.m_clearAndDrawRunnable = new Runnable(){

            @Override
            public void run() {
                AnnotateView.this.refreshAnnotateDrawPath();
            }
        };
        this.m_bDrawFinished = false;
        this.post(this.m_clearAndDrawRunnable);
    }

    private void refreshAnnotateDrawPath() {
        if (!this.m_bPresenter || !this.m_isUp && this.m_curToolType != AnnoToolType.ANNO_TOOL_TYPE_ERASER && this.m_curToolType != AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT) {
            this.m_annoDrawObjList.clear();
            return;
        }
        if (null != this.m_spolightImage) {
            this.m_spolightImage.eraseColor(0);
        }
        if (null != this.m_backgroundCanvas) {
            this.m_backgroundCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        block10: for (int i = 0; i < this.m_annoDrawObjList.size(); ++i) {
            AnnoDrawObj obj = this.m_annoDrawObjList.get(i);
            AnnoToolType type = AnnoToolType.values()[obj.toolType];
            switch (type) {
                case ANNO_TOOL_TYPE_HIGHLIGHTER: 
                case ANNO_TOOL_TYPE_PEN: {
                    this.drawPolyline(obj.width, obj.color, obj.alpha, obj.annoPoints);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_AUTO_LINE: 
                case ANNO_TOOL_TYPE_AUTO_ELLIPSE: 
                case ANNO_TOOL_TYPE_AUTO_ELLIPSE_SEMI_FILL: 
                case ANNO_TOOL_TYPE_AUTO_ELLIPSE_FILL: 
                case ANNO_TOOL_TYPE_AUTO_RECTANGLE: 
                case ANNO_TOOL_TYPE_AUTO_RECTANGLE_SEMI_FILL: 
                case ANNO_TOOL_TYPE_AUTO_RECTANGLE_FILL: {
                    this.drawAutoShape(obj.width, obj.color, obj.alpha, obj.startX, obj.startY, obj.endX, obj.endY, obj.toolType);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_ARROW: {
                    this.drawArrow(obj.width, obj.color, obj.alpha, (int)obj.startX, (int)obj.startY, (int)obj.endX, (int)obj.endY, obj.text, obj.fontSize, obj.annoPoints);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_AUTO_STAMP_ARROW: 
                case ANNO_TOOL_TYPE_AUTO_STAMP_X: 
                case ANNO_TOOL_TYPE_AUTO_STAMP_CHECK: 
                case ANNO_TOOL_TYPE_AUTO_DIAMOND: {
                    this.fillPolygon(obj.width, obj.color, obj.alpha, obj.toolType, obj.annoPoints);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_MULTI_THICKNESS_PEN: 
                case ANNO_TOOL_TYPE_MULTI_THICKNESS_ERASER: {
                    this.fillAnnoPath(obj.path, obj.color, obj.alpha, obj.toolType);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_AUTO_ARROW2: {
                    this.strokeAutoShapeArrow(2, obj.color, 128, obj.toolType, obj.annoPoints);
                    continue block10;
                }
                case ANNO_TOOL_TYPE_AUTO_ARROW1: 
                case ANNO_TOOL_TYPE_AUTO_DOUBLE_ARROW: {
                    this.strokeAutoShapeArrow(obj.width, obj.color, obj.alpha, obj.toolType, obj.annoPoints);
                }
                case ANNO_TOOL_TYPE_TEXTBOX: {
                    this.drawText(obj.text, (int)obj.startX, (int)obj.startY, obj.color, obj.isBold, obj.isItalic, obj.fontSize);
                }
            }
        }
        this.drawFaceView();
        this.onRepaint();
        this.m_annoDrawObjList.clear();
    }

    private int getStatusBarHeight() {
        int statusBarHeight = 0;
        int resourceId = this.getContext().getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getContext().getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight;
    }

    @Override
    public void endEditing() {
        for (IDrawingViewListener listener : this.m_listeners) {
            listener.onEndEditing();
        }
    }

    @Override
    public void beginEditing(int x, int y) {
        for (IDrawingViewListener listener : this.m_listeners) {
            listener.onBeginEditing((int)this.m_startX, (int)this.m_startY);
        }
    }

    @Override
    public void beginPath() {
        this.m_annoFillPath = new Path();
    }

    @Override
    public void closePath() {
        if (null != this.m_annoFillPath) {
            this.m_annoFillPath.close();
        }
    }

    @Override
    public void moveToAbs(float toPosX, float toPosY) {
        if (null != this.m_annoFillPath) {
            this.m_annoFillPath.moveTo(toPosX, toPosY);
        }
    }

    @Override
    public void lineToAbs(float toPosX, float toPosY) {
        if (null != this.m_annoFillPath) {
            this.m_annoFillPath.lineTo(toPosX, toPosY);
        }
    }

    @Override
    public void curveToQuadAbs(float toPosX, float toPosY, float endPosX, float endPosY) {
        if (null != this.m_annoFillPath) {
            this.m_annoFillPath.quadTo(toPosX, toPosY, endPosX, endPosY);
        }
    }

    @Override
    public void curveToCubicAbs(float x1, float y1, float x2, float y2, float x3, float y3) {
        if (null != this.m_annoFillPath) {
            this.m_annoFillPath.cubicTo(x1, y1, x2, y2, x3, y3);
        }
    }

    private class GuestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public void onLongPress(MotionEvent e) {
            AnnotateView.this.onLongPressed(true);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return AnnotateView.this.onLongPressed(false);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return AnnotateView.this.onLongPressed(false);
        }
    }
}

