/*
 * Decompiled with CFR 0.152.
 */
package com.revolverobotics.kubisdk;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.revolverobotics.kubisdk.IKubiManagerDelegate;
import com.revolverobotics.kubisdk.Kubi;
import com.revolverobotics.kubisdk.KubiSearchResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class KubiManager
implements BluetoothAdapter.LeScanCallback {
    private final int RSSI_CONNECT = -80;
    private final int RSSI_DISCONNECT = -100;
    private final int AUTO_SCAN_INTERVAL = 0;
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_DISCONNECTING = 1;
    public static final int STATUS_FINDING = 2;
    public static final int STATUS_CONNECTING = 3;
    public static final int STATUS_CONNECTED = 4;
    public static final int STATUS_RECONNECTING = 5;
    public static final int FAIL_NONE = 0;
    public static final int FAIL_CONNECTION_LOST = 1;
    public static final int FAIL_DISTANCE = 2;
    public static final int FAIL_NO_BLUETOOTH = 3;
    public static final int FAIL_NO_BLE = 4;
    IKubiManagerDelegate mDelegate;
    boolean mAutoFind = false;
    boolean mAutoDisconnect = false;
    Handler mHandler;
    int mFailure = 0;
    int mStatus = 0;
    boolean cancelScan = false;
    int mBluetoothDiscoveryTime = 5000;
    private Context mContext;
    ArrayList<KubiSearchResult> mKubiList = new ArrayList();
    private ArrayList<KubiSearchResult> nearKubis = new ArrayList();
    private ArrayList<String> foundMACs = new ArrayList();
    private BluetoothAdapter adapter;
    private BroadcastReceiver bluetoothBroadcastReceiver;
    private Kubi connectedKubi;
    private BluetoothDevice connectDevice;
    private Runnable fullScanFinish = new Runnable(){

        @Override
        public void run() {
            KubiManager.this.finishScan(true);
        }
    };
    private Runnable findFinish = new Runnable(){

        @Override
        public void run() {
            KubiManager.this.finishScan(false);
        }
    };

    public IKubiManagerDelegate getDelegate() {
        return this.mDelegate;
    }

    public void setDelegate(IKubiManagerDelegate mDelegate) {
        this.mDelegate = mDelegate;
    }

    public Boolean getAutoFind() {
        return this.mAutoFind;
    }

    public void setAutoFind(Boolean mAutoFind) {
        this.mAutoFind = mAutoFind;
    }

    public ArrayList<KubiSearchResult> getKubiList() {
        return this.mKubiList;
    }

    public int getBluetoothDiscoveryTime() {
        return this.mBluetoothDiscoveryTime;
    }

    public void setBluetoothDiscoveryTime(int mBluetoothDiscoveryTime) {
        this.mBluetoothDiscoveryTime = mBluetoothDiscoveryTime;
    }

    public int getFailure() {
        return this.mFailure;
    }

    public int getStatus() {
        return this.mStatus;
    }

    public Kubi getKubi() {
        return this.connectedKubi;
    }

    public KubiManager(Context context, IKubiManagerDelegate delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mHandler = new Handler();
        this.startScanning();
    }

    public KubiManager(Context context, IKubiManagerDelegate delegate, boolean autoFind) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mAutoFind = autoFind;
        this.mHandler = new Handler();
        this.startScanning();
    }

    public void disconnect() {
        if (this.connectedKubi != null) {
            this.setStatus(1);
            this.connectedKubi.disconnect();
        }
    }

    public void connectToKubi(KubiSearchResult device) {
        if (this.connectedKubi != null) {
            Kubi last = this.connectedKubi;
            this.connectedKubi = null;
            last.disconnect();
        }
        Log.i((String)"Kubi Manager", (String)("Connecting to kubi with ID " + device.getName()));
        this.connectDevice = device.getDevice();
        this.setStatus(3);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                KubiManager.this.connectKubi();
            }
        });
    }

    public void findKubi(int delayMs) {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                KubiManager.this.findKubi();
            }
        }, (long)delayMs);
    }

    public void findKubi() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (!bluetoothAdapter.isEnabled()) {
            Log.i((String)"Kubi SDK: findKubi", (String)"Bluetooth not available. Cannot connect to Kubi.");
            this.sendFail(3);
            this.setStatus(0);
            return;
        }
        if (this.mStatus == 0 || this.mStatus == 2) {
            this.mFailure = 0;
            if (this.adapter == null) {
                this.adapter = BluetoothAdapter.getDefaultAdapter();
            }
            this.startScan(false);
            this.setStatus(2);
        }
    }

    private boolean isLocationEnabled() {
        LocationManager lm = (LocationManager)this.mContext.getSystemService("location");
        if (lm == null) {
            return false;
        }
        boolean gpsStatus = lm.isProviderEnabled("gps");
        return gpsStatus;
    }

    public void stopFinding() {
        this.cancelScan = true;
        this.mHandler.removeCallbacks(this.fullScanFinish);
        this.mHandler.removeCallbacks(this.findFinish);
        if (Build.VERSION.SDK_INT >= 23 && !this.isLocationEnabled()) {
            if (this.adapter.isDiscovering()) {
                this.adapter.cancelDiscovery();
                try {
                    this.mContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            this.adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        }
        this.setStatus(0);
    }

    public void findAllKubis() {
        this.mFailure = 0;
        if (this.adapter == null) {
            this.adapter = BluetoothAdapter.getDefaultAdapter();
        }
        this.startScan(true);
    }

    private void setStatus(final int status) {
        if (status != this.mStatus) {
            final int old = this.mStatus;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    KubiManager.this.notifyChangeStatus(old, status);
                }
            });
            this.mStatus = status;
        }
    }

    private void sendFail(final int fail) {
        if (this.mFailure == 0) {
            this.mFailure = fail;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    KubiManager.this.notifyFailure(fail);
                }
            });
        }
    }

    public void onKubiReady(Kubi kubi) {
        if (kubi == this.connectedKubi) {
            this.setStatus(4);
        } else {
            kubi.disconnect();
        }
    }

    public void onKubiDisconnect(Kubi kubi) {
        if (kubi == this.connectedKubi) {
            if (this.mStatus != 1) {
                this.sendFail(1);
                this.setStatus(5);
            } else {
                this.connectedKubi = null;
                this.setStatus(0);
            }
        }
    }

    public void onKubiUpdateRSSI(Kubi kubi, int rssi) {
        if (kubi == this.connectedKubi && rssi < -100 && this.mAutoDisconnect) {
            this.sendFail(2);
            kubi.disconnect();
        }
    }

    private void startScanning() {
        this.adapter = BluetoothAdapter.getDefaultAdapter();
        if (this.adapter != null && this.adapter.isEnabled()) {
            if (this.mAutoFind) {
                this.findKubi(0);
            }
        } else if (this.mDelegate != null) {
            this.sendFail(3);
            this.setStatus(0);
        }
    }

    private void startScan(boolean fullScan) {
        if (this.adapter == null || !this.adapter.isEnabled()) {
            this.sendFail(3);
            return;
        }
        this.cancelScan = false;
        if (fullScan) {
            if (Build.VERSION.SDK_INT >= 23 && !this.isLocationEnabled()) {
                this.mHandler.postDelayed(this.fullScanFinish, (long)this.getBluetoothDiscoveryTime());
            } else {
                this.mHandler.postDelayed(this.fullScanFinish, 2000L);
            }
        } else if (Build.VERSION.SDK_INT >= 23 && !this.isLocationEnabled()) {
            this.mHandler.postDelayed(this.findFinish, (long)this.getBluetoothDiscoveryTime());
        } else {
            this.mHandler.postDelayed(this.findFinish, 2000L);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                KubiManager.this.doScan();
            }
        }).start();
        this.nearKubis.clear();
        this.foundMACs.clear();
    }

    private void finishScan(boolean fullScan) {
        if (Build.VERSION.SDK_INT >= 23 && !this.isLocationEnabled()) {
            if (this.adapter.isDiscovering()) {
                this.adapter.cancelDiscovery();
                try {
                    this.mContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            this.adapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        }
        if (!this.cancelScan) {
            Collections.sort(this.nearKubis, new Comparator<KubiSearchResult>(){

                @Override
                public int compare(KubiSearchResult a, KubiSearchResult b) {
                    return b.getRSSI() - a.getRSSI();
                }
            });
            this.mKubiList = new ArrayList<KubiSearchResult>(this.nearKubis);
            if (!fullScan) {
                KubiSearchResult device;
                boolean kubiFound = false;
                if (this.nearKubis.size() > 0 && (device = this.mKubiList.get(0)) != null && device.getRSSI() > -80) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            KubiManager.this.notifyKubiDeviceFound(device);
                        }
                    });
                    this.setStatus(0);
                    kubiFound = true;
                }
                if (!kubiFound) {
                    if (this.mAutoFind) {
                        this.findKubi(0);
                    } else {
                        this.setStatus(0);
                    }
                }
            } else {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        KubiManager.this.notifyScanComplete(KubiManager.this.nearKubis);
                    }
                });
            }
        }
    }

    private void doScan() {
        if (!this.cancelScan) {
            boolean result = false;
            if (Build.VERSION.SDK_INT >= 23 && !this.isLocationEnabled()) {
                if (this.adapter.isDiscovering()) {
                    this.adapter.cancelDiscovery();
                    try {
                        this.mContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.bluetoothBroadcastReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        String action = intent.getAction();
                        if ("android.bluetooth.device.action.FOUND".equals(action)) {
                            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                            short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)Short.MIN_VALUE);
                            if (!KubiManager.this.foundMACs.contains(device.getAddress())) {
                                KubiManager.this.foundMACs.add(device.getAddress());
                                try {
                                    String prefix = device.getName().substring(0, 4);
                                    if (prefix.equals("kubi") || prefix.equals("Rev-")) {
                                        KubiSearchResult result = new KubiSearchResult(device, rssi);
                                        KubiManager.this.nearKubis.add(result);
                                        if (KubiManager.this.mStatus == 2 && rssi > -80) {
                                            KubiManager.this.mHandler.removeCallbacks(KubiManager.this.findFinish);
                                            KubiManager.this.mHandler.post(KubiManager.this.findFinish);
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        if ("android.bluetooth.adapter.action.DISCOVERY_STARTED".equals(action)) {
                            // empty if block
                        }
                    }
                };
                IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
                filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
                this.mContext.registerReceiver(this.bluetoothBroadcastReceiver, filter);
                result = this.adapter.startDiscovery();
            } else {
                result = this.adapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
            }
            if (!result) {
                this.sendFail(4);
            }
        }
    }

    private void connectKubi() {
        if (this.connectDevice != null) {
            this.connectedKubi = new Kubi(this.mContext, this, this.connectDevice);
        }
    }

    private void notifyChangeStatus(int oldStatus, int newStatus) {
        if (this.mDelegate != null) {
            this.mDelegate.kubiManagerStatusChanged(this, oldStatus, newStatus);
        }
    }

    private void notifyFailure(int reason) {
        if (this.mDelegate != null) {
            this.mDelegate.kubiManagerFailed(this, reason);
        }
    }

    private void notifyKubiDeviceFound(KubiSearchResult device) {
        if (this.mDelegate != null) {
            this.mDelegate.kubiDeviceFound(this, device);
        }
    }

    private void notifyScanComplete(ArrayList<KubiSearchResult> list) {
        if (this.mDelegate != null) {
            this.mDelegate.kubiScanComplete(this, list);
        }
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] arg2) {
        if (!this.foundMACs.contains(device.getAddress())) {
            this.foundMACs.add(device.getAddress());
            try {
                String prefix = device.getName().substring(0, 4);
                if (prefix.equals("kubi") || prefix.equals("Rev-")) {
                    this.nearKubis.add(new KubiSearchResult(device, rssi));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

