/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ConfigurationInfo;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.zipow.cmmlib.AppContext;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.box.BoxMgr;
import com.zipow.videobox.dropbox.ZMDropbox;
import com.zipow.videobox.googledrive.GoogleDriveMgr;
import com.zipow.videobox.onedrive.OneDriveConfig;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.sdk.PromptProxyServerTaskManager;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.Locale;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.LanguageUtil;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.AccountService;
import us.zoom.sdk.AccoutServiceImpl;
import us.zoom.sdk.InMeetingService;
import us.zoom.sdk.InMeetingServiceImpl;
import us.zoom.sdk.MeetingService;
import us.zoom.sdk.MeetingServiceImpl;
import us.zoom.sdk.MeetingSettingsHelper;
import us.zoom.sdk.MeetingSettingsHelperImpl;
import us.zoom.sdk.PreMeetingService;
import us.zoom.sdk.PreMeetingServiceImpl;
import us.zoom.sdk.ZoomSDKAuthenticationListener;
import us.zoom.sdk.ZoomSDKInitializeListener;
import us.zoom.videomeetings.R;

public class ZoomSDK {
    private static final String TAG = ZoomSDK.class.getSimpleName();
    private static final String KEY_LAST_VERIFIED_APP_KEY = ".last_verified_app_key";
    private static final String KEY_LAST_VERIFIED_APP_SECRET = ".last_verified_app_secret";
    private static final String KEY_IS_APP_VERIFIED = ".is_app_verified";
    private static final String ZOOM_BOX_APP_REDIRECT_URL = "http://localhost";
    private static ZoomSDK instance = null;
    private String mDomain = "zoom.us";
    private Context mContext;
    private MeetingService mMeetingService;
    private PreMeetingService mPreMeetingService;
    private AccountService mAccountService;
    private InMeetingService mInMeetingService;
    private MeetingSettingsHelper mMeetingSettingsHelper;
    private ZoomSDKInitializeListener mInitializeListener;
    private ListenerList mAuthenticationListener = new ListenerList();
    private BroadcastReceiver mNetworkStateReceiver;
    private String mAppKey;
    private String mAppSecret;
    private boolean mbVerifying = false;
    private boolean mbLogining = false;
    private boolean mbAutoRetryVerifyApp = false;
    private Handler mHandler = new Handler();
    private PTUI.ISDKAuthListener mSDKAuthListener = new PTUI.ISDKAuthListener(){

        @Override
        public void onSDKAuth(int result) {
            ZoomSDK.this.onSDKAuth(result);
        }
    };
    private PTUI.IPTUIListener mPTUIListener = new PTUI.IPTUIListener(){

        @Override
        public void onPTAppEvent(int event, long result) {
            switch (event) {
                case 0: {
                    ZoomSDK.this.onSDKLoginReturn(result);
                    break;
                }
                case 1: {
                    ZoomSDK.this.onSDKLogoutReturn(result);
                }
            }
        }

        @Override
        public void onDataNetworkStatusChanged(boolean connected) {
        }
    };
    private PTUI.INotifyZAKListener mNotifyZAKListener = new PTUI.INotifyZAKListener(){

        @Override
        public void notifyZAKRefreshFailed(int result) {
            switch (result) {
                case 1001: 
                case 1134: {
                    if (ZoomSDK.this.isLoggedIn()) {
                        ZoomSDK.this.logoutZoom();
                    }
                    ZoomSDK.this.onZoomIdentityExpired(result);
                }
            }
        }
    };

    private ZoomSDK() {
        PTUI.getInstance().addPTUIListener(this.mPTUIListener);
        PTUI.getInstance().addINotifyZAKListener(this.mNotifyZAKListener);
    }

    public static synchronized ZoomSDK getInstance() {
        if (instance == null) {
            instance = new ZoomSDK();
        }
        return instance;
    }

    public void addAuthenticationListener(ZoomSDKAuthenticationListener listener) {
        this.mAuthenticationListener.add((IListener)listener);
    }

    public void removeAuthenticationListener(ZoomSDKAuthenticationListener listener) {
        this.mAuthenticationListener.remove((IListener)listener);
    }

    public void initialize(Context context, String appKey, String appSecret, ZoomSDKInitializeListener listener) {
        this.initialize(context, appKey, appSecret, this.mDomain, false, listener);
    }

    public void initialize(Context context, String appKey, String appSecret, boolean autoRetryVerifyApp, ZoomSDKInitializeListener listener) {
        this.initialize(context, appKey, appSecret, this.mDomain, autoRetryVerifyApp, listener);
    }

    public void initialize(Context context, String appKey, String appSecret, String domain, ZoomSDKInitializeListener listener) {
        this.initialize(context, appKey, appSecret, domain, false, listener);
    }

    public void initialize(Context context, String appKey, String appSecret, String domain, boolean autoRetryVerifyApp, ZoomSDKInitializeListener listener) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (appKey == null) {
            throw new NullPointerException("appKey cannot be null");
        }
        if (appSecret == null) {
            throw new NullPointerException("appSecret cannot be null");
        }
        if (listener == null) {
            throw new NullPointerException("listener cannot be null");
        }
        if (!this.isInitialized()) {
            if (!this.isDeviceSupported(context)) {
                listener.onZoomSDKInitializeResult(99, 0);
                return;
            }
            this.mContext = context.getApplicationContext();
            if (this.mContext == null) {
                throw new NullPointerException("call getApplicationContext() from the input context returns null");
            }
            VideoBoxApplication.setZoomSDKApplicationContext(this.mContext);
            AppContext.initialize(this.mContext);
            VideoBoxApplication.initialize(this.mContext, true);
        }
        boolean verified = PreferenceUtil.readBooleanValue(this.getPreferenceKeyIsAppVerified(), false);
        String lastKey = PreferenceUtil.readStringValue(this.getPreferenceKeyLastVerifiedAppKey(), null);
        String lastSecret = PreferenceUtil.readStringValue(this.getPreferenceKeyLastVerifiedAppSecret(), null);
        if (this.isInitialized() && verified && StringUtil.isSameString((String)appKey, (String)lastKey) && StringUtil.isSameString((String)appSecret, (String)lastSecret)) {
            Log.w((String)TAG, (String)"initialized twice!!!");
            listener.onZoomSDKInitializeResult(0, 0);
            return;
        }
        this.mInitializeListener = listener;
        this.setDomain(domain);
        this.verifyApp(appKey, appSecret, autoRetryVerifyApp);
    }

    public String getVersion(Context context) {
        if (context == null) {
            throw new NullPointerException("argument context is null");
        }
        return context.getString(R.string.zm_version_name);
    }

    public boolean isDeviceSupported(Context context) {
        boolean glversionSupported;
        if (context == null) {
            throw new NullPointerException("argument context is null");
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        boolean bl = glversionSupported = configurationInfo.reqGlEsVersion >= 131072;
        if (!glversionSupported) {
            Log.w((String)TAG, (String)("isDeviceSupported, GLES version is too low: " + String.format(Locale.US, "0x%05x", configurationInfo.reqGlEsVersion)));
            return false;
        }
        if (Build.CPU_ABI.equals("armeabi") || Build.CPU_ABI.startsWith("armeabi-v6")) {
            Log.w((String)TAG, (String)("isDeviceSupported, CPU ABI is not supported: " + Build.CPU_ABI));
            return false;
        }
        return true;
    }

    public void verifyApp(String appKey, String appSecret, boolean autoRetryVerifyApp) {
        if (appKey == null || appKey.length() == 0 || appSecret == null || appSecret.length() == 0) {
            Log.e((String)TAG, (String)("illegal app key or secret. Key: " + appKey + ", Secret: " + appSecret));
            if (this.mInitializeListener != null) {
                this.mInitializeListener.onZoomSDKInitializeResult(2, 0);
            }
        }
        if (this.mbVerifying) {
            return;
        }
        PTUI.getInstance().addSDKAuthListener(this.mSDKAuthListener);
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
        this.mbAutoRetryVerifyApp = autoRetryVerifyApp;
        this.mbVerifying = true;
        PTApp.getInstance().sdk_Auth(appKey, appSecret);
    }

    public boolean isInitialized() {
        return PTApp.getInstance().getSdkAuthResult() == 0;
    }

    public int loginWithZoom(String email, String password) {
        if (!this.isInitialized()) {
            return 1;
        }
        if (email == null || email.length() == 0 || password == null || password.length() == 0) {
            Log.e((String)TAG, (String)("illegal email or password. email: " + email + ", password: " + password));
            return 6;
        }
        if (this.mbLogining) {
            return 101;
        }
        this.mbLogining = true;
        return PTApp.getInstance().loginZoom(email, password, true);
    }

    public int loginWithSSOToken(String ssoToken) {
        if (!this.isInitialized()) {
            return 1;
        }
        if (ssoToken == null || ssoToken.length() == 0) {
            Log.e((String)TAG, (String)("illegal sso Token. ssoToken: " + ssoToken));
            return 6;
        }
        if (this.mbLogining) {
            return 101;
        }
        this.mbLogining = true;
        return PTApp.getInstance().loginWithSSOToken(ssoToken);
    }

    public boolean logoutZoom() {
        if (!this.isInitialized()) {
            return false;
        }
        PTApp.getInstance().logout(0);
        return true;
    }

    public boolean isLoggedIn() {
        if (!this.isInitialized()) {
            return false;
        }
        return PTApp.getInstance().isWebSignedOn();
    }

    public int tryAutoLoginZoom() {
        if (!this.isInitialized()) {
            return 1;
        }
        if (this.mbLogining) {
            return 101;
        }
        this.mbLogining = true;
        int result = 101;
        if (PTApp.getInstance().getPTLoginType() == 100) {
            result = PTApp.getInstance().loginZoomWithLocalToken();
        } else if (PTApp.getInstance().getPTLoginType() == 101) {
            result = PTApp.getInstance().loginSSOWithLocalToken();
        }
        if (result != 0) {
            this.mbLogining = false;
        }
        return result;
    }

    public void setDomain(String domain) {
        if (domain != null && domain.length() > 0) {
            this.mDomain = domain;
            String siteUrl = "https://" + domain;
            if (domain.startsWith("http://") || domain.startsWith("https://")) {
                siteUrl = domain;
                String[] s = domain.split("://");
                this.mDomain = s[1];
            }
            AppContext appContext = new AppContext("config");
            appContext.setKeyValue("conf.webserver", siteUrl, AppContext.APP_NAME_CHAT);
            appContext.setKeyValue("conf.webserver.before.cn", siteUrl, AppContext.APP_NAME_CHAT);
            PTApp.getInstance().configZoomDomain(siteUrl);
            Log.i((String)TAG, (String)("setDomain, set Zoom domain as " + this.mDomain));
        }
    }

    public String getDomain() {
        return this.mDomain;
    }

    public void setSdkLocale(Context context, Locale locale) {
        LanguageUtil.setAppLocale((Context)context, (Locale)locale);
    }

    public Locale getSdkLocale(Context context) {
        return LanguageUtil.getAppLocale((Context)context);
    }

    public void setShowProxyServerDialogImmediatelyIfNeeded(boolean show) {
        PromptProxyServerTaskManager.getInstance().setRunImmediatelyEnabled(show);
    }

    @Deprecated
    public boolean setDropBoxAppKeyPair(Context context, String appKey, String appSecret) {
        return ZMDropbox.setAppKeyPair(context, appKey, appSecret);
    }

    @Deprecated
    public boolean setOneDriveClientId(Context context, String clientId) {
        return OneDriveConfig.setClientID(context, clientId);
    }

    @Deprecated
    public boolean setBoxAppKeyPair(Context context, String appKey, String appSecret) {
        return BoxMgr.setAppKeyPair(context, appKey, appSecret, ZOOM_BOX_APP_REDIRECT_URL);
    }

    @Deprecated
    public boolean setGoogleDriveInfo(Context context, String clientId, String redirectURL) {
        return GoogleDriveMgr.setClientID(context, clientId) && GoogleDriveMgr.setRedirectURL(context, redirectURL);
    }

    public MeetingService getMeetingService() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.mMeetingService == null) {
            this.mMeetingService = new MeetingServiceImpl(this);
        }
        return this.mMeetingService;
    }

    public AccountService getAccountService() {
        if (!this.isInitialized() || !PTApp.getInstance().isWebSignedOn()) {
            Log.e((String)TAG, (String)"ZoomSdk not initialized or User not login!");
            return null;
        }
        if (this.mAccountService == null) {
            this.mAccountService = new AccoutServiceImpl();
        }
        return this.mAccountService;
    }

    public PreMeetingService getPreMeetingService() {
        if (!this.isInitialized() || !PTApp.getInstance().isWebSignedOn()) {
            Log.e((String)TAG, (String)"ZoomSdk not initialized or User not login!");
            return null;
        }
        if (this.mPreMeetingService == null) {
            this.mPreMeetingService = new PreMeetingServiceImpl(this);
        }
        return this.mPreMeetingService;
    }

    public InMeetingService getInMeetingService() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.mInMeetingService == null) {
            this.mInMeetingService = new InMeetingServiceImpl();
        }
        return this.mInMeetingService;
    }

    public MeetingSettingsHelper getMeetingSettingsHelper() {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.mMeetingSettingsHelper == null) {
            this.mMeetingSettingsHelper = new MeetingSettingsHelperImpl();
        }
        return this.mMeetingSettingsHelper;
    }

    private void onSDKAuth(int result) {
        this.mbVerifying = false;
        if (result == 0) {
            PreferenceUtil.saveBooleanValue(this.getPreferenceKeyIsAppVerified(), true);
            PreferenceUtil.saveStringValue(this.getPreferenceKeyLastVerifiedAppKey(), this.mAppKey);
            PreferenceUtil.saveStringValue(this.getPreferenceKeyLastVerifiedAppSecret(), this.mAppSecret);
            if (this.mInitializeListener != null) {
                this.mInitializeListener.onZoomSDKInitializeResult(0, 0);
            }
            this.mInitializeListener = null;
            this.stopListenNetworkState();
        } else {
            switch (result) {
                case 3023: 
                case 3024: 
                case 3025: {
                    PreferenceUtil.saveBooleanValue(this.getPreferenceKeyIsAppVerified(), false);
                    PreferenceUtil.saveStringValue(this.getPreferenceKeyLastVerifiedAppKey(), null);
                    PreferenceUtil.saveStringValue(this.getPreferenceKeyLastVerifiedAppSecret(), null);
                    if (this.mInitializeListener != null) {
                        this.mInitializeListener.onZoomSDKInitializeResult(2, result);
                    }
                    this.stopListenNetworkState();
                    break;
                }
                default: {
                    if (this.mInitializeListener != null) {
                        this.mInitializeListener.onZoomSDKInitializeResult(3, result);
                    }
                    if (!this.mbAutoRetryVerifyApp) break;
                    if (NetworkUtil.hasDataNetwork((Context)this.mContext)) {
                        this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ZoomSDK.this.verifyApp(ZoomSDK.this.mAppKey, ZoomSDK.this.mAppSecret, ZoomSDK.this.mbAutoRetryVerifyApp);
                            }
                        }, 5000L);
                        break;
                    }
                    this.startListenNetworkState();
                }
            }
        }
    }

    private void onSDKLoginReturn(long result) {
        this.mbLogining = false;
        IListener[] listeners = this.mAuthenticationListener.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                ZoomSDKAuthenticationListener l = (ZoomSDKAuthenticationListener)listener;
                l.onZoomSDKLoginResult(result);
            }
        }
    }

    private void onSDKLogoutReturn(long result) {
        IListener[] listeners = this.mAuthenticationListener.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                ZoomSDKAuthenticationListener l = (ZoomSDKAuthenticationListener)listener;
                l.onZoomSDKLogoutResult(result);
            }
        }
    }

    private void onZoomIdentityExpired(long result) {
        IListener[] listeners = this.mAuthenticationListener.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                ZoomSDKAuthenticationListener l = (ZoomSDKAuthenticationListener)listener;
                l.onZoomIdentityExpired();
            }
        }
    }

    public String getPreferenceKeyLastVerifiedAppSecret() {
        return this.mContext.getPackageName() + KEY_LAST_VERIFIED_APP_SECRET;
    }

    public String getPreferenceKeyLastVerifiedAppKey() {
        return this.mContext.getPackageName() + KEY_LAST_VERIFIED_APP_KEY;
    }

    public String getPreferenceKeyIsAppVerified() {
        return this.mContext.getPackageName() + KEY_IS_APP_VERIFIED;
    }

    private void startListenNetworkState() {
        if (this.mNetworkStateReceiver == null) {
            this.mNetworkStateReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(action)) {
                        return;
                    }
                    ZoomSDK.this.onNetworkState(intent);
                }
            };
            this.mContext.registerReceiver(this.mNetworkStateReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private void stopListenNetworkState() {
        if (this.mNetworkStateReceiver != null) {
            this.mContext.unregisterReceiver(this.mNetworkStateReceiver);
            this.mNetworkStateReceiver = null;
        }
    }

    private void onNetworkState(Intent intent) {
        if (!this.mbAutoRetryVerifyApp) {
            this.stopListenNetworkState();
            return;
        }
        if (NetworkUtil.hasDataNetwork((Context)this.mContext)) {
            this.verifyApp(this.mAppKey, this.mAppSecret, this.mbAutoRetryVerifyApp);
        }
    }
}

