/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.mainboard.Mainboard;
import us.zoom.sdk.InMeetingUserInfo;

class SDKMeetingInterfaceHelper {
    private static final int stackIndex = 3;

    SDKMeetingInterfaceHelper() {
    }

    public static boolean isConfAppCreated() {
        Mainboard mainboard = Mainboard.getMainboard();
        return mainboard != null && mainboard.isSDKConfAppCreated();
    }

    public static boolean isInSlientMode() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.inSilentMode();
    }

    public static boolean isInMeeting() {
        if (!SDKMeetingInterfaceHelper.isConfAppCreated()) {
            return false;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (!confMgr.isConfConnected()) {
            return false;
        }
        return !SDKMeetingInterfaceHelper.isInSlientMode();
    }

    public static boolean isWebinar() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.isWebinar();
        }
        return false;
    }

    public static boolean isWebinarAttendee() {
        return SDKMeetingInterfaceHelper.isWebinar() && ConfMgr.getInstance().isViewOnlyMeeting();
    }

    public static InMeetingUserInfo CmmUserToInMeetingUserInfo(CmmUser user) {
        CmmAudioStatus audioStatus;
        InMeetingUserInfo info = new InMeetingUserInfo();
        info.setUserId(user.getNodeId());
        info.setUserName(user.getScreenName());
        info.setEmail(user.getEmail());
        info.setHost(user.isHost());
        info.setCoHost(user.isCoHost());
        info.setInSilentMode(user.inSilentMode());
        info.setRaisedHandState(user.getRaiseHandState());
        info.setAvatarPath(user.getSmallPicPath());
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        if (videoStatus != null) {
            info.getVideoStatus().setSending(videoStatus.getIsSending());
            info.getVideoStatus().setReceiving(videoStatus.getIsReceving());
            info.getVideoStatus().setSource(videoStatus.getIsSource());
        }
        if ((audioStatus = user.getAudioStatusObj()) != null) {
            info.getAudioStatus().setMuted(audioStatus.getIsMuted());
            info.getAudioStatus().setTalking(audioStatus.getIsTalking());
            info.getAudioStatus().setAudioType(audioStatus.getAudiotype());
        }
        return info;
    }

    public static synchronized boolean isValidCall() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[3];
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (stackTraceElement != null && confContext != null) {
            String uniqueId = stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
            boolean result = confContext.isVaildCallForSDK(uniqueId, 500);
            return result;
        }
        return true;
    }
}

