/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.content.Context;
import android.graphics.PointF;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmShareStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.IRendererUnit;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.sdk.ISDKShareDataListener;
import com.zipow.videobox.sdk.SDKShareUnit;
import com.zipow.videobox.sdk.SDKVideoUnit;
import com.zipow.videobox.view.video.VideoRenderer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.sdk.InMeetingService;
import us.zoom.sdk.InMeetingServiceImpl;
import us.zoom.sdk.InMeetingVideoControllerImpl;
import us.zoom.sdk.MobileRTCRenderInfo;
import us.zoom.sdk.MobileRTCVideoUnitRenderInfo;
import us.zoom.sdk.MobileRTCVideoView;
import us.zoom.sdk.MobileRTCVideoViewManager;
import us.zoom.sdk.SDKMeetingInterfaceHelper;
import us.zoom.sdk.ZoomSDK;

class MobileRTCVideoViewManagerImpl
extends ConfUI.SimpleConfUIListener
implements MobileRTCVideoViewManager,
InMeetingServiceImpl.ISwitchCameraListener {
    private static final String TAG = MobileRTCVideoViewManagerImpl.class.getSimpleName();
    private static final int MAX_SHARE_SCALE_LEVEL_COUNT = 3;
    private static final int MAX_VELOCITY_IN_DIP = 1500;
    private int mWidth = 0;
    private int mHeight = 0;
    private boolean mIsGLSurfaceCreated = false;
    private MobileRTCVideoView.MobileRTCVideoRender mVideoRender;
    private SDKVideoUnit mKeyVideoUnit;
    private SDKVideoUnit mUnitPreview;
    private MobileRTCVideoUnitRenderInfo mPreviewUnitRenderInfo;
    private SDKVideoUnit mUnitActiveVideo;
    private MobileRTCVideoUnitRenderInfo mActiveUnitRenderInfo;
    private SDKShareUnit mUnitShare;
    private VideoSize mShareSize;
    private MobileRTCRenderInfo mShareUnitRenderInfo;
    private long mActiveUserId = 0L;
    private long mShareUserId = 0L;
    private Map<Long, SDKVideoUnit> mAttendeeVideos = new HashMap<Long, SDKVideoUnit>();
    private Map<Long, MobileRTCVideoUnitRenderInfo> mAttendeeUnitRenderInfoList = new HashMap<Long, MobileRTCVideoUnitRenderInfo>();
    private LinkedList<Runnable> mCachedTasks = new LinkedList();
    private ISDKShareDataListener mSDKShareDataListener;
    private double mZoomVal = 0.0;
    private float mContentX = 0.0f;
    private float mContentY = 0.0f;
    private float mScaleWidth = 0.0f;
    private float mScaleHeight = 0.0f;
    private boolean mIsNotWaiting = false;
    private boolean mIsFitScreen = true;
    private Scroller mScroller;
    private Handler mFlingHandler = new Handler();
    private boolean mStopFling = false;
    private boolean mFlinged;
    private boolean mbIgnoreNextScroll = false;
    private boolean mScrolled;

    public MobileRTCVideoViewManagerImpl(MobileRTCVideoView.MobileRTCVideoRender videoRender, ISDKShareDataListener listener) {
        SDKVideoUnit.initDefaultResources();
        DecelerateInterpolator interpolator = new DecelerateInterpolator(1.0f);
        this.mScroller = new Scroller((Context)VideoBoxApplication.getInstance(), (Interpolator)interpolator);
        this.mVideoRender = videoRender;
        this.mSDKShareDataListener = listener;
    }

    public boolean isGLSurfaceCreated() {
        return this.mIsGLSurfaceCreated;
    }

    private void onCreateUnits() {
        this.createPreviewVideoUnit(this.mPreviewUnitRenderInfo);
        this.createActiveVideoUnit(this.mActiveUnitRenderInfo);
        for (Map.Entry<Long, MobileRTCVideoUnitRenderInfo> entry : this.mAttendeeUnitRenderInfoList.entrySet()) {
            long userId = entry.getKey();
            MobileRTCVideoUnitRenderInfo renderInfo = entry.getValue();
            this.createAttendeeVideoUnit(userId, renderInfo);
        }
        this.createShareVideoUnit(this.mShareUserId, this.mShareUnitRenderInfo);
    }

    private void onUpdateUnits() {
        if (this.mPreviewUnitRenderInfo != null) {
            this.updatePreviewVideoUnit(this.mPreviewUnitRenderInfo);
        }
        if (this.mActiveUnitRenderInfo != null) {
            this.updateActiveVideoUnit(this.mActiveUnitRenderInfo);
        }
        for (Map.Entry<Long, MobileRTCVideoUnitRenderInfo> entry : this.mAttendeeUnitRenderInfoList.entrySet()) {
            long userId = entry.getKey();
            MobileRTCVideoUnitRenderInfo viewInfo = entry.getValue();
            this.updateAttendeeVideoUnit(userId, viewInfo);
        }
        this.updateShareVideoUnit(this.mShareUnitRenderInfo);
    }

    @Override
    public boolean addPreviewVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        if (renderInfo == null) {
            return false;
        }
        if (this.mPreviewUnitRenderInfo != null) {
            Log.e((String)TAG, (String)"addPreviewVideoUnit: already has a preview video.");
            return false;
        }
        this.mPreviewUnitRenderInfo = renderInfo;
        if (this.isGLSurfaceCreated()) {
            this.createPreviewVideoUnit(this.mPreviewUnitRenderInfo);
        }
        return true;
    }

    private void createPreviewVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        if (this.mUnitPreview != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"createPreviewVideoUnit: cannot get video manager.");
            return;
        }
        RendererUnitInfo unitInfo = this.convertRenderInfo(renderInfo);
        this.mUnitPreview = this.createVideoUnit(unitInfo);
        if (this.mUnitPreview != null) {
            this.mUnitPreview.setUnitName("MyPreview");
            this.mUnitPreview.setUserNameVisible(renderInfo.is_username_visible, false);
            this.mUnitPreview.setBorderVisible(renderInfo.is_border_visible);
            this.mUnitPreview.setBackgroundColor(renderInfo.backgroud_color);
            this.mUnitPreview.setCanShowAudioOff(renderInfo.is_show_audio_off);
            videoMgr.setAspectMode(this.mUnitPreview.getRendererInfo(), renderInfo.aspect_mode);
            this.mUnitPreview.onCreate();
            this.mUnitPreview.startPreview(videoMgr.getDefaultCameraToUse());
        }
    }

    @Override
    public void updatePreviewVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        RendererUnitInfo unitInfo;
        if (renderInfo == null) {
            return;
        }
        if (this.mPreviewUnitRenderInfo == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"updatePreviewVideoUnit: cannot get video manager.");
            return;
        }
        this.mPreviewUnitRenderInfo = renderInfo;
        if (this.isGLSurfaceCreated() && (unitInfo = this.convertRenderInfo(renderInfo)) != null && this.mUnitPreview != null) {
            this.mUnitPreview.updateUnitInfo(this.mWidth, this.mHeight, unitInfo);
            this.mUnitPreview.setBorderVisible(renderInfo.is_border_visible);
            this.mUnitPreview.setBackgroundColor(renderInfo.backgroud_color);
            this.mUnitPreview.setCanShowAudioOff(renderInfo.is_show_audio_off);
            videoMgr.setAspectMode(this.mUnitPreview.getRendererInfo(), renderInfo.aspect_mode);
        }
    }

    @Override
    public void removePreviewVideoUnit() {
        if (this.mUnitPreview != null) {
            this.mUnitPreview.removeUser();
            this.mUnitPreview.clearRenderer();
            this.mUnitPreview.onDestroy();
            this.mUnitPreview = null;
        }
        this.mPreviewUnitRenderInfo = null;
    }

    @Override
    public boolean addActiveVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return false;
        }
        if (renderInfo == null) {
            return false;
        }
        if (this.mActiveUnitRenderInfo != null) {
            return false;
        }
        this.mActiveUnitRenderInfo = renderInfo;
        if (this.mUnitActiveVideo != null) {
            Log.e((String)TAG, (String)"addActiveVideoUnit: already has a active video.");
            return false;
        }
        if (this.isGLSurfaceCreated()) {
            this.createActiveVideoUnit(this.mActiveUnitRenderInfo);
        }
        return true;
    }

    private void createActiveVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        if (this.mUnitActiveVideo != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"createActiveVideoUnit: cannot get video manager.");
            return;
        }
        RendererUnitInfo unitInfo = this.convertRenderInfo(renderInfo);
        this.mUnitActiveVideo = this.createVideoUnit(unitInfo);
        if (this.mUnitActiveVideo != null) {
            this.mActiveUserId = ConfUI.getInstance().getActiveVideo();
            this.mUnitActiveVideo.setUnitName("ActiveVideo");
            this.mUnitActiveVideo.setUserNameVisible(renderInfo.is_username_visible, false);
            this.mUnitActiveVideo.setBorderVisible(renderInfo.is_border_visible);
            this.mUnitActiveVideo.setBackgroundColor(renderInfo.backgroud_color);
            this.mUnitActiveVideo.setCanShowAudioOff(renderInfo.is_show_audio_off);
            videoMgr.setAspectMode(this.mUnitActiveVideo.getRendererInfo(), renderInfo.aspect_mode);
            this.mUnitActiveVideo.onCreate();
            this.checkShowActiveVideo();
        }
    }

    @Override
    public void updateActiveVideoUnit(MobileRTCVideoUnitRenderInfo renderInfo) {
        RendererUnitInfo unitInfo;
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return;
        }
        if (renderInfo == null) {
            return;
        }
        if (this.mActiveUnitRenderInfo == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"updateActiveVideoUnit: cannot get video manager.");
            return;
        }
        this.mActiveUnitRenderInfo = renderInfo;
        if (this.isGLSurfaceCreated() && (unitInfo = this.convertRenderInfo(renderInfo)) != null && this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.updateUnitInfo(this.mWidth, this.mHeight, unitInfo);
            this.mUnitActiveVideo.setUserNameVisible(renderInfo.is_username_visible, false);
            this.mUnitActiveVideo.setBorderVisible(renderInfo.is_border_visible);
            this.mUnitActiveVideo.setBackgroundColor(renderInfo.backgroud_color);
            this.mUnitActiveVideo.setCanShowAudioOff(renderInfo.is_show_audio_off);
            videoMgr.setAspectMode(this.mUnitActiveVideo.getRendererInfo(), renderInfo.aspect_mode);
        }
    }

    @Override
    public void removeActiveVideoUnit() {
        if (this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.removeUser();
            this.mUnitActiveVideo.clearRenderer();
            this.mUnitActiveVideo.onDestroy();
            this.mUnitActiveVideo = null;
        }
        this.mActiveUnitRenderInfo = null;
    }

    @Override
    public boolean addAttendeeVideoUnit(long userId, MobileRTCVideoUnitRenderInfo renderInfo) {
        if (!SDKMeetingInterfaceHelper.isInMeeting() || SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return false;
        }
        if (renderInfo == null) {
            return false;
        }
        if (this.mAttendeeUnitRenderInfoList.containsKey(userId)) {
            Log.e((String)TAG, (String)"addAttendeeVideoUnit: already has a video unit for this userId.");
            return false;
        }
        this.mAttendeeUnitRenderInfoList.put(userId, renderInfo);
        if (this.isGLSurfaceCreated()) {
            this.createAttendeeVideoUnit(userId, renderInfo);
        }
        return true;
    }

    private void createAttendeeVideoUnit(long userId, MobileRTCVideoUnitRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        if (this.mAttendeeVideos.containsKey(userId)) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"createAttendeeVideoUnit: cannot get video manager.");
            return;
        }
        RendererUnitInfo unitInfo = this.convertRenderInfo(renderInfo);
        SDKVideoUnit videoUnit = this.createVideoUnit(unitInfo);
        if (videoUnit != null) {
            videoUnit.setType(0);
            videoUnit.setUnitName("Video_" + userId);
            videoUnit.setUserNameVisible(renderInfo.is_username_visible, false);
            videoUnit.setBorderVisible(renderInfo.is_border_visible);
            videoUnit.setBackgroundColor(renderInfo.backgroud_color);
            videoUnit.setCanShowAudioOff(renderInfo.is_show_audio_off);
            videoMgr.setAspectMode(videoUnit.getRendererInfo(), renderInfo.aspect_mode);
            this.mAttendeeVideos.put(userId, videoUnit);
            videoUnit.onCreate();
            videoUnit.setUser(userId);
        }
    }

    @Override
    public void updateAttendeeVideoUnit(long userId, MobileRTCVideoUnitRenderInfo renderInfo) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return;
        }
        if (renderInfo == null) {
            return;
        }
        if (!this.mAttendeeUnitRenderInfoList.containsKey(userId)) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"updateAttendeeVideoUnit: cannot get video manager.");
            return;
        }
        this.mAttendeeUnitRenderInfoList.put(userId, renderInfo);
        if (this.isGLSurfaceCreated() && this.mAttendeeVideos.containsKey(userId)) {
            SDKVideoUnit videoUnit = this.mAttendeeVideos.get(userId);
            RendererUnitInfo unitInfo = this.convertRenderInfo(renderInfo);
            if (unitInfo != null && videoUnit != null) {
                videoUnit.updateUnitInfo(this.mWidth, this.mHeight, unitInfo);
                videoUnit.setUserNameVisible(renderInfo.is_username_visible, false);
                videoUnit.setBorderVisible(renderInfo.is_border_visible);
                videoUnit.setBackgroundColor(renderInfo.backgroud_color);
                videoUnit.setCanShowAudioOff(renderInfo.is_show_audio_off);
                videoMgr.setAspectMode(videoUnit.getRendererInfo(), renderInfo.aspect_mode);
            }
        }
    }

    @Override
    public void removeAttendeeVideoUnit(long userId) {
        if (this.mAttendeeVideos.containsKey(userId)) {
            SDKVideoUnit videoUnit = this.mAttendeeVideos.get(userId);
            videoUnit.removeUser();
            videoUnit.clearRenderer();
            videoUnit.onDestroy();
            this.mAttendeeVideos.remove(userId);
        }
        if (this.mAttendeeUnitRenderInfoList.containsKey(userId)) {
            this.mAttendeeUnitRenderInfoList.remove(userId);
        }
    }

    @Override
    public void removeAllAttendeeVideoUnit() {
        for (Map.Entry<Long, SDKVideoUnit> entry : this.mAttendeeVideos.entrySet()) {
            SDKVideoUnit unit = entry.getValue();
            if (unit == null) continue;
            unit.removeUser();
            unit.clearRenderer();
            unit.onDestroy();
        }
        this.mAttendeeVideos.clear();
        this.mAttendeeUnitRenderInfoList.clear();
    }

    @Override
    public boolean addShareVideoUnit(long userId, MobileRTCRenderInfo renderInfo) {
        if (renderInfo == null) {
            return false;
        }
        if (this.mShareUnitRenderInfo != null) {
            return false;
        }
        this.mShareUnitRenderInfo = renderInfo;
        this.mShareUserId = userId;
        if (this.isGLSurfaceCreated()) {
            this.createShareVideoUnit(userId, renderInfo);
        }
        return true;
    }

    private void createShareVideoUnit(long userId, MobileRTCRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            Log.e((String)TAG, (String)"createShareVideoUnit: cannot get share manager.");
            return;
        }
        RendererUnitInfo shareUnitInfo = this.createShareUnitInfo();
        if (shareUnitInfo != null && userId != 0L) {
            this.createKeyVideoUnit(this.mWidth, this.mHeight);
            this.mUnitShare = shareMgr.createSDKShareUnit(this.mWidth, this.mHeight, shareUnitInfo, this.mVideoRender.getGroupIndex());
            if (this.mUnitShare == null) {
                return;
            }
            this.mUnitShare.onCreate();
            this.mUnitShare.setUser(userId);
            this.mSDKShareDataListener.onShareUnitCreated(userId);
            this.mSDKShareDataListener.onUpdateUnitShare(this.mUnitShare);
        }
    }

    @Override
    public void updateShareVideoUnit(MobileRTCRenderInfo renderInfo) {
        if (renderInfo == null) {
            return;
        }
        if (this.mShareUnitRenderInfo == null) {
            return;
        }
        this.mShareUnitRenderInfo = renderInfo;
        if (this.isGLSurfaceCreated()) {
            this.updateUnitShare();
        }
    }

    private RendererUnitInfo createShareUnitInfo() {
        RendererUnitInfo unitInfo = null;
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            shareSize = new VideoSize(16, 9);
        }
        unitInfo = this.createShareUnitInfo(shareSize);
        return unitInfo;
    }

    private RendererUnitInfo createShareUnitInfo(VideoSize size) {
        int l;
        int w;
        int h;
        int t;
        int shareWidth = size.width;
        int shareHeight = size.height;
        if (shareWidth == 0 || shareHeight == 0) {
            return null;
        }
        int shareRenderWidth = this.getShareRenderWidth();
        int shareRenderHeight = this.getShareRenderHeight();
        if (this.mIsFitScreen && Math.abs(this.mZoomVal - this.getMinLevelZoomValue()) < 0.01) {
            if (shareRenderWidth * shareHeight > shareRenderHeight * shareWidth) {
                t = 0;
                h = shareRenderHeight;
                w = h * shareWidth / shareHeight;
                l = (shareRenderWidth - w) / 2;
            } else {
                l = 0;
                w = shareRenderWidth;
                h = w * shareHeight / shareWidth;
                t = (shareRenderHeight - h) / 2;
            }
        } else {
            float contentWidth = (float)((double)shareWidth * this.mZoomVal);
            float contentHeight = (float)((double)shareHeight * this.mZoomVal);
            if (contentWidth > (float)shareRenderWidth) {
                l = 0;
                w = shareRenderWidth;
            } else {
                w = (int)contentWidth;
                l = (shareRenderWidth - w) / 2;
            }
            if (contentHeight > (float)shareRenderHeight) {
                t = 0;
                h = shareRenderHeight;
            } else {
                h = (int)contentHeight;
                t = (shareRenderHeight - h) / 2;
            }
        }
        return new RendererUnitInfo(this.mShareUnitRenderInfo.xPercent * this.mWidth / 100 + l, this.mShareUnitRenderInfo.yPercent * this.mHeight / 100 + t, w, h);
    }

    @Override
    public void removeShareVideoUnit() {
        if (this.mUnitShare != null) {
            this.mUnitShare.onDestroy();
            this.mUnitShare = null;
            this.mSDKShareDataListener.onShareUnitDestoryed();
        }
        this.mShareUnitRenderInfo = null;
        this.mShareSize = null;
    }

    @Override
    public void removeAllVideoUnits() {
        this.removePreviewVideoUnit();
        this.removeActiveVideoUnit();
        this.removeShareVideoUnit();
        this.removeAllAttendeeVideoUnit();
    }

    private SDKVideoUnit createVideoUnit(RendererUnitInfo unitInfo) {
        this.createKeyVideoUnit(this.mWidth, this.mHeight);
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        return videoMgr.createVideoUnit(false, this.mWidth, this.mHeight, unitInfo, this.mVideoRender.getGroupIndex());
    }

    private RendererUnitInfo convertRenderInfo(MobileRTCRenderInfo renderInfo) {
        if (renderInfo.xPercent < 0) {
            renderInfo.xPercent = 0;
        } else if (renderInfo.xPercent > 100) {
            renderInfo.xPercent = 100;
        }
        if (renderInfo.yPercent < 0) {
            renderInfo.yPercent = 0;
        } else if (renderInfo.yPercent > 100) {
            renderInfo.yPercent = 100;
        }
        if (renderInfo.widthPercent < 0) {
            renderInfo.widthPercent = 0;
        } else if (renderInfo.widthPercent > 100) {
            renderInfo.widthPercent = 100;
        }
        if (renderInfo.heightPercent < 0) {
            renderInfo.heightPercent = 0;
        } else if (renderInfo.heightPercent > 100) {
            renderInfo.heightPercent = 100;
        }
        int left = renderInfo.xPercent * this.mWidth / 100;
        int top = renderInfo.yPercent * this.mHeight / 100;
        int width = renderInfo.widthPercent * this.mWidth / 100;
        int height = renderInfo.heightPercent * this.mHeight / 100;
        return new RendererUnitInfo(left, top, width, height);
    }

    private void createKeyVideoUnit(int width, int height) {
        if (this.mKeyVideoUnit != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"createKeyVideoUnit: cannot get video manager.");
            return;
        }
        RendererUnitInfo unitInfo = new RendererUnitInfo(0, 0, 1, 1);
        this.mKeyVideoUnit = videoMgr.createVideoUnit(true, width, height, unitInfo, this.mVideoRender.getGroupIndex());
        if (this.mKeyVideoUnit != null) {
            SdkConfUIBridge.getInstance().addListener(this);
            InMeetingService inMeetingService = ZoomSDK.getInstance().getInMeetingService();
            if (inMeetingService != null && inMeetingService.getInMeetingVideoController() != null) {
                ((InMeetingVideoControllerImpl)inMeetingService.getInMeetingVideoController()).addSwitchCameraListener(this);
            }
            if (this.mVideoRender != null) {
                Log.i((String)TAG, (String)("startRender: group index = " + this.mVideoRender.getGroupIndex()));
                if (!this.mVideoRender.isRunning()) {
                    this.mVideoRender.startRenderer(this.mVideoRender.getProperFPS());
                }
                if (!this.mVideoRender.isInitialized()) {
                    this.mVideoRender.initialize();
                }
            }
        }
    }

    private void destroyKeyVideoUnit() {
        if (this.mKeyVideoUnit == null) {
            return;
        }
        InMeetingService inMeetingService = ZoomSDK.getInstance().getInMeetingService();
        if (inMeetingService != null && inMeetingService.getInMeetingVideoController() != null) {
            ((InMeetingVideoControllerImpl)inMeetingService.getInMeetingVideoController()).removeSwitchCameraListener(this);
        }
        SdkConfUIBridge.getInstance().removeListener(this);
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            Log.e((String)TAG, (String)"destroyKeyVideoUnit: cannot get video manager.");
            return;
        }
        videoMgr.destroyVideoUnit(this.mKeyVideoUnit);
        this.mKeyVideoUnit = null;
        if (this.mVideoRender != null && this.mVideoRender.isRunning()) {
            Log.i((String)TAG, (String)("destory: group index = " + this.mVideoRender.getGroupIndex()));
            this.mVideoRender.stopRenderAfterRun();
        }
    }

    private void checkShowActiveVideo() {
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            Log.e((String)TAG, (String)"checkShowActiveVideo: failed to get user list");
            return;
        }
        int userCount = ConfMgr.getInstance().getClientWithoutOnHoldUserCount(true);
        long activeUserId = 0L;
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            if (this.mActiveUserId == 0L) {
                return;
            }
            activeUserId = 1L;
        } else {
            CmmUser user;
            activeUserId = this.mActiveUserId;
            if (userCount == 1) {
                return;
            }
            if (userCount == 2 && (user = userList.getPeerUser(false, true)) != null) {
                activeUserId = user.getNodeId();
            }
        }
        if (activeUserId > 0L && this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.setType(1);
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (userCount == 2) {
                this.mUnitActiveVideo.setUser(activeUserId);
            } else if (videoMgr != null && videoMgr.isManualMode()) {
                this.mUnitActiveVideo.setUser(videoMgr.getSelectedUser());
            } else {
                this.mUnitActiveVideo.setUser(1L);
            }
        }
    }

    @Override
    public void beforeSwitchCamera() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            Log.i((String)TAG, (String)"beforeSwitchCamera: failed to get confStatus");
            return;
        }
        for (Map.Entry<Long, SDKVideoUnit> entry : this.mAttendeeVideos.entrySet()) {
            if (!confStatus.isMyself(entry.getKey())) continue;
            SDKVideoUnit videoUnit = entry.getValue();
            videoUnit.stopVideo(false);
            break;
        }
    }

    @Override
    public void afterSwitchCamera() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            Log.i((String)TAG, (String)"afterSwitchCamera: failed to get confStatus");
            return;
        }
        for (Map.Entry<Long, SDKVideoUnit> entry : this.mAttendeeVideos.entrySet()) {
            if (!confStatus.isMyself(entry.getKey())) continue;
            SDKVideoUnit videoUnit = entry.getValue();
            videoUnit.startVideo();
            break;
        }
    }

    @Override
    public boolean onConfStatusChanged(int status) {
        return true;
    }

    @Override
    public boolean onConfStatusChanged2(int cmd, long arg1) {
        if (cmd == 1) {
            this.destory();
        }
        return true;
    }

    @Override
    public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
        switch (cmd) {
            case 4: {
                this.checkShowVideos(userId);
                break;
            }
            case 10: {
                this.mActiveUserId = userId;
                this.checkShowVideos(userId);
                break;
            }
            case 6: {
                this.mActiveUserId = userId;
                this.onUserActiveVideoForDeck(userId);
                break;
            }
            case 52: {
                this.onShareUserReceivingStatus(userId);
                break;
            }
            case 53: {
                break;
            }
            case 54: {
                this.onShareDataSizeChanged(userId);
            }
        }
        return true;
    }

    private void onShareDataSizeChanged(long userId) {
        if (this.mUnitShare == null) {
            return;
        }
        Log.i((String)TAG, (String)("onShareDataSizeChanged, userId=" + userId));
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        boolean bFirst = false;
        VideoSize sizeNew = null;
        bFirst = this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0;
        sizeNew = shareMgr.getShareDataResolution(userId);
        if (sizeNew == null || sizeNew.width == 0 || sizeNew.height == 0) {
            return;
        }
        this.mShareSize = sizeNew;
        Log.i((String)TAG, (String)("onShareDataSizeChanged: size=" + this.mShareSize.width + ", " + this.mShareSize.height));
        this.mSDKShareDataListener.onShareSourceDataSizeChanged(this.mShareSize.width, this.mShareSize.height);
        boolean _bFirst = bFirst;
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return;
        }
        if (_bFirst || this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            int countLevels;
            int level = this.getCurrentScaleLevel();
            if (level >= (countLevels = this.getScaleLevelsCount())) {
                level = countLevels - 1;
                this.mZoomVal = this.scaleLevelToZoomValue(level);
            }
            this.mIsFitScreen = this.checkFitScreen();
            this.updateUnitShare();
            this.trimContentPos();
            if (this.mIsFitScreen) {
                if (this.mUnitShare != null) {
                    this.mScaleWidth = this.mUnitShare.getWidth();
                    this.mScaleHeight = this.mUnitShare.getHeight();
                }
            } else {
                this.mScaleWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
                this.mScaleHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            }
            this.notifyDestAreaChanged();
        }
    }

    private void onShareUserReceivingStatus(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            Log.i((String)TAG, (String)("onShareUserReceivingStatus, cannot get user. userId=" + userId));
            return;
        }
        CmmShareStatus shareStatus = user.getShareStatusObj();
        if (shareStatus == null) {
            Log.i((String)TAG, (String)"onShareUserReceivingStatus, cannot get share status.");
            return;
        }
        this.mSDKShareDataListener.onShareUserReceivingStatus(userId);
        boolean isReceiving = shareStatus.getIsReceiving();
        Log.i((String)TAG, (String)("onShareUserReceivingStatus, userId=" + userId + ", isReceiving=" + isReceiving));
        if (isReceiving) {
            this.mIsNotWaiting = true;
            this.onShareDataSizeChanged(userId);
        } else {
            this.mIsNotWaiting = false;
        }
    }

    private void updateUnitShare() {
        if (this.mUnitShare != null) {
            RendererUnitInfo unitInfo = this.createShareUnitInfo();
            if (unitInfo != null) {
                this.mUnitShare.updateUnitInfo(unitInfo, this.mWidth, this.mHeight);
            }
            this.mSDKShareDataListener.onUpdateUnitShare(this.mUnitShare);
        }
    }

    private void onUserActiveVideoForDeck(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                MobileRTCVideoViewManagerImpl.this.checkShowActiveVideo();
            }
        });
    }

    private void checkShowVideos(final long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ConfMgr confMgr;
                CmmConfStatus confStatus;
                if (MobileRTCVideoViewManagerImpl.this.mUnitActiveVideo != null) {
                    MobileRTCVideoViewManagerImpl.this.checkShowActiveVideo();
                }
                if ((confStatus = (confMgr = ConfMgr.getInstance()).getConfStatusObj()) == null) {
                    return;
                }
                for (Map.Entry entry : MobileRTCVideoViewManagerImpl.this.mAttendeeVideos.entrySet()) {
                    if (!confStatus.isSameUser(userId, (Long)entry.getKey())) continue;
                    SDKVideoUnit videoUnit = (SDKVideoUnit)entry.getValue();
                    videoUnit.setUser((Long)entry.getKey());
                    break;
                }
            }
        });
    }

    public void onGLSurfaceDestoryed() {
        this.mWidth = 0;
        this.mHeight = 0;
        this.mIsGLSurfaceCreated = false;
    }

    public void onGLSurfaceChanged(VideoRenderer renderer, int width, int height) {
        if (this.mVideoRender == null) {
            this.mVideoRender = (MobileRTCVideoView.MobileRTCVideoRender)renderer;
        }
        Log.i((String)TAG, (String)("onGLSurfaceChanged: groupIndex = " + this.mVideoRender.getGroupIndex() + ", width=" + width + ", height=" + height));
        if (this.mWidth == 0 && this.mHeight == 0) {
            this.mWidth = width;
            this.mHeight = height;
            this.doCachedTasks();
            if (this.mWidth > 0 && this.mHeight > 0) {
                this.mIsGLSurfaceCreated = true;
            }
            this.onCreateUnits();
        } else {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mKeyVideoUnit != null) {
                this.mKeyVideoUnit.onGLViewSizeChanged(width, height);
            }
            if (this.mUnitPreview != null) {
                this.mUnitPreview.onGLViewSizeChanged(width, height);
            }
            if (this.mUnitActiveVideo != null) {
                this.mUnitActiveVideo.onGLViewSizeChanged(width, height);
            }
            if (this.mUnitShare != null) {
                this.mUnitShare.onGLViewSizeChanged(width, height);
            }
            for (Map.Entry<Long, SDKVideoUnit> entry : this.mAttendeeVideos.entrySet()) {
                IRendererUnit unit = entry.getValue();
                if (unit == null) continue;
                unit.onGLViewSizeChanged(width, height);
            }
            this.onUpdateUnits();
        }
    }

    public void onIdle() {
        if (this.mUnitPreview != null) {
            this.mUnitPreview.onIdle();
        }
        if (this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.onIdle();
        }
        for (Map.Entry<Long, SDKVideoUnit> entry : this.mAttendeeVideos.entrySet()) {
            SDKVideoUnit unit = entry.getValue();
            if (unit == null) continue;
            unit.onIdle();
        }
    }

    @Override
    public void destory() {
        if (this.mKeyVideoUnit == null) {
            return;
        }
        this.removePreviewVideoUnit();
        this.removeActiveVideoUnit();
        this.removeShareVideoUnit();
        this.removeAllAttendeeVideoUnit();
        this.destroyKeyVideoUnit();
    }

    public void runOnRendererInited(Runnable action) {
        if (action == null) {
            return;
        }
        MobileRTCVideoView.MobileRTCVideoRender renderer = this.mVideoRender;
        if (renderer == null) {
            Log.e((String)TAG, (String)"runOnGLThread: mRenderer is null");
            return;
        }
        if (renderer.isInitialized()) {
            action.run();
        } else {
            this.cacheTask(action);
        }
    }

    private void cacheTask(Runnable action) {
        this.mCachedTasks.add(action);
    }

    private void doCachedTasks() {
        for (Runnable task : this.mCachedTasks) {
            task.run();
        }
        this.mCachedTasks.clear();
    }

    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mbIgnoreNextScroll) {
            this.mbIgnoreNextScroll = false;
            return;
        }
        this.mScrolled = true;
        this.mStopFling = true;
        if (!this.mIsNotWaiting) {
            return;
        }
        this.mContentX -= distanceX;
        this.mContentY -= distanceY;
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        this.mFlinged = true;
        if (!this.mIsNotWaiting || !this.isGLSurfaceCreated()) {
            return;
        }
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        if (velocityX > 0.0f) {
            this.mScroller.setFinalX(0);
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            this.mScroller.setFinalX((int)((float)this.mUnitShare.getWidth() - contentWidth));
        }
        if (velocityY > 0.0f) {
            this.mScroller.setFinalY(0);
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            this.mScroller.setFinalY((int)((float)this.mUnitShare.getHeight() - contentHeight));
        }
        int maxVelocity = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)1500.0f);
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            if (velocityX == 0.0f) {
                velocityX = 0.1f;
            }
            float rate = velocityY / velocityX;
            if (velocityX > (float)maxVelocity) {
                velocityX = maxVelocity;
            } else if (velocityX < (float)(-maxVelocity)) {
                velocityX = -maxVelocity;
            }
            velocityY = velocityX * rate;
        } else {
            if (velocityY == 0.0f) {
                velocityY = 0.1f;
            }
            float rate = velocityX / velocityY;
            if (velocityY > (float)maxVelocity) {
                velocityY = maxVelocity;
            } else if (velocityY < (float)(-maxVelocity)) {
                velocityY = -maxVelocity;
            }
            velocityX = velocityY * rate;
        }
        this.mScroller.fling((int)this.mContentX, (int)this.mContentY, (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mStopFling = false;
        this.handleFling();
    }

    private void handleFling() {
        this.mFlingHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!MobileRTCVideoViewManagerImpl.this.mStopFling && MobileRTCVideoViewManagerImpl.this.updateContentPosOnFling()) {
                    MobileRTCVideoViewManagerImpl.this.handleFling();
                }
            }
        }, 40L);
    }

    private boolean updateContentPosOnFling() {
        boolean xStopped = false;
        boolean yStopped = false;
        if (this.mUnitShare == null || this.mShareSize == null) {
            return false;
        }
        if (!this.mScroller.computeScrollOffset()) {
            return false;
        }
        this.mContentX = this.mScroller.getCurrX();
        if (this.mContentX > 0.0f) {
            this.mContentX = 0.0f;
            xStopped = true;
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            if (this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
                xStopped = true;
            }
        }
        this.mContentY = this.mScroller.getCurrY();
        if (this.mContentY > 0.0f) {
            this.mContentY = 0.0f;
            yStopped = true;
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            if (this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
                yStopped = true;
            }
        }
        this.notifyDestAreaChanged();
        return !xStopped && !yStopped;
    }

    public void onDoubleTap(MotionEvent e) {
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return;
        }
        int levelsCount = this.getScaleLevelsCount();
        int oldLevel = this.getCurrentScaleLevel();
        int newLevel = (oldLevel + 1) % levelsCount;
        if (newLevel == oldLevel) {
            return;
        }
        if (newLevel == 0) {
            this.zoomToFitUnit();
        } else {
            this.switchToLevel(newLevel, e.getX(), e.getY());
        }
    }

    private int getScaleLevelsCount() {
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return 3;
        }
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        float maxContextDisplayWidth = (float)(maxLevelZoomVal * (double)this.mShareSize.width);
        float maxContextDisplayHeight = (float)(maxLevelZoomVal * (double)this.mShareSize.height);
        if (maxContextDisplayWidth <= (float)this.getShareRenderWidth() && maxContextDisplayHeight < (float)this.getShareRenderHeight()) {
            return 1;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        float mediumContextDisplayWidth = (float)(mediumLevelZoomVal * (double)this.mShareSize.width);
        float mediumContextDisplayHeight = (float)(mediumLevelZoomVal * (double)this.mShareSize.height);
        if (mediumContextDisplayWidth <= (float)this.getShareRenderWidth() && mediumContextDisplayHeight < (float)this.getShareRenderHeight()) {
            return 2;
        }
        return 3;
    }

    private int getCurrentScaleLevel() {
        int i;
        int levelsCount = this.getScaleLevelsCount();
        double[] levelZooms = new double[levelsCount];
        for (i = 0; i < levelsCount; ++i) {
            levelZooms[i] = this.scaleLevelToZoomValue(i);
        }
        for (i = 0; i < levelsCount - 1; ++i) {
            if (!(this.mZoomVal >= levelZooms[i]) || !(this.mZoomVal < levelZooms[i + 1])) continue;
            return i;
        }
        return levelsCount - 1;
    }

    private void switchToLevel(int level, float x, float y) {
        this.switchToZoom(this.scaleLevelToZoomValue(level), x, y);
    }

    private void switchToZoom(double zoomVal, float x, float y) {
        double oldZoom = this.mZoomVal;
        this.mZoomVal = zoomVal;
        this.mIsFitScreen = this.checkFitScreen();
        float xOnUnit = this.viewXToShareUnitX(x);
        float yOnUnit = this.viewYToShareUnitY(y);
        PointF pixelPosOnContent = this.unitPosToPixelPosOnContent(xOnUnit, yOnUnit, oldZoom);
        this.updateUnitShare();
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return;
        }
        float pixelXOnContent = pixelPosOnContent.x;
        float pixelYOnContent = pixelPosOnContent.y;
        this.mScaleWidth = (float)((double)this.mShareSize.width * this.mZoomVal);
        this.mScaleHeight = (float)((double)this.mShareSize.height * this.mZoomVal);
        this.resetDestAreaCenter(pixelXOnContent, pixelYOnContent);
    }

    private PointF getCenterPixelPosOnContent() {
        if (this.mUnitShare == null) {
            return null;
        }
        return this.unitPosToPixelPosOnContent(this.mUnitShare.getWidth() / 2, this.mUnitShare.getHeight() / 2, this.mZoomVal);
    }

    private void resetDestAreaCenter(float pixelX, float pixelY) {
        if (this.mUnitShare == null) {
            return;
        }
        this.mContentX = (float)(this.mUnitShare.getWidth() / 2) - (float)((double)pixelX * this.mZoomVal);
        this.mContentY = (float)(this.mUnitShare.getHeight() / 2) - (float)((double)pixelY * this.mZoomVal);
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private boolean checkFitScreen() {
        if (this.mZoomVal < 0.01) {
            return true;
        }
        double zoomFit = this.scaleLevelToZoomValue(0);
        return Math.abs(this.mZoomVal - zoomFit) < 0.01;
    }

    private double getMaxLevelZoomValue() {
        float density = VideoBoxApplication.getInstance().getResources().getDisplayMetrics().density;
        float maxLevelZoomVal = density * 160.0f / 120.0f;
        return maxLevelZoomVal;
    }

    private double getMinLevelZoomValue() {
        if (this.mShareSize == null) {
            return 0.0;
        }
        int renderWidth = this.getShareRenderWidth();
        int renderHeight = this.getShareRenderHeight();
        double fitWidth = 0.0;
        if (renderWidth * this.mShareSize.height > renderHeight * this.mShareSize.width) {
            int fitHeight = renderHeight;
            fitWidth = (double)fitHeight * (double)this.mShareSize.width / (double)this.mShareSize.height;
        } else {
            fitWidth = renderWidth;
        }
        double minLevelZoomVal = fitWidth / (double)this.mShareSize.width;
        return minLevelZoomVal;
    }

    private PointF unitPosToPixelPosOnContent(float x, float y, double zoomVal) {
        float xOnContent = x - this.mContentX;
        float yOnContent = y - this.mContentY;
        float pixelXOnContent = (float)((double)xOnContent / zoomVal);
        float pixelYOnContent = (float)((double)yOnContent / zoomVal);
        return new PointF(pixelXOnContent, pixelYOnContent);
    }

    private void notifyDestAreaChanged() {
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            return;
        }
        if (this.mUnitShare == null) {
            return;
        }
        Log.i((String)TAG, (String)("mContentX=" + (int)this.mContentX + ", mContentY=" + (int)this.mContentY + ", mScaleWidth=" + (int)this.mScaleWidth + ", mScaleHeight=" + (int)this.mScaleHeight));
        this.mUnitShare.destAreaChanged((int)this.mContentX, (int)this.mContentY, (int)this.mScaleWidth, (int)this.mScaleHeight);
        this.mSDKShareDataListener.onDestAreaChangedChanged(this.mContentX, this.mContentY, this.mScaleWidth, this.mScaleHeight);
    }

    private void zoomToFitUnit() {
        Log.d((String)TAG, (String)"zoomToFitUnit");
        if (this.mUnitShare == null) {
            return;
        }
        this.mZoomVal = this.scaleLevelToZoomValue(0);
        this.mIsFitScreen = this.checkFitScreen();
        this.mContentX = 0.0f;
        this.mContentY = 0.0f;
        this.updateUnitShare();
        this.mScaleWidth = this.mUnitShare.getWidth();
        this.mScaleHeight = this.mUnitShare.getHeight();
        this.notifyDestAreaChanged();
    }

    @Override
    public float viewToShareContentX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return (float)((double)(x - (float)this.mUnitShare.getLeft() - this.mContentX) / this.mZoomVal);
    }

    @Override
    public float viewToShareContentY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return (float)((double)(y - (float)this.mUnitShare.getTop() - this.mContentY) / this.mZoomVal);
    }

    @Override
    public float shareContentToViewX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return (float)((double)x * this.mZoomVal + (double)this.mUnitShare.getLeft() + (double)this.mContentX);
    }

    @Override
    public float shareContentToViewY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return (float)((double)y * this.mZoomVal + (double)this.mUnitShare.getTop() + (double)this.mContentY);
    }

    private float viewXToShareUnitX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return x - (float)this.mUnitShare.getLeft();
    }

    private float viewYToShareUnitY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return y - (float)this.mUnitShare.getTop();
    }

    private double scaleLevelToZoomValue(int level) {
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return 1.0;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        int levelsCount = this.getScaleLevelsCount();
        if (levelsCount == 1) {
            if (minLevelZoomVal > maxLevelZoomVal) {
                return minLevelZoomVal;
            }
            return Math.min(minLevelZoomVal, maxLevelZoomVal);
        }
        if (levelsCount == 2) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        if (levelsCount >= 3) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
                case 1: {
                    return mediumLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        Log.i((String)TAG, (String)("scaleLevelToZoomValue, invalid levelsCount=" + levelsCount));
        return 0.0;
    }

    private void trimContentPos() {
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
        float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
        if (this.mContentX > 0.0f) {
            if (contentWidth >= (float)this.mUnitShare.getWidth()) {
                this.mContentX = 0.0f;
            } else if (this.mContentX + contentWidth > (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
            }
        } else if (contentWidth >= (float)this.mUnitShare.getWidth() && this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
            this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
        } else if (contentWidth <= (float)this.mUnitShare.getWidth()) {
            this.mContentX = 0.0f;
        }
        if (this.mContentY > 0.0f) {
            if (contentHeight >= (float)this.mUnitShare.getHeight()) {
                this.mContentY = 0.0f;
            } else if (this.mContentY + contentHeight > (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
            }
        } else if (contentHeight >= (float)this.mUnitShare.getHeight() && this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
            this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
        } else if (contentHeight <= (float)this.mUnitShare.getHeight()) {
            this.mContentY = 0.0f;
        }
    }

    private int getShareRenderWidth() {
        return this.mShareUnitRenderInfo.widthPercent * this.mWidth / 100;
    }

    private int getShareRenderHeight() {
        return this.mShareUnitRenderInfo.heightPercent * this.mHeight / 100;
    }
}

