/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.sdk.SDKShareView;
import com.zipow.videobox.sdk.SDKVideoRenderer;
import com.zipow.videobox.sdk.SDKVideoView;
import com.zipow.videobox.view.video.VideoRenderer;
import com.zipow.videobox.view.video.ZPGLTextureView;
import java.util.concurrent.atomic.AtomicInteger;
import javax.microedition.khronos.opengles.GL10;
import us.zoom.androidlib.util.HardwareUtil;
import us.zoom.sdk.MobileRTCVideoViewManager;
import us.zoom.sdk.MobileRTCVideoViewManagerImpl;
import us.zoom.sdk.SDKMainHandler;
import us.zoom.videomeetings.R;

public class MobileRTCVideoView
extends RelativeLayout
implements SDKVideoView.Listener,
GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    private static final String TAG = MobileRTCVideoView.class.getSimpleName();
    private MobileRTCVideoViewManagerImpl mVideoViewMgr;
    private MobileRTCVideoRender mVideoRender;
    private ViewGroup mView;
    private SDKVideoView mVideoView;
    private SDKShareView mShareView;
    private GestureDetector mGestureDetector;
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public MobileRTCVideoView(Context context) {
        this(context, null);
    }

    public MobileRTCVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MobileRTCVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mView = (ViewGroup)LayoutInflater.from((Context)context).inflate(R.layout.zm_videoview_sdk, null, false);
        this.mVideoView = (SDKVideoView)this.mView.findViewById(R.id.videoContainer);
        this.mShareView = (SDKShareView)this.mView.findViewById(R.id.shareView);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        this.mGestureDetector.setIsLongpressEnabled(false);
        this.initVideoView(context);
        this.mVideoViewMgr = new MobileRTCVideoViewManagerImpl(this.mVideoRender, this.mShareView);
        this.addView((View)this.mView);
    }

    private void initVideoView(Context context) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.mVideoView.setPreserveEGLContextOnPause(true);
        }
        this.mVideoRender = new MobileRTCVideoRender(this.mVideoView, MobileRTCVideoView.generateGroupIndex());
        this.mVideoView.setRenderer(this.mVideoRender);
        this.mVideoView.setListener(this);
    }

    public void setGestureDetectorEnabled(boolean isEnabled) {
        if (!this.isInEditMode() && isEnabled) {
            this.mVideoView.setGestureDetector(this.mGestureDetector);
        } else {
            this.mVideoView.setGestureDetector(null);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    public synchronized MobileRTCVideoViewManager getVideoViewManager() {
        if (!PTApp.getInstance().isSdkEnableCustomizedUI()) {
            return null;
        }
        Mainboard mainboard = Mainboard.getMainboard();
        if (mainboard != null && !mainboard.isSDKConfAppCreated()) {
            return null;
        }
        return this.mVideoViewMgr;
    }

    public void onPause() {
        this.mVideoView.onPause();
        this.mVideoRender.pauseRenderer();
    }

    public void onResume() {
        this.mVideoView.onResume();
        this.mVideoRender.resumeRenderer();
    }

    public boolean onDown(MotionEvent e) {
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mVideoViewMgr != null) {
            this.mVideoViewMgr.onFling(e1, e2, velocityX, velocityY);
        }
        return true;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mVideoViewMgr != null) {
            this.mVideoViewMgr.onScroll(e1, e2, distanceX, distanceY);
        }
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.mVideoViewMgr != null) {
            this.mVideoViewMgr.onDoubleTap(e);
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        return true;
    }

    private static int generateGroupIndex() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    @Override
    public void beforeGLContextDestroyed() {
        if (this.mVideoRender != null) {
            Log.i((String)TAG, (String)("beforeGLContextDestroyed group index =" + this.mVideoRender.getGroupIndex()));
            this.mVideoRender.beforeGLContextDestroyed();
        }
    }

    @Override
    public void onVideoViewAttached() {
        Log.i((String)TAG, (String)("onAttachedToWindow group index =" + this.mVideoRender.getGroupIndex()));
    }

    @Override
    public void onVideoViewDettached() {
        Log.i((String)TAG, (String)("onDetachedFromWindow group index =" + this.mVideoRender.getGroupIndex()));
        if (this.mVideoViewMgr != null) {
            this.mVideoViewMgr.destory();
        }
    }

    class MobileRTCVideoRender
    extends SDKVideoRenderer {
        private static final int RENDERER_FPS = 25;
        private static final int RENDERER_FPS_LOW_PERFORMANCE = 15;
        private int mGroupIndex;
        long lastIdleTaskTime;

        public MobileRTCVideoRender(ZPGLTextureView glView, int groupIndex) {
            super(glView, groupIndex);
            this.lastIdleTaskTime = 0L;
            this.mGroupIndex = groupIndex;
        }

        @Override
        public void onDrawFrame(GL10 gl, VideoRenderer renderer) {
            long curTime = System.currentTimeMillis();
            if (curTime < this.lastIdleTaskTime || curTime - this.lastIdleTaskTime > 500L) {
                this.lastIdleTaskTime = curTime;
                SDKMainHandler.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        if (MobileRTCVideoView.this.mVideoViewMgr != null) {
                            MobileRTCVideoView.this.mVideoViewMgr.onIdle();
                        }
                    }
                });
            }
        }

        public float getProperFPS() {
            float fps = 25.0f;
            if (HardwareUtil.getCPUKernalNumbers() < 2 && HardwareUtil.getCPUKernelFrequency((int)0, (int)2) < 1400000) {
                fps = 15.0f;
            }
            return fps;
        }

        @Override
        protected void onGLSurfaceCreated() {
            Log.i((String)TAG, (String)("onGLSurfaceCreated group index =" + this.mGroupIndex));
        }

        @Override
        protected void onGLSurfaceChanged(final int width, final int height) {
            Log.i((String)TAG, (String)("onGLSurfaceChanged group index =" + this.mGroupIndex + ", width=" + width + ", height=" + height));
            if (!this.isInitialized()) {
                this.initialize();
            }
            final MobileRTCVideoRender renderer = this;
            SDKMainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    if (MobileRTCVideoView.this.mVideoViewMgr != null) {
                        MobileRTCVideoView.this.mVideoViewMgr.onGLSurfaceChanged(renderer, width, height);
                    }
                }
            });
        }

        @Override
        protected void onGLSurfaceDestoryed() {
            if (!this.isRunning()) {
                this.stopRenderer();
            }
            SDKMainHandler.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    if (MobileRTCVideoView.this.mVideoViewMgr != null) {
                        MobileRTCVideoView.this.mVideoViewMgr.onGLSurfaceDestoryed();
                    }
                }
            });
        }

        public int getGroupIndex() {
            return this.mGroupIndex;
        }
    }
}

