/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.video.VideoLayoutHelper;
import us.zoom.sdk.MeetingSettingsHelper;

class MeetingSettingsHelperImpl
implements MeetingSettingsHelper {
    MeetingSettingsHelperImpl() {
    }

    @Override
    public void setAutoConnectVoIPWhenJoinMeeting(boolean enabled) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setAlwaysUseVoIPWhenJoinMeeting(enabled);
    }

    @Override
    public boolean isAutoConnectVoIPWhenJoinMeetingEnabled() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.alwaysUseVoIPWhenJoinMeeting();
    }

    @Override
    public void setMuteMyMicrophoneWhenJoinMeeting(boolean enabled) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setAlwaysMuteMicWhenJoinVoIP(enabled);
    }

    @Override
    public boolean isMuteMyMicrophoneWhenJoinMeetingEnabled() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.alwaysMuteMicWhenJoinVoIP();
    }

    @Override
    public void setTurnOffMyVideoWhenJoinMeeting(boolean enabled) {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return;
        }
        settingHelper.setNeverStartVideoWhenJoinMeeting(enabled);
    }

    @Override
    public boolean isTurnOffMyVideoWhenJoinMeetingEnabled() {
        PTSettingHelper settingHelper = PTApp.getInstance().getSettingHelper();
        if (settingHelper == null) {
            return false;
        }
        return settingHelper.neverStartVideoWhenJoinMeeting();
    }

    @Override
    public void setKubiDeviceEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("enable_kubi_device", enabled);
    }

    @Override
    public boolean isKubiDeviceEnabled() {
        return PreferenceUtil.readBooleanValue("enable_kubi_device", false);
    }

    @Override
    public void setPreferredCameraAntibanding(String antibanding) {
        PreferenceUtil.saveStringValue("camera_antibanding", antibanding);
    }

    @Override
    public String getPreferredCameraAntibanding() {
        String antibanding = PreferenceUtil.readStringValue("camera_antibanding", null);
        return antibanding;
    }

    @Override
    public boolean isHideNoVideoUsersEnabled() {
        return VideoLayoutHelper.getInstance().isHideNoVideoUsersEnabled();
    }

    @Override
    public void setHideNoVideoUsersEnabled(boolean enabled) {
        VideoLayoutHelper.getInstance().setHideNoVideoUsersEnabled(enabled);
    }

    @Override
    public boolean isSwitchVideoLayoutAccordingToUserCountEnabled() {
        return VideoLayoutHelper.getInstance().isSwitchVideoLayoutAccordingToUserCountEnabled();
    }

    @Override
    public void setSwitchVideoLayoutAccordingToUserCountEnabled(boolean enabled) {
        VideoLayoutHelper.getInstance().setSwitchVideoLayoutAccordingToUserCountEnabled(enabled);
    }

    @Override
    public int getSwitchVideoLayoutUserCountThreshold() {
        return VideoLayoutHelper.getInstance().getSwitchVideoLayoutUserCountThreshold();
    }

    @Override
    public void setSwitchVideoLayoutUserCountThreshold(int value) {
        VideoLayoutHelper.getInstance().setSwitchVideoLayoutUserCountThreshold(value);
    }

    @Override
    public void setGalleryVideoViewDisabled(boolean disabled) {
        PreferenceUtil.saveBooleanValue("no_gallery_videos_view", disabled);
    }

    @Override
    public boolean isGalleryVideoViewDisabled() {
        return PreferenceUtil.readBooleanValue("no_gallery_videos_view", false);
    }

    @Override
    public void setGalleryViewCapacity(int cap) {
        VideoLayoutHelper.getInstance().setGalleryViewCapacity(cap);
    }

    @Override
    public int getGalleryViewCapacity() {
        return VideoLayoutHelper.getInstance().getGalleryViewCapacity();
    }

    @Override
    public boolean isAlwaysShowMeetingToolbarEnabled() {
        return PreferenceUtil.readBooleanValue("always_show_meeting_toolbar", false);
    }

    @Override
    public void setAlwaysShowMeetingToolbarEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("always_show_meeting_toolbar", enabled);
    }

    @Override
    public boolean isNoVideoTileOnShareScreenEnabled() {
        return PreferenceUtil.readBooleanValue("no_video_tile_on_share_screen", false);
    }

    @Override
    public void setNoVideoTileOnShareScreenEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("no_video_tile_on_share_screen", enabled);
    }

    @Override
    public void setLargeShareVideoSceneEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("large_share_video_scene_mode", enabled);
    }

    @Override
    public boolean isLargeShareVideoSceneEnabled() {
        return PreferenceUtil.readBooleanValue("large_share_video_scene_mode", false);
    }

    @Override
    public boolean isNoLeaveMeetingButtonForHostEnabled() {
        return PreferenceUtil.readBooleanValue("no_leave_meeting_button_for_host", false);
    }

    @Override
    public void setNoLeaveMeetingButtonForHostEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("no_leave_meeting_button_for_host", enabled);
    }

    @Override
    public boolean isNoUserJoinOrLeaveTipEnabled() {
        return PreferenceUtil.readBooleanValue("no_user_join_or_leave_tip", false);
    }

    @Override
    public void setNoUserJoinOrLeaveTipEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("no_user_join_or_leave_tip", enabled);
    }

    @Override
    public void setHideFullPhoneNumber4PureCallinUser(boolean bHide) {
        PTApp.getInstance().enableHideFullPhoneNumber4PureCallinUser(bHide);
    }

    @Override
    public boolean isCustomizedMeetingUIEnabled() {
        return PTApp.getInstance().isSdkEnableCustomizedUI() && PreferenceUtil.readBooleanValue("sdk_use_customized_meeting_ui", false);
    }

    @Override
    public void setCustomizedMeetingUIEnabled(boolean enabled) {
        if (!PTApp.getInstance().isSdkEnableCustomizedUI()) {
            return;
        }
        PreferenceUtil.saveBooleanValue("sdk_use_customized_meeting_ui", enabled);
    }

    @Override
    public void setConfNotificatonChannelId(String channelId) {
        PreferenceUtil.saveStringValue("sdk_conf_notification_channel_id", channelId);
    }

    @Override
    public void setClaimHostWithHostKeyActionEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("sdk_enable_claim_host_with_hostkey", enabled);
    }

    @Override
    public void setNoInviteH323RoomCallOutEnabled(boolean enabled) {
        PreferenceUtil.saveBooleanValue("sdk_no_invite_room_call_out", enabled);
    }

    @Override
    public void setClosedCaptionHidden(boolean bHide) {
        PreferenceUtil.saveBooleanValue("closed_caption_enabled", !bHide);
    }

    @Override
    public boolean isHideClosedCaption() {
        return !PreferenceUtil.readBooleanValue("closed_caption_enabled", false);
    }
}

