/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.zipow.videobox.IntegrationActivity;
import com.zipow.videobox.JoinByURLActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.mainboard.Mainboard;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppAPI4SDKSinkUI;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.sdk.SDKCustomizedMeetingUIHelper;
import com.zipow.videobox.util.PreferenceUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.DialOutStatusListener;
import us.zoom.sdk.InstantMeetingOptions;
import us.zoom.sdk.InviteRoomSystemHelper;
import us.zoom.sdk.InviteRoomSystemHelperImpl;
import us.zoom.sdk.JoinMeetingOptions;
import us.zoom.sdk.JoinMeetingParams;
import us.zoom.sdk.MeetingOptions;
import us.zoom.sdk.MeetingService;
import us.zoom.sdk.MeetingServiceListener;
import us.zoom.sdk.MeetingStatus;
import us.zoom.sdk.SDKMainHandler;
import us.zoom.sdk.SDKMeetingInterfaceHelper;
import us.zoom.sdk.StartMeetingOptions;
import us.zoom.sdk.StartMeetingParams;
import us.zoom.sdk.StartMeetingParams4APIUser;
import us.zoom.sdk.StartMeetingParams4NormalUser;
import us.zoom.sdk.StartMeetingParamsWithoutLogin;
import us.zoom.sdk.ZoomSDK;
import us.zoom.videomeetings.R;

class MeetingServiceImpl
implements MeetingService,
PTAppAPI4SDKSinkUI.IPTAppAPI4SDKSinkUIListener,
PTUI.IConfFailListener,
PTUI.IInviteByCallOutListener,
PTUI.ICallMeListener {
    private static final String TAG = MeetingServiceImpl.class.getSimpleName();
    private static final int ZC_OPTIONS_NO_AUDIO = 8;
    private static final int ZC_OPTIONS_NO_VIDEO = 16;
    private ZoomSDK mZoomSdk;
    private boolean isConfInstanceExist = false;
    private MeetingStatus mMeetingStatus = MeetingStatus.MEETING_STATUS_IDLE;
    private int mInmeetingMask = 0;
    private InviteRoomSystemHelper mInviteRoomSystemHelper;
    private ListenerList mListenerList = new ListenerList();
    private ListenerList mCallOutListenerList = new ListenerList();
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onConfStatusChanged(int status) {
            return MeetingServiceImpl.this.handleOnConfStatusChanged(status);
        }

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return MeetingServiceImpl.this.handleOnConfStatusChanged2(cmd, ret);
        }

        @Override
        public void onJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
            MeetingServiceImpl.this.handleJoinConfConfirmPasswordValidateResult(success, needWait);
        }
    };
    private static final int CONF_READY_MASK = 1;
    private static final int SHARE_READY_MASK = 2;
    private static final int VIDEO_READY_MASK = 4;
    private static final int AUDIO_READY_MASK = 8;

    public MeetingServiceImpl(ZoomSDK zoomSdk) {
        this.mZoomSdk = zoomSdk;
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
        PTUI.getInstance().addConfFailListener(this);
        PTUI.getInstance().addInviteByCallOutListener(this);
        PTUI.getInstance().addCallMeListener(this);
        PTApp.getInstance().setPTAppAPI4SDKSink(PTAppAPI4SDKSinkUI.getInstance());
        PTAppAPI4SDKSinkUI.getInstance().addListener(this);
    }

    @Override
    public void addListener(MeetingServiceListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(MeetingServiceListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public void addDialOutListener(DialOutStatusListener listener) {
        this.mCallOutListenerList.add((IListener)listener);
    }

    @Override
    public void removeDialOutListener(DialOutStatusListener listener) {
        this.mCallOutListenerList.remove((IListener)listener);
    }

    @Override
    public int startMeeting(Context context, String meetingNo) {
        return this.startMeeting(context, meetingNo, null);
    }

    @Override
    public int startMeeting(Context context, String meetingNo, MeetingOptions opts) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IDLE) {
            Log.e((String)TAG, (String)"startMeeting: Already has a meeting in progress or is starting.");
            return 101;
        }
        StringBuilder sUri = new StringBuilder();
        sUri.append(this.getZoomScheme(context) + "://");
        sUri.append(this.mZoomSdk.getDomain());
        sUri.append("/start?");
        if (meetingNo != null && meetingNo.length() > 0) {
            sUri.append("confno=");
            sUri.append(meetingNo);
            if (opts != null && !(opts instanceof StartMeetingOptions) && !MeetingOptions.class.getName().equals(opts.getClass().getName())) {
                throw new RuntimeException("To start an existed meeting, meeting options should be an instance of MeetingOptions or StartMeetingOptions.");
            }
        } else if (opts != null && !(opts instanceof InstantMeetingOptions) && !MeetingOptions.class.getName().equals(opts.getClass().getName())) {
            throw new RuntimeException("To start an instant meeting, meeting options should be an instance of MeetingOptions or InstantMeetingOptions.");
        }
        this.appendOptions(opts, sUri);
        Log.i((String)TAG, (String)("startMeeting: sUri=" + sUri));
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUri.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"startMeeting: Parse URL failed", (Throwable)e);
            return 100;
        }
        this.handleUriAction(context, uri);
        return 0;
    }

    @Override
    public int startMeeting(Context context, String userId, String zoomToken, int userType, String meetingNo, String displayName) {
        return this.startMeeting(context, userId, zoomToken, userType, meetingNo, displayName, null);
    }

    @Override
    public int startMeeting(Context context, String userId, String zoomToken, int userType, String meetingNo, String displayName, MeetingOptions opts) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IDLE) {
            Log.e((String)TAG, (String)"startMeeting: Already has a meeting in progress or is starting.");
            return 101;
        }
        if (context == null || userId == null || userId.length() == 0 || zoomToken == null || zoomToken.length() == 0 || displayName == null || displayName.length() == 0) {
            Log.e((String)TAG, (String)"startMeeting: context, userId, zoomToken, meetingNo and displayName cannot be null or empty");
            return 99;
        }
        if (userType != 99 && userType != 100) {
            Log.e((String)TAG, (String)("startMeeting: invalid userType: " + userType));
            return 99;
        }
        if (userType == 99 && StringUtil.isEmptyOrNull((String)meetingNo)) {
            Log.e((String)TAG, (String)"startMeeting: API user can not start a instant meeting");
            return 99;
        }
        StringBuilder sUri = new StringBuilder();
        sUri.append(this.getZoomScheme(context) + "://");
        sUri.append(this.mZoomSdk.getDomain());
        sUri.append("/start?stype=");
        sUri.append(userType);
        sUri.append("&sid=");
        sUri.append(userId);
        sUri.append("&uid=");
        sUri.append(userId);
        sUri.append("&token=");
        sUri.append(zoomToken);
        sUri.append("&uname=");
        try {
            sUri.append(URLEncoder.encode(displayName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"startMeeting: URL encode displayName failed", (Throwable)e);
            return 100;
        }
        if (meetingNo != null && meetingNo.length() > 0) {
            sUri.append("&confno=");
            sUri.append(meetingNo);
            if (opts != null && !(opts instanceof StartMeetingOptions) && !MeetingOptions.class.getName().equals(opts.getClass().getName())) {
                throw new RuntimeException("To start an existed meeting, meeting options should be an instance of MeetingOptions or StartMeetingOptions.");
            }
        } else if (opts != null && !(opts instanceof InstantMeetingOptions) && !MeetingOptions.class.getName().equals(opts.getClass().getName())) {
            throw new RuntimeException("To start an instant meeting, meeting options should be an instance of MeetingOptions or InstantMeetingOptions.");
        }
        this.appendOptions(opts, sUri);
        Log.i((String)TAG, (String)("startMeeting: sUri=" + sUri));
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUri.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"startMeeting: Parse URL failed", (Throwable)e);
            return 100;
        }
        this.handleUriAction(context, uri);
        return 0;
    }

    @Override
    public int startMeetingWithParams(Context context, StartMeetingParams param) {
        return this.startMeetingWithParams(context, param, null);
    }

    @Override
    public int startMeetingWithParams(Context context, StartMeetingParams param, StartMeetingOptions opts) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IDLE) {
            Log.e((String)TAG, (String)"startMeetingWithParams: Already has a meeting in progress or is starting.");
            return 101;
        }
        if (context == null || param == null || (param.meetingNo == null || param.meetingNo.length() == 0) && (param.vanityID == null || param.vanityID.length() == 0)) {
            Log.e((String)TAG, (String)"startMeetingWithParams: context, params and params's meetingNo/vanityId  cannot be null or empty");
            return 99;
        }
        if (param.meetingNo != null && param.meetingNo.length() > 0 && param.vanityID != null && param.vanityID.length() > 0) {
            Log.e((String)TAG, (String)"startMeetingWithParams: Both meetingNo and vanityID have value,  please just set one of them");
            return 99;
        }
        StringBuilder sUri = new StringBuilder();
        sUri.append(this.getZoomScheme(context) + "://");
        sUri.append(this.mZoomSdk.getDomain());
        if (param instanceof StartMeetingParams4APIUser) {
            StartMeetingParams4APIUser params4APIUser = (StartMeetingParams4APIUser)param;
            if (params4APIUser.userId == null || params4APIUser.userId.length() == 0 || params4APIUser.zoomToken == null || params4APIUser.zoomToken.length() == 0 || params4APIUser.displayName == null || params4APIUser.displayName.length() == 0) {
                Log.e((String)TAG, (String)"StartMeetingParams4APIUser:  userId, zoomToken and displayName cannot be null or empty");
                return 99;
            }
            sUri.append("/start?stype=");
            sUri.append(99);
            sUri.append("&sid=");
            sUri.append(params4APIUser.userId);
            sUri.append("&uid=");
            sUri.append(params4APIUser.userId);
            sUri.append("&token=");
            sUri.append(params4APIUser.zoomToken);
            sUri.append("&uname=");
            try {
                sUri.append(URLEncoder.encode(params4APIUser.displayName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"startMeetingWithParams: URL encode displayName failed", (Throwable)e);
                return 100;
            }
            sUri.append("&confno=");
            if (param.meetingNo != null && param.meetingNo.length() > 0) {
                if (param.meetingNo.equals("0")) {
                    return 99;
                }
                sUri.append(param.meetingNo);
            } else {
                sUri.append("0&sdkVanityID=");
                sUri.append(param.vanityID);
            }
        } else if (param instanceof StartMeetingParams4NormalUser) {
            if (!this.mZoomSdk.isLoggedIn()) {
                return 101;
            }
            StartMeetingParams4NormalUser params4NormalUser = (StartMeetingParams4NormalUser)param;
            sUri.append("/start?");
            sUri.append("confno=");
            if (params4NormalUser.meetingNo != null && params4NormalUser.meetingNo.length() > 0) {
                sUri.append(params4NormalUser.meetingNo);
            } else {
                sUri.append("0&sdkVanityID=");
                sUri.append(params4NormalUser.vanityID);
            }
        } else if (param instanceof StartMeetingParamsWithoutLogin) {
            if (this.mZoomSdk.isLoggedIn()) {
                return 101;
            }
            StartMeetingParamsWithoutLogin paramsWithoutLogin = (StartMeetingParamsWithoutLogin)param;
            if (paramsWithoutLogin.userId == null || paramsWithoutLogin.userId.length() == 0 || paramsWithoutLogin.zoomToken == null || paramsWithoutLogin.zoomToken.length() == 0 || paramsWithoutLogin.zoomAccessToken == null || paramsWithoutLogin.zoomAccessToken.length() == 0 || paramsWithoutLogin.displayName == null || paramsWithoutLogin.displayName.length() == 0) {
                Log.e((String)TAG, (String)"StartMeetingParams4APIUser:  userId, zoomToken and displayName cannot be null or empty");
                return 99;
            }
            if (paramsWithoutLogin.userType != 99 && paramsWithoutLogin.userType != 100 && paramsWithoutLogin.userType != 0 && paramsWithoutLogin.userType != 2 && paramsWithoutLogin.userType != 101 && paramsWithoutLogin.userType != 102) {
                Log.e((String)TAG, (String)("StartMeetingParamsWithoutLogin: invalid userType: " + paramsWithoutLogin.userType));
                return 99;
            }
            sUri.append("/start?stype=");
            sUri.append(paramsWithoutLogin.userType);
            sUri.append("&sid=");
            sUri.append(paramsWithoutLogin.userId);
            sUri.append("&uid=");
            sUri.append(paramsWithoutLogin.userId);
            sUri.append("&token=");
            sUri.append(paramsWithoutLogin.zoomToken);
            if (paramsWithoutLogin.zoomAccessToken != null && paramsWithoutLogin.zoomAccessToken.length() > 0) {
                sUri.append("&zak=");
                sUri.append(paramsWithoutLogin.zoomAccessToken);
            }
            sUri.append("&uname=");
            try {
                sUri.append(URLEncoder.encode(paramsWithoutLogin.displayName, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"startMeetingWithParams: URL encode displayName failed", (Throwable)e);
                return 100;
            }
            sUri.append("&confno=");
            if (param.meetingNo != null && param.meetingNo.length() > 0) {
                if (param.meetingNo.equals("0") && paramsWithoutLogin.userType == 99) {
                    return 99;
                }
                sUri.append(param.meetingNo);
            } else {
                sUri.append("0&sdkVanityID=");
                sUri.append(param.vanityID);
            }
        } else {
            return 99;
        }
        this.appendOptions(opts, sUri);
        Log.i((String)TAG, (String)("startMeetingWithParams: sUri=" + sUri));
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUri.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"startMeetingWithParams: Parse URL failed", (Throwable)e);
            return 100;
        }
        this.handleUriAction(context, uri);
        return 0;
    }

    @Override
    public int startInstantMeeting(Context context) {
        return this.startInstantMeeting(context, null);
    }

    @Override
    public int startInstantMeeting(Context context, MeetingOptions opts) {
        return this.startMeeting(context, null, opts);
    }

    @Override
    public int startInstantMeeting(Context context, String userId, String zoomToken, int userType, String displayName) {
        return this.startInstantMeeting(context, userId, zoomToken, userType, displayName, null);
    }

    @Override
    public int startInstantMeeting(Context context, String userId, String zoomToken, int userType, String displayName, MeetingOptions opts) {
        return this.startMeeting(context, userId, zoomToken, userType, null, displayName, opts);
    }

    @Override
    public int joinMeeting(Context context, String meetingNo, String displayName) {
        return this.joinMeeting(context, meetingNo, displayName, null, null);
    }

    @Override
    public int joinMeeting(Context context, String meetingNo, String displayName, String password) {
        return this.joinMeeting(context, meetingNo, displayName, password, null);
    }

    @Override
    public int joinMeeting(Context context, String meetingNo, String displayName, MeetingOptions opts) {
        return this.joinMeeting(context, meetingNo, displayName, null, opts);
    }

    @Override
    public int joinMeeting(Context context, String meetingNo, String displayName, String password, MeetingOptions opts) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IDLE) {
            Log.e((String)TAG, (String)"joinMeeting: Already has a meeting in progress or is starting.");
            return 101;
        }
        if (context == null || meetingNo == null || meetingNo.length() == 0 || displayName == null || displayName.length() == 0) {
            Log.e((String)TAG, (String)"joinMeeting: context, meetingNo and displayName cannot be null or empty");
            return 99;
        }
        StringBuilder sUri = new StringBuilder();
        sUri.append(this.getZoomScheme(context) + "://");
        sUri.append(this.mZoomSdk.getDomain());
        sUri.append("/join?confno=");
        sUri.append(meetingNo);
        sUri.append("&uname=");
        try {
            sUri.append(URLEncoder.encode(displayName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"joinMeeting: URL encode displayName failed", (Throwable)e);
            return 100;
        }
        if (!StringUtil.isEmptyOrNull((String)password)) {
            sUri.append("&pwd=");
            try {
                sUri.append(URLEncoder.encode(password, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"joinMeeting: URL encode displayName failed", (Throwable)e);
                return 100;
            }
        }
        if (opts != null && !(opts instanceof JoinMeetingOptions) && !MeetingOptions.class.getName().equals(opts.getClass().getName())) {
            throw new RuntimeException("To join an meeting, meeting options should be an instance of MeetingOptions or JoinMeetingOptions.");
        }
        this.appendOptions(opts, sUri);
        Log.i((String)TAG, (String)("joinMeeting: sUri=" + sUri));
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUri.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"joinMeeting: Parse URL failed", (Throwable)e);
            return 100;
        }
        this.handleUriAction(context, uri);
        return 0;
    }

    @Override
    public int joinMeetingWithParams(Context context, JoinMeetingParams param) {
        return this.joinMeetingWithParams(context, param, null);
    }

    @Override
    public int joinMeetingWithParams(Context context, JoinMeetingParams param, JoinMeetingOptions opts) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IDLE) {
            Log.e((String)TAG, (String)"joinMeeting: Already has a meeting in progress or is starting.");
            return 101;
        }
        if (context == null || param == null || (param.meetingNo == null || param.meetingNo.length() == 0) && (param.vanityID == null || param.vanityID.length() == 0) || param.displayName == null || param.displayName.length() == 0) {
            Log.e((String)TAG, (String)"joinMeetingWithParams: context, meetingNo, vanityID and displayName cannot be null or empty");
            return 99;
        }
        if (param.meetingNo != null && param.meetingNo.length() > 0 && param.vanityID != null && param.vanityID.length() > 0) {
            Log.e((String)TAG, (String)"joinMeetingWithParams: Both meetingNo and vanityID have value,  please just set one of them");
            return 99;
        }
        StringBuilder sUri = new StringBuilder();
        sUri.append(this.getZoomScheme(context) + "://");
        sUri.append(this.mZoomSdk.getDomain());
        sUri.append("/join?confno=");
        if (param.vanityID != null && param.vanityID.length() > 0) {
            sUri.append("0&sdkVanityID=");
            sUri.append(param.vanityID);
        } else {
            sUri.append(param.meetingNo);
        }
        sUri.append("&uname=");
        try {
            sUri.append(URLEncoder.encode(param.displayName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)"joinMeeting: URL encode displayName failed", (Throwable)e);
            return 100;
        }
        if (!StringUtil.isEmptyOrNull((String)param.password)) {
            sUri.append("&pwd=");
            try {
                sUri.append(URLEncoder.encode(param.password, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"joinMeeting: URL encode displayName failed", (Throwable)e);
                return 100;
            }
        }
        this.appendOptions(opts, sUri);
        Log.i((String)TAG, (String)("joinMeetingWithParams: sUri=" + sUri));
        Uri uri = null;
        try {
            uri = Uri.parse((String)sUri.toString());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"joinMeetingWithParams: Parse URL failed", (Throwable)e);
            return 100;
        }
        this.handleUriAction(context, uri);
        return 0;
    }

    private void handleUriAction(Context context, Uri uri) {
        if (PTApp.getInstance().isSdkEnableCustomizedUI() && PreferenceUtil.readBooleanValue("sdk_use_customized_meeting_ui", false)) {
            VideoBoxApplication.getInstance().setConfUIPreloaded(true);
            Mainboard.getMainboard().notifyUrlAction(uri.toString());
        } else {
            Intent intent = new Intent(context, JoinByURLActivity.class);
            intent.setAction("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            context.startActivity(intent);
        }
    }

    @Override
    public MeetingStatus getMeetingStatus() {
        if (!this.mZoomSdk.isInitialized()) {
            return MeetingStatus.MEETING_STATUS_IDLE;
        }
        return this.mMeetingStatus;
    }

    @Override
    public void leaveCurrentMeeting(boolean endIfPossible) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_CONNECTING && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IN_WAITING_ROOM && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_WAITINGFORHOST) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfStatus status = confMgr.getConfStatusObj();
        if (status != null && endIfPossible && status.isHost()) {
            confMgr.endConference();
        } else {
            confMgr.leaveConference();
        }
    }

    @Override
    public void pauseCurrentMeeting() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return;
        }
        ConfUI.getInstance().pauseAudio();
    }

    @Override
    public void resumeCurrentMeeting() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return;
        }
        ConfUI.getInstance().resumeAudio();
    }

    @Override
    public void returnToMeeting(Context context) {
        if (SDKCustomizedMeetingUIHelper.isSdkUsingCustomizedMeetingUI()) {
            return;
        }
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_CONNECTING && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_IN_WAITING_ROOM && this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_WAITINGFORHOST) {
            return;
        }
        if (context == null) {
            context = VideoBoxApplication.getInstance();
        }
        Intent clickIntent = new Intent(context, IntegrationActivity.class);
        clickIntent.setAction(IntegrationActivity.ACTION_RETURN_TO_CONF);
        if (!(context instanceof Activity)) {
            clickIntent.addFlags(0x10000000);
        }
        context.startActivity(clickIntent);
    }

    @Override
    public String getCurrentRtcMeetingID() {
        if (!this.mZoomSdk.isInitialized()) {
            return "";
        }
        return PTApp.getInstance().getActiveCallId();
    }

    @Override
    public long getCurrentRtcMeetingNumber() {
        if (!this.mZoomSdk.isInitialized()) {
            return 0L;
        }
        return PTApp.getInstance().getActiveMeetingNo();
    }

    @Override
    public String getCurrentMeetingUrl() {
        if (!this.mZoomSdk.isInitialized()) {
            return null;
        }
        MeetingInfo meetingItem = PTApp.getInstance().getActiveMeetingItem();
        if (meetingItem != null) {
            return meetingItem.getJoinMeetingUrl();
        }
        return null;
    }

    @Override
    public boolean isCurrentMeetingLocked() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfStatus status = confMgr.getConfStatusObj();
        return status != null && status.isConfLocked();
    }

    @Override
    public boolean isCurrentMeetingHost() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && myself.isHost();
    }

    @Override
    public boolean dialOutUser(String number, String userName, boolean isCallMe) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        if (this.isDialOutInProgress()) {
            return false;
        }
        if (isCallMe) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus status = confMgr.getConfStatusObj();
            return status != null && status.startCallOut(number);
        }
        return PTApp.getInstance().inviteCallOutUser(number, userName);
    }

    @Override
    public boolean cancelDialOut(boolean isCallMe) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        if (!this.isDialOutInProgress()) {
            return false;
        }
        if (isCallMe) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus status = confMgr.getConfStatusObj();
            return status != null && status.hangUp();
        }
        return PTApp.getInstance().cancelCallOut();
    }

    @Override
    public boolean isDialOutInProgress() {
        return this.isDialOutInProgress(true) && this.getCallOutStatus(true) != 0 || this.isDialOutInProgress(false) && this.getCallOutStatus(false) != 0;
    }

    private boolean isDialOutInProgress(boolean isCallMe) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        if (isCallMe) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus status = confMgr.getConfStatusObj();
            return status != null && status.isCallOutInProgress();
        }
        return PTApp.getInstance().isCallOutInProgress(null);
    }

    private int getCallOutStatus(boolean isCallMe) {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return 0;
        }
        if (isCallMe) {
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmConfStatus status = confMgr.getConfStatusObj();
            if (status != null) {
                return status.getCallMeStatus();
            }
            return 0;
        }
        return PTApp.getInstance().getCallOutStatus();
    }

    @Override
    public boolean isDialoutSupported() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        MeetingInfo meetingItem = confContext.getMeetingItem();
        if (meetingItem == null) {
            return false;
        }
        int supportCallOutType = meetingItem.getSupportCallOutType();
        return 0 != supportCallOutType && !meetingItem.getTelephonyOff();
    }

    @Override
    public boolean isInviteRoomSystemSupported() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        MeetingInfo info = confContext.getMeetingItem();
        if (info == null) {
            return false;
        }
        return info.getIsH323Enabled();
    }

    @Override
    public void configDSCP(int audio, int video, boolean reset) {
        VideoBoxApplication app = VideoBoxApplication.getInstance();
        if (app.isPTApp()) {
            PTApp.getInstance().configSdkDSCP(audio, video, reset);
        }
    }

    private boolean handleOnConfStatusChanged(int status) {
        MeetingStatus newMeetingStatus = this.mMeetingStatus;
        switch (status) {
            case 2: 
            case 5: 
            case 10: {
                newMeetingStatus = MeetingStatus.MEETING_STATUS_CONNECTING;
                this.isConfInstanceExist = true;
                break;
            }
            case 14: {
                newMeetingStatus = MeetingStatus.MEETING_STATUS_DISCONNECTING;
                break;
            }
            case 20: {
                newMeetingStatus = MeetingStatus.MEETING_STATUS_RECONNECTING;
                break;
            }
        }
        this.notifyMeetingStatus(newMeetingStatus, 0, 0);
        return true;
    }

    private boolean handleOnConfStatusChanged2(int cmd, long ret) {
        MeetingStatus newMeetingStatus = this.mMeetingStatus;
        if (cmd == 39) {
            newMeetingStatus = SDKMeetingInterfaceHelper.isInSlientMode() ? MeetingStatus.MEETING_STATUS_IN_WAITING_ROOM : MeetingStatus.MEETING_STATUS_INMEETING;
            this.notifyMeetingStatus(newMeetingStatus, 0, 0);
            return true;
        }
        boolean inmeetingStautsLogic = true;
        switch (cmd) {
            case 5: {
                this.mInmeetingMask |= 8;
                break;
            }
            case 6: {
                this.mInmeetingMask |= 4;
                break;
            }
            case 60: {
                this.mInmeetingMask |= 2;
                break;
            }
            case 8: {
                this.mInmeetingMask |= 1;
                break;
            }
            default: {
                inmeetingStautsLogic = false;
            }
        }
        if (inmeetingStautsLogic && this.isReady2InMeeting(this.mInmeetingMask)) {
            newMeetingStatus = SDKMeetingInterfaceHelper.isInSlientMode() ? MeetingStatus.MEETING_STATUS_IN_WAITING_ROOM : MeetingStatus.MEETING_STATUS_INMEETING;
            this.mInmeetingMask = 0;
            this.notifyMeetingStatus(newMeetingStatus, 0, 0);
        }
        return true;
    }

    @Override
    public void onConfFail(int reason, int errorCode) {
        switch (reason) {
            case 1: {
                break;
            }
            case 4: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 4, errorCode);
                break;
            }
            case 11: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 5, errorCode);
                break;
            }
            case 12: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 6, errorCode);
                break;
            }
            case 19: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 7, errorCode);
                break;
            }
            case 14: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 8, errorCode);
                break;
            }
            case 15: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 9, errorCode);
                break;
            }
            case 10: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 10, errorCode);
                break;
            }
            case 13: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 11, errorCode);
                break;
            }
            case 20: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 12, errorCode);
                break;
            }
            case 17: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 13, errorCode);
                break;
            }
            case 18: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 14, errorCode);
                break;
            }
            case 5: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 15, errorCode);
                break;
            }
            case 21: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 16, errorCode);
                break;
            }
            case 22: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 17, errorCode);
                break;
            }
            case 23: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 18, errorCode);
                break;
            }
            case 24: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 19, errorCode);
                break;
            }
            case 26: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 20, errorCode);
                break;
            }
            case 8: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 21, errorCode);
                break;
            }
            default: {
                this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_FAILED, 100, errorCode);
            }
        }
    }

    private void notifyMeetingStatus(final MeetingStatus status, final int errorCode, final int internalErrorCode) {
        if (status == this.mMeetingStatus) {
            return;
        }
        this.mMeetingStatus = status;
        SDKMainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                IListener[] listeners = MeetingServiceImpl.this.mListenerList.getAll();
                if (listeners != null) {
                    for (IListener listener : listeners) {
                        MeetingServiceListener l = (MeetingServiceListener)listener;
                        l.onMeetingStatusChanged(status, errorCode, internalErrorCode);
                    }
                }
            }
        });
    }

    private void handleJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
        if (success && needWait) {
            this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_WAITINGFORHOST, 0, 0);
        }
    }

    private boolean isReady2InMeeting(int flag) {
        return flag == 15;
    }

    @Override
    public void onCallOutStatusChanged(int status) {
        this.sinkCallOutStatusChanged(status);
    }

    @Override
    public void onCallMeStatusChanged(int status) {
        this.sinkCallOutStatusChanged(status);
    }

    private void sinkCallOutStatusChanged(int status) {
        if (status == 0) {
            return;
        }
        IListener[] listeners = this.mCallOutListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                DialOutStatusListener l = (DialOutStatusListener)listener;
                l.onDialOutStatusChanged(status);
            }
        }
    }

    private void appendOptions(MeetingOptions opts, StringBuilder sUri) {
        if (opts != null) {
            boolean hasKeepVoip = false;
            if (!StringUtil.isEmptyOrNull((String)opts.participant_id)) {
                sUri.append("&participantid=");
                try {
                    sUri.append(URLEncoder.encode(opts.participant_id, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Log.e((String)TAG, (String)"URL encode participantid failed", (Throwable)e);
                }
            }
            if (!StringUtil.isEmptyOrNull((String)opts.custom_meeting_id)) {
                sUri.append("&custom_meeting_id=");
                try {
                    sUri.append(URLEncoder.encode(opts.custom_meeting_id, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Log.e((String)TAG, (String)"URL encode custom_meeting_id failed", (Throwable)e);
                }
            }
            if (opts.no_driving_mode) {
                sUri.append("&no_driving_mode=1");
            }
            if (opts.no_invite) {
                sUri.append("&no_invite=1");
            }
            if (opts.no_meeting_end_message) {
                sUri.append("&no_meeting_end_message=1");
            }
            if (opts.no_meeting_error_message) {
                sUri.append("&no_meeting_error_message=1");
            }
            if (opts.no_titlebar) {
                sUri.append("&no_titlebar=1");
            }
            if (opts.no_bottom_toolbar) {
                sUri.append("&no_bottom_toolbar=1");
                if (!hasKeepVoip) {
                    sUri.append("&keep_voip=1");
                }
            }
            if (opts.no_dial_in_via_phone) {
                sUri.append("&no_dial_in_via_phone=1");
            }
            if (opts.no_dial_out_to_phone) {
                sUri.append("&no_dial_out_to_phone=1");
            }
            if (opts.no_disconnect_audio) {
                sUri.append("&no_disconnect_audio=1");
                if (!hasKeepVoip) {
                    sUri.append("&keep_voip=1");
                }
            }
            if (opts.no_share) {
                sUri.append("&no_share=1");
            }
            if (PTApp.getInstance().isSdkNeedWaterMark()) {
                sUri.append("&show_water_mark=1");
            }
            sUri.append("&meeting_views_options=" + opts.meeting_views_options);
            sUri.append("&invite_options=" + opts.invite_options);
            int zc = 0;
            if (opts.no_video) {
                zc |= 0x10;
            }
            if (opts instanceof JoinMeetingOptions) {
                JoinMeetingOptions joinOpts = (JoinMeetingOptions)opts;
                if (!StringUtil.isEmptyOrNull((String)joinOpts.webinar_token)) {
                    sUri.append("&tk=");
                    try {
                        sUri.append(URLEncoder.encode(joinOpts.webinar_token, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.e((String)TAG, (String)"URL encode webinar_token failed", (Throwable)e);
                    }
                }
                if (joinOpts.no_audio) {
                    zc |= 8;
                }
            } else if (opts instanceof StartMeetingOptions) {
                StartMeetingOptions startOpts = (StartMeetingOptions)opts;
                if (startOpts.no_audio) {
                    zc |= 8;
                }
            } else if (opts instanceof InstantMeetingOptions) {
                // empty if block
            }
            sUri.append("&zc=" + zc);
        }
    }

    private String getZoomScheme(Context context) {
        String str = context.getString(R.string.zm_zoom_scheme);
        if (StringUtil.isEmptyOrNull((String)str)) {
            str = "zoomus";
        }
        return str;
    }

    @Override
    public InviteRoomSystemHelper getInviteRoomSystemHelper() {
        if (this.mInviteRoomSystemHelper == null) {
            this.mInviteRoomSystemHelper = new InviteRoomSystemHelperImpl();
        }
        return this.mInviteRoomSystemHelper;
    }

    @Override
    public boolean tryRetrieveMicrophone() {
        if (this.getMeetingStatus() != MeetingStatus.MEETING_STATUS_INMEETING) {
            return false;
        }
        return ConfUI.getInstance().tryRetrieveMicrophone();
    }

    @Override
    public void Notify_VideoConfInstanceDestroyed() {
        this.isConfInstanceExist = false;
        this.mInmeetingMask = 0;
        this.notifyMeetingStatus(MeetingStatus.MEETING_STATUS_IDLE, 0, 0);
    }
}

