/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.content.Context;
import android.os.Bundle;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RecordMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.fragment.ConfChatFragment;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.UIMgr;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.androidlib.widget.ZMIgnoreKeyboardLayout;
import us.zoom.videomeetings.R;

public class MeetingActivity
extends ConfActivityNormal {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ZMIgnoreKeyboardLayout confViewContentLayout = (ZMIgnoreKeyboardLayout)this.findViewById(R.id.confViewContentLayout);
        if (confViewContentLayout != null) {
            confViewContentLayout.setIgnoreKeyboardOpen(false);
        }
    }

    @Override
    protected int getLayout() {
        return super.getLayout();
    }

    @Override
    public boolean isImmersedModeEnabled() {
        return this.isAlwaysFullScreen() && super.isImmersedModeEnabled();
    }

    protected boolean isAlwaysFullScreen() {
        return true;
    }

    @Override
    protected boolean isSensorOrientationEnabled() {
        return true;
    }

    @Override
    public void onClickParticipants() {
        super.onClickParticipants();
    }

    @Override
    protected void onStartShare() {
    }

    @Override
    protected void onStopShare() {
    }

    @Override
    protected void onAudioStatusChanged() {
    }

    @Override
    protected void onMyVideoStatusChanged() {
    }

    @Override
    protected void onMeetingConnected() {
    }

    @Override
    protected void onSilentModeChanged(boolean inSilentMode) {
    }

    @Override
    protected void onMyAudioTypeChanged() {
    }

    @Override
    protected void onMyAudioSourceTypeChanged() {
    }

    @Override
    protected void onMyRaiseLowerHandStatusChanged(boolean isRaiseHand) {
    }

    @Override
    protected boolean handleConfPayReminder(boolean isOrignalHost) {
        return false;
    }

    @Override
    protected void onJoinMeetingConfirmed() {
    }

    public boolean setCustomizedMeetingId(String meetingId) {
        if (this.mConfParams != null && meetingId != null) {
            this.mConfParams.setCustomMeetingId(meetingId);
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null) {
                ParamsList params = confContext.getAppContextParams();
                params.putString("custom_meeting_id", meetingId);
                confContext.setAppContextParams(params);
                return true;
            }
        }
        return false;
    }

    public boolean isMeetingConnected() {
        return ConfMgr.getInstance().isConfConnected();
    }

    public boolean isInSilentMode() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.inSilentMode();
    }

    @Override
    public boolean isSharingOut() {
        return super.isSharingOut();
    }

    @Override
    public boolean isSharingScreen() {
        return super.isSharingScreen();
    }

    public void showLeaveDialog() {
        super.onClickLeave();
    }

    @Override
    public void showAudioOptions() {
        this.dismissAllTips();
        super.showAudioOptions();
    }

    public void showVideoOptions() {
        this.dismissAllTips();
        super.onClickBtnVideo();
    }

    public void showParticipants() {
        this.dismissAllTips();
        super.onClickParticipants();
    }

    public void showShareOptions() {
        this.dismissAllTips();
        super.onClickShare();
    }

    public void doAudioAction() {
        super.onClickBtnAudio();
    }

    public void showMoreOptions() {
        super.onClickMore();
    }

    public boolean isVideoMuted() {
        ConfMgr confMgr = ConfMgr.getInstance();
        VideoSessionMgr videoMgr = confMgr.getVideoObj();
        return videoMgr == null || !videoMgr.isVideoStarted();
    }

    @Override
    public void muteVideo(boolean mute) {
        super.muteVideo(mute);
    }

    public boolean canSwitchCamera() {
        if (this.getmCameraComponent() != null) {
            return this.getmCameraComponent().canSwitchCamera();
        }
        return false;
    }

    public void switchToNextCamera() {
        if (this.getmCameraComponent() != null) {
            this.getmCameraComponent().switchToNextCamera();
        }
    }

    public boolean isAudioConnected() {
        return ConfLocalHelper.isAudioConnected();
    }

    public boolean isAudioMuted() {
        return ConfLocalHelper.isAudioMuted();
    }

    public boolean connectVoIP() {
        return ConfLocalHelper.connectVoIP();
    }

    @Override
    public void disconnectAudio() {
        super.disconnectAudio();
    }

    @Override
    public void muteAudio(boolean mute) {
        super.muteAudio(mute);
    }

    public void stopShare() {
        if (this.isSharingOut()) {
            super.onClickStopShare();
        }
    }

    public void dismissAllTips() {
        super.dismissTempTips();
    }

    public boolean isCMREnabled() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        return recordMgr != null && recordMgr.canStartCMR();
    }

    public boolean isCMRInProgress() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        return recordMgr != null && recordMgr.isCMRInProgress();
    }

    public void startCloudRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr != null && recordMgr.canStartCMR()) {
            recordMgr.startCMR();
        }
    }

    public void stopCloudRecord() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr != null && recordMgr.canStartCMR() && recordMgr.isRecordingInProgress()) {
            recordMgr.stopRecord(recordMgr.isCMRInProgress());
        }
    }

    @Override
    public boolean canSwitchAudioSource() {
        return super.canSwitchAudioSource();
    }

    public int getCurrentAudioSourceType() {
        return ConfUI.getInstance().getCurrentAudioSourceType();
    }

    public void switchAudioSource() {
        ConfLocalHelper.switchAudio(this, this.getMyAudioType());
    }

    public boolean isAllowToChat() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        return !confContext.isChatOff();
    }

    public void showChatsView() {
        if (UIMgr.isLargeMode((Context)this)) {
            ConfChatFragment.showAsFragment(this.getSupportFragmentManager(), 0L);
        } else {
            ConfChatFragment.showAsActivity((ZMActivity)this, 0, 0L);
        }
    }

    public void raiseHand() {
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user == null) {
            return;
        }
        if (user.getRaiseHandState()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(35, user.getNodeId());
    }

    public void lowerHand() {
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user == null) {
            return;
        }
        if (!user.getRaiseHandState()) {
            return;
        }
        ConfMgr.getInstance().handleUserCmd(36, user.getNodeId());
    }

    public boolean isRaisedHand() {
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user == null) {
            return false;
        }
        return user.getRaiseHandState();
    }
}

