/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.RoomDevice;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.InviteRoomSystemHelper;
import us.zoom.sdk.InviteRoomSystemListener;
import us.zoom.sdk.MeetingServiceImpl;
import us.zoom.sdk.RoomSystemDevice;

class InviteRoomSystemHelperImpl
implements InviteRoomSystemHelper,
PTUI.IRoomCallListener {
    private static final String TAG = MeetingServiceImpl.class.getSimpleName();
    private ListenerList mInviteRoomSystemListenerList = new ListenerList();

    public InviteRoomSystemHelperImpl() {
        PTUI.getInstance().addRoomCallListener(this);
    }

    @Override
    public void addEventListener(InviteRoomSystemListener listener) {
        this.mInviteRoomSystemListenerList.add((IListener)listener);
    }

    @Override
    public void removeEventListener(InviteRoomSystemListener listener) {
        this.mInviteRoomSystemListenerList.remove((IListener)listener);
    }

    @Override
    public boolean sendMeetingPairingCode(long meetingId, String pairingCode) {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return false;
        }
        return meetingHelper.sendMeetingParingCode(meetingId, pairingCode);
    }

    @Override
    public boolean callOutRoomSystem(RoomSystemDevice device) {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null || device == null) {
            return false;
        }
        return meetingHelper.callOutRoomSystem(device.getAddress(), device.getDeviceType(), device.getEncrypt());
    }

    @Override
    public boolean cancelCallOutRoomSystem() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return false;
        }
        return meetingHelper.cancelRoomDevice();
    }

    @Override
    public void onRoomCallEvent(int event, long result, boolean isActiveMeeting) {
        this.sinkRoomSystemCallEvent(event, result, isActiveMeeting);
    }

    @Override
    public String[] getH323Address() {
        PTApp ptapp = PTApp.getInstance();
        String h323ConfInfo = ptapp.getH323Gateway();
        if (!StringUtil.isEmptyOrNull((String)h323ConfInfo)) {
            return h323ConfInfo.split(";");
        }
        return null;
    }

    @Override
    public String getH323Password() {
        PTApp ptapp = PTApp.getInstance();
        if (ptapp != null) {
            return ptapp.getH323Password();
        }
        return null;
    }

    @Override
    public List<RoomSystemDevice> getRoomDevices() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return null;
        }
        ArrayList<RoomSystemDevice> roomDevices = new ArrayList<RoomSystemDevice>();
        ArrayList<RoomDevice> devices = new ArrayList<RoomDevice>();
        if (!meetingHelper.getRoomDevices(devices)) {
            return null;
        }
        for (RoomDevice dev : devices) {
            if (dev == null || StringUtil.isEmptyOrNull((String)dev.getIp()) && StringUtil.isEmptyOrNull((String)dev.getE164num())) continue;
            RoomSystemDevice roomSystemDevice = new RoomSystemDevice(dev.getName(), dev.getIp(), dev.getE164num(), dev.getDeviceType(), dev.getEncrypt());
            roomDevices.add(roomSystemDevice);
        }
        return roomDevices;
    }

    private void sinkRoomSystemCallEvent(int event, long result, boolean isActiveMeeting) {
        if (event != 7 && event != 8) {
            return;
        }
        IListener[] listeners = this.mInviteRoomSystemListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InviteRoomSystemListener l = (InviteRoomSystemListener)listener;
                if (event == 7) {
                    l.onParingRoomSystemResult(this.RoomCallResultToParingResult((int)result));
                    continue;
                }
                if (event != 8) continue;
                l.onCallOutRoomSystemStatusChanged(this.RoomCallResultToCallStatus((int)result));
            }
        }
    }

    private int RoomCallResultToParingResult(int result) {
        int paringResult = 0;
        switch (result) {
            case 0: {
                paringResult = 1;
                break;
            }
            case 3001: {
                paringResult = 2;
                break;
            }
            case 3021: {
                paringResult = 3;
                break;
            }
            case 3022: {
                paringResult = 4;
                break;
            }
            default: {
                paringResult = 5;
            }
        }
        return paringResult;
    }

    private int RoomCallResultToCallStatus(int result) {
        int callStatus = 0;
        switch (result) {
            case 0: {
                callStatus = 1;
                break;
            }
            case 1: {
                callStatus = 2;
                break;
            }
            case 2: {
                callStatus = 3;
                break;
            }
            default: {
                callStatus = 4;
            }
        }
        return callStatus;
    }
}

