/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.sdk.InMeetingUserInfo;
import us.zoom.sdk.InMeetingWaitingRoomController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingWaitingRoomControllerImpl
implements InMeetingWaitingRoomController {
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserEvent(int eventType, long userId, int flag) {
            return InMeetingWaitingRoomControllerImpl.this.sinkUserEvent(eventType, userId, flag);
        }
    };
    private ListenerList mListenerList = new ListenerList();

    public InMeetingWaitingRoomControllerImpl() {
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
    }

    @Override
    public void addListener(InMeetingWaitingRoomController.InMeetingWaitingRoomListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(InMeetingWaitingRoomController.InMeetingWaitingRoomListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public boolean isSupportWaitingRoom() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isMeetingSupportSilentMode();
    }

    @Override
    public boolean isSupportWaitingRoomUponEntryFeature() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.supportPutUserinWaitingListUponEntryFeature();
    }

    @Override
    public boolean isWaitingRoomOnEntryFlagOn() {
        return ConfMgr.getInstance().isPutOnHoldOnEntryOn();
    }

    @Override
    public MobileRTCSDKError enableWaitingRoomOnEntry(boolean bEnable) {
        if (!this.canHandleWatingRoomApi()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        ConfMgr.getInstance().setPutOnHoldOnEntry(bEnable);
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public List<Long> getWaitingRoomUserLst() {
        if (!this.canHandleWatingRoomApi()) {
            return null;
        }
        ArrayList<Long> waitingUserList = new ArrayList<Long>();
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList != null) {
            int count = userList.getUserCount();
            for (int i = 0; i < count; ++i) {
                CmmUser user = userList.getUserAt(i);
                if (user.isMMRUser() || !user.inSilentMode()) continue;
                waitingUserList.add(user.getNodeId());
            }
        }
        return waitingUserList;
    }

    @Override
    public InMeetingUserInfo getWaitingRoomUserInfoByID(long userId) {
        if (!this.canHandleWatingRoomApi()) {
            return null;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return null;
        }
        return SDKMeetingInterfaceHelper.CmmUserToInMeetingUserInfo(user);
    }

    @Override
    public MobileRTCSDKError admitToMeeting(long userId) {
        if (!this.canHandleWatingRoomApi()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null || !user.inSilentMode()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (ConfMgr.getInstance().handleUserCmd(42, userId)) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError putInWaitingRoom(long userId) {
        if (!this.canHandleWatingRoomApi()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null || user.inSilentMode()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (ConfMgr.getInstance().handleUserCmd(41, userId)) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    private boolean sinkUserEvent(int eventType, long userId, int flag) {
        IListener[] listeners;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (this.canHandleWatingRoomApi() && user != null && user.inSilentMode() && (listeners = this.mListenerList.getAll()) != null) {
            block4: for (IListener listener : listeners) {
                InMeetingWaitingRoomController.InMeetingWaitingRoomListener l = (InMeetingWaitingRoomController.InMeetingWaitingRoomListener)listener;
                switch (eventType) {
                    case 0: {
                        l.onWatingRoomUserJoin(user.getNodeId());
                        continue block4;
                    }
                    case 1: {
                        l.onWatingRoomUserLeft(user.getNodeId());
                    }
                }
            }
        }
        return true;
    }

    private boolean canHandleWatingRoomApi() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && (myself.isHost() || myself.isCoHost()) && !myself.inSilentMode();
    }
}

