/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.hardware.Camera;
import com.zipow.nydus.NydusUtil;
import com.zipow.nydus.VideoCapturer;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.MediaDevice;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.sdk.CameraDevice;
import us.zoom.sdk.InMeetingServiceImpl;
import us.zoom.sdk.InMeetingVideoController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingVideoControllerImpl
implements InMeetingVideoController {
    private int mCurrentVideoRotation = -1;
    private ListenerList mSwitchCameraListenerList = new ListenerList();

    InMeetingVideoControllerImpl() {
    }

    @Override
    public long activeVideoUserID() {
        VideoSessionMgr videMgr = ConfMgr.getInstance().getVideoObj();
        long activeUserId = 0L;
        if (videMgr != null) {
            activeUserId = videMgr.getActiveUserID();
        }
        return activeUserId;
    }

    @Override
    public boolean isMyVideoMuted() {
        ConfMgr confMgr = ConfMgr.getInstance();
        VideoSessionMgr videoMgr = confMgr.getVideoObj();
        return videoMgr == null || !videoMgr.isVideoStarted();
    }

    @Override
    public boolean canUnmuteMyVideo() {
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return false;
        }
        return ConfMgr.getInstance().canUnmuteMyVideo();
    }

    @Override
    public MobileRTCSDKError muteMyVideo(boolean mute) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (mute) {
            if (videoMgr.isVideoStarted() && videoMgr.stopMyVideo(0L)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
        } else {
            if (!ConfMgr.getInstance().canUnmuteMyVideo()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            PreferenceUtil.removeValue("camera_is_freezed");
            boolean started = videoMgr.startMyVideo(0L);
            if (!started && !VideoCapturer.getInstance().isCapturing()) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public boolean rotateMyVideo(int rotation) {
        if (rotation < 0 || rotation > 3) {
            return false;
        }
        this.mCurrentVideoRotation = rotation;
        String cameraId = null;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            if (videoMgr.isVideoStarted() || videoMgr.isPreviewing()) {
                cameraId = videoMgr.getDefaultDevice();
            }
            if (StringUtil.isEmptyOrNull((String)cameraId)) {
                cameraId = videoMgr.getDefaultCameraToUse();
            }
        } else {
            int iFrontCamId = NydusUtil.getFrontCameraId();
            if (iFrontCamId >= 0) {
                cameraId = String.valueOf(iFrontCamId);
            }
        }
        if (StringUtil.isEmptyOrNull((String)cameraId)) {
            return false;
        }
        int orientation = 0;
        switch (rotation) {
            case 0: {
                orientation = 0;
                break;
            }
            case 1: {
                orientation = 270;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 90;
            }
        }
        rotation = this.getRotation(cameraId, orientation);
        return this.rotateDevice(rotation);
    }

    private int getRotation(String sCameraId, int orientation) {
        if (sCameraId == null) {
            return 0;
        }
        int cameraId = -1;
        try {
            cameraId = Integer.parseInt(sCameraId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (cameraId < 0) {
            return 0;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        NydusUtil.getCameraInfo(cameraId, info);
        int cameraOrientatin = NydusUtil.getRealCameraOrientation(cameraId);
        orientation = (orientation + 45) / 90 * 90;
        int rotation = 0;
        rotation = !NydusUtil.isCameraMirror(cameraId) ? (info.facing == 1 ? (cameraOrientatin - orientation + 360) % 360 : (cameraOrientatin + orientation) % 360) : (info.facing == 0 ? (cameraOrientatin - orientation + 360) % 360 : (cameraOrientatin + orientation) % 360);
        return rotation;
    }

    private boolean rotateDevice(int rotation) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            int action = 0;
            switch (rotation) {
                case 0: {
                    action = 0;
                    break;
                }
                case 90: {
                    action = 1;
                    break;
                }
                case 180: {
                    action = 2;
                    break;
                }
                case 270: {
                    action = 3;
                }
            }
            return videoMgr.rotateDevice(action, 0L);
        }
        return false;
    }

    @Override
    public boolean canSwitchCamera() {
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user == null) {
            return false;
        }
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        if (videoStatus == null) {
            return false;
        }
        return videoStatus.getIsSending() && this.getNumberOfCameras() >= 2 && ConfMgr.getInstance().isConfConnected() && !ConfMgr.getInstance().isCallingOut();
    }

    private int getNumberOfCameras() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return 0;
        }
        return videoMgr.getNumberOfCameras();
    }

    @Override
    public boolean switchToNextCamera() {
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return false;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        if (this.getNumberOfCameras() < 1) {
            return false;
        }
        this.onSwitchToNextCamera(false);
        if (!videoMgr.switchToNextCam() && !videoMgr.isVideoStarted()) {
            return false;
        }
        this.onSwitchToNextCamera(true);
        this.rotateMyVideo(this.mCurrentVideoRotation);
        return true;
    }

    @Override
    public boolean switchCamera(String cameraId) {
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return false;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        if (this.getNumberOfCameras() < 1) {
            return false;
        }
        String curCamId = videoMgr.getDefaultDevice();
        if (StringUtil.isSameString((String)cameraId, (String)curCamId)) {
            return true;
        }
        this.onSwitchToNextCamera(false);
        if (!videoMgr.switchCamera(cameraId) && !videoMgr.isVideoStarted()) {
            return false;
        }
        this.onSwitchToNextCamera(true);
        this.rotateMyVideo(this.mCurrentVideoRotation);
        return true;
    }

    @Override
    public List<CameraDevice> getCameraDeviceList() {
        ArrayList<CameraDevice> cameraDevices = new ArrayList<CameraDevice>();
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return null;
        }
        List<MediaDevice> devices = videoMgr.getCamList();
        if (devices == null || devices.size() == 0) {
            return null;
        }
        int i = 0;
        for (i = 0; i < devices.size(); ++i) {
            MediaDevice device = devices.get(i);
            if (NydusUtil.isFrontCamera(device.getDeviceId())) {
                cameraDevices.add(new CameraDevice(device.getDeviceId(), "Front Camera", CameraDevice.CAMERA_TYPE_FRONT, device.isSelectedDevice()));
                continue;
            }
            if (NydusUtil.isBackCamera(device.getDeviceId())) {
                cameraDevices.add(new CameraDevice(device.getDeviceId(), "Back Camera", CameraDevice.CAMERA_TYPE_BACK, device.isSelectedDevice()));
                continue;
            }
            String deviceName = device.getDeviceName();
            if (StringUtil.isEmptyOrNull((String)deviceName)) {
                deviceName = "USB Camera";
            }
            cameraDevices.add(new CameraDevice(device.getDeviceId(), deviceName, CameraDevice.CAMERA_TYPE_UVC, device.isSelectedDevice()));
        }
        return cameraDevices;
    }

    @Override
    public String getSelectedCameraId() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return "";
        }
        return videoMgr.getDefaultDevice();
    }

    @Override
    public boolean isFrontCamera(String cameraId) {
        return NydusUtil.isFrontCamera(cameraId);
    }

    @Override
    public boolean isBackCamera(String cameraId) {
        return NydusUtil.isBackCamera(cameraId);
    }

    @Override
    public MobileRTCSDKError stopAttendeeVideo(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        if (videoStatus == null || !videoStatus.getIsSending()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
            if (!user.videoCanMuteByHost()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (ConfMgr.getInstance().handleUserCmd(61, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError askAttendeeStartVideo(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        if (videoStatus == null || videoStatus.getIsSending()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!user.videoCanUnmuteByHost()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
            if (ConfMgr.getInstance().handleUserCmd(62, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isUserVideoSpotLighted(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null) {
            return videoMgr.isLeaderofLeadMode(userId);
        }
        return false;
    }

    @Override
    public MobileRTCSDKError spotLightVideo(boolean on, long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmVideoStatus videoStatus = user.getVideoStatusObj();
        if (videoStatus == null || !videoStatus.getIsSending()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself.isHost() || myself.isCoHost() || myself.isBOModerator()) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr != null && videoMgr.setLeadShipMode(on, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public long getPinnedUser() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null && videoMgr.isManualMode()) {
            return videoMgr.getSelectedUser();
        }
        return 0L;
    }

    @Override
    public boolean isUserPinned(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        return videoMgr != null && videoMgr.isSelectedUser(userId);
    }

    @Override
    public MobileRTCSDKError pinVideo(boolean on, long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (on && videoMgr.isLeadShipMode()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (videoMgr.setManualMode(on, userId)) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    void addSwitchCameraListener(InMeetingServiceImpl.ISwitchCameraListener listener) {
        this.mSwitchCameraListenerList.add((IListener)listener);
    }

    void removeSwitchCameraListener(InMeetingServiceImpl.ISwitchCameraListener listener) {
        this.mSwitchCameraListenerList.remove((IListener)listener);
    }

    private void onSwitchToNextCamera(boolean isAfter) {
        IListener[] listeners = this.mSwitchCameraListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceImpl.ISwitchCameraListener l = (InMeetingServiceImpl.ISwitchCameraListener)listener;
                if (!isAfter) {
                    l.beforeSwitchCamera();
                    continue;
                }
                l.afterSwitchCamera();
            }
        }
    }
}

