/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.content.Intent;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.sdk.SDKScreenShareMgr;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.sdk.InMeetingShareController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.MobileRTCShareView;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingShareControllerImpl
implements InMeetingShareController {
    private MobileRTCShareView mShareView;
    private ListenerList mListenerList = new ListenerList();
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return InMeetingShareControllerImpl.this.sinkUserStatusChanged(cmd, userId);
        }
    };

    public InMeetingShareControllerImpl() {
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
    }

    @Override
    public void addListener(InMeetingShareController.InMeetingShareListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(InMeetingShareController.InMeetingShareListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public MobileRTCSDKError startShareScreenSession(Intent data) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (data == null) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        MobileRTCSDKError success = this.startShareViewSession();
        if (success == MobileRTCSDKError.SDKERR_SUCCESS) {
            SDKScreenShareMgr.getInstance().prepare(data);
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError startShareScreenContent() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        boolean success = this.setShareCaptureObject();
        if (SDKScreenShareMgr.getInstance().isSharing()) {
            SDKScreenShareMgr.getInstance().startShare();
        }
        if (success) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError stopShareScreen() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        boolean success = this.stopShareSession();
        if (SDKScreenShareMgr.getInstance().isSharing()) {
            SDKScreenShareMgr.getInstance().stopShare();
        }
        if (success) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError startShareViewSession() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (shareSession.startShare()) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError startShareViewContent(MobileRTCShareView shareView) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (this.mShareView != null) {
            return MobileRTCSDKError.SDKERR_INVALID_PARAMETER;
        }
        this.mShareView = shareView;
        boolean success = this.setShareCaptureObject();
        shareView.start(true);
        if (success) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError stopShareView() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (this.mShareView != null) {
            this.mShareView.stop();
            this.mShareView = null;
        }
        if (this.stopShareSession()) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public boolean isShareLocked() {
        return ConfMgr.getInstance().isShareLocked();
    }

    @Override
    public MobileRTCSDKError lockShare(boolean isLock) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself.isHost() || myself.isCoHost()) {
            if (ConfMgr.getInstance().handleConfCmd(isLock ? 76 : 77)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isSharingOut() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 2;
    }

    @Override
    public boolean isSharingScreen() {
        return this.isSharingOut() && SDKScreenShareMgr.getInstance().isSharing();
    }

    @Override
    public boolean isOtherSharing() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 3;
    }

    @Override
    public boolean isSenderSupportAnnotation(long nShareSourceUserID) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.senderSupportAnnotation(nShareSourceUserID);
    }

    private boolean setShareCaptureObject() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.setCaptureObject();
    }

    private boolean stopShareSession() {
        ShareSessionMgr shareSession = ConfMgr.getInstance().getShareObj();
        if (shareSession == null) {
            return false;
        }
        return shareSession.stopShare();
    }

    private boolean sinkUserStatusChanged(int cmd, long userId) {
        if (SDKMeetingInterfaceHelper.isInSlientMode()) {
            return true;
        }
        long nodeId = this.getNodeIdByUserId(userId);
        if (nodeId == -1L && cmd != 51) {
            return false;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block4: for (IListener listener : listeners) {
                InMeetingShareController.InMeetingShareListener l = (InMeetingShareController.InMeetingShareListener)listener;
                switch (cmd) {
                    case 51: {
                        l.onShareActiveUser(nodeId);
                        continue block4;
                    }
                    case 52: {
                        l.onShareUserReceivingStatus(nodeId);
                    }
                }
            }
        }
        return true;
    }

    private long getNodeIdByUserId(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null) {
            return user.getNodeId();
        }
        return -1L;
    }
}

