/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.zipow.videobox.PListActivity;
import com.zipow.videobox.SimpleInMeetingActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.SdkConfUIBridge;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.fragment.meeting.qa.ZMQAAttendeeViewerFragment;
import com.zipow.videobox.fragment.meeting.qa.ZMQAPanelistViewerFragment;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.E2EMeetingExternalSessionKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.sdk.EnumComponentType;
import us.zoom.sdk.InMeetingAnnotationController;
import us.zoom.sdk.InMeetingAnnotationControllerImpl;
import us.zoom.sdk.InMeetingAudioController;
import us.zoom.sdk.InMeetingAudioControllerImpl;
import us.zoom.sdk.InMeetingChatController;
import us.zoom.sdk.InMeetingChatControllerImpl;
import us.zoom.sdk.InMeetingChatMessage;
import us.zoom.sdk.InMeetingCloudRecordController;
import us.zoom.sdk.InMeetingCloudRecordControllerImpl;
import us.zoom.sdk.InMeetingEventHandler;
import us.zoom.sdk.InMeetingEventHandlerImpl;
import us.zoom.sdk.InMeetingLiveStreamController;
import us.zoom.sdk.InMeetingLiveStreamControllerImpl;
import us.zoom.sdk.InMeetingQAController;
import us.zoom.sdk.InMeetingQAControllerImpl;
import us.zoom.sdk.InMeetingRemoteController;
import us.zoom.sdk.InMeetingRemoteControllerImpl;
import us.zoom.sdk.InMeetingService;
import us.zoom.sdk.InMeetingServiceListener;
import us.zoom.sdk.InMeetingShareController;
import us.zoom.sdk.InMeetingShareControllerImpl;
import us.zoom.sdk.InMeetingUserInfo;
import us.zoom.sdk.InMeetingUserList;
import us.zoom.sdk.InMeetingUserListImpl;
import us.zoom.sdk.InMeetingVideoController;
import us.zoom.sdk.InMeetingVideoControllerImpl;
import us.zoom.sdk.InMeetingWaitingRoomController;
import us.zoom.sdk.InMeetingWaitingRoomControllerImpl;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;
import us.zoom.videomeetings.R;

class InMeetingServiceImpl
implements InMeetingService {
    private InMeetingAudioController mInMeetingAudioController;
    private InMeetingVideoController mInMeetingVideoController;
    private InMeetingShareController mInMeetingShareController;
    private InMeetingChatController mInMeetingChatController;
    private InMeetingCloudRecordController mInMeetingCloudRecordController;
    private InMeetingAnnotationController mInMeetingAnnotationController;
    private InMeetingQAController mInMeetingQAController;
    private InMeetingWaitingRoomController mInMeetingWaitingRoomController;
    private InMeetingRemoteController mInMeetingRemoteController;
    private InMeetingLiveStreamController mInMeetingLiveStreamController;
    private ListenerList mListenerList = new ListenerList();
    private InMeetingEventHandler mInMeetingEventHandler = new InMeetingEventHandlerImpl();
    private ConfUI.IConfUIListener mConfUIListener = new ConfUI.SimpleConfUIListener(){

        @Override
        public boolean onConfStatusChanged(int status) {
            return InMeetingServiceImpl.this.sinkConfStatusChanged(status);
        }

        @Override
        public boolean onConfStatusChanged2(int cmd, long ret) {
            return InMeetingServiceImpl.this.sinkConfStatusChanged2(cmd, ret);
        }

        @Override
        public boolean onUserStatusChanged(int cmd, long userId, int userAction) {
            return InMeetingServiceImpl.this.sinkUserStatusChanged(cmd, userId);
        }

        @Override
        public boolean onUserEvent(int eventType, long userId, int flag) {
            return InMeetingServiceImpl.this.sinkUserUpdate(eventType, userId);
        }

        @Override
        public void onJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
            InMeetingServiceImpl.this.sinkJoinConfConfirmMeetingInfo(success, hasPassword, hasScreenName);
        }

        @Override
        public void onJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
            InMeetingServiceImpl.this.sinkJoinConfConfirmPasswordValidateResult(success, needWait);
        }

        @Override
        public void onJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
            InMeetingServiceImpl.this.sinkJoinConfConfirmMeetingStatus(canJoinNow, hasScreenName);
        }

        @Override
        public void onWebinarNeedRegister(boolean bNeedApproval) {
            InMeetingServiceImpl.this.sinkWebinarNeedRegister(bNeedApproval);
        }

        @Override
        public boolean onChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
            return InMeetingServiceImpl.this.sinkChatMessageReceived(msgID, sender, senderDisplayName, receiver, receiverDisplayName, content, time);
        }

        @Override
        public void onDeviceStatusChanged(int cmd, int ret) {
            InMeetingServiceImpl.this.sinkDeviceStatusChanged(cmd, ret);
        }

        @Override
        public void onAudioSourceTypeChanged(int type) {
            InMeetingServiceImpl.this.sinkAudioSourceTypeChanged(type);
        }
    };
    private long latestCallTime = 0L;

    public InMeetingServiceImpl() {
        SdkConfUIBridge.getInstance().addListener(this.mConfUIListener);
    }

    @Override
    public void addListener(InMeetingServiceListener listener) {
        this.mListenerList.add((IListener)listener);
    }

    @Override
    public void removeListener(InMeetingServiceListener listener) {
        this.mListenerList.remove((IListener)listener);
    }

    @Override
    public InMeetingAudioController getInMeetingAudioController() {
        if (this.mInMeetingAudioController == null) {
            this.mInMeetingAudioController = new InMeetingAudioControllerImpl();
        }
        return this.mInMeetingAudioController;
    }

    @Override
    public InMeetingVideoController getInMeetingVideoController() {
        if (this.mInMeetingVideoController == null) {
            this.mInMeetingVideoController = new InMeetingVideoControllerImpl();
        }
        return this.mInMeetingVideoController;
    }

    @Override
    public InMeetingShareController getInMeetingShareController() {
        if (this.mInMeetingShareController == null) {
            this.mInMeetingShareController = new InMeetingShareControllerImpl();
        }
        return this.mInMeetingShareController;
    }

    @Override
    public InMeetingChatController getInMeetingChatController() {
        if (this.mInMeetingChatController == null) {
            this.mInMeetingChatController = new InMeetingChatControllerImpl();
        }
        return this.mInMeetingChatController;
    }

    @Override
    public InMeetingAnnotationController getInMeetingAnnotationController() {
        if (this.mInMeetingAnnotationController == null) {
            this.mInMeetingAnnotationController = new InMeetingAnnotationControllerImpl();
        }
        return this.mInMeetingAnnotationController;
    }

    @Override
    public InMeetingCloudRecordController getInMeetingCloudRecordController() {
        if (this.mInMeetingCloudRecordController == null) {
            this.mInMeetingCloudRecordController = new InMeetingCloudRecordControllerImpl();
        }
        return this.mInMeetingCloudRecordController;
    }

    @Override
    public InMeetingQAController getInMeetingQAController() {
        if (this.mInMeetingQAController == null) {
            this.mInMeetingQAController = new InMeetingQAControllerImpl();
        }
        return this.mInMeetingQAController;
    }

    @Override
    public InMeetingWaitingRoomController getInMeetingWaitingRoomController() {
        if (this.mInMeetingWaitingRoomController == null) {
            this.mInMeetingWaitingRoomController = new InMeetingWaitingRoomControllerImpl();
        }
        return this.mInMeetingWaitingRoomController;
    }

    @Override
    public InMeetingRemoteController getInMeetingRemoteController() {
        if (this.mInMeetingRemoteController == null) {
            this.mInMeetingRemoteController = new InMeetingRemoteControllerImpl();
        }
        return this.mInMeetingRemoteController;
    }

    @Override
    public InMeetingLiveStreamController getInMeetingLiveStreamController() {
        if (this.mInMeetingLiveStreamController == null) {
            this.mInMeetingLiveStreamController = new InMeetingLiveStreamControllerImpl();
        }
        return this.mInMeetingLiveStreamController;
    }

    @Override
    public boolean isMeetingConnected() {
        ConfMgr confMgr = ConfMgr.getInstance();
        return confMgr.isConfConnected();
    }

    @Override
    public boolean isMeetingLocked() {
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfStatus status = confMgr.getConfStatusObj();
        return status != null && status.isConfLocked();
    }

    @Override
    public MobileRTCSDKError lockMeeting(boolean isLock) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself.isHost() || myself.isCoHost()) {
            if (ConfMgr.getInstance().handleConfCmd(isLock ? 56 : 57)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public int getInMeetingUserCount() {
        return ConfMgr.getInstance().getClientUserCount();
    }

    @Override
    public MobileRTCSDKError changeName(String inputName, long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (this.isMyself(userId) || myself.isHost() || myself.isCoHost()) {
            if (ConfMgr.getInstance().changeUserNameByID(inputName, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public InMeetingUserList getInMeetingUserList() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return null;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return null;
        }
        ArrayList<InMeetingUserInfo> userInfoList = new ArrayList<InMeetingUserInfo>();
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList != null) {
            int count = userList.getUserCount();
            for (int i = 0; i < count; ++i) {
                CmmUser user = userList.getUserAt(i);
                if (user.isMMRUser() || user.inSilentMode()) continue;
                userInfoList.add(SDKMeetingInterfaceHelper.CmmUserToInMeetingUserInfo(user));
            }
        }
        return new InMeetingUserListImpl(userInfoList);
    }

    @Override
    public long getMyUserID() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return -1L;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return -1L;
        }
        return myself.getNodeId();
    }

    @Override
    public InMeetingUserInfo getMyUserInfo() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return null;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return null;
        }
        return SDKMeetingInterfaceHelper.CmmUserToInMeetingUserInfo(myself);
    }

    @Override
    public InMeetingUserInfo getUserInfoById(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return null;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return null;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return null;
        }
        return SDKMeetingInterfaceHelper.CmmUserToInMeetingUserInfo(user);
    }

    @Override
    public MobileRTCSDKError makeHost(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!this.isMyself(userId) && (myself.isHost() || myself.isCoHost()) && !user.isNoHostUser()) {
            if (ConfMgr.getInstance().handleUserCmd(30, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError assignCohost(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        boolean isCurUserHost = confStatus.isHost();
        boolean isCurUserBOModerator = confStatus.isBOModerator();
        if (!isCurUserBOModerator && isCurUserHost && !user.isNoHostUser()) {
            if (!user.isCoHost() && user.canActAsCoHost()) {
                if (ConfMgr.getInstance().handleUserCmd(43, userId)) {
                    return MobileRTCSDKError.SDKERR_SUCCESS;
                }
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean canbeCohost(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return false;
        }
        return !user.isNoHostUser() && user.canActAsCoHost();
    }

    @Override
    public MobileRTCSDKError revokeCohost(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        boolean isCurUserHost = confStatus.isHost();
        if (isCurUserHost && user.isCoHost()) {
            if (ConfMgr.getInstance().handleUserCmd(44, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError removeUser(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!this.isMyself(userId) && (myself.isHost() || myself.isCoHost())) {
            CmmUser user = ConfMgr.getInstance().getUserById(userId);
            if (user == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            if (ConfMgr.getInstance().handleUserCmd(29, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError setPlayChimeOnOff(boolean on) {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && (myself.isHost() || myself.isCoHost()) && !myself.isBOModerator()) {
            ConfMgr.getInstance().setPlayChimeOnOff(on);
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isPlayChimeOn() {
        return ConfMgr.getInstance().isPlayChimeOn();
    }

    @Override
    public long activeShareUserID() {
        long activeUserId = 0L;
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr != null) {
            activeUserId = shareMgr.getActiveUserID();
        }
        return activeUserId;
    }

    @Override
    public boolean isSameUser(long user1, long user2) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return false;
        }
        return confStatus.isSameUser(user1, user2);
    }

    @Override
    public boolean isHostUser(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return false;
        }
        return user.isHost();
    }

    @Override
    public boolean isMyself(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return false;
        }
        return confStatus.isMyself(userId);
    }

    @Override
    public MobileRTCSDKError raiseMyHand() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (confStatus == null || myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!confStatus.isAllowRaiseHand()) {
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        if (myself.getRaiseHandState()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (ConfMgr.getInstance().handleUserCmd(35, myself.getNodeId())) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError lowerHand(long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!user.getRaiseHandState()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (confStatus.isMyself(userId)) {
            if (ConfMgr.getInstance().handleUserCmd(36, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself.isHost() || myself.isCoHost()) {
            if (ConfMgr.getInstance().handleUserCmd(36, userId)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isMeetingHost() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && myself.isHost();
    }

    @Override
    public void leaveCurrentMeeting(boolean endIfPossible) {
        ConfMgr confMgr = ConfMgr.getInstance();
        CmmConfStatus status = confMgr.getConfStatusObj();
        ConfMgr.getInstance().notifyConfLeaveReason(String.valueOf(1), true);
        if (status != null && endIfPossible && status.isHost()) {
            confMgr.endConference();
        } else {
            confMgr.leaveConference();
        }
    }

    @Override
    public String getCurrentMeetingID() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.getMeetingId();
        }
        return "";
    }

    @Override
    public long getCurrentMeetingNumber() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.getConfNumber();
        }
        return 0L;
    }

    @Override
    public String getCurrentMeetingTopic() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return meetingItem.getTopic();
        }
        return null;
    }

    @Override
    public String getCurrentMeetingUrl() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return meetingItem.getJoinMeetingUrl();
        }
        return null;
    }

    @Override
    public String getCurrentMeetingInviteEmailSubject() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return meetingItem.getInviteEmailSubject();
        }
        return null;
    }

    @Override
    public String getCurrentMeetingInviteEmailContent() {
        MeetingInfo meetingItem;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && (meetingItem = confContext.getMeetingItem()) != null) {
            return meetingItem.getInviteEmailContent();
        }
        return null;
    }

    @Override
    public byte[] getE2EMeetingSecureKey() {
        return ConfMgr.getInstance().getE2EMeetingSecureKey();
    }

    @Override
    public boolean handleE2EMeetingExternalSessionKeyReady(Map<EnumComponentType, E2EMeetingExternalSessionKey> params, boolean isLeaveMeeting) {
        HashMap<String, E2EMeetingExternalSessionKey> sessionKeyParams = new HashMap<String, E2EMeetingExternalSessionKey>();
        for (Map.Entry<EnumComponentType, E2EMeetingExternalSessionKey> entry : params.entrySet()) {
            sessionKeyParams.put(this.EnumComponentTypeToString(entry.getKey()), entry.getValue());
        }
        return ConfMgr.getInstance().handleE2EMeetingExternalSessionKeyReady(sessionKeyParams, isLeaveMeeting);
    }

    private String EnumComponentTypeToString(EnumComponentType type) {
        switch (type) {
            case EnumComponentType_Def: {
                return String.valueOf(0);
            }
            case EnumComponentType_Chat: {
                return String.valueOf(1);
            }
            case EnumComponentType_FT: {
                return String.valueOf(2);
            }
            case EnumComponentType_AUDIO: {
                return String.valueOf(3);
            }
            case EnumComponentType_VIDEO: {
                return String.valueOf(4);
            }
            case EnumComponentType_AS: {
                return String.valueOf(5);
            }
        }
        return "";
    }

    private int EnumComponentTypeToInt(EnumComponentType type) {
        switch (type) {
            case EnumComponentType_Def: {
                return 0;
            }
            case EnumComponentType_Chat: {
                return 1;
            }
            case EnumComponentType_FT: {
                return 2;
            }
            case EnumComponentType_AUDIO: {
                return 3;
            }
            case EnumComponentType_VIDEO: {
                return 4;
            }
            case EnumComponentType_AS: {
                return 5;
            }
        }
        return -1;
    }

    @Override
    public boolean isExternalMeeting() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isExternalMeeting();
    }

    @Override
    public boolean isInternalMeeting() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && confContext.isInternalMeeting();
    }

    @Override
    public boolean isFailoverMeeting() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        return confContext != null && (confContext.getLaunchReason() == 5 || confContext.getLaunchReason() == 6);
    }

    @Override
    public int querySessionNetworkStatus(EnumComponentType type, boolean bSending) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            return confContext.querySessionNetworkStatus(this.EnumComponentTypeToInt(type), bSending);
        }
        return -1;
    }

    @Override
    public boolean claimHostWithHostKey(String hostKey) {
        long currentTime = System.currentTimeMillis();
        if (this.latestCallTime != 0L && currentTime - this.latestCallTime < 500L) {
            return false;
        }
        this.latestCallTime = currentTime;
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.hasHostinMeeting()) {
            return false;
        }
        return ConfMgr.getInstance().verifyHostKey(hostKey);
    }

    @Override
    public boolean isWebinar() {
        return SDKMeetingInterfaceHelper.isWebinar();
    }

    @Override
    public void showZoomParticipantsUI(Activity activity, int requestCode) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return;
        }
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, PListActivity.class);
        intent.setFlags(131072);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    @Override
    public void showZoomQAUI(Activity activity, int requestCode) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return;
        }
        if (activity == null) {
            return;
        }
        if (!this.isWebinar()) {
            return;
        }
        Bundle args = new Bundle();
        Intent intent = new Intent((Context)activity, SimpleInMeetingActivity.class);
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            intent.putExtra("fragmentClass", ZMQAAttendeeViewerFragment.class.getName());
        } else {
            intent.putExtra("fragmentClass", ZMQAPanelistViewerFragment.class.getName());
        }
        intent.putExtra("fragmentArguments", args);
        activity.startActivityForResult(intent, requestCode);
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    private boolean sinkUserUpdate(int eventType, long userId) {
        CmmConfStatus confStatus;
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (SDKMeetingInterfaceHelper.isInSlientMode() || user != null && user.inSilentMode()) {
            return true;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && !confStatus.isMyself(userId)) {
            return true;
        }
        long nodeId = this.getNodeIdByUserId(userId);
        if (nodeId == -1L && eventType != 1) {
            return true;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block5: for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                switch (eventType) {
                    case 0: {
                        l.onMeetingUserJoin(nodeId);
                        continue block5;
                    }
                    case 1: {
                        l.onMeetingUserLeave(userId);
                        continue block5;
                    }
                    case 2: {
                        l.onMeetingUserUpdated(nodeId);
                    }
                }
            }
        }
        return true;
    }

    private boolean sinkUserStatusChanged(int cmd, long userId) {
        CmmConfStatus confStatus;
        if (SDKMeetingInterfaceHelper.isInSlientMode()) {
            return true;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && !confStatus.isMyself(userId)) {
            return true;
        }
        long nodeId = this.getNodeIdByUserId(userId);
        if (nodeId == -1L && cmd != 51) {
            return false;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block9: for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                switch (cmd) {
                    case 1: {
                        l.onMeetingHostChanged(nodeId);
                        continue block9;
                    }
                    case 43: {
                        l.onMeetingCoHostChanged(nodeId);
                        continue block9;
                    }
                    case 4: {
                        l.onUserVideoStatusChanged(nodeId);
                        continue block9;
                    }
                    case 9: {
                        l.onUserAudioStatusChanged(nodeId);
                        continue block9;
                    }
                    case 21: {
                        l.onUserAudioTypeChanged(nodeId);
                        continue block9;
                    }
                    case 35: {
                        l.onLowOrRaiseHandStatusChanged(nodeId, true);
                        continue block9;
                    }
                    case 36: {
                        l.onLowOrRaiseHandStatusChanged(nodeId, false);
                    }
                }
            }
        }
        return true;
    }

    private boolean sinkConfStatusChanged(int status) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block4: for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                switch (status) {
                    case 12: {
                        l.onMeetingReady();
                        continue block4;
                    }
                    case 11: {
                        l.onMeetingSecureKeyNotification(ConfMgr.getInstance().getE2EMeetingSecureKey());
                    }
                }
            }
        }
        return true;
    }

    private boolean sinkConfStatusChanged2(int cmd, long ret) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            block6: for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                switch (cmd) {
                    case 1: {
                        l.onMeetingLeaveComplete(ret);
                        continue block6;
                    }
                    case 2: {
                        this.handleConfFail(ret, l);
                        continue block6;
                    }
                    case 21: {
                        l.onSpotlightVideoChanged(ret == 1L);
                        continue block6;
                    }
                    case 67: {
                        l.onMeetingNeedColseOtherMeeting(this.mInMeetingEventHandler);
                    }
                }
            }
        }
        return true;
    }

    private void handleConfFail(long errorCode, InMeetingServiceListener l) {
        int leaveReason = ConfLocalHelper.errorCodeToLeaveReason((int)errorCode);
        switch (leaveReason) {
            case 1: {
                break;
            }
            case 4: {
                l.onMeetingFail(4, (int)errorCode);
                break;
            }
            case 11: {
                l.onMeetingFail(5, (int)errorCode);
                break;
            }
            case 12: {
                l.onMeetingFail(6, (int)errorCode);
                break;
            }
            case 19: {
                l.onMeetingFail(7, (int)errorCode);
                break;
            }
            case 14: {
                l.onMeetingFail(8, (int)errorCode);
                break;
            }
            case 15: {
                l.onMeetingFail(9, (int)errorCode);
                break;
            }
            case 10: {
                l.onMeetingFail(10, (int)errorCode);
                break;
            }
            case 13: {
                l.onMeetingFail(11, (int)errorCode);
                break;
            }
            case 20: {
                l.onMeetingFail(12, (int)errorCode);
                break;
            }
            case 17: {
                l.onMeetingFail(13, (int)errorCode);
                break;
            }
            case 18: {
                l.onMeetingFail(14, (int)errorCode);
                break;
            }
            case 5: {
                l.onMeetingFail(15, (int)errorCode);
                break;
            }
            case 21: {
                l.onMeetingFail(16, (int)errorCode);
                break;
            }
            case 22: {
                l.onMeetingFail(17, (int)errorCode);
                break;
            }
            case 23: {
                l.onMeetingFail(18, (int)errorCode);
                break;
            }
            case 24: {
                l.onMeetingFail(19, (int)errorCode);
                break;
            }
            case 26: {
                l.onMeetingFail(20, (int)errorCode);
                break;
            }
            case 8: {
                l.onMeetingFail(21, (int)errorCode);
                break;
            }
            default: {
                l.onMeetingFail(100, (int)errorCode);
            }
        }
    }

    private void sinkJoinConfConfirmMeetingInfo(boolean success, boolean hasPassword, boolean hasScreenName) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                if (!success) continue;
                if (hasPassword) {
                    if (hasScreenName) {
                        l.onMeetingNeedPasswordOrDisplayName(true, false, this.mInMeetingEventHandler);
                        continue;
                    }
                    l.onMeetingNeedPasswordOrDisplayName(true, true, this.mInMeetingEventHandler);
                    continue;
                }
                if (hasScreenName) continue;
                l.onMeetingNeedPasswordOrDisplayName(false, true, this.mInMeetingEventHandler);
            }
        }
    }

    private void sinkJoinConfConfirmPasswordValidateResult(boolean success, boolean needWait) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                if (success) {
                    if (!needWait) continue;
                    l.onMeetingNeedWaitHost();
                    continue;
                }
                l.onMeetingNeedPasswordOrDisplayName(true, false, this.mInMeetingEventHandler);
            }
        }
    }

    private void sinkJoinConfConfirmMeetingStatus(boolean canJoinNow, boolean hasScreenName) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                if (!canJoinNow) continue;
                if (hasScreenName) {
                    l.onMeetingReadyToJoin();
                    continue;
                }
                l.onMeetingNeedPasswordOrDisplayName(false, true, this.mInMeetingEventHandler);
            }
        }
    }

    private void sinkWebinarNeedRegister(boolean bNeedApproval) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                if (bNeedApproval) {
                    l.onWebinarNeedRegister();
                    continue;
                }
                l.onJoinWebinarNeedUserNameAndEmail(this.mInMeetingEventHandler);
            }
        }
    }

    private void sinkDeviceStatusChanged(int cmd, int ret) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                if (cmd != 1) continue;
                if (ret == 10) {
                    l.onMicrophoneStatusError(InMeetingAudioController.MobileRTCMicrophoneError.MobileRTCMicrophoneError_FeedbackDetected);
                    continue;
                }
                if (ret == 2) {
                    l.onMicrophoneStatusError(InMeetingAudioController.MobileRTCMicrophoneError.MobileRTCMicrophoneError_MicUnavailable);
                    continue;
                }
                if (ret != 9) continue;
                l.onMicrophoneStatusError(InMeetingAudioController.MobileRTCMicrophoneError.MobileRTCMicrophoneError_MicMuted);
            }
        }
    }

    private boolean sinkChatMessageReceived(String msgID, long sender, String senderDisplayName, long receiver, String receiverDisplayName, String content, long time) {
        if (SDKMeetingInterfaceHelper.isInSlientMode()) {
            return true;
        }
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                InMeetingChatMessage msg = new InMeetingChatMessage();
                msg.setMsgId(msgID);
                msg.setSenderUserId(sender);
                msg.setSenderDisplayName(senderDisplayName);
                msg.setReceiverUserId(receiver);
                msg.setReceiverDisplayName(receiverDisplayName);
                msg.setContent(content);
                msg.setTime(time);
                l.onChatMessageReceived(msg);
            }
        }
        return true;
    }

    private void sinkAudioSourceTypeChanged(int type) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingServiceListener l = (InMeetingServiceListener)listener;
                l.onMyAudioSourceTypeChanged(type);
            }
        }
    }

    private long getNodeIdByUserId(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user != null) {
            return user.getNodeId();
        }
        return -1L;
    }

    public static interface ISwitchCameraListener
    extends IListener {
        public void beforeSwitchCamera();

        public void afterSwitchCamera();
    }
}

