/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.qa.ZoomQAComponent;
import com.zipow.videobox.confapp.qa.ZoomQAUI;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.sdk.InMeetingQAController;

class InMeetingQAControllerImpl
implements InMeetingQAController {
    private ListenerList mListenerList = new ListenerList();
    private ZoomQAUI.IZoomQAUIListener mQAUIListener = new ZoomQAUI.SimpleZoomQAUIListener(){

        @Override
        public void notifyConnectStart() {
            InMeetingQAControllerImpl.this.sinkNotifyConnectStart();
        }

        @Override
        public void notifyConnectResult(boolean bConnectSuccess) {
            InMeetingQAControllerImpl.this.sinkNotifyConnectResult(bConnectSuccess);
        }

        @Override
        public void onReceiveQuestion(String questionID) {
            InMeetingQAControllerImpl.this.sinkReceiveQuestion(questionID);
        }

        @Override
        public void onReceiveAnswer(String answerID) {
            InMeetingQAControllerImpl.this.sinkReceiveAnswer(answerID);
        }

        @Override
        public void onQuestionMarkedAsAnswered(String questionID) {
            InMeetingQAControllerImpl.this.sinkQuestionMarkedAsAnswered(questionID);
        }
    };

    InMeetingQAControllerImpl() {
    }

    @Override
    public void addQAListener(InMeetingQAController.InMeetingQAListener listener) {
        this.mListenerList.add((IListener)listener);
        if (this.mListenerList.size() == 1) {
            ZoomQAUI.getInstance().addListener(this.mQAUIListener);
        }
    }

    @Override
    public void removeQAListener(InMeetingQAController.InMeetingQAListener listener) {
        this.mListenerList.remove((IListener)listener);
        if (this.mListenerList.size() == 0) {
            ZoomQAUI.getInstance().removeListener(this.mQAUIListener);
        }
    }

    @Override
    public boolean isQAEnabled() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        return !confContext.isQANDAOFF();
    }

    @Override
    public int getOpenQuestionCount() {
        ZoomQAComponent qacomponent = ConfMgr.getInstance().getQAComponent();
        if (qacomponent == null) {
            return 0;
        }
        return qacomponent.getOpenQuestionCount();
    }

    private void sinkNotifyConnectStart() {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingQAController.InMeetingQAListener l = (InMeetingQAController.InMeetingQAListener)listener;
                l.onQAConnectStarted();
            }
        }
    }

    private void sinkNotifyConnectResult(boolean bConnectSuccess) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingQAController.InMeetingQAListener l = (InMeetingQAController.InMeetingQAListener)listener;
                l.onQAConnected(bConnectSuccess);
            }
        }
    }

    private void sinkReceiveQuestion(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingQAController.InMeetingQAListener l = (InMeetingQAController.InMeetingQAListener)listener;
                l.onReceiveQuestion(questionID);
            }
        }
    }

    private void sinkReceiveAnswer(String answerID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingQAController.InMeetingQAListener l = (InMeetingQAController.InMeetingQAListener)listener;
                l.onReceiveAnswer(answerID);
            }
        }
    }

    private void sinkQuestionMarkedAsAnswered(String questionID) {
        IListener[] listeners = this.mListenerList.getAll();
        if (listeners != null) {
            for (IListener listener : listeners) {
                InMeetingQAController.InMeetingQAListener l = (InMeetingQAController.InMeetingQAListener)listener;
                l.onQuestionMarkedAsAnswered(questionID);
            }
        }
    }
}

