/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.RecordMgr;
import us.zoom.sdk.InMeetingCloudRecordController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingCloudRecordControllerImpl
implements InMeetingCloudRecordController {
    InMeetingCloudRecordControllerImpl() {
    }

    @Override
    public boolean isCloudRecordEnabled() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        return recordMgr.canStartCMR();
    }

    @Override
    public MobileRTCSDKError startCloudRecord() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (this.canHandleCloudRecordApi()) {
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            if (!recordMgr.canStartCMR()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (!recordMgr.startCMR()) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError stopCloudRecord() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (this.canHandleCloudRecordApi()) {
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            if (!recordMgr.stopRecord(recordMgr.isCMRInProgress())) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError pauseCloudRecord() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (this.canHandleCloudRecordApi()) {
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            if (!recordMgr.canControlCMR()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (!recordMgr.pauseCMR()) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError resumeCloudRecord() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (this.canHandleCloudRecordApi()) {
            RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
            if (recordMgr == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            if (!recordMgr.canControlCMR()) {
                return MobileRTCSDKError.SDKERR_NO_PERMISSION;
            }
            if (!recordMgr.resumeCMR()) {
                return MobileRTCSDKError.SDKERR_OTHER_ERROR;
            }
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isCloudRecordInProgress() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        return recordMgr.isCMRInProgress();
    }

    @Override
    public boolean isCloudRecordPaused() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        return recordMgr.isCMRPaused();
    }

    @Override
    public boolean isMeetingBeingRecording() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        return recordMgr.theMeetingisBeingRecording();
    }

    @Override
    public boolean isRecordingMeetingOnCloud() {
        RecordMgr recordMgr = ConfMgr.getInstance().getRecordMgr();
        if (recordMgr == null) {
            return false;
        }
        return recordMgr.recordingMeetingOnCloud();
    }

    private boolean canHandleCloudRecordApi() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        return myself != null && (myself.isHost() || myself.isCoHost()) && !myself.isBOModerator();
    }
}

