/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import android.content.Context;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.AudioSessionMgr;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.sdk.InMeetingAudioController;
import us.zoom.sdk.MobileRTCSDKError;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingAudioControllerImpl
implements InMeetingAudioController {
    InMeetingAudioControllerImpl() {
    }

    @Override
    public boolean isMyAudioMuted() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        return audioStatus.getIsMuted();
    }

    @Override
    public boolean canUnmuteMyAudio() {
        CmmUser myself;
        if (SDKMeetingInterfaceHelper.isWebinarAttendee() && ((myself = ConfMgr.getInstance().getMyself()) == null || !myself.isViewOnlyUserCanTalk())) {
            return false;
        }
        return ConfMgr.getInstance().canUnmuteMyself();
    }

    @Override
    public MobileRTCSDKError muteMyAudio(boolean mute) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            long oldConfOption = confContext.getConfOption();
            if (mute) {
                audioMgr.setMutebySelfFlag(mute);
                if (!audioMgr.stopAudio()) {
                    audioMgr.setMutebySelfFlag(confContext.getOldMuteMyselfFlag(oldConfOption));
                    return MobileRTCSDKError.SDKERR_OTHER_ERROR;
                }
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            boolean canUnmute = ConfMgr.getInstance().canUnmuteMyself();
            if (canUnmute) {
                if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
                    CmmUser myself = ConfMgr.getInstance().getMyself();
                    if (myself == null) {
                        return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
                    }
                    if (!myself.isViewOnlyUserCanTalk()) {
                        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
                    }
                }
                audioMgr.setMutebySelfFlag(mute);
                if (!audioMgr.startAudio()) {
                    audioMgr.setMutebySelfFlag(confContext.getOldMuteMyselfFlag(oldConfOption));
                    return MobileRTCSDKError.SDKERR_OTHER_ERROR;
                }
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_NO_PERMISSION;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public boolean isAudioConnected() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        long audioType = audioStatus.getAudiotype();
        return 2L != audioType;
    }

    @Override
    public MobileRTCSDKError disconnectAudio() {
        CmmConfStatus confStatus;
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L == audioType ? audioMgr.turnOnOffAudioSession(false) : 1L == audioType && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && confStatus.hangUp()) {
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public MobileRTCSDKError connectAudioWithVoIP() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        long audioType = audioStatus.getAudiotype();
        if (0L != audioType) {
            CmmConfStatus confStatus;
            if (1L == audioType && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
                confStatus.hangUp();
            }
            if (audioMgr.turnOnOffAudioSession(true)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
        }
        return MobileRTCSDKError.SDKERR_OTHER_ERROR;
    }

    @Override
    public boolean canSwitchAudioOutput() {
        boolean headsetOn;
        if (!ConfMgr.getInstance().isConfConnected() || ConfMgr.getInstance().isCallingOut()) {
            return false;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        long myAudioType = audioStatus.getAudiotype();
        int streamType = VoiceEnginContext.getSelectedPlayerStreamType();
        boolean isStreamVoiceCall = streamType == 0 || streamType < 0 && ConfUI.getInstance().isCallOffHook();
        boolean supportTelephony = VoiceEngineCompat.isFeatureTelephonySupported((Context)VideoBoxApplication.getInstance());
        boolean bl = headsetOn = HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn();
        return !(!isStreamVoiceCall || !supportTelephony && !headsetOn || myAudioType != 0L && !ConfUI.getInstance().isCallOffHook());
    }

    @Override
    public MobileRTCSDKError setLoudSpeakerStatus(boolean on) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!this.canSwitchAudioOutput()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (!on && HeadsetUtil.getInstance().isBluetoothScoAudioOn() && VoiceEngineCompat.isBluetoothScoSupported()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        audioMgr.setPreferedLoudSpeakerStatus(on ? 1 : 0);
        ConfUI.getInstance().checkOpenLoudSpeaker();
        return MobileRTCSDKError.SDKERR_SUCCESS;
    }

    @Override
    public boolean getLoudSpeakerStatus() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        return audioMgr.getLoudSpeakerStatus();
    }

    @Override
    public MobileRTCSDKError muteAttendeeAudio(boolean isMute, long userId) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && (myself.isHost() || myself.isCoHost())) {
            if (isMute) {
                if (ConfMgr.getInstance().handleUserCmd(46, userId)) {
                    return MobileRTCSDKError.SDKERR_SUCCESS;
                }
                if (ConfMgr.getInstance().handleUserCmd(47, userId)) {
                    return MobileRTCSDKError.SDKERR_SUCCESS;
                }
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError muteAllAttendeeAudio(boolean allowUnmuteSelf) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself != null && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            ConfMgr.getInstance().handleUserCmd(48, 0L);
            if (allowUnmuteSelf ? ConfMgr.getInstance().handleConfCmd(82) : ConfMgr.getInstance().handleConfCmd(83)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError unmuteAllAttendeeAudio() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        if (myself != null && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
            if (ConfMgr.getInstance().handleUserCmd(49, 0L)) {
                return MobileRTCSDKError.SDKERR_SUCCESS;
            }
            return MobileRTCSDKError.SDKERR_OTHER_ERROR;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public MobileRTCSDKError setMuteOnEntry(boolean on) {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
        }
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && (myself.isHost() || myself.isCoHost()) && !myself.isBOModerator()) {
            AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
            if (audioMgr == null) {
                return MobileRTCSDKError.SDKERR_WRONG_USEAGE;
            }
            audioMgr.setMuteOnEntry(on);
            return MobileRTCSDKError.SDKERR_SUCCESS;
        }
        return MobileRTCSDKError.SDKERR_NO_PERMISSION;
    }

    @Override
    public boolean isMuteOnEntryOn() {
        AudioSessionMgr audioMgr = ConfMgr.getInstance().getAudioObj();
        if (audioMgr == null) {
            return false;
        }
        return audioMgr.isMuteOnEntryOn();
    }
}

