/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.sdk;

import com.zipow.annotate.AnnoToolType;
import com.zipow.videobox.sdk.SDKAnnotationMgr;
import us.zoom.sdk.InMeetingAnnotationController;
import us.zoom.sdk.SDKMeetingInterfaceHelper;

class InMeetingAnnotationControllerImpl
implements InMeetingAnnotationController {
    InMeetingAnnotationControllerImpl() {
    }

    @Override
    public boolean startAnnotation() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return false;
        }
        if (SDKMeetingInterfaceHelper.isWebinarAttendee()) {
            return false;
        }
        return SDKAnnotationMgr.getInstance().startAnnotation();
    }

    @Override
    public boolean stopAnnotation() {
        if (!SDKMeetingInterfaceHelper.isInMeeting()) {
            return false;
        }
        return SDKAnnotationMgr.getInstance().stopAnnotation();
    }

    @Override
    public boolean setToolColor(int color2) {
        return SDKAnnotationMgr.getInstance().setToolColor(color2);
    }

    @Override
    public boolean setToolType(InMeetingAnnotationController.AnnotationToolType toolType) {
        return SDKAnnotationMgr.getInstance().setToolType(this.convert2AnnoToolType(toolType));
    }

    @Override
    public boolean setToolWidth(int width) {
        return SDKAnnotationMgr.getInstance().setToolWidth(width);
    }

    @Override
    public boolean clear() {
        return SDKAnnotationMgr.getInstance().eraseAll();
    }

    @Override
    public boolean undo() {
        return SDKAnnotationMgr.getInstance().undo();
    }

    @Override
    public boolean redo() {
        return SDKAnnotationMgr.getInstance().redo();
    }

    @Override
    public boolean isPresenter() {
        return SDKAnnotationMgr.getInstance().isPresenter();
    }

    private AnnoToolType convert2AnnoToolType(InMeetingAnnotationController.AnnotationToolType toolType) {
        switch (toolType) {
            case ANNO_TOOL_NONE_DRAWING: {
                return AnnoToolType.ANNO_TOOL_NONE_DRAWING;
            }
            case ANNO_TOOL_TYPE_PEN: {
                return AnnoToolType.ANNO_TOOL_TYPE_PEN;
            }
            case ANNO_TOOL_TYPE_HIGHLIGHTER: {
                return AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER;
            }
            case ANNO_TOOL_TYPE_SPOTLIGHT: {
                return AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT;
            }
            case ANNO_TOOL_TYPE_ERASER: {
                return AnnoToolType.ANNO_TOOL_TYPE_ERASER;
            }
            case ANNO_TOOL_TYPE_AUTO_ARROW2: {
                return AnnoToolType.ANNO_TOOL_TYPE_AUTO_ARROW2;
            }
        }
        return AnnoToolType.ANNO_TOOL_NONE_DRAWING;
    }
}

