/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Process;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;

class AudioDeviceAndroidOpenSLESHelper {
    private static final int LOUDSPEAKER_STATUS_NOTSET = -1;
    private static final int LOUDSPEAKER_STATUS_OFF = 0;
    private static final int LOUDSPEAKER_STATUS_ON = 1;
    private Context _context;
    private AudioManager _audioManager;
    private int mLoudSpeakerStatus = -1;
    final String logTag = "webrtc";

    AudioDeviceAndroidOpenSLESHelper() {
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return -1;
        }
        this.mLoudSpeakerStatus = loudspeakerOn ? 1 : 0;
        int apiLevel = Integer.parseInt(Build.VERSION.SDK);
        if (3 == apiLevel || 4 == apiLevel) {
            if (loudspeakerOn) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == apiLevel || 6 == apiLevel || 7 == apiLevel)) {
            if (loudspeakerOn) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(true);
            } else {
                this._audioManager.setSpeakerphoneOn(false);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(loudspeakerOn);
        }
        return 0;
    }

    private boolean CheckAudioRecordPermission() {
        if (this._context == null) {
            return false;
        }
        int ret = this._context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid());
        return ret == 0;
    }

    private void SetAudioMode(boolean startCall, boolean supportInCommunication) {
        int apiLevel = Integer.parseInt(Build.VERSION.SDK);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return;
        }
        int startMode = 0;
        boolean needSetAudioMode = false;
        if (!supportInCommunication) {
            needSetAudioMode = true;
            startMode = 0;
        } else if ((Build.BRAND.equals("Samsung") && apiLevel <= 10 || Build.BRAND.equals("samsung")) && 8 == apiLevel) {
            needSetAudioMode = true;
            startMode = 4;
        } else if (apiLevel > 10) {
            needSetAudioMode = true;
            startMode = 3;
        }
        int mode = 0;
        if (needSetAudioMode) {
            mode = startCall ? startMode : 0;
            this._audioManager.setMode(mode);
            if (this._audioManager.getMode() != mode) {
                // empty if block
            }
        }
        if (startCall) {
            if (mode == 3) {
                VoiceEnginContext.setSelectedPlayerStreamType(0);
            } else {
                VoiceEnginContext.setSelectedPlayerStreamType(3);
            }
            if ("Amazon".equals(Build.MANUFACTURER) && !VoiceEngineCompat.isFeatureTelephonySupported(this._context)) {
                float percent = (float)this._audioManager.getStreamVolume(3) / (float)this._audioManager.getStreamMaxVolume(3);
                if (percent < 0.6f) {
                    percent = 0.6f;
                    int volumeMusic = (int)((float)this._audioManager.getStreamMaxVolume(3) * percent);
                    this._audioManager.setStreamVolume(3, volumeMusic, 0);
                }
                int volume = (int)((float)this._audioManager.getStreamMaxVolume(0) * percent);
                this._audioManager.setStreamVolume(0, volume, 0);
            }
        }
    }

    private boolean isRecorderConfigurationNativeAPIDisabled() {
        boolean bRet = VoiceEngineCompat.isRecorderConfigurationNativeAPIDisabled(this._context);
        return bRet;
    }

    private boolean isPlayerConfigurationNativeAPIDisabled() {
        boolean bRet = VoiceEngineCompat.isPlayerConfigurationNativeAPIDisabled(this._context);
        return bRet;
    }

    private void DoLog(String msg) {
    }

    private void DoLogErr(String msg) {
    }
}

