/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.os.Process;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.webrtc.voiceengine.VoiceEnginContext;
import org.webrtc.voiceengine.VoiceEngineCompat;

@SuppressLint(value={"NewApi"})
class AudioDeviceAndroid {
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock = new ReentrantLock();
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    private AcousticEchoCanceler _echoCanceler;
    private AutomaticGainControl _deviceAGC;
    private NoiseSuppressor _deviceNS;
    final String logTag = "webrtc";

    AudioDeviceAndroid() {
        this.DoLog("AudioDeviceAndroid.<init>");
        try {
            this._playBuffer = ByteBuffer.allocateDirect(960);
            this._recBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception e) {
            this.DoLog(e.getMessage());
        }
        this._tempBufPlay = new byte[960];
        this._tempBufRec = new byte[960];
    }

    public boolean initAEC(int audioSession) {
        if (this._echoCanceler != null) {
            return false;
        }
        if (!AcousticEchoCanceler.isAvailable()) {
            this.DoLog("AudioDeviceAndroid.initAEC, AcousticEchoCanceler.isAvailable() false");
            return false;
        }
        try {
            this._echoCanceler = AcousticEchoCanceler.create((int)audioSession);
        }
        catch (Exception e) {
            this.DoLog("AudioDeviceAndroid.initAEC create echoCanceler, " + e.getMessage());
            return false;
        }
        if (this._echoCanceler == null) {
            this.DoLog("AudioDeviceAndroid.initAEC, _echoCanceler create fail");
            return false;
        }
        this._echoCanceler.setEnabled(true);
        this.DoLog("AudioDeviceAndroid.initAEC, _echoCanceler Enabled = " + this._echoCanceler.getEnabled());
        return this._echoCanceler.getEnabled();
    }

    public boolean releaseAEC() {
        if (null == this._echoCanceler) {
            return false;
        }
        this._echoCanceler.setEnabled(false);
        this._echoCanceler.release();
        this._echoCanceler = null;
        return true;
    }

    public boolean initAGC(int audioSession) {
        if (this._deviceAGC != null) {
            return false;
        }
        try {
            if (!AutomaticGainControl.isAvailable()) {
                this.DoLog("AudioDeviceAndroid.initAGC, AutomaticGainControl.isAvailable() false");
                return false;
            }
            this._deviceAGC = AutomaticGainControl.create((int)audioSession);
        }
        catch (Exception e) {
            this.DoLog("AudioDeviceAndroid.initAGC create deviceAGC exception, " + e.getMessage());
            return false;
        }
        catch (Error e) {
            this.DoLog("AudioDeviceAndroid.initAGC create deviceAGC error, " + e.getMessage());
            return false;
        }
        if (this._deviceAGC == null) {
            this.DoLog("AudioDeviceAndroid.initAGC, _deviceAGC create fail");
            return false;
        }
        this._deviceAGC.setEnabled(true);
        this.DoLog("AudioDeviceAndroid.initAGC, _deviceAGC Enabled = " + this._deviceAGC.getEnabled());
        return this._deviceAGC.getEnabled();
    }

    public boolean releaseAGC() {
        if (null == this._deviceAGC) {
            return false;
        }
        this._deviceAGC.setEnabled(false);
        this._deviceAGC.release();
        this._deviceAGC = null;
        return true;
    }

    public boolean initNS(int audioSession) {
        if (this._deviceNS != null) {
            return false;
        }
        try {
            if (!NoiseSuppressor.isAvailable()) {
                this.DoLog("AudioDeviceAndroid.initNS, NoiseSuppressor.isAvailable() false");
                return false;
            }
            this._deviceNS = NoiseSuppressor.create((int)audioSession);
        }
        catch (Exception e) {
            this.DoLog("AudioDeviceAndroid.initNS create NoiseSuppressor exception, " + e.getMessage());
            return false;
        }
        catch (Error e) {
            this.DoLog("AudioDeviceAndroid.initNS create NoiseSuppressor error, " + e.getMessage());
            return false;
        }
        if (this._deviceNS == null) {
            this.DoLog("AudioDeviceAndroid.initNS, _deviceNS create fail");
            return false;
        }
        this._deviceNS.setEnabled(true);
        this.DoLog("AudioDeviceAndroid.initNS, _deviceNS Enabled = " + this._deviceNS.getEnabled());
        return this._deviceNS.getEnabled();
    }

    public boolean releaseNS() {
        if (null == this._deviceNS) {
            return false;
        }
        this._deviceNS.setEnabled(false);
        this._deviceNS.release();
        this._deviceNS = null;
        return true;
    }

    private int InitRecording(int audioSource, int sampleRate) {
        this.DoLog("AudioDeviceAndroid.InitRecording, audioSource=" + audioSource + ", sampleRate=" + sampleRate);
        int bestAudioSource = audioSource;
        if (Build.VERSION.SDK_INT >= 22 && !VoiceEngineCompat.isAudioSourceVoiceCommunicationDisabled()) {
            bestAudioSource = 7;
        } else if (Build.VERSION.SDK_INT >= 11) {
            bestAudioSource = 6;
        }
        boolean bestAudioSourceCreatFailed = false;
        int minRecBufSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)16, (int)2);
        this.DoLog("AudioDeviceAndroid.InitRecording, min rec buf size is " + minRecBufSize);
        int recBufSize = minRecBufSize * 2;
        this._bufferedRecSamples = 5 * sampleRate / 200;
        this.DoLog("AudioDeviceAndroid.InitRecording, rough rec delay set to " + this._bufferedRecSamples);
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(bestAudioSource, sampleRate, 16, 2, recBufSize);
        }
        catch (Exception e) {
            this.DoLog("AudioDeviceAndroid.InitRecording, " + e.getMessage() + "audioSource [" + bestAudioSource + "]");
            bestAudioSourceCreatFailed = true;
        }
        if (!bestAudioSourceCreatFailed && this._audioRecord.getState() != 1) {
            this.DoLog("rec not initialized " + sampleRate + "audioSource [" + bestAudioSource + "], bestAudioSourceCreatFailed");
            bestAudioSourceCreatFailed = true;
        }
        if (bestAudioSourceCreatFailed) {
            if (this._audioRecord != null) {
                try {
                    this._audioRecord.release();
                }
                catch (Exception e) {
                    this.DoLogErr("release _audioRecord failed: e=" + e.getMessage());
                }
                this._audioRecord = null;
            }
            try {
                this._audioRecord = new AudioRecord(audioSource, sampleRate, 16, 2, recBufSize);
            }
            catch (Exception AudioRecordE) {
                this.DoLog("AudioDeviceAndroid.InitRecording, " + AudioRecordE.getMessage() + "audioSource [" + audioSource + "]");
                return -1;
            }
            if (this._audioRecord.getState() != 1) {
                this.DoLog("rec not initialized " + sampleRate + "audioSource [" + audioSource + "]");
                return -1;
            }
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.DoLog("AudioDeviceAndroid.InitRecording, rec sample rate set to " + sampleRate + "audioSource=[" + this._audioRecord.getAudioSource() + "], audioSessionID [" + this._audioRecord.getAudioSessionId() + "]");
        } else {
            this.DoLog("AudioDeviceAndroid.InitRecording, rec sample rate set to " + sampleRate + "audioSource=[" + this._audioRecord.getAudioSource() + "]");
        }
        return this._bufferedRecSamples;
    }

    private int StartRecording() {
        this.DoLog("StartRecording");
        if (!this._isPlaying) {
            this.SetAudioMode(true);
        }
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.DoLog("StartRecording, e=" + e);
            return -1;
        }
        this.DoLog("StartRecording, success");
        this._isRecording = true;
        return 0;
    }

    private int InitPlayback(int sampleRate) {
        int minPlayBufSize;
        this.DoLog("InitPlayback, sampleRate=" + sampleRate + "_audioRecord = " + this._audioRecord);
        int playBufSize = minPlayBufSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)4, (int)2);
        if (playBufSize < 6000) {
            playBufSize *= 2;
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        if (Build.VERSION.SDK_INT >= 16 && this._audioRecord != null) {
            try {
                this._audioTrack = new AudioTrack(0, sampleRate, 4, 2, playBufSize, 1, this._audioRecord.getAudioSessionId());
            }
            catch (Exception e) {
                this.DoLog(e.getMessage());
            }
        }
        if (this._audioTrack == null) {
            try {
                this._audioTrack = new AudioTrack(0, sampleRate, 4, 2, playBufSize, 1);
            }
            catch (Exception e) {
                this.DoLog(e.getMessage());
                return -1;
            }
        }
        if (this._audioTrack.getState() != 1) {
            return -1;
        }
        this.DoLogErr("AudioDeviceAndroid.InitPlayback, AudioSessionID[" + this._audioTrack.getAudioSessionId() + "]");
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(0);
    }

    private int StartPlayback() {
        this.DoLog("StartPlayback");
        if (!this._isRecording) {
            this.SetAudioMode(true);
        }
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException e) {
            this.DoLogErr("StartPlayback, e=" + e);
            e.printStackTrace();
            return -1;
        }
        this.DoLog("StartPlayback, success");
        this._isPlaying = true;
        return 0;
    }

    private int StopRecording() {
        this.DoLog("StopRecording");
        this._recLock.lock();
        try {
            this.DoLog("StopRecording before stop");
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    this._audioRecord.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    this.DoLogErr("StopRecording, e=" + e);
                    int n = -1;
                    this._doRecInit = true;
                    this._recLock.unlock();
                    return n;
                }
            }
            this.DoLog("StopRecording after stop");
            this._audioRecord.release();
            this._audioRecord = null;
        }
        finally {
            this._doRecInit = true;
            this._recLock.unlock();
        }
        if (!this._isPlaying) {
            this.SetAudioMode(false);
        }
        this._isRecording = false;
        this.DoLog("StopRecording end");
        return 0;
    }

    private boolean CheckAudioRecordPermission() {
        if (this._context == null) {
            return false;
        }
        int ret = this._context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid());
        return ret == 0;
    }

    private int StopPlayback() {
        this.DoLog("StopPlayback");
        this._playLock.lock();
        try {
            if (this._audioTrack.getPlayState() == 3) {
                this.DoLog("StopPlayback before stop");
                try {
                    this._audioTrack.stop();
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                    this.DoLogErr("StopPlayback, e=" + e);
                    int n = -1;
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return n;
                }
                this.DoLog("StopPlayback after stop");
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        finally {
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        if (!this._isRecording) {
            this.SetAudioMode(false);
        }
        this._isPlaying = false;
        this.DoLog("StopPlayback end");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int lengthInBytes) {
        int bufferedSamples = 0;
        this._playLock.lock();
        try {
            if (this._audioTrack == null) {
                int n = -2;
                return n;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Throwable e) {
                    this.DoLog("Set play thread priority failed: " + e.getMessage());
                }
                this._doPlayInit = false;
            }
            int written = 0;
            this._playBuffer.get(this._tempBufPlay);
            if (this._audioTrack.getState() == 1 && this._audioTrack.getPlayState() == 3) {
                written = this._audioTrack.write(this._tempBufPlay, 0, lengthInBytes);
            }
            this._playBuffer.rewind();
            this._bufferedPlaySamples += written >> 1;
            int pos = this._audioTrack.getPlaybackHeadPosition();
            if (pos < this._playPosition) {
                this._playPosition = 0;
            }
            this._bufferedPlaySamples -= pos - this._playPosition;
            this._playPosition = pos;
            if (!this._isRecording) {
                bufferedSamples = this._bufferedPlaySamples;
            }
            if (written != lengthInBytes) {
                int n = -1;
                return n;
            }
        }
        catch (Throwable e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
        finally {
            this._playLock.unlock();
        }
        return bufferedSamples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int RecordAudio(int lengthInBytes) {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                int n = -2;
                return n;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Throwable e) {
                    this.DoLog("Set rec thread priority failed: " + e.getMessage());
                }
                this._doRecInit = false;
            }
            int readBytes = 0;
            this._recBuffer.rewind();
            readBytes = this._audioRecord.read(this._tempBufRec, 0, lengthInBytes);
            this._recBuffer.put(this._tempBufRec);
            if (readBytes != lengthInBytes) {
                int n = -1;
                return n;
            }
        }
        catch (Exception e) {
            this.DoLogErr("RecordAudio try failed: " + e.getMessage());
        }
        catch (Error e) {
            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
        }
        finally {
            this._recLock.unlock();
        }
        return this._bufferedPlaySamples;
    }

    private int SetPlayoutSpeaker(boolean loudspeakerOn) {
        this.DoLog("SetPlayoutSpeaker, loudspeakerOn=" + loudspeakerOn);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not change audio routing - no audio manager");
            return -1;
        }
        int apiLevel = Integer.parseInt(Build.VERSION.SDK);
        if (3 == apiLevel || 4 == apiLevel) {
            if (loudspeakerOn) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == apiLevel || 6 == apiLevel || 7 == apiLevel)) {
            if (loudspeakerOn) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(true);
            } else {
                this._audioManager.setSpeakerphoneOn(false);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(loudspeakerOn);
        }
        return 0;
    }

    private int SetPlayoutVolume(int level) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int retVal = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, level, 0);
            retVal = 0;
        }
        return retVal;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int level = -1;
        if (this._audioManager != null) {
            level = this._audioManager.getStreamVolume(0);
        }
        return level;
    }

    private void SetAudioMode(boolean startCall) {
        boolean supportInCommunication = true;
        int apiLevel = Integer.parseInt(Build.VERSION.SDK);
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return;
        }
        int startMode = 0;
        boolean needSetAudioMode = false;
        if (!supportInCommunication) {
            needSetAudioMode = true;
            startMode = 0;
        } else if ((Build.BRAND.equals("Samsung") && apiLevel <= 10 || Build.BRAND.equals("samsung")) && 8 == apiLevel) {
            needSetAudioMode = true;
            startMode = 4;
        } else if (apiLevel > 10) {
            needSetAudioMode = true;
            startMode = 3;
        }
        int mode = 0;
        if (needSetAudioMode) {
            mode = startCall ? startMode : 0;
            this._audioManager.setMode(mode);
            if (this._audioManager.getMode() != mode) {
                // empty if block
            }
        }
        if (startCall) {
            if (mode == 3) {
                VoiceEnginContext.setSelectedPlayerStreamType(0);
            } else {
                VoiceEnginContext.setSelectedPlayerStreamType(3);
            }
            if ("Amazon".equals(Build.MANUFACTURER) && !VoiceEngineCompat.isFeatureTelephonySupported(this._context)) {
                float percent = (float)this._audioManager.getStreamVolume(3) / (float)this._audioManager.getStreamMaxVolume(3);
                if (percent < 0.6f) {
                    percent = 0.6f;
                    int volumeMusic = (int)((float)this._audioManager.getStreamMaxVolume(3) * percent);
                    this._audioManager.setStreamVolume(3, volumeMusic, 0);
                }
                int volume = (int)((float)this._audioManager.getStreamMaxVolume(0) * percent);
                this._audioManager.setStreamVolume(0, volume, 0);
            }
        }
    }

    private void DoLog(String msg) {
    }

    private void DoLogErr(String msg) {
    }
}

