/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.view.MotionEvent;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmVideoStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.TipMessageType;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.NormalMessageTip;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.DriverModeVideoScene;
import com.zipow.videobox.view.video.GalleryVideoScene;
import com.zipow.videobox.view.video.LargeShareVideoScene;
import com.zipow.videobox.view.video.NormalVideoScene;
import com.zipow.videobox.view.video.ShareVideoScene;
import com.zipow.videobox.view.video.VideoLayoutHelper;
import com.zipow.videobox.view.video.VideoRenderer;
import us.zoom.androidlib.util.ParamsList;
import us.zoom.videomeetings.R;

public class VideoSceneMgr
extends AbsVideoSceneMgr {
    private static final String TAG = VideoSceneMgr.class.getSimpleName();
    private NormalVideoScene mNormalScene = null;
    private ShareVideoScene mShareScene = null;
    private GalleryVideoScene mGalleryScene1 = null;
    private GalleryVideoScene mGalleryScene2 = null;
    private DriverModeVideoScene mDriverModeScene = null;
    private AbsVideoScene mActiveScene;
    private AbsVideoScene mComingScene;
    private int mMicMutedPreDriverMode = -1;
    private int mVideoMutedPreDriverMode = -1;
    private boolean mIsDriverModeShownAsDefaultScene = false;
    private int mVideoUserCount = 0;
    private AbsVideoScene mLastSceneBeforeShare = null;
    private int mLastHostVideoLayout = -1;
    private boolean isInitLastHostVideoLayout;
    private boolean mIsDraggingToLeft = false;
    private boolean mIsDraggingToRight = false;
    private boolean mIsSwitchingScene = false;
    private int mMicMutedPreDrivingModeParam = -1;
    private int mVideoMutedPreDrivingModeParam = -1;

    public VideoSceneMgr() {
        if (UIMgr.isDriverModeEnabled()) {
            this.mDriverModeScene = new DriverModeVideoScene(this);
            this.mSceneList.add(this.mDriverModeScene);
        }
        this.mNormalScene = new NormalVideoScene(this);
        this.mNormalScene.setVisible(true);
        this.mSceneList.add(this.mNormalScene);
        this.mShareScene = this.isShowLargeShareVideoScene() ? new LargeShareVideoScene(this) : new ShareVideoScene(this);
        this.mSceneList.add(this.mShareScene);
        this.mGalleryScene1 = new GalleryVideoScene(this);
        this.mSceneList.add(this.mGalleryScene1);
        this.mGalleryScene2 = new GalleryVideoScene(this);
        this.mSceneList.add(this.mGalleryScene2);
        this.mActiveScene = this.mNormalScene;
        this.mVideoUserCount = ConfLocalHelper.getTotalVideoCount();
    }

    @Override
    public boolean isInShareVideoScene() {
        return this.mActiveScene != null && this.mActiveScene instanceof ShareVideoScene;
    }

    @Override
    public boolean isInNormalVideoScene() {
        return this.mActiveScene != null && this.mActiveScene instanceof NormalVideoScene;
    }

    @Override
    public boolean isInDriveModeScence() {
        return this.mActiveScene != null && this.mActiveScene instanceof DriverModeVideoScene;
    }

    @Override
    public AbsVideoScene getActiveScene() {
        return this.mActiveScene;
    }

    @Override
    public boolean isViewingSharing() {
        return this.mActiveScene == this.mShareScene && this.mShareScene.hasContent();
    }

    @Override
    protected void beforeNotifyScenesGLRendererChanged(VideoRenderer renderer, int width, int height) {
        if (this.mActiveScene != null && this.mActiveScene.isPreloadStatus()) {
            this.mActiveScene.setLocation(0, 0);
            this.mActiveScene.resumeVideo();
        }
    }

    @Override
    protected void beforeNotifyScenesShareActiveUser(long userId) {
        if (userId > 0L) {
            if (this.mActiveScene != null && !this.mShareScene.isVisible()) {
                if (this.mComingScene != null) {
                    this.mActiveScene.setLocation(0, 0);
                    this.destroyComingScene();
                }
                this.mLastSceneBeforeShare = this.mActiveScene;
                if (this.mActiveScene != this.mDriverModeScene || this.mDriverModeScene == null) {
                    if (this.mShareScene.isCachedEnabled()) {
                        this.mShareScene.destroyCachedUnits();
                    }
                    this.switchToShareScene();
                }
            }
        } else if (this.mActiveScene == this.mShareScene) {
            if (this.mComingScene != null) {
                this.destroyComingScene();
            }
            this.mShareScene.setCacheEnabled(false);
            if (this.mLastSceneBeforeShare instanceof GalleryVideoScene && ConfLocalHelper.isMeetSwitchToGalleryView()) {
                this.switchToGalleryScene(0);
            } else {
                this.switchToNormalScene();
            }
            this.mLastSceneBeforeShare = null;
            this.mShareScene.setCacheEnabled(true);
        } else {
            this.mLastSceneBeforeShare = null;
        }
    }

    private void destroyComingScene() {
        this.mComingScene.setVisible(false);
        this.mComingScene.stop();
        this.mComingScene.destroy();
        this.mComingScene = null;
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        if (this.mActiveScene != null) {
            this.mActiveScene.onDoubleTap(e);
        }
    }

    @Override
    public void scrollHorizontal(boolean left) {
        int base;
        if (ConfMgr.getInstance().isCallingOut()) {
            return;
        }
        if (this.getSceneCount() <= 1) {
            return;
        }
        if (this.mIsSwitchingScene) {
            return;
        }
        int target_index = 0;
        int n = base = UIMgr.isDriverModeEnabled() ? 1 : 0;
        if (this.mActiveScene == this.mNormalScene || this.mActiveScene == this.mShareScene) {
            target_index += base;
        } else if (this.mActiveScene instanceof GalleryVideoScene) {
            target_index = ((GalleryVideoScene)this.mActiveScene).getPageIndex() + this.getBasicSceneCount();
        }
        int n2 = target_index = (target_index += left ? -1 : 1) < 0 ? 0 : target_index;
        if (target_index > this.getSceneCount() - 1) {
            return;
        }
        this.switchToScene(target_index);
    }

    @Override
    public boolean isInDefaultScene() {
        return this.mActiveScene == this.mNormalScene || this.mActiveScene == this.mShareScene;
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (ConfMgr.getInstance().isCallingOut()) {
            return;
        }
        if (this.mActiveScene != null) {
            this.mActiveScene.onScroll(e1, e2, distanceX, distanceY);
        }
        if (this.getSceneCount() <= 1 && !this.canScroll(distanceX)) {
            return;
        }
        if (distanceX == 0.0f || this.mIsSwitchingScene) {
            return;
        }
        if (this.mComingScene == null) {
            if (this.mActiveScene == this.mDriverModeScene && this.mDriverModeScene != null) {
                if (distanceX > 0.0f) {
                    this.mComingScene = this.getShareActiveUserId() > 0L ? this.mShareScene : this.mNormalScene;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)this.mRenderer.getWidth() - distanceX), 0);
                }
            } else if (this.mActiveScene == this.mNormalScene) {
                if (distanceX > 0.0f && ConfLocalHelper.getTotalVideoCount() >= 2 && !this.isGalleryVideoModeDisabled()) {
                    this.mGalleryScene1.setPageIndex(0);
                    this.mComingScene = this.mGalleryScene1;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)this.mRenderer.getWidth() - distanceX), 0);
                } else if (distanceX < 0.0f && UIMgr.isDriverModeEnabled()) {
                    this.mComingScene = this.mDriverModeScene;
                    if (this.mComingScene != null) {
                        this.mComingScene.setVisible(true);
                        this.mComingScene.setLocation((int)((float)(-this.mRenderer.getWidth()) - distanceX), 0);
                    }
                }
            } else if (this.mActiveScene == this.mShareScene) {
                if (distanceX > 0.0f && this.mShareScene.canDragSceneToLeft() && !this.isGalleryVideoModeDisabled()) {
                    this.mGalleryScene1.setPageIndex(0);
                    this.mComingScene = this.mGalleryScene1;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)this.mRenderer.getWidth() - distanceX), 0);
                } else if (distanceX < 0.0f && UIMgr.isDriverModeEnabled() && this.mShareScene.canDragSceneToRight()) {
                    this.mComingScene = this.mDriverModeScene;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)(-this.mRenderer.getWidth()) - distanceX), 0);
                }
            } else if (this.mActiveScene == this.mGalleryScene1) {
                if (distanceX < 0.0f) {
                    if (!this.mGalleryScene1.hasPrevPage()) {
                        this.mComingScene = this.getShareActiveUserId() > 0L ? this.mShareScene : this.mNormalScene;
                    } else {
                        this.mComingScene = this.mGalleryScene2;
                        this.mGalleryScene2.checkGalleryUnits(this.mRenderer.getWidth(), this.mRenderer.getHeight());
                        this.mGalleryScene2.setPageIndex(this.mGalleryScene1.getPageIndex() - 1);
                    }
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)(-this.mRenderer.getWidth()) - distanceX), 0);
                } else if (this.mGalleryScene1.hasNextPage()) {
                    this.mGalleryScene2.checkGalleryUnits(this.mRenderer.getWidth(), this.mRenderer.getHeight());
                    this.mGalleryScene2.setPageIndex(this.mGalleryScene1.getPageIndex() + 1);
                    this.mComingScene = this.mGalleryScene2;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)this.mRenderer.getWidth() - distanceX), 0);
                }
            } else if (this.mActiveScene == this.mGalleryScene2) {
                if (distanceX < 0.0f) {
                    if (!this.mGalleryScene2.hasPrevPage()) {
                        this.mComingScene = this.getShareActiveUserId() > 0L ? this.mShareScene : this.mNormalScene;
                    } else {
                        this.mComingScene = this.mGalleryScene1;
                        this.mGalleryScene1.setPageIndex(this.mGalleryScene2.getPageIndex() - 1);
                    }
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)(-this.mRenderer.getWidth()) - distanceX), 0);
                } else if (this.mGalleryScene2.hasNextPage()) {
                    this.mGalleryScene1.setPageIndex(this.mGalleryScene2.getPageIndex() + 1);
                    this.mComingScene = this.mGalleryScene1;
                    this.mComingScene.setVisible(true);
                    this.mComingScene.setLocation((int)((float)this.mRenderer.getWidth() - distanceX), 0);
                }
            }
            if (this.mComingScene != null) {
                this.mIsDraggingToLeft = distanceX > 0.0f;
                boolean bl = this.mIsDraggingToRight = distanceX < 0.0f;
                if (this.mComingScene instanceof GalleryVideoScene) {
                    GalleryVideoScene galleryScene = (GalleryVideoScene)this.mComingScene;
                    galleryScene.updateContentSubscription();
                }
                this.mComingScene.create(this.mRenderer.getWidth(), this.mRenderer.getHeight(), false);
                this.mComingScene.pauseVideo();
                this.mComingScene.start();
            }
        } else if (this.mIsDraggingToLeft) {
            if (this.mComingScene.getLeft() - (int)distanceX < 0) {
                this.mComingScene.setLocation(0, 0);
            } else {
                this.mComingScene.move(-((int)distanceX), 0);
            }
        } else if (this.mIsDraggingToRight) {
            if (this.mComingScene.getLeft() - (int)distanceX > 0) {
                this.mComingScene.setLocation(0, 0);
            } else {
                this.mComingScene.move(-((int)distanceX), 0);
            }
        }
        if (this.mComingScene != null && this.mActiveScene != null) {
            this.mActiveScene.pauseVideo();
            if (this.mIsDraggingToLeft) {
                if (this.mActiveScene.getLeft() - (int)distanceX + this.mActiveScene.getWidth() < 0) {
                    this.mActiveScene.setLocation(-this.mActiveScene.getWidth(), 0);
                } else {
                    this.mActiveScene.move(-((int)distanceX), 0);
                }
            } else if (this.mIsDraggingToRight) {
                if (this.mActiveScene.getLeft() - (int)distanceX > this.mRenderer.getWidth()) {
                    this.mActiveScene.setLocation(this.mRenderer.getWidth(), 0);
                } else {
                    this.mActiveScene.move(-((int)distanceX), 0);
                }
            }
        }
        if (this.mComingScene != null) {
            this.mComingScene.onDraggingIn();
            this.onDraggingVideoScene();
        }
    }

    @Override
    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mActiveScene != null) {
            this.mActiveScene.onFling(e1, e2, velocityX, velocityY);
        }
    }

    @Override
    public void onDown(MotionEvent e) {
        if (this.mActiveScene != null) {
            this.mActiveScene.onDown(e);
        }
    }

    private void switchScreen() {
        this.mIsSwitchingScene = true;
        AbsVideoScene oldActiveScene = this.mActiveScene;
        if (this.mActiveScene != null && this.mActiveScene.isVisible()) {
            this.unPinVideo();
            if (this.mActiveScene.isCachedEnabled()) {
                this.mActiveScene.cacheUnits();
            }
            this.mActiveScene.setVisible(false);
            this.mActiveScene.stop();
            oldActiveScene.destroy();
            this.mActiveScene = null;
        }
        this.mComingScene.setLocation(0, 0);
        this.mActiveScene = this.mComingScene;
        this.mComingScene = null;
        this.mIsSwitchingScene = false;
        this.onVideoSceneChanged(oldActiveScene, this.mActiveScene);
        this.onDropVideoScene(true);
        this.mActiveScene.resumeVideo();
        this.onSceneChanged();
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        if (this.mActiveScene != null && this.mActiveScene.onTouchEvent(e)) {
            return true;
        }
        if (e.getActionMasked() == 1 && this.mComingScene != null && !this.mIsSwitchingScene) {
            if (this.mIsDraggingToLeft && this.mComingScene.getLeft() < this.mRenderer.getWidth() * 2 / 3 || this.mIsDraggingToRight && this.mComingScene.getRight() > this.mRenderer.getWidth() / 3) {
                this.switchScreen();
            } else if (this.mComingScene.isVisible()) {
                this.mIsSwitchingScene = true;
                if (this.mComingScene.isCachedEnabled()) {
                    this.mComingScene.cacheUnits();
                }
                if (this.mActiveScene != null) {
                    this.mComingScene.setLocation(Integer.MIN_VALUE, 0);
                    this.mActiveScene.setLocation(0, 0);
                    this.mActiveScene.resumeVideo();
                }
                this.mComingScene.setVisible(false);
                this.mComingScene.stop();
                this.mComingScene.destroy();
                this.mComingScene = null;
                this.mIsSwitchingScene = false;
                this.onDropVideoScene(false);
            }
            return true;
        }
        if (e.getActionMasked() == 1) {
            this.onDropVideoScene(false);
        }
        return false;
    }

    private void onSwitchOutDriverMode() {
        this.mMicMutedPreDrivingModeParam = -1;
        this.mVideoMutedPreDrivingModeParam = -1;
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity != null) {
            CmmConfContext confContext;
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr == null) {
                return;
            }
            if (this.mIsDriverModeShownAsDefaultScene) {
                this.mMicMutedPreDriverMode = -1;
                this.mIsDriverModeShownAsDefaultScene = false;
            }
            if (confMgr.canUnmuteMyself() && this.mMicMutedPreDriverMode == 0) {
                confActivity.muteAudio(false);
                NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_UNMUTED.name(), null, confActivity.getResources().getString(R.string.zm_msg_driving_mode_message_unmuted), 3000L);
            } else {
                CmmAudioStatus audioStatus;
                CmmUser user = confMgr.getMyself();
                if (user != null && (audioStatus = user.getAudioStatusObj()) != null && audioStatus.getAudiotype() != 2L && audioStatus.getIsMuted()) {
                    NormalMessageTip.show(confActivity.getSupportFragmentManager(), TipMessageType.TIP_AUDIO_MUTED.name(), null, confActivity.getResources().getString(R.string.zm_msg_driving_mode_message_muted), 3000L);
                }
            }
            if (this.mVideoMutedPreDriverMode == 0) {
                confActivity.muteVideo(false);
            }
            if ((confContext = confMgr.getConfContext()) == null) {
                return;
            }
            ParamsList params = confContext.getAppContextParams();
            params.remove("micMutedPreDrivingMode");
            params.remove("videoMutedPreDrivingMode");
            confContext.setAppContextParams(params);
        }
    }

    private void onSwitchToDriverMode() {
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity != null) {
            ConfMgr confMgr = ConfMgr.getInstance();
            if (confMgr == null) {
                return;
            }
            CmmUser user = confMgr.getMyself();
            if (user == null) {
                return;
            }
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            if (audioStatus == null) {
                return;
            }
            CmmVideoStatus videoStatus = user.getVideoStatusObj();
            if (videoStatus == null) {
                return;
            }
            boolean audioMuted = audioStatus.getIsMuted();
            if (!audioMuted) {
                confActivity.muteAudio(true);
            }
            VideoSessionMgr videoMgr = confMgr.getVideoObj();
            boolean videoMuted = false;
            if (videoMgr != null) {
                boolean bl = videoMuted = !videoMgr.isVideoStarted();
                if (!videoMuted) {
                    confActivity.muteVideo(true);
                }
            }
            this.mMicMutedPreDriverMode = this.mMicMutedPreDrivingModeParam < 0 ? (audioStatus.getAudiotype() == 2L ? -1 : (audioMuted ? 1 : 0)) : this.mMicMutedPreDrivingModeParam;
            this.mVideoMutedPreDriverMode = this.mVideoMutedPreDrivingModeParam < 0 ? (videoStatus.getIsSource() ? (videoMuted ? 1 : 0) : -1) : this.mVideoMutedPreDrivingModeParam;
            CmmConfContext confContext = confMgr.getConfContext();
            if (confContext == null) {
                return;
            }
            ParamsList params = confContext.getAppContextParams();
            params.putInt("micMutedPreDrivingMode", this.mMicMutedPreDriverMode);
            params.putInt("videoMutedPreDrivingMode", this.mVideoMutedPreDriverMode);
            confContext.setAppContextParams(params);
        }
    }

    @Override
    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        if (this.mActiveScene != null) {
            return this.mActiveScene.onVideoViewSingleTapConfirmed(e);
        }
        return false;
    }

    public void showPinModeInNormalScene() {
        if (this.mNormalScene != null) {
            if (this.mNormalScene.isExchangedMode()) {
                this.mNormalScene.setExchangedMode(false);
            }
            this.switchToScene(this.mNormalScene);
        }
    }

    public void switchToNormalScene() {
        this.switchToScene(this.mNormalScene);
    }

    private void switchToShareScene() {
        if (this.mActiveScene != null && this.mActiveScene != this.mShareScene) {
            this.mActiveScene.pauseVideo();
            this.mActiveScene.grantUnitsTo(this.mShareScene);
        }
        this.switchToScene(this.mShareScene);
    }

    public void switchToDriverModeScene() {
        if (this.canSwitchScene(this.mDriverModeScene)) {
            if (this.mDriverModeScene != null) {
                this.mDriverModeScene.setIsVideoOnPrevDrivingMode(this.mVideoMutedPreDrivingModeParam != 1);
            }
            this.switchToScene(this.mDriverModeScene);
        }
    }

    public void restoreDriverModeSceneOnFailoverSuccess() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        ParamsList params = confContext.getAppContextParams();
        this.mMicMutedPreDrivingModeParam = params.getInt("micMutedPreDrivingMode", -1);
        this.mVideoMutedPreDrivingModeParam = params.getInt("videoMutedPreDrivingMode", -1);
        this.switchToDriverModeScene();
    }

    public void switchToDriverModeSceneAsDefaultScene() {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        if (!this.canSwitchScene(this.mDriverModeScene)) {
            return;
        }
        this.mMicMutedPreDrivingModeParam = 0;
        this.mVideoMutedPreDrivingModeParam = confContext.isVideoOn() ? 0 : 1;
        this.mIsDriverModeShownAsDefaultScene = true;
        this.switchToScene(this.mDriverModeScene);
    }

    public void switchToDefaultScene() {
        AbsVideoScene defaultScene = this.getShareActiveUserId() > 0L ? this.mShareScene : this.mNormalScene;
        this.switchToScene(defaultScene);
    }

    @Override
    public boolean onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
        boolean reallyChanged = super.onNetworkRestrictionModeChanged(isNetworkRestrictionMode);
        if (reallyChanged && this.mActiveScene != null) {
            this.mActiveScene.onNetworkRestrictionModeChanged(isNetworkRestrictionMode);
        }
        return reallyChanged;
    }

    private String getAccessibliityDescriptionDefaultSceneSwitch() {
        if (this.getShareActiveUserId() > 0L) {
            return this.getConfActivity().getString(R.string.zm_description_btn_switch_share_scene);
        }
        return this.getConfActivity().getString(R.string.zm_description_btn_switch_normal_scene);
    }

    public String getAccessibliltyDescriptionSceneSwitch(int index) {
        if (UIMgr.isDriverModeEnabled()) {
            if (index == 0) {
                return this.getConfActivity().getString(R.string.zm_description_btn_switch_driving_scene);
            }
            if (index == 1) {
                return this.getAccessibliityDescriptionDefaultSceneSwitch();
            }
        } else if (index == 0) {
            return this.getAccessibliityDescriptionDefaultSceneSwitch();
        }
        return this.getConfActivity().getString(R.string.zm_description_btn_switch_gallery_scene);
    }

    @Override
    public void switchToScene(int index) {
        GalleryVideoScene galleryScene;
        if (UIMgr.isDriverModeEnabled()) {
            if (index == 0) {
                this.switchToDriverModeScene();
                return;
            }
            if (index == 1) {
                this.switchToDefaultScene();
                return;
            }
        } else if (index == 0) {
            this.switchToDefaultScene();
            return;
        }
        if ((galleryScene = this.mGalleryScene1).isVisible()) {
            galleryScene = this.mGalleryScene2;
        }
        if (galleryScene.isVisible()) {
            return;
        }
        if (!this.canSwitchScene(galleryScene)) {
            return;
        }
        int basicSceneCount = this.getBasicSceneCount();
        galleryScene.setPageIndex(index - basicSceneCount);
        this.switchToScene(galleryScene);
    }

    public void switchToGalleryScene(int indexOfGalleryScene) {
        GalleryVideoScene galleryScene = this.mGalleryScene1;
        if (galleryScene.isVisible()) {
            return;
        }
        if (galleryScene.isVisible()) {
            return;
        }
        int basicSceneCount = this.getBasicSceneCount();
        galleryScene.setPageIndex(basicSceneCount + indexOfGalleryScene);
        this.switchToScene(galleryScene);
    }

    public void switchToScene(AbsVideoScene scene) {
        if (!this.canSwitchScene(scene)) {
            return;
        }
        if (this.mActiveScene == null || this.mActiveScene == scene || scene == null || this.mIsSwitchingScene) {
            return;
        }
        this.mIsSwitchingScene = true;
        if (this.mActiveScene.isCachedEnabled()) {
            this.mActiveScene.cacheUnits();
        }
        AbsVideoScene oldScene = this.mActiveScene;
        oldScene.setVisible(false);
        scene.setVisible(true);
        this.mActiveScene = null;
        oldScene.pauseVideo();
        oldScene.stop();
        oldScene.destroy();
        if (scene instanceof GalleryVideoScene) {
            GalleryVideoScene galleryVideoScene = (GalleryVideoScene)scene;
            galleryVideoScene.checkGalleryUnits(this.mRenderer.getWidth(), this.mRenderer.getHeight());
        }
        scene.create(this.mRenderer.getWidth(), this.mRenderer.getHeight());
        scene.setLocation(0, 0);
        scene.start();
        this.mActiveScene = scene;
        this.mIsSwitchingScene = false;
        this.onVideoSceneChanged(oldScene, this.mActiveScene);
        this.mActiveScene.resumeVideo();
    }

    @Override
    public void onConfReady() {
        super.onConfReady();
        this.mNormalScene.setPreloadEnabled(true);
        this.mGalleryScene1.preload();
        this.mGalleryScene2.preload();
        if (this.mDriverModeScene != null) {
            ParamsList params;
            this.mDriverModeScene.setPreloadEnabled(true);
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext != null && (params = confContext.getAppContextParams()).getInt("drivingMode", -1) == 1) {
                return;
            }
            this.mDriverModeScene.preload();
        }
    }

    @Override
    public void onConfLeaving() {
        if (this.mNormalScene != null) {
            this.mNormalScene.setCanStartPreview(false);
        }
    }

    @Override
    public void onHostChanged(long userId, boolean isCurUserHost) {
        super.onHostChanged(userId, isCurUserHost);
        if (isCurUserHost) {
            this.onSceneChanged();
        }
    }

    @Override
    public void onShareActiveUser(long userId) {
        super.onShareActiveUser(userId);
        this.checkCurrentScene();
    }

    @Override
    public void onUserVideoStatus(long userId) {
        super.onUserVideoStatus(userId);
        this.checkCurrentScene();
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        if (!this.isInitLastHostVideoLayout) {
            this.initLastHostVideoLayout();
        }
        super.onUserEvent(eventType, userId, flag);
        if (ConfLocalHelper.shouldSwitchActiveSpeakerView(this)) {
            return;
        }
        this.checkCurrentScene();
        if (this.isInitLastHostVideoLayout && this.mLastHostVideoLayout != -1) {
            this.restoreHostVideoLayout();
        }
        int lastVideoCount = this.mVideoUserCount;
        this.mVideoUserCount = ConfLocalHelper.getTotalVideoCount();
        VideoLayoutHelper layoutHelper = VideoLayoutHelper.getInstance();
        if (layoutHelper == null) {
            return;
        }
        if (!layoutHelper.isSwitchVideoLayoutAccordingToUserCountEnabled() || ConfLocalHelper.isViewOnlyButNotSupportMMR()) {
            return;
        }
        int threshold = layoutHelper.getSwitchVideoLayoutUserCountThreshold();
        if (lastVideoCount < threshold && this.mVideoUserCount >= threshold) {
            if (this.mActiveScene instanceof NormalVideoScene) {
                this.switchToScene(this.mGalleryScene1);
            }
        } else if (lastVideoCount >= threshold && this.mVideoUserCount < threshold && this.mActiveScene instanceof GalleryVideoScene) {
            this.switchToNormalScene();
        }
    }

    private void onVideoSceneChanged(AbsVideoScene fromScene, AbsVideoScene toScene) {
        boolean isSwitchToDriverMode;
        this.getConfActivity().onVideoSceneChanged(fromScene, toScene);
        boolean isSwitchOutDriverMode = fromScene == this.mDriverModeScene && this.mDriverModeScene != null;
        boolean bl = isSwitchToDriverMode = toScene == this.mDriverModeScene && this.mDriverModeScene != null;
        if (isSwitchToDriverMode) {
            this.onSwitchToDriverMode();
        } else if (isSwitchOutDriverMode) {
            this.onSwitchOutDriverMode();
        }
        this.onAccessibilityRootViewUpdated();
        this.announceAccessibilityAtActiveScene();
        this.onSceneChanged();
    }

    private void onDraggingVideoScene() {
        this.getConfActivity().onDraggingVideoScene();
    }

    private void onDropVideoScene(boolean activeSceneChanged) {
        this.getConfActivity().onDropVideoScene(activeSceneChanged);
    }

    @Override
    public int getSceneCount() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            return 1;
        }
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            return 1;
        }
        if (this.isGalleryVideoModeDisabled()) {
            return this.getBasicSceneCount();
        }
        int userCount = ConfLocalHelper.getTotalVideoCount();
        if (userCount < 2 && this.getShareActiveUserId() == 0L && !(this.mActiveScene instanceof GalleryVideoScene)) {
            return this.getBasicSceneCount();
        }
        int basicSceneCount = this.getBasicSceneCount();
        int galleryUnitsCount = 0;
        GalleryVideoScene galleryScene = null;
        if (this.mActiveScene instanceof GalleryVideoScene) {
            galleryScene = (GalleryVideoScene)this.mActiveScene;
        } else {
            galleryScene = this.mGalleryScene1;
            galleryScene.updateLayoutInfo();
        }
        if (galleryScene != null && (galleryUnitsCount = galleryScene.getUnitsCount()) == 0) {
            galleryScene.updateLayoutInfo();
            galleryUnitsCount = galleryScene.getUnitsCount();
        }
        if (galleryUnitsCount == 0) {
            return basicSceneCount;
        }
        return userCount / galleryUnitsCount + (userCount % galleryUnitsCount > 0 ? 1 : 0) + basicSceneCount;
    }

    public int getBasicSceneCount() {
        return UIMgr.isDriverModeEnabled() ? 2 : 1;
    }

    @Override
    public boolean isInDriverMode() {
        return this.mDriverModeScene != null && this.mActiveScene == this.mDriverModeScene;
    }

    public boolean canBePinVideo() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        return !videoMgr.isLeadShipMode();
    }

    public boolean pinVideo(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        if (userId == 0L) {
            return false;
        }
        if (this.canBePinVideo()) {
            videoMgr.setManualMode(true, userId);
            return true;
        }
        return false;
    }

    public boolean unPinVideo() {
        long userId;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return false;
        }
        if (videoMgr.isManualMode() && (userId = videoMgr.getSelectedUser()) != 0L) {
            videoMgr.setManualMode(false, userId);
            return true;
        }
        return false;
    }

    @Override
    public void attendeeVideoControlChange(long videoControlMode) {
        this.checkCurrentScene();
    }

    @Override
    public void attendeeVideoLayoutChange(long videoLayout) {
        this.checkCurrentScene();
    }

    private boolean canSwitchScene(AbsVideoScene target) {
        if (ConfLocalHelper.isAttendeeSupportVideoLayoutChange()) {
            if (this.isActiveOrShare(target) && !ConfLocalHelper.isMeetSwitchToGalleryView()) {
                return true;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null) {
                int controlMode = confStatus.getAttendeeVideoControlMode();
                if (controlMode == 0) {
                    return this.isActiveOrShare(target);
                }
                if (controlMode == 2) {
                    int layoutMode = confStatus.getAttendeeVideoLayoutMode();
                    if (layoutMode == 0) {
                        return this.isActiveOrShare(target);
                    }
                    if (layoutMode == 1) {
                        return this.isGalleryOrShare(target);
                    }
                } else if (controlMode == 1) {
                    return this.isGalleryOrShare(target);
                }
            }
        }
        return true;
    }

    private boolean checkCurrentScene() {
        if (ConfLocalHelper.isAttendeeSupportVideoLayoutChange()) {
            if (!ConfLocalHelper.isMeetSwitchToGalleryView()) {
                this.switchToDefaultScene();
                return true;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus != null) {
                int controlMode = confStatus.getAttendeeVideoControlMode();
                if (controlMode == 0) {
                    if (this.mActiveScene != this.mNormalScene) {
                        this.switchToDefaultScene();
                        return true;
                    }
                } else if (controlMode == 2) {
                    int layoutMode = confStatus.getAttendeeVideoLayoutMode();
                    if (layoutMode == 0 && !this.isActiveOrShare()) {
                        this.switchToDefaultScene();
                    } else if (layoutMode == 1 && !this.isGalleryOrShare()) {
                        this.mGalleryScene1.setPageIndex(0);
                        this.switchToScene(this.mGalleryScene1);
                        return true;
                    }
                } else if (controlMode == 1 && !this.isGalleryOrShare()) {
                    this.mGalleryScene1.setPageIndex(0);
                    this.switchToScene(this.mGalleryScene1);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isGalleryOrShare() {
        return this.mActiveScene == this.mGalleryScene1 || this.mActiveScene == this.mGalleryScene2 || this.mActiveScene == this.mShareScene && this.getShareActiveUserId() > 0L;
    }

    private boolean isActiveOrShare() {
        return this.mActiveScene == this.mNormalScene || this.mActiveScene == this.mShareScene && this.getShareActiveUserId() > 0L;
    }

    private boolean isGalleryOrShare(AbsVideoScene target) {
        return target == this.mGalleryScene1 || target == this.mGalleryScene2 || target == this.mShareScene && this.getShareActiveUserId() > 0L;
    }

    private boolean isActiveOrShare(AbsVideoScene target) {
        return target == this.mNormalScene || target == this.mShareScene && this.getShareActiveUserId() > 0L;
    }

    private void onSceneChanged() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself != null && myself.isHost()) {
            if (this.mActiveScene == this.mNormalScene || this.mActiveScene == this.mDriverModeScene) {
                ConfLocalHelper.setAttendeeVideoLayout(0);
            } else if (this.mActiveScene == this.mGalleryScene1 || this.mActiveScene == this.mGalleryScene2) {
                ConfLocalHelper.setAttendeeVideoLayout(1);
            }
        }
    }

    private void initLastHostVideoLayout() {
        CmmUser mySelf = ConfMgr.getInstance().getMyself();
        if (mySelf != null) {
            CmmConfStatus confStatus;
            this.isInitLastHostVideoLayout = true;
            if (mySelf.isHost() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
                this.mLastHostVideoLayout = confStatus.getAttendeeVideoLayoutMode();
            }
        }
    }

    private void restoreHostVideoLayout() {
        CmmConfStatus confStatus;
        CmmUser mySelf = ConfMgr.getInstance().getMyself();
        if (mySelf != null && mySelf.isHost() && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null) {
            int layoutMode = confStatus.getAttendeeVideoLayoutMode();
            if (layoutMode != this.mLastHostVideoLayout) {
                if (this.mLastHostVideoLayout == 0 && !this.isActiveOrShare()) {
                    this.switchToDefaultScene();
                } else if (this.mLastHostVideoLayout == 1 && !this.isGalleryOrShare()) {
                    this.mGalleryScene1.setPageIndex(0);
                    this.switchToScene(this.mGalleryScene1);
                }
            }
            this.mLastHostVideoLayout = -1;
        }
    }

    private boolean canScroll(float distanceX) {
        if (this.mActiveScene instanceof GalleryVideoScene) {
            GalleryVideoScene galleryVideoScene = (GalleryVideoScene)this.mActiveScene;
            return galleryVideoScene.hasPrevPage() && distanceX < 0.0f || galleryVideoScene.hasNextPage() && distanceX > 0.0f;
        }
        return false;
    }

    private boolean isGalleryVideoModeDisabled() {
        if (this.getShareActiveUserId() > 0L && this.isShowLargeShareVideoScene()) {
            return true;
        }
        return PreferenceUtil.readBooleanValue("no_gallery_videos_view", false);
    }

    private boolean isShowLargeShareVideoScene() {
        return PreferenceUtil.readBooleanValue("large_share_video_scene_mode", false);
    }
}

