/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.zipow.annotate.ZoomShareData;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmShareStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.GLImage;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.ShareUnit;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ConfShareLocalHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.RCMouseView;
import com.zipow.videobox.view.video.VideoRenderer;
import com.zipow.videobox.view.video.VideoSceneMgr;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ShareVideoScene
extends AbsVideoScene
implements GLButton.OnClickListener,
View.OnClickListener {
    private final String TAG = ShareVideoScene.class.getSimpleName();
    private static final int MAX_SCALE_LEVEL_COUNT = 3;
    private static final int MAX_VELOCITY_IN_DIP = 1500;
    private VideoUnit mUnitActiveVideo;
    private ShareUnit mUnitShare;
    private GLButton mGLBtnExpandVideo;
    private GLImage mGLImageWaterMark;
    private ShareUnit mCachedUnitShare;
    private VideoSize mCachedShareSize;
    private VideoSize mActiveVideoSize;
    private VideoSize mShareSize;
    private double mZoomVal = 0.0;
    private float mContentX = 0.0f;
    private float mContentY = 0.0f;
    private float mScaleWidth = 0.0f;
    private float mScaleHeight = 0.0f;
    private boolean mIsNotWaiting = false;
    private Scroller mScroller;
    private Handler mFlingHandler = new Handler();
    private boolean mStopFling = false;
    private boolean mHasCachedData = false;
    private boolean mIsFitScreen = true;
    private boolean mIsVideoExpand = true;
    private ImageButton[] mSwitchSceneButtons;
    private int mWaterMarkWidth = 0;
    private int mWaterMarkHeight = 0;
    private boolean mInRemoteControlMode = false;
    private long mLastMultiTouchEndTime = 0L;
    private ShareSessionMgr mShareSession;
    private static final long DOUBLE_SCROLL_INTERVAL_TIME = 150L;
    private static final long SINGLE_TAP_INTERVAL_TIME = 200L;
    private static final float SCROLL_THRESHOLD = 10.0f;
    private static final int RC_HANDLER_MESSAGE_LONG_PRESS = 1;
    private static final int RC_HANDLER_MESSAGE_SINGLE_TAP = 2;
    private float mLastX1;
    private float mLastY1;
    private float mLastX2;
    private float mLastY2;
    private float mLastDoubleScrollX;
    private float mLastDoubleScrollY;
    private float mDistance;
    private boolean mIsMultiTouchZooming = false;
    private long mLastDoubleScrollTime = 0L;
    private boolean mIsDoubleScrollMode = false;
    private int mMoveCount = 0;
    private MotionEvent mCurrentDownEvent;
    private MotionEvent mPreviousUpEvent;
    private boolean mIsDoubleTap;
    private float mRCMouseX;
    private float mRCMouseY;
    private boolean mScrolled;
    private boolean mFlinged;
    private boolean mbIgnoreNextScroll = false;
    private final Handler mRemoteControlGestureHandler = new Handler(){

        public void handleMessage(Message msg) {
            Bundle b = msg.getData();
            switch (msg.what) {
                case 1: {
                    float x = b.getFloat("x");
                    float y = b.getFloat("y");
                    ShareVideoScene.this.remoteControlLongPress(x, y);
                    break;
                }
                case 2: {
                    float x = b.getFloat("x");
                    float y = b.getFloat("y");
                    float rawX = b.getFloat("raw_x");
                    float rawY = b.getFloat("raw_y");
                    ShareVideoScene.this.remoteControlSingleTap(x, y);
                    RCMouseView rcMouseView = ShareVideoScene.this.getConfActivity().getRCMouseView();
                    if (rcMouseView == null) break;
                    rcMouseView.moveMouse(rawX, rawY);
                }
            }
        }
    };

    public ShareVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
        DecelerateInterpolator interpolator = new DecelerateInterpolator(1.0f);
        this.mScroller = new Scroller((Context)VideoBoxApplication.getInstance(), (Interpolator)interpolator);
        this.setCacheEnabled(true);
        this.mShareSession = ConfMgr.getInstance().getShareObj();
    }

    public boolean hasContent() {
        return this.mHasCachedData;
    }

    @Override
    protected void onCreateUnits() {
        this.createUnitShare();
        if (!this.isNoVideoTileOnShareScreenEnabled()) {
            if (this.mIsVideoExpand) {
                this.createUnitActiveVideo();
            }
            this.createExpandVideoButton();
        }
        this.createGLImageWaterMark();
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
        }
    }

    private void createUnitActiveVideo() {
        if (this.mUnitActiveVideo != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long activeUserId = this.getVideoSceneMgr().getActiveUserId();
        RendererUnitInfo unitInfo = this.createVideoUnitInfo(activeUserId > 0L);
        if (unitInfo != null) {
            this.mUnitActiveVideo = videoMgr.createVideoUnit(false, unitInfo);
            if (this.mUnitActiveVideo != null) {
                this.mUnitActiveVideo.setUnitName("ActiveVideoInShareScene");
                this.mUnitActiveVideo.setVideoScene(this);
                this.mUnitActiveVideo.setBorderVisible(false);
                this.mUnitActiveVideo.setBackgroundColor(0);
                this.mUnitActiveVideo.setUserNameVisible(false);
                this.mUnitActiveVideo.setCanShowAudioOff(true);
                this.mUnitActiveVideo.setIsFloating(true);
                this.addUnit(this.mUnitActiveVideo);
                this.mUnitActiveVideo.onCreate();
            }
        }
    }

    private void createUnitShare() {
        if (this.mUnitShare != null) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        RendererUnitInfo shareUnitInfo = this.createShareUnitInfo();
        if (shareUnitInfo != null) {
            boolean bCached = false;
            if (this.mCachedUnitShare != null) {
                bCached = true;
                this.mUnitShare = this.mCachedUnitShare;
                this.mShareSize = this.mCachedShareSize;
                this.mCachedUnitShare = null;
                this.mUnitShare.updateUnitInfo(shareUnitInfo);
            } else {
                this.mUnitShare = shareMgr.createShareUnit(shareUnitInfo);
                if (this.mUnitShare == null) {
                    return;
                }
            }
            this.mUnitShare.setVideoScene(this);
            this.addUnit(this.mUnitShare);
            if (!bCached) {
                this.mUnitShare.onCreate();
            }
        }
    }

    private void destroyUnitActiveVideo() {
        if (this.mUnitActiveVideo == null) {
            return;
        }
        this.mUnitActiveVideo.removeUser();
        if (this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.onDestroy();
            this.removeUnit(this.mUnitActiveVideo);
            this.mUnitActiveVideo = null;
        }
        this.onUpdateUnits();
    }

    @Override
    public void updateAccessibilitySceneDescription() {
        if (this.getConfActivity() != null) {
            if (this.getConfActivity().isSharingOut()) {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_share));
                return;
            }
            if (this.getConfActivity().isToolbarShowing()) {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_share_toolbar_showed));
            } else {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_share_toolbar_hided));
            }
        }
    }

    @Override
    protected void onUpdateUnits() {
        if (this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            PointF center = this.getCenterPixelPosOnContent();
            this.updateUnitsWithoutResetDestArea();
            if (center == null) {
                return;
            }
            this.resetDestAreaCenter(center.x, center.y);
        }
        long shareActiveUser = this.getVideoSceneMgr().getShareActiveUserId();
        this.updateSharingTitle(shareActiveUser);
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
            this.updateAccessibilitySceneDescription();
        }
    }

    private void updateUnitsWithoutResetDestArea() {
        this.updateUnitShare();
        this.updateUnitActiveVideo();
        this.updateExpandVideoButton();
        this.updateGLImageWaterMark();
    }

    private void updateUnitActiveVideo() {
        long activeUserId;
        RendererUnitInfo unitInfo;
        if (this.mUnitActiveVideo != null && (unitInfo = this.createVideoUnitInfo((activeUserId = this.getVideoSceneMgr().getActiveUserId()) > 0L)) != null) {
            this.mUnitActiveVideo.updateUnitInfo(unitInfo);
        }
    }

    private void updateUnitShare() {
        if (this.mUnitShare != null) {
            RendererUnitInfo unitInfo = this.createShareUnitInfo();
            if (unitInfo != null) {
                this.mUnitShare.updateUnitInfo(unitInfo);
            }
            ZoomShareData.getInstance().onUpdateUnitShare(this.mUnitShare, this.getWidth() - this.getShareRenderWidth(), this.getHeight() - this.getShareRenderHeight());
        }
    }

    @Override
    protected void onDestroyUnits() {
        if (this.mUnitShare != null) {
            this.mUnitShare.removeUser();
        }
        this.mUnitActiveVideo = null;
        this.mUnitShare = null;
        this.mShareSize = null;
        this.mGLImageWaterMark = null;
        if (this.mCachedUnitShare == null) {
            this.mHasCachedData = false;
        }
    }

    @Override
    protected void onStart() {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ShareVideoScene.this.updateContentSubscription();
            }
        });
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
        }
    }

    @Override
    public void updateContentSubscription() {
        if (!this.isPreloadStatus()) {
            this.checkShowVideo();
            this.checkShowShare();
        }
    }

    @Override
    protected void onStop() {
        if (this.mUnitShare != null) {
            this.mUnitShare.stopViewShareContent();
        }
        if (this.mUnitActiveVideo != null) {
            this.mUnitActiveVideo.removeUser();
        }
        this.showWaiting(false);
        this.updateSharingTitle(0L);
    }

    @Override
    protected void onResumeVideo() {
        if (!this.mHasCachedData) {
            this.showWaiting(true);
        }
        this.updateContentSubscription();
        this.updateSharingTitle(this.getVideoSceneMgr().getShareActiveUserId());
        this.updateSwitchScenePanel();
    }

    @Override
    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        if (this.mCachedUnitShare != null) {
            this.mCachedUnitShare.onGLViewSizeChanged(width, height);
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.hasGrantedUnits() && this.isCreated()) {
            this.stopAndDestroyAllGrantedUnits();
        }
        super.onGLRendererChanged(renderer, width, height);
        if (this.mIsMultiTouchZooming) {
            this.onMultiTouchZoomEnd();
        }
    }

    @Override
    public void onActiveVideoChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ShareVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserVideoStatus(long userId) {
        super.onUserVideoStatus(userId);
        if (this.isPreloadStatus()) {
            return;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ShareVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserVideoDataSizeChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ShareVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserAudioStatus(long userId) {
        this.updateUserAudioStatus(userId);
    }

    @Override
    public void onAudioTypeChanged(long userId) {
        this.updateUserAudioStatus(userId);
    }

    private void updateUserAudioStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnitActiveVideo != null) {
            long activeUserId = this.mUnitActiveVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
            if (user != null) {
                activeUserId = user.getNodeId();
            }
            if (activeUserId != 0L && confStatus.isSameUser(userId, activeUserId)) {
                this.mUnitActiveVideo.onUserAudioStatus();
            }
        }
    }

    @Override
    public void onUserPicReady(long userId) {
        this.updateUserPic(userId);
    }

    private void updateUserPic(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnitActiveVideo != null) {
            long activeUserId = this.mUnitActiveVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
            if (user != null) {
                activeUserId = user.getNodeId();
            }
            if (activeUserId != 0L && confStatus.isSameUser(userId, activeUserId)) {
                this.mUnitActiveVideo.updateAvatar();
            }
        }
    }

    @Override
    public void onShareActiveUser(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                ShareVideoScene.this.checkShowShare();
            }
        });
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        if (this.isPreloadStatus()) {
            return;
        }
        switch (eventType) {
            case 0: {
                this.updateSwitchScenePanel();
                break;
            }
            case 1: {
                this.updateSwitchScenePanel();
                break;
            }
            case 2: {
                this.updateContentSubscription();
                if (this.mIsNotWaiting) break;
                this.showWaiting(true);
            }
        }
    }

    private void showWaiting(boolean show) {
        ConfActivity activity = this.getConfActivity();
        View panelWaitingShare = activity.findViewById(R.id.panelWaitingShare);
        TextView txtMsgWaitingShare = (TextView)panelWaitingShare.findViewById(R.id.txtMsgWaitingShare);
        if (show) {
            CmmUser user = ConfMgr.getInstance().getUserById(this.getVideoSceneMgr().getShareActiveUserId());
            if (user == null) {
                return;
            }
            String name = user.getScreenName();
            if (name.endsWith("s")) {
                txtMsgWaitingShare.setText((CharSequence)activity.getString(R.string.zm_msg_waiting_share_s, new Object[]{name}));
            } else {
                txtMsgWaitingShare.setText((CharSequence)activity.getString(R.string.zm_msg_waiting_share, new Object[]{name}));
            }
            panelWaitingShare.setVisibility(0);
            this.mIsNotWaiting = false;
        } else {
            panelWaitingShare.setVisibility(4);
            this.mIsNotWaiting = true;
            this.updateGLImageWaterMark();
        }
    }

    @Override
    public void onShareUserReceivingStatus(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        CmmShareStatus shareStatus = user.getShareStatusObj();
        if (shareStatus == null) {
            return;
        }
        boolean isReceiving = shareStatus.getIsReceiving();
        if (isReceiving) {
            VideoSize size;
            this.mHasCachedData = true;
            this.showWaiting(false);
            this.stopAndDestroyAllGrantedUnits();
            ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
            if (shareMgr != null && (size = shareMgr.getShareDataResolution(userId)) != null && size.width > 0 && size.height > 0) {
                this.onShareDataSizeChanged(userId);
            }
        } else if (!this.mHasCachedData) {
            this.showWaiting(true);
        }
        this.updateSharingTitle(this.getVideoSceneMgr().getShareActiveUserId());
    }

    @Override
    public void onShareUserSendingStatus(long userId) {
        ShareSessionMgr shareMgr;
        AbsVideoSceneMgr sceneMgr = this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        if (userId == sceneMgr.getShareActiveUserId() && (shareMgr = ConfMgr.getInstance().getShareObj()) != null) {
            boolean bVideoShare = shareMgr.isVideoSharingInProgress();
            if (bVideoShare && !sceneMgr.isVideoShareInProgress()) {
                this.zoomToFitUnit();
            }
            sceneMgr.setIsVideoShareInProgress(bVideoShare);
        }
    }

    @Override
    protected void onGrantedUnitsDestroyed() {
        this.checkShowVideo();
    }

    @Override
    public void onShareDataSizeChanged(long userId) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        boolean bFirst = false;
        VideoSize sizeNew = null;
        bFirst = this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0;
        sizeNew = shareMgr.getShareDataResolution(userId);
        if (sizeNew == null || sizeNew.width == 0 || sizeNew.height == 0) {
            return;
        }
        this.mShareSize = sizeNew;
        ZoomShareData.getInstance().onShareSourceDataSizeChanged(this.mShareSize.width, this.mShareSize.height);
        boolean _bFirst = bFirst;
        AbsVideoSceneMgr sceneMgr = this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        boolean bVideoShare = shareMgr.isVideoSharingInProgress();
        if (bVideoShare && !sceneMgr.isVideoShareInProgress()) {
            this.mIsFitScreen = true;
        }
        sceneMgr.setIsVideoShareInProgress(bVideoShare);
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return;
        }
        if (_bFirst || this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            int countLevels;
            int level = this.getCurrentScaleLevel();
            if (level >= (countLevels = this.getScaleLevelsCount())) {
                level = countLevels - 1;
                this.mZoomVal = this.scaleLevelToZoomValue(level);
            }
            this.mIsFitScreen = this.checkFitScreen();
            this.updateUnitsWithoutResetDestArea();
            this.trimContentPos();
            if (this.mIsFitScreen) {
                if (this.mUnitShare != null) {
                    this.mScaleWidth = this.mUnitShare.getWidth();
                    this.mScaleHeight = this.mUnitShare.getHeight();
                }
            } else {
                this.mScaleWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
                this.mScaleHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            }
            this.notifyDestAreaChanged();
        }
    }

    @Override
    public void onConfVideoSendingStatusChanged() {
        if (!this.isPreloadStatus()) {
            this.checkShowVideo();
        }
    }

    @Override
    public void beforeSwitchCamera() {
        if (this.mUnitActiveVideo == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(this.mUnitActiveVideo.getUser())) {
            this.mUnitActiveVideo.stopVideo(false);
        }
    }

    @Override
    public void afterSwitchCamera() {
        if (this.mUnitActiveVideo == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(this.mUnitActiveVideo.getUser())) {
            this.mUnitActiveVideo.startVideo();
        }
    }

    private void checkShowVideo() {
        CmmUser peerUser;
        if (!this.isCreated()) {
            return;
        }
        if (this.hasGrantedUnits()) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        VideoSessionMgr videoMgr = confMgr.getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmUserList userList = confMgr.getUserList();
        if (userList == null) {
            return;
        }
        RendererUnitInfo unitInfo = null;
        long activeUserId = this.getVideoSceneMgr().getActiveUserId();
        if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() == 2 && (peerUser = userList.getPeerUser(false, true)) != null) {
            activeUserId = peerUser.getNodeId();
        }
        if (this.mUnitActiveVideo == null) {
            return;
        }
        CmmConfContext confContext = confMgr.getConfContext();
        if (confContext == null) {
            return;
        }
        boolean isVideoMeeting = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting();
        boolean noOneIsSendingVideo = confMgr.noOneIsSendingVideo();
        if (activeUserId > 0L && (isVideoMeeting || !noOneIsSendingVideo)) {
            VideoSize size = this.getUserVideoSize(activeUserId);
            if (size == null || size.width == 0 || size.height == 0) {
                size = this.getMyVideoSize();
            }
            if (this.mActiveVideoSize == null || !this.mActiveVideoSize.similarTo(size)) {
                this.mActiveVideoSize = size;
                unitInfo = this.createVideoUnitInfo(true);
                if (unitInfo != null) {
                    this.mUnitActiveVideo.updateUnitInfo(unitInfo);
                }
            } else {
                this.mActiveVideoSize = size;
            }
            this.mUnitActiveVideo.setType(0);
            this.mUnitActiveVideo.setUser(activeUserId);
            this.mUnitActiveVideo.setBorderVisible(true);
            this.mUnitActiveVideo.setBackgroundColor(-16777216);
        } else if (videoMgr.isVideoStarted()) {
            CmmUser user = userList.getMyself();
            if (user == null) {
                return;
            }
            if (this.mUnitActiveVideo.getUser() != user.getNodeId()) {
                unitInfo = this.createPreviewVideoUnitInfo();
                this.mUnitActiveVideo.updateUnitInfo(unitInfo);
            }
            this.mUnitActiveVideo.setType(0);
            this.mUnitActiveVideo.setUser(user.getNodeId());
            this.mUnitActiveVideo.setBorderVisible(true);
            this.mUnitActiveVideo.setBackgroundColor(-16777216);
        } else {
            this.mUnitActiveVideo.stopVideo(true);
            this.mUnitActiveVideo.removeUser();
            this.mUnitActiveVideo.setBorderVisible(false);
            this.mUnitActiveVideo.setBackgroundColor(0);
        }
    }

    private void checkShowShare() {
        if (!this.isCreated()) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        if (this.mUnitShare == null) {
            return;
        }
        long shareActiveUser = this.getVideoSceneMgr().getShareActiveUserId();
        if (shareActiveUser != 0L) {
            RendererUnitInfo unitInfo = this.createShareUnitInfo();
            if (unitInfo != null) {
                this.mUnitShare.updateUnitInfo(unitInfo);
            }
            long oldUser = this.mUnitShare.getUser();
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (this.getLeft() == 0 && confStatus != null && !confStatus.isSameUser(oldUser, shareActiveUser) && !this.mHasCachedData) {
                this.showWaiting(true);
            }
            this.mUnitShare.setUser(shareActiveUser);
            this.updateSharingTitle(shareActiveUser);
        } else {
            this.mUnitShare.removeUser();
            this.showWaiting(false);
        }
    }

    private void updateSharingTitle(long shareActiveUser) {
        View panelSharingTitle = this.getConfActivity().findViewById(R.id.panelSharingTitle);
        ConfShareLocalHelper.updateShareTitle((Context)this.getConfActivity(), shareActiveUser, panelSharingTitle);
        if (this.isLargeShareVideoMode()) {
            ViewGroup.MarginLayoutParams marginParams = (ViewGroup.MarginLayoutParams)panelSharingTitle.getLayoutParams();
            marginParams.bottomMargin = this.getHeight() - this.getShareRenderHeight();
            panelSharingTitle.setLayoutParams((ViewGroup.LayoutParams)marginParams);
            panelSharingTitle.getParent().requestLayout();
        }
        if (this.isVisible() && this.isStarted() && this.hasContent() && !this.getConfActivity().isToolbarShowing()) {
            panelSharingTitle.setVisibility(0);
        } else {
            panelSharingTitle.setVisibility(8);
        }
    }

    private RendererUnitInfo createVideoUnitInfo(boolean hasActiveUser) {
        if (hasActiveUser && this.mActiveVideoSize != null) {
            return this.createActiveVideoUnitInfo(this.mActiveVideoSize);
        }
        return this.createPreviewVideoUnitInfo();
    }

    private VideoSize getMyVideoSize() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return new VideoSize(16, 9);
        }
        VideoSize size = videoMgr.getMyVideoSize();
        return size;
    }

    private VideoSize calcVideoUnitSize(VideoSize videoSize) {
        int widthPreview = 0;
        int heightPreview = 0;
        if (videoSize == null || videoSize.width == 0 && videoSize.height == 0) {
            return new VideoSize(16, 9);
        }
        int landscapeWidth = Math.max(UIUtil.getDisplayWidth((Context)this.getConfActivity()), UIUtil.getDisplayHeight((Context)this.getConfActivity())) / 8;
        int portraitWidth = Math.min(UIUtil.getDisplayWidth((Context)this.getConfActivity()), UIUtil.getDisplayHeight((Context)this.getConfActivity())) / 8;
        if (videoSize.width > videoSize.height) {
            int minWidth = UIUtil.dip2px((Context)this.getConfActivity(), (float)80.0f);
            widthPreview = Math.max(landscapeWidth, minWidth);
        } else {
            int minWidth = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            widthPreview = Math.max(portraitWidth, minWidth);
        }
        heightPreview = widthPreview * videoSize.height / videoSize.width;
        return new VideoSize(widthPreview, heightPreview);
    }

    private RendererUnitInfo createPreviewVideoUnitInfo() {
        VideoSize unitSize = this.calcVideoUnitSize(this.getMyVideoSize());
        return this.createVideoUnitInfo(unitSize);
    }

    private RendererUnitInfo createActiveVideoUnitInfo(VideoSize activeVideoSize) {
        VideoSize unitSize = this.calcVideoUnitSize(activeVideoSize);
        return this.createVideoUnitInfo(unitSize);
    }

    private RendererUnitInfo createVideoUnitInfo(VideoSize unitSize) {
        int widthPreview = unitSize.width;
        int heightPreview = unitSize.height;
        int marginPreview = UIUtil.dip2px((Context)this.getConfActivity(), (float)5.0f);
        int leftPreview = this.getWidth() - marginPreview - widthPreview;
        int topPreview = this.getHeight() - heightPreview - marginPreview;
        int toolbarHeight = this.getConfActivity().getToolbarHeight();
        if (toolbarHeight > 0) {
            topPreview -= toolbarHeight;
        }
        return new RendererUnitInfo(this.getLeft() + leftPreview, this.getTop() + topPreview, widthPreview, heightPreview);
    }

    private RendererUnitInfo createShareUnitInfo() {
        RendererUnitInfo unitInfo = null;
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            shareSize = new VideoSize(16, 9);
        }
        unitInfo = this.createShareUnitInfo(shareSize);
        return unitInfo;
    }

    private RendererUnitInfo createShareUnitInfo(VideoSize size) {
        int l;
        int w;
        int h;
        int t;
        int shareWidth = size.width;
        int shareHeight = size.height;
        if (shareWidth == 0 || shareHeight == 0) {
            return null;
        }
        int shareRenderWidth = this.getShareRenderWidth();
        int shareRenderHeight = this.getShareRenderHeight();
        int activeVideoTop = this.getShareRenderHeight();
        int activeVideoLeft = this.getShareRenderWidth();
        if (this.mIsFitScreen && Math.abs(this.mZoomVal - this.getMinLevelZoomValue()) < 0.01) {
            if (shareRenderWidth * shareHeight > shareRenderHeight * shareWidth) {
                t = 0;
                h = shareRenderHeight;
                w = h * shareWidth / shareHeight;
                l = (shareRenderWidth - w) / 2;
                if (l + w > activeVideoLeft && (l = activeVideoLeft - w) < 0) {
                    l = 0;
                }
            } else {
                l = 0;
                w = shareRenderWidth;
                h = w * shareHeight / shareWidth;
                t = (shareRenderHeight - h) / 2;
                if (activeVideoTop > 0 && t + h > activeVideoTop && (t = activeVideoTop - h) < 0) {
                    t = 0;
                }
            }
        } else {
            float contentWidth = (float)((double)shareWidth * this.mZoomVal);
            float contentHeight = (float)((double)shareHeight * this.mZoomVal);
            if (contentWidth > (float)shareRenderWidth) {
                l = 0;
                w = shareRenderWidth;
            } else {
                w = (int)contentWidth;
                l = (shareRenderWidth - w) / 2;
                if (l + w > activeVideoLeft && (l = activeVideoLeft - w) < 0) {
                    l = 0;
                }
            }
            if (contentHeight > (float)shareRenderHeight) {
                t = 0;
                h = shareRenderHeight;
            } else {
                h = (int)contentHeight;
                t = (shareRenderHeight - h) / 2;
                if (activeVideoTop > 0 && t + h > activeVideoTop && (t = activeVideoTop - h) < 0) {
                    t = 0;
                }
            }
        }
        return new RendererUnitInfo(this.getLeft() + l, this.getTop() + t, w, h);
    }

    @Override
    public void onDown(MotionEvent e) {
        this.mStopFling = true;
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        if (!this.mInRemoteControlMode) {
            this.mStopFling = true;
            if (!this.mIsNotWaiting) {
                return;
            }
            if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
                return;
            }
            int levelsCount = this.getScaleLevelsCount();
            int oldLevel = this.getCurrentScaleLevel();
            int newLevel = (oldLevel + 1) % levelsCount;
            if (newLevel == oldLevel) {
                return;
            }
            if (newLevel == 0) {
                this.zoomToFitUnit();
            } else {
                this.switchToLevel(newLevel, e.getX(), e.getY());
            }
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        if (!this.mIsNotWaiting) {
            return false;
        }
        if (super.onTouchEvent(e)) {
            return true;
        }
        if (e.getPointerCount() == 2) {
            this.mRemoteControlGestureHandler.removeCallbacksAndMessages(null);
            float x1 = e.getX(0);
            float y1 = e.getY(0);
            float x2 = e.getX(1);
            float y2 = e.getY(1);
            if (e.getActionMasked() == 5) {
                this.mLastX1 = 0.0f;
                this.mLastY1 = 0.0f;
                this.mLastX2 = 0.0f;
                this.mLastY2 = 0.0f;
                this.mScrolled = false;
                this.mFlinged = false;
            }
            if (this.mInRemoteControlMode) {
                if (e.getActionMasked() == 5) {
                    this.mLastDoubleScrollX = x1;
                    this.mLastDoubleScrollY = y1;
                    this.mDistance = (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
                    this.mLastDoubleScrollTime = System.currentTimeMillis();
                }
                if (!this.mIsMultiTouchZooming && !this.mIsDoubleScrollMode && e.getActionMasked() == 2) {
                    double pxDis = Math.abs(Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)) - (double)this.mDistance);
                    double dpDis = UIUtil.px2dip((Context)this.getConfActivity(), (int)((int)pxDis));
                    if (this.mMoveCount <= 20 && dpDis > 80.0) {
                        this.mIsMultiTouchZooming = true;
                        return true;
                    }
                    if (this.mMoveCount > 20) {
                        this.mIsDoubleScrollMode = true;
                        return true;
                    }
                    ++this.mMoveCount;
                }
            } else {
                this.mIsMultiTouchZooming = true;
            }
            if (this.mIsDoubleScrollMode) {
                if (System.currentTimeMillis() - this.mLastDoubleScrollTime > 150L) {
                    this.mLastDoubleScrollTime = System.currentTimeMillis();
                    if (Math.abs(x1 - this.mLastDoubleScrollX) < Math.abs(y1 - this.mLastDoubleScrollY)) {
                        if (this.mLastDoubleScrollY - y1 > 0.0f) {
                            this.remoteControlDoubleScroll(0.0f, 1.0f);
                        } else {
                            this.remoteControlDoubleScroll(0.0f, -1.0f);
                        }
                    }
                    this.mLastDoubleScrollX = x1;
                    this.mLastDoubleScrollY = y1;
                }
                return true;
            }
            if (e.getActionMasked() == 1) {
                if (this.mIsMultiTouchZooming) {
                    this.onMultiTouchZoomEnd();
                    this.moveMouseToRightPosition();
                    return true;
                }
                if (this.mIsDoubleScrollMode) {
                    this.mIsDoubleScrollMode = false;
                    this.mMoveCount = 0;
                    this.mbIgnoreNextScroll = true;
                    return true;
                }
            }
            if (this.mIsMultiTouchZooming && this.mLastX1 != 0.0f && this.mLastY1 != 0.0f && this.mLastX2 != 0.0f && this.mLastY2 != 0.0f) {
                this.onMultiTouchZoom(x1, y1, x2, y2, this.mLastX1, this.mLastY1, this.mLastX2, this.mLastY2);
            }
            this.mLastX1 = x1;
            this.mLastY1 = y1;
            this.mLastX2 = x2;
            this.mLastY2 = y2;
            return true;
        }
        if (this.mIsMultiTouchZooming) {
            this.onMultiTouchZoomEnd();
            this.moveMouseToRightPosition();
            this.mMoveCount = 0;
            return true;
        }
        if (this.mIsDoubleScrollMode) {
            this.mIsDoubleScrollMode = false;
            this.mMoveCount = 0;
            this.mbIgnoreNextScroll = true;
            return true;
        }
        if (e.getPointerCount() == 1 && this.mInRemoteControlMode) {
            if (e.getActionMasked() == 0) {
                this.mScrolled = false;
                this.mFlinged = false;
                if (this.mCurrentDownEvent != null && this.mPreviousUpEvent != null && this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, e)) {
                    this.mRemoteControlGestureHandler.removeMessages(2);
                    this.mIsDoubleTap = true;
                    this.remoteControlDoubleTap(e.getX(), e.getY());
                } else {
                    Message message = Message.obtain();
                    Bundle b = new Bundle();
                    b.putFloat("x", e.getX());
                    b.putFloat("y", e.getY());
                    message.what = 1;
                    message.setData(b);
                    this.mRemoteControlGestureHandler.sendMessageDelayed(message, 1500L);
                }
                if (this.mCurrentDownEvent != null) {
                    this.mCurrentDownEvent.recycle();
                }
                this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)e);
            } else if (e.getActionMasked() == 2) {
                if (this.mCurrentDownEvent != null && (Math.abs(this.mCurrentDownEvent.getX() - e.getX()) > 10.0f || Math.abs(this.mCurrentDownEvent.getY() - e.getY()) > 10.0f)) {
                    this.mRemoteControlGestureHandler.removeCallbacksAndMessages(null);
                    return false;
                }
            } else if (e.getActionMasked() == 1) {
                this.mRemoteControlGestureHandler.removeMessages(1);
                if (!(this.mCurrentDownEvent == null || this.mIsDoubleTap || e.getEventTime() - this.mCurrentDownEvent.getEventTime() >= 200L || this.mScrolled || this.mFlinged)) {
                    Message message = Message.obtain();
                    Bundle b = new Bundle();
                    b.putFloat("x", e.getX());
                    b.putFloat("y", e.getY());
                    b.putFloat("raw_x", e.getRawX());
                    b.putFloat("raw_y", e.getRawY());
                    message.setData(b);
                    message.what = 2;
                    this.mRemoteControlGestureHandler.sendMessageDelayed(message, 500L);
                }
                this.mIsDoubleTap = false;
                if (this.mPreviousUpEvent != null) {
                    this.mPreviousUpEvent.recycle();
                }
                this.mPreviousUpEvent = MotionEvent.obtain((MotionEvent)e);
            }
        }
        return false;
    }

    private boolean isConsideredDoubleTap(MotionEvent firstDown, MotionEvent firstUp, MotionEvent secondDown) {
        int deltaY;
        if (secondDown.getEventTime() - firstUp.getEventTime() > 300L) {
            return false;
        }
        int deltaX = (int)firstDown.getX() - (int)secondDown.getX();
        return (float)(deltaX * deltaX + (deltaY = (int)firstDown.getY() - (int)secondDown.getY()) * deltaY) < UIUtil.px2dip((Context)this.getConfActivity(), (int)100) * UIUtil.px2dip((Context)this.getConfActivity(), (int)100);
    }

    private void moveMouseToRightPosition() {
        if (this.mRCMouseX == 0.0f && this.mRCMouseY == 0.0f) {
            return;
        }
        float viewX = this.shareContentToViewX(this.mRCMouseX);
        float viewY = this.shareContentToViewY(this.mRCMouseY);
        RCMouseView rcMouseView = this.getConfActivity().getRCMouseView();
        if (rcMouseView != null) {
            rcMouseView.moveMouse(viewX, viewY);
        }
    }

    @Override
    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        if (this.mInRemoteControlMode) {
            return true;
        }
        return super.onVideoViewSingleTapConfirmed(e);
    }

    private void onMultiTouchZoom(float x1, float y1, float x2, float y2, float lastX1, float lastY1, float lastX2, float lastY2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float lastDx = lastX2 - lastX1;
        float lastDy = lastY2 - lastY1;
        double curDistance = Math.sqrt(dx * dx + dy * dy);
        double lastDistance = Math.sqrt(lastDx * lastDx + lastDy * lastDy);
        double newZoom = this.mZoomVal * (curDistance / lastDistance);
        float lastX1OnUnit = this.viewXToShareUnitX(lastX1);
        float lastY1OnUnit = this.viewYToShareUnitY(lastY1);
        PointF pixelLastPos1OnContent = this.unitPosToPixelPosOnContent(lastX1OnUnit, lastY1OnUnit, this.mZoomVal);
        float lastXPos1OnContentNew = (float)((double)pixelLastPos1OnContent.x * newZoom);
        float lastYPos1OnContentNew = (float)((double)pixelLastPos1OnContent.y * newZoom);
        this.mZoomVal = newZoom;
        this.mIsFitScreen = this.checkFitScreen();
        this.updateUnitsWithoutResetDestArea();
        float x1OnUnit = this.viewXToShareUnitX(x1);
        float y1OnUnit = this.viewYToShareUnitY(y1);
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return;
        }
        this.mScaleWidth = (float)((double)this.mShareSize.width * newZoom);
        this.mScaleHeight = (float)((double)this.mShareSize.height * newZoom);
        this.mContentX = x1OnUnit - lastXPos1OnContentNew;
        this.mContentY = y1OnUnit - lastYPos1OnContentNew;
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private void onMultiTouchZoomEnd() {
        this.mIsMultiTouchZooming = false;
        this.mLastMultiTouchEndTime = System.currentTimeMillis();
        if (this.mZoomVal < this.getMinLevelZoomValue()) {
            this.zoomToFitUnit();
            this.moveMouseToRightPosition();
        } else if (this.mZoomVal > this.getMaxLevelZoomValue()) {
            if (this.mUnitShare == null) {
                return;
            }
            this.switchToLevel(this.getScaleLevelsCount() - 1, this.mUnitShare.getWidth() / 2 + this.mUnitShare.getLeft(), this.mUnitShare.getHeight() / 2 + this.mUnitShare.getTop());
            this.moveMouseToRightPosition();
        }
    }

    public boolean canDragSceneToLeft() {
        if (this.mInRemoteControlMode) {
            return false;
        }
        if (this.mUnitShare == null || !this.mHasCachedData) {
            return false;
        }
        if (this.mShareSize == null) {
            return true;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
        return this.mContentX + contentWidth <= (float)this.mUnitShare.getWidth();
    }

    public boolean canDragSceneToRight() {
        if (this.mInRemoteControlMode) {
            return false;
        }
        if (this.mUnitShare == null || !this.mHasCachedData) {
            return false;
        }
        if (this.mShareSize == null) {
            return true;
        }
        return this.mContentX >= 0.0f;
    }

    private boolean checkFitScreen() {
        if (this.mZoomVal < 0.01) {
            return true;
        }
        double zoomFit = this.scaleLevelToZoomValue(0);
        return Math.abs(this.mZoomVal - zoomFit) < 0.01;
    }

    private double getMaxLevelZoomValue() {
        float density = VideoBoxApplication.getInstance().getResources().getDisplayMetrics().density;
        float maxLevelZoomVal = density * 160.0f / 120.0f;
        return maxLevelZoomVal;
    }

    private double getMinLevelZoomValue() {
        if (this.mShareSize == null) {
            return 0.0;
        }
        int renderWidth = this.getShareRenderWidth();
        int renderHeight = this.getShareRenderHeight();
        double fitWidth = 0.0;
        if (renderWidth * this.mShareSize.height > renderHeight * this.mShareSize.width) {
            int fitHeight = renderHeight;
            fitWidth = (double)fitHeight * (double)this.mShareSize.width / (double)this.mShareSize.height;
        } else {
            fitWidth = renderWidth;
        }
        double minLevelZoomVal = fitWidth / (double)this.mShareSize.width;
        return minLevelZoomVal;
    }

    private int getScaleLevelsCount() {
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return 3;
        }
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        float maxContextDisplayWidth = (float)(maxLevelZoomVal * (double)this.mShareSize.width);
        float maxContextDisplayHeight = (float)(maxLevelZoomVal * (double)this.mShareSize.height);
        if (maxContextDisplayWidth <= (float)this.getShareRenderWidth() && maxContextDisplayHeight < (float)this.getShareRenderHeight()) {
            return 1;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        float mediumContextDisplayWidth = (float)(mediumLevelZoomVal * (double)this.mShareSize.width);
        float mediumContextDisplayHeight = (float)(mediumLevelZoomVal * (double)this.mShareSize.height);
        if (mediumContextDisplayWidth <= (float)this.getShareRenderWidth() && mediumContextDisplayHeight < (float)this.getShareRenderHeight()) {
            return 2;
        }
        return 3;
    }

    private int getCurrentScaleLevel() {
        int i;
        int levelsCount = this.getScaleLevelsCount();
        double[] levelZooms = new double[levelsCount];
        for (i = 0; i < levelsCount; ++i) {
            levelZooms[i] = this.scaleLevelToZoomValue(i);
        }
        for (i = 0; i < levelsCount - 1; ++i) {
            if (!(this.mZoomVal >= levelZooms[i]) || !(this.mZoomVal < levelZooms[i + 1])) continue;
            return i;
        }
        return levelsCount - 1;
    }

    private void switchToLevel(int level, float x, float y) {
        this.switchToZoom(this.scaleLevelToZoomValue(level), x, y);
    }

    private void switchToZoom(double zoomVal, float x, float y) {
        double oldZoom = this.mZoomVal;
        this.mZoomVal = zoomVal;
        this.mIsFitScreen = this.checkFitScreen();
        float xOnUnit = this.viewXToShareUnitX(x);
        float yOnUnit = this.viewYToShareUnitY(y);
        PointF pixelPosOnContent = this.unitPosToPixelPosOnContent(xOnUnit, yOnUnit, oldZoom);
        this.updateUnitsWithoutResetDestArea();
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return;
        }
        float pixelXOnContent = pixelPosOnContent.x;
        float pixelYOnContent = pixelPosOnContent.y;
        this.mScaleWidth = (float)((double)this.mShareSize.width * this.mZoomVal);
        this.mScaleHeight = (float)((double)this.mShareSize.height * this.mZoomVal);
        this.resetDestAreaCenter(pixelXOnContent, pixelYOnContent);
    }

    private PointF getCenterPixelPosOnContent() {
        if (this.mUnitShare == null) {
            return null;
        }
        return this.unitPosToPixelPosOnContent(this.mUnitShare.getWidth() / 2, this.mUnitShare.getHeight() / 2, this.mZoomVal);
    }

    private void resetDestAreaCenter(float pixelX, float pixelY) {
        if (this.mUnitShare == null) {
            return;
        }
        this.mContentX = (float)(this.mUnitShare.getWidth() / 2) - (float)((double)pixelX * this.mZoomVal);
        this.mContentY = (float)(this.mUnitShare.getHeight() / 2) - (float)((double)pixelY * this.mZoomVal);
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private PointF unitPosToPixelPosOnContent(float x, float y, double zoomVal) {
        float xOnContent = x - this.mContentX;
        float yOnContent = y - this.mContentY;
        float pixelXOnContent = (float)((double)xOnContent / zoomVal);
        float pixelYOnContent = (float)((double)yOnContent / zoomVal);
        return new PointF(pixelXOnContent, pixelYOnContent);
    }

    private void notifyDestAreaChanged() {
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            return;
        }
        if (this.mUnitShare == null) {
            return;
        }
        this.mUnitShare.destAreaChanged((int)this.mContentX, (int)this.mContentY, (int)this.mScaleWidth, (int)this.mScaleHeight);
        ZoomShareData.getInstance().onDestAreaChangedChanged(this.mContentX, this.mContentY, this.mScaleWidth, this.mScaleHeight);
    }

    private void zoomToFitUnit() {
        if (this.mUnitShare == null) {
            return;
        }
        this.mZoomVal = this.scaleLevelToZoomValue(0);
        this.mIsFitScreen = this.checkFitScreen();
        this.mContentX = 0.0f;
        this.mContentY = 0.0f;
        this.updateUnitsWithoutResetDestArea();
        this.mScaleWidth = this.mUnitShare.getWidth();
        this.mScaleHeight = this.mUnitShare.getHeight();
        this.notifyDestAreaChanged();
    }

    public float viewToShareContentX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return (float)((double)(x - (float)this.mUnitShare.getLeft() - this.mContentX) / this.mZoomVal);
    }

    public float viewToShareContentY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return (float)((double)(y - (float)this.mUnitShare.getTop() - this.mContentY) / this.mZoomVal);
    }

    public float shareContentToViewX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return (float)((double)x * this.mZoomVal + (double)this.mUnitShare.getLeft() + (double)this.mContentX);
    }

    public float shareContentToViewY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return (float)((double)y * this.mZoomVal + (double)this.mUnitShare.getTop() + (double)this.mContentY);
    }

    private float viewXToShareUnitX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return x - (float)this.mUnitShare.getLeft();
    }

    private float viewYToShareUnitY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return y - (float)this.mUnitShare.getTop();
    }

    private double scaleLevelToZoomValue(int level) {
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return 1.0;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        int levelsCount = this.getScaleLevelsCount();
        if (levelsCount == 1) {
            if (minLevelZoomVal > maxLevelZoomVal && this.getVideoSceneMgr().isVideoShareInProgress()) {
                return minLevelZoomVal;
            }
            return Math.min(minLevelZoomVal, maxLevelZoomVal);
        }
        if (levelsCount == 2) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        if (levelsCount >= 3) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
                case 1: {
                    return mediumLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        return 0.0;
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mbIgnoreNextScroll) {
            this.mbIgnoreNextScroll = false;
            return;
        }
        this.mScrolled = true;
        this.mStopFling = true;
        if (!this.mIsNotWaiting) {
            return;
        }
        if (System.currentTimeMillis() - this.mLastMultiTouchEndTime < 300L) {
            return;
        }
        this.mContentX -= distanceX;
        this.mContentY -= distanceY;
        this.trimContentPos();
        if (this.isInRemoteControlMode()) {
            this.moveMouseToRightPosition();
        }
        this.notifyDestAreaChanged();
    }

    private void trimContentPos() {
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
        float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
        if (this.mContentX > 0.0f) {
            if (contentWidth >= (float)this.mUnitShare.getWidth()) {
                this.mContentX = 0.0f;
            } else if (this.mContentX + contentWidth > (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
            }
        } else if (contentWidth >= (float)this.mUnitShare.getWidth() && this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
            this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
        } else if (contentWidth <= (float)this.mUnitShare.getWidth()) {
            this.mContentX = 0.0f;
        }
        if (this.mContentY > 0.0f) {
            if (contentHeight >= (float)this.mUnitShare.getHeight()) {
                this.mContentY = 0.0f;
            } else if (this.mContentY + contentHeight > (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
            }
        } else if (contentHeight >= (float)this.mUnitShare.getHeight() && this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
            this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
        } else if (contentHeight <= (float)this.mUnitShare.getHeight()) {
            this.mContentY = 0.0f;
        }
    }

    @Override
    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mIsMultiTouchZooming || this.mIsDoubleScrollMode) {
            return;
        }
        this.mFlinged = true;
        if (!this.mIsNotWaiting || !this.isCreated()) {
            return;
        }
        if (System.currentTimeMillis() - this.mLastMultiTouchEndTime < 300L) {
            return;
        }
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        if (velocityX > 0.0f) {
            this.mScroller.setFinalX(0);
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            this.mScroller.setFinalX((int)((float)this.mUnitShare.getWidth() - contentWidth));
        }
        if (velocityY > 0.0f) {
            this.mScroller.setFinalY(0);
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            this.mScroller.setFinalY((int)((float)this.mUnitShare.getHeight() - contentHeight));
        }
        int maxVelocity = UIUtil.dip2px((Context)this.getConfActivity(), (float)1500.0f);
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            if (velocityX == 0.0f) {
                velocityX = 0.1f;
            }
            float rate = velocityY / velocityX;
            if (velocityX > (float)maxVelocity) {
                velocityX = maxVelocity;
            } else if (velocityX < (float)(-maxVelocity)) {
                velocityX = -maxVelocity;
            }
            velocityY = velocityX * rate;
        } else {
            if (velocityY == 0.0f) {
                velocityY = 0.1f;
            }
            float rate = velocityX / velocityY;
            if (velocityY > (float)maxVelocity) {
                velocityY = maxVelocity;
            } else if (velocityY < (float)(-maxVelocity)) {
                velocityY = -maxVelocity;
            }
            velocityX = velocityY * rate;
        }
        this.mScroller.fling((int)this.mContentX, (int)this.mContentY, (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mStopFling = false;
        this.handleFling();
    }

    private void handleFling() {
        this.mFlingHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!ShareVideoScene.this.mStopFling && ShareVideoScene.this.updateContentPosOnFling()) {
                    ShareVideoScene.this.handleFling();
                }
            }
        }, 40L);
    }

    private boolean updateContentPosOnFling() {
        boolean xStopped = false;
        boolean yStopped = false;
        if (this.mUnitShare == null || this.mShareSize == null) {
            return false;
        }
        if (!this.mScroller.computeScrollOffset()) {
            return false;
        }
        this.mContentX = this.mScroller.getCurrX();
        if (this.mContentX > 0.0f) {
            this.mContentX = 0.0f;
            xStopped = true;
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            if (this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
                xStopped = true;
            }
        }
        this.mContentY = this.mScroller.getCurrY();
        if (this.mContentY > 0.0f) {
            this.mContentY = 0.0f;
            yStopped = true;
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            if (this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
                yStopped = true;
            }
        }
        this.notifyDestAreaChanged();
        this.moveMouseToRightPosition();
        return !xStopped && !yStopped;
    }

    public boolean needShowSwitchCameraButton() {
        return false;
    }

    private void createExpandVideoButton() {
        RendererUnitInfo unitInfo;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Drawable drawable2 = null;
        if (!this.mIsVideoExpand) {
            drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_expand_video);
        }
        if ((unitInfo = this.createExpandVideoButtonUnitInfo(drawable2)) != null) {
            this.mGLBtnExpandVideo = videoMgr.createGLButton(unitInfo);
            if (this.mGLBtnExpandVideo != null) {
                this.mGLBtnExpandVideo.setUnitName("ExpandVideo");
                this.mGLBtnExpandVideo.setVideoScene(this);
                this.addUnit(this.mGLBtnExpandVideo);
                this.mGLBtnExpandVideo.onCreate();
                this.mGLBtnExpandVideo.setBackground(drawable2);
                this.mGLBtnExpandVideo.setOnClickListener(this);
            }
        }
    }

    private void updateExpandVideoButton() {
        RendererUnitInfo unitInfo;
        if (this.mGLBtnExpandVideo == null) {
            return;
        }
        Drawable drawable2 = null;
        if (!this.mIsVideoExpand) {
            drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_expand_video);
        }
        if ((unitInfo = this.createExpandVideoButtonUnitInfo(drawable2)) != null) {
            this.mGLBtnExpandVideo.updateUnitInfo(unitInfo);
            this.mGLBtnExpandVideo.setBackground(drawable2);
        }
    }

    private RendererUnitInfo createExpandVideoButtonUnitInfo(Drawable background) {
        int h;
        int w;
        int y;
        int x;
        if (this.mIsVideoExpand) {
            if (this.mUnitActiveVideo == null) {
                return null;
            }
            x = this.mUnitActiveVideo.getLeft();
            y = this.mUnitActiveVideo.getTop();
            w = this.mUnitActiveVideo.getWidth();
            h = this.mUnitActiveVideo.getHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            int margin = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
            x = this.getLeft() + this.getWidth() - w - margin;
            y = this.getTop() + this.getHeight() - h - margin;
            int toolbarHeight = this.getConfActivity().getToolbarHeight();
            if (toolbarHeight > 0) {
                y -= toolbarHeight;
            }
        }
        return new RendererUnitInfo(x, y, w, h);
    }

    private void createGLImageWaterMark() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Bitmap bmpWaterMark = ConfLocalHelper.createWaterMarkBitmap(this.getShareRenderWidth(), this.getShareRenderHeight(), R.color.zm_share_text, 1.0f);
        if (bmpWaterMark == null) {
            return;
        }
        RendererUnitInfo unitInfo = this.createGLImageWaterMarkUnitInfo();
        this.mGLImageWaterMark = videoMgr.createGLImage(unitInfo);
        if (this.mGLImageWaterMark != null) {
            this.mGLImageWaterMark.setVisible(false);
            this.mGLImageWaterMark.setUnitName("mGLImageWaterMark");
            this.mGLImageWaterMark.setVideoScene(this);
            this.addUnit(this.mGLImageWaterMark);
            this.mGLImageWaterMark.onCreate();
            this.mGLImageWaterMark.setBackground(bmpWaterMark);
        }
    }

    private void updateGLImageWaterMark() {
        if (this.mGLImageWaterMark == null || this.hasGrantedUnits()) {
            return;
        }
        RendererUnitInfo unitInfo = this.createGLImageWaterMarkUnitInfo();
        if (this.mIsNotWaiting && this.mUnitActiveVideo != null && this.mUnitActiveVideo.isVideoShowing()) {
            Bitmap bmpWaterMark;
            this.mGLImageWaterMark.updateUnitInfo(unitInfo);
            this.mGLImageWaterMark.setVisible(true);
            if ((this.mWaterMarkWidth != this.getShareRenderWidth() || this.mWaterMarkHeight != this.getShareRenderHeight()) && (bmpWaterMark = ConfLocalHelper.createWaterMarkBitmap(this.getShareRenderWidth(), this.getShareRenderHeight(), R.color.zm_share_text, 1.0f)) != null) {
                this.mGLImageWaterMark.setBackground(bmpWaterMark);
                this.mWaterMarkWidth = this.getShareRenderWidth();
                this.mWaterMarkHeight = this.getShareRenderHeight();
            }
        } else {
            this.mGLImageWaterMark.setVisible(false);
        }
    }

    private RendererUnitInfo createGLImageWaterMarkUnitInfo() {
        return new RendererUnitInfo(this.getLeft(), this.getTop(), this.getShareRenderWidth(), this.getShareRenderHeight());
    }

    @Override
    public void onClick(GLButton button) {
        this.setVideoExpand(!this.mIsVideoExpand);
    }

    private void setVideoExpand(boolean expand) {
        if (this.mIsVideoExpand == expand) {
            return;
        }
        this.mIsVideoExpand = expand;
        if (!this.mIsVideoExpand) {
            this.destroyUnitActiveVideo();
        } else {
            this.createUnitActiveVideo();
            this.updateExpandVideoButton();
            this.onUpdateUnits();
            this.checkShowVideo();
        }
    }

    private void updateSwitchScenePanel() {
        if (this.isVideoPaused()) {
            return;
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        LinearLayout panelSwitchSceneButtons = (LinearLayout)activity.findViewById(R.id.panelSwitchSceneButtons);
        this.mSwitchSceneButtons = new ImageButton[10];
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int sceneCount = sceneMgr.getSceneCount();
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        panelSwitchSceneButtons.removeAllViews();
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            this.mSwitchSceneButtons[i] = new ImageButton((Context)activity);
            this.mSwitchSceneButtons[i].setBackgroundColor(0);
            this.mSwitchSceneButtons[i].setImageResource(i == basicSceneCount - 1 ? R.drawable.zm_btn_switch_scene_selected : R.drawable.zm_btn_switch_scene_unselected);
            this.mSwitchSceneButtons[i].setVisibility(i < sceneCount ? 0 : 8);
            this.mSwitchSceneButtons[i].setOnClickListener((View.OnClickListener)this);
            this.mSwitchSceneButtons[i].setContentDescription((CharSequence)(i == basicSceneCount - 1 ? this.getConfActivity().getString(R.string.zm_description_scene_share) : ((VideoSceneMgr)this.getVideoSceneMgr()).getAccessibliltyDescriptionSceneSwitch(i)));
            panelSwitchSceneButtons.addView((View)this.mSwitchSceneButtons[i], UIUtil.dip2px((Context)activity, (float)20.0f), UIUtil.dip2px((Context)activity, (float)40.0f));
        }
        this.positionSwitchScenePanel();
        panelSwitchScene.setVisibility(sceneCount <= 1 ? 4 : 0);
    }

    private void positionSwitchScenePanel() {
        int top = this.getHeight() - UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (UIUtil.isPortraitMode((Context)this.getConfActivity())) {
            top -= UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        panelSwitchScene.setPadding(0, top, 0, 0);
        panelSwitchScene.getParent().requestLayout();
        panelSwitchScene.setVisibility(this.isLargeShareVideoMode() ? 4 : 0);
    }

    public void onClick(View v) {
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            if (this.mSwitchSceneButtons[i] != v) continue;
            this.switchToScene(i);
        }
    }

    private void switchToScene(int i) {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        if (i == basicSceneCount - 1) {
            return;
        }
        ((VideoSceneMgr)this.getVideoSceneMgr()).switchToScene(i);
    }

    @Override
    public void cacheUnits() {
        if (this.mUnitShare == null) {
            return;
        }
        this.removeUnit(this.mUnitShare);
        RendererUnitInfo unitInfo = new RendererUnitInfo(-this.mUnitShare.getWidth(), this.mUnitShare.getTop(), this.mUnitShare.getWidth(), this.mUnitShare.getHeight());
        this.mUnitShare.updateUnitInfo(unitInfo);
        this.mCachedUnitShare = this.mUnitShare;
        this.mCachedShareSize = this.mShareSize;
        this.mUnitShare = null;
        this.mShareSize = null;
    }

    @Override
    public void destroyCachedUnits() {
        if (this.mCachedUnitShare != null) {
            this.mCachedUnitShare.onDestroy();
            this.mCachedUnitShare = null;
            this.mCachedShareSize = null;
            this.mHasCachedData = false;
            this.mShareSize = null;
        }
    }

    @Override
    public void onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
        }
    }

    public void hideTitleAndSwitchScenePanel() {
        View panelSwitchScene;
        View panelSharingTitle = this.getConfActivity().findViewById(R.id.panelSharingTitle);
        if (null != panelSharingTitle) {
            panelSharingTitle.setVisibility(8);
        }
        if (null != (panelSwitchScene = this.getConfActivity().findViewById(R.id.panelSwitchScene))) {
            panelSwitchScene.setVisibility(8);
        }
    }

    public boolean isInRemoteControlMode() {
        return this.mInRemoteControlMode;
    }

    public void setInRemoteControlMode(boolean mInRemoteControlMode) {
        this.mInRemoteControlMode = mInRemoteControlMode;
    }

    public boolean remoteControlSingleTap(float viewX, float viewY) {
        float contentX = this.viewToShareContentX(viewX);
        float cotnentY = this.viewToShareContentY(viewY);
        this.mRCMouseX = contentX;
        this.mRCMouseY = cotnentY;
        if (this.mShareSession != null) {
            return this.mShareSession.remoteControlSingleTap(contentX, cotnentY);
        }
        return false;
    }

    public boolean remoteControlDoubleTap(float viewX, float viewY) {
        float contentX = this.viewToShareContentX(viewX);
        float cotnentY = this.viewToShareContentY(viewY);
        this.mRCMouseX = contentX;
        this.mRCMouseY = cotnentY;
        if (this.mShareSession != null) {
            return this.mShareSession.remoteControlDoubleTap(contentX, cotnentY);
        }
        return false;
    }

    public boolean remoteControlLongPress(float viewX, float viewY) {
        float contentX = this.viewToShareContentX(viewX);
        float cotnentY = this.viewToShareContentY(viewY);
        this.mRCMouseX = contentX;
        this.mRCMouseY = cotnentY;
        if (this.mShareSession != null) {
            return this.mShareSession.remoteControlLongPress(contentX, cotnentY);
        }
        return false;
    }

    public boolean remoteControlDoubleScroll(float x, float y) {
        if (this.mShareSession != null) {
            return this.mShareSession.remoteControlDoubleScroll(x, y);
        }
        return false;
    }

    public boolean remoteControlSingleMove(float viewX, float viewY) {
        float contentX = this.viewToShareContentX(viewX);
        float cotnentY = this.viewToShareContentY(viewY);
        this.mRCMouseX = contentX;
        this.mRCMouseY = cotnentY;
        if (this.mShareSession != null) {
            return this.mShareSession.remoteControlSingleMove(contentX, cotnentY);
        }
        return false;
    }

    public boolean remoteControlCharInput(String str) {
        return this.mShareSession.remoteControlCharInput(str);
    }

    public boolean remoteControlKeyInput(int keyType) {
        return this.mShareSession.remoteControlKeyInput(keyType);
    }

    public int getShareRenderHeight() {
        return this.getHeight();
    }

    public int getShareRenderWidth() {
        return this.getWidth();
    }

    public boolean isNoVideoTileOnShareScreenEnabled() {
        return PreferenceUtil.readBooleanValue("no_video_tile_on_share_screen", false);
    }

    public boolean isLargeShareVideoMode() {
        return false;
    }
}

