/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zipow.videobox.ConfActivityNormal;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.ShareVideoScene;

public class RCMouseView
extends ImageView {
    private float mClickXRelativeToRCFloatView;
    private float mClickYRelativeToRCFloatView;
    private AbsVideoSceneMgr mAbsVideoSceneMgr;
    private ConfActivityNormal mActivity;
    private long mPrevMouseDragTime;
    private Handler mHandler;

    public RCMouseView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    public RCMouseView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public RCMouseView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public RCMouseView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mActivity = (ConfActivityNormal)context;
        this.mHandler = new Handler();
    }

    public void moveMouse(float rawX, float rawY) {
        View parent = (View)this.getParent();
        if (parent == null) {
            return;
        }
        int[] location = new int[2];
        parent.getLocationOnScreen(location);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
        params.leftMargin = (int)rawX - location[0];
        params.topMargin = (int)rawY - location[1];
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void moveRCMouse() {
        if (this.mActivity != null) {
            AbsVideoScene activeScene;
            this.mAbsVideoSceneMgr = this.mActivity.getVideoSceneMgr();
            if (this.mAbsVideoSceneMgr != null && (activeScene = this.mAbsVideoSceneMgr.getActiveScene()) != null && activeScene instanceof ShareVideoScene) {
                ShareVideoScene shareScene = (ShareVideoScene)activeScene;
                if (!shareScene.isStarted() || !shareScene.isInRemoteControlMode()) {
                    return;
                }
                float x = this.getLeft();
                float y = this.getTop();
                shareScene.remoteControlSingleMove(x, y);
            }
        }
    }

    public void showRCMouse(boolean show) {
        if (show) {
            int width = this.mActivity.getVideoSceneMgr().getActiveScene().getWidth();
            int height = this.mActivity.getVideoSceneMgr().getActiveScene().getHeight();
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
            params.topMargin = height / 2;
            params.leftMargin = width / 2;
            this.setLayoutParams((ViewGroup.LayoutParams)params);
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    private boolean correctPostion(int x, int y) {
        FrameLayout.LayoutParams params;
        int widthSpec;
        int heightSpec = widthSpec = View.MeasureSpec.makeMeasureSpec((int)Integer.MAX_VALUE, (int)Integer.MIN_VALUE);
        this.measure(widthSpec, heightSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        View parent = (View)this.getParent();
        if (parent == null) {
            return false;
        }
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x + width > parentWidth) {
            x = parentWidth - width;
        }
        if (y + height > parentHeight) {
            y = parentHeight - height;
        }
        if ((params = (FrameLayout.LayoutParams)this.getLayoutParams()) == null) {
            return false;
        }
        if (params.topMargin != y || params.leftMargin != x) {
            params.topMargin = y;
            params.leftMargin = x;
            this.setLayoutParams((ViewGroup.LayoutParams)params);
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 0) {
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            this.mClickXRelativeToRCFloatView = event.getRawX() - (float)location[0];
            this.mClickYRelativeToRCFloatView = event.getRawY() - (float)location[1];
        } else if (event.getActionMasked() == 2) {
            int x = (int)(event.getRawX() - this.mClickXRelativeToRCFloatView);
            int y = (int)(event.getRawY() - this.mClickYRelativeToRCFloatView);
            boolean postionChanged = this.correctPostion(x, y);
            long currentTime = System.currentTimeMillis();
            if (postionChanged && currentTime - this.mPrevMouseDragTime > 200L) {
                this.mPrevMouseDragTime = currentTime;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RCMouseView.this.moveRCMouse();
                    }
                }, 200L);
            }
        } else if (event.getActionMasked() == 1) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    RCMouseView.this.moveRCMouse();
                }
            }, 200L);
        }
        return true;
    }
}

