/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.GLImage;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.VideoSceneMgr;
import java.util.List;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class NormalVideoScene
extends AbsVideoScene
implements View.OnClickListener,
HeadsetUtil.IHeadsetConnectionListener {
    public static final int MAX_SWITCH_SCENE_BUTTONS = 10;
    private static final int INDEX_ACCESSIBILITY_VIEW_ACTIVEVIDEO = 0;
    private static final int INDEX_ACCESSIBILITY_VIEW_PREVIEW = 1;
    private static final String TAG = NormalVideoScene.class.getSimpleName();
    private VideoUnit mUnitActiveVideo;
    private VideoUnit mUnitPreview;
    private VideoSize mActiveVideoSize;
    private boolean mIsExchangedMode = false;
    private boolean mCanStartPreview = true;
    private int mUserCount = 1;
    private ImageButton[] mSwitchSceneButtons;
    private GLImage mGLImageWaterMark;
    private int mWaterMarkWidth = 0;
    private int mWaterMarkHeight = 0;

    public NormalVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
    }

    @Override
    public long getPreviewRenderInfo() {
        VideoUnit unit = this.getMyVideoUnit();
        if (unit != null) {
            return unit.getRendererInfo();
        }
        return 0L;
    }

    @Override
    public void onActiveVideoChanged(long userId) {
        if (this.isVideoPaused()) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        String userName = "";
        if (user != null) {
            userName = user.getScreenName();
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                NormalVideoScene.this.checkShowActiveVideo();
            }
        });
    }

    @Override
    public void onConfReady() {
        this.checkUpdateVideoUnitsForViewOnlyMeeting();
        this.updateAccessibilitySceneDescription();
        this.getVideoSceneMgr().announceAccessibilityAtActiveScene();
    }

    private void checkUpdateVideoUnitsForViewOnlyMeeting() {
        if (ConfLocalHelper.isViewOnlyButNotSpeakAttendee()) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr != null && videoMgr.isPreviewing() && this.mUnitActiveVideo != null) {
                videoMgr.stopPreviewDevice(this.mUnitActiveVideo.getRendererInfo());
            }
            this.removePreviewUnit();
        }
    }

    private void removePreviewUnit() {
        if (this.mUnitPreview == null) {
            return;
        }
        this.mUnitPreview.removeUser();
        this.mUnitPreview.onDestroy();
        this.removeUnit(this.mUnitPreview);
        this.mUnitPreview = null;
        this.onUpdateUnits();
    }

    @Override
    public void onUserVideoStatus(final long userId) {
        super.onUserVideoStatus(userId);
        if (this.isPreloadStatus()) {
            return;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                NormalVideoScene.this.checkUpdateUserVideo(userId);
            }
        });
    }

    @Override
    public void onUserVideoDataSizeChanged(final long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                NormalVideoScene.this.checkUpdateUserVideo(userId);
            }
        });
    }

    @Override
    public void onUserVideoQualityChanged(long userId) {
        if (this.mUnitActiveVideo != null && this.mUnitActiveVideo.getCanShowNetworkStatus()) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return;
            }
            if (videoMgr.isSameVideo(this.mUnitActiveVideo.getUser(), userId)) {
                this.mUnitActiveVideo.onNetworkStatusChanged();
            }
        }
    }

    @Override
    public void onUserAudioStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            this.updateUserAudioStatus(userId);
        } else {
            this.updateUserAudioStatus(userId);
        }
    }

    @Override
    public void onAudioTypeChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            this.updateUserAudioStatus(userId);
        }
    }

    private void updateUserAudioStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnitActiveVideo != null) {
            long activeUserId = this.mUnitActiveVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
            if (user != null) {
                activeUserId = user.getNodeId();
            }
            if (activeUserId != 0L && confStatus.isSameUser(userId, activeUserId)) {
                this.mUnitActiveVideo.onUserAudioStatus();
            }
        }
        if (this.mUnitPreview != null && this.mUnitPreview.getUser() != 0L && confStatus.isSameUser(userId, this.mUnitPreview.getUser())) {
            this.mUnitPreview.onUserAudioStatus();
        }
    }

    @Override
    public void onUserPicReady(long userId) {
        this.updateUserPic(userId);
    }

    private void updateUserPic(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnitActiveVideo != null) {
            long activeUserId = this.mUnitActiveVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
            if (user != null) {
                activeUserId = user.getNodeId();
            }
            if (activeUserId != 0L && confStatus.isSameUser(userId, activeUserId)) {
                this.mUnitActiveVideo.updateAvatar();
            }
        }
        if (this.mUnitPreview != null && this.mUnitPreview.getUser() != 0L && confStatus.isSameUser(userId, this.mUnitPreview.getUser())) {
            this.mUnitPreview.updateAvatar();
        }
    }

    @Override
    public void onAutoStartVideo() {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                NormalVideoScene.this.showMyVideo();
            }
        });
        this.updateSwitchScenePanel();
    }

    @Override
    public void onConfOne2One() {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                NormalVideoScene.this.startOne2One();
            }
        });
    }

    @Override
    public void onMyVideoStatusChanged() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (videoMgr.isPreviewing()) {
            return;
        }
        if (this.mUserCount == 1) {
            this.mActiveVideoSize = this.getMyVideoSize();
        }
        this.showMyVideo();
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        if (this.isPreloadStatus()) {
            return;
        }
        this.mUserCount = ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount();
        switch (eventType) {
            case 0: {
                if (this.mUserCount == 2) {
                    this.updateUnits();
                }
                this.updateSwitchScenePanel();
                break;
            }
            case 1: {
                if (this.mUserCount < 2) {
                    if (this.mIsExchangedMode) {
                        this.exchangeVideoUnits();
                    }
                    this.mActiveVideoSize = this.getMyVideoSize();
                    this.updateContentSubscription();
                } else if (this.mUserCount == 2) {
                    this.updateContentSubscription();
                }
                this.updateSwitchScenePanel();
                break;
            }
            case 2: {
                this.updateContentSubscription();
            }
        }
    }

    @Override
    public void onLaunchConfParamReady() {
        this.updateContentSubscription();
    }

    @Override
    public void onConfVideoSendingStatusChanged() {
        if (ConfMgr.getInstance().noOneIsSendingVideo() && this.mIsExchangedMode) {
            boolean isVideoMeeting;
            CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
            if (confContext == null) {
                return;
            }
            boolean bl = isVideoMeeting = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting();
            if (!isVideoMeeting) {
                this.exchangeVideoUnits();
                return;
            }
        }
        this.updateContentSubscription();
    }

    @Override
    public void beforeSwitchCamera() {
        VideoUnit unit = this.getMyVideoUnit();
        if (unit != null) {
            unit.stopVideo(false);
        }
    }

    @Override
    public void afterSwitchCamera() {
        VideoUnit unit = this.getMyVideoUnit();
        if (unit != null) {
            unit.startVideo();
        }
    }

    @Override
    protected void onStart() {
        CmmUser user;
        this.mUserCount = ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount();
        if (this.mUserCount < 1) {
            this.mUserCount = 1;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                if (NormalVideoScene.this.mUserCount < 2) {
                    if (NormalVideoScene.this.mIsExchangedMode) {
                        NormalVideoScene.this.exchangeVideoUnits();
                    }
                    NormalVideoScene.this.mActiveVideoSize = NormalVideoScene.this.getMyVideoSize();
                }
                NormalVideoScene.this.updateContentSubscription();
            }
        });
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
        }
        if ((user = ConfMgr.getInstance().getMyself()) != null) {
            this.updateUserAudioStatus(user.getNodeId());
        }
        HeadsetUtil.getInstance().addListener((HeadsetUtil.IHeadsetConnectionListener)this);
    }

    @Override
    public void updateContentSubscription() {
        if (!this.isPreloadStatus()) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr != null && videoMgr.isPreviewing()) {
                return;
            }
            this.showMyVideo();
            this.checkShowActiveVideo();
        }
    }

    @Override
    protected void onResumeVideo() {
        this.updateContentSubscription();
        this.updateSwitchScenePanel();
        this.removeFadeView();
    }

    @Override
    protected void onStop() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (this.hasUnit(this.mUnitActiveVideo)) {
            this.mUnitActiveVideo.removeUser();
        }
        if (this.hasUnit(this.mUnitPreview)) {
            this.mUnitPreview.removeUser();
        }
        HeadsetUtil.getInstance().removeListener((HeadsetUtil.IHeadsetConnectionListener)this);
    }

    @Override
    protected void onCreateUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (!this.mIsExchangedMode) {
            this.createActiveVideoUnit(videoMgr);
            if (!ConfMgr.getInstance().isViewOnlyMeeting()) {
                this.createPreviewVideoUnit(videoMgr);
            }
        } else {
            this.createPreviewVideoUnit(videoMgr);
            this.createActiveVideoUnit(videoMgr);
        }
        this.createSwitchCameraButton(videoMgr);
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
            this.updateAccessibilitySceneDescription();
            this.getVideoSceneMgr().announceAccessibilityAtActiveScene();
        }
        this.createGLImageWaterMark();
    }

    @Override
    public void updateAccessibilitySceneDescription() {
        if (!ConfMgr.getInstance().isConfConnected()) {
            this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_connecting));
            return;
        }
        if (this.getConfActivity() != null) {
            if (this.getConfActivity().isToolbarShowing()) {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_normal_toolbar_showed));
            } else {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_normal_toolbar_hided));
            }
        }
    }

    @Override
    public Rect getBoundsForAccessbilityViewIndex(int index) {
        switch (index) {
            case 0: {
                if (this.mUnitActiveVideo == null) break;
                return new Rect(this.mUnitActiveVideo.getLeft(), this.mUnitActiveVideo.getTop(), this.mUnitActiveVideo.getRight(), this.mUnitActiveVideo.getBottom());
            }
            case 1: {
                if (this.mUnitPreview == null) break;
                return new Rect(this.mUnitPreview.getLeft(), this.mUnitPreview.getTop(), this.mUnitPreview.getRight(), this.mUnitPreview.getBottom());
            }
        }
        return new Rect();
    }

    @Override
    public int getAccessbilityViewIndexAt(float x, float y) {
        if (this.mUnitActiveVideo != null && this.mUnitActiveVideo.isPointInUnit(x, y)) {
            return 0;
        }
        if (this.mUnitPreview != null && this.mUnitPreview.isPointInUnit(x, y)) {
            return 1;
        }
        return -1;
    }

    @Override
    public CharSequence getAccessibilityDescriptionForIndex(int index) {
        StringBuilder builder = new StringBuilder();
        switch (index) {
            case 0: {
                CmmUser user;
                if (this.mUnitActiveVideo == null || (user = ConfMgr.getInstance().getUserById(this.mUnitActiveVideo.getUser())) == null) break;
                String name = user.getScreenName();
                builder.append(name);
                break;
            }
            case 1: {
                CmmUser user;
                if (this.mUnitPreview == null || (user = ConfMgr.getInstance().getUserById(this.mUnitPreview.getUser())) == null) break;
                String name = user.getScreenName();
                builder.append(name);
            }
        }
        return builder.toString();
    }

    @Override
    public void getAccessibilityVisibleVirtualViews(List<Integer> virtualViewIds) {
        if (this.mUnitActiveVideo != null) {
            virtualViewIds.add(0);
        }
        if (this.mUnitPreview != null) {
            virtualViewIds.add(1);
        }
    }

    private void createSwitchCameraButton(VideoSessionMgr videoMgr) {
    }

    private void createPreviewVideoUnit(VideoSessionMgr videoMgr) {
        RendererUnitInfo unitInfo = this.createPreviewVideoUnitInfo();
        if (unitInfo != null) {
            this.mUnitPreview = videoMgr.createVideoUnit(false, unitInfo);
            if (this.mUnitPreview != null) {
                this.mUnitPreview.setUnitName("MyPreview");
                this.mUnitPreview.setVideoScene(this);
                this.mUnitPreview.setUserNameVisible(this.isShowUserName(this.mIsExchangedMode), false);
                this.mUnitPreview.setBorderVisible(false);
                this.mUnitPreview.setBackgroundColor(this.mUserCount > 1 && !this.mIsExchangedMode ? -16777216 : 0);
                this.mUnitPreview.setCanShowAudioOff(!this.mIsExchangedMode || this.mUnitPreview.isUserNameVisible());
                this.mUnitPreview.setCanShowWaterMark(this.mIsExchangedMode && this.isShowWaterMarkIfCan());
                videoMgr.setAspectMode(this.mUnitPreview.getRendererInfo(), 3);
                this.addUnit(this.mUnitPreview);
                this.mUnitPreview.onCreate();
            }
        }
    }

    private void createActiveVideoUnit(VideoSessionMgr videoMgr) {
        long activeUserId = this.getVideoSceneMgr().getActiveUserId();
        RendererUnitInfo unitInfo = this.createActiveVideoUnitInfo(activeUserId > 0L);
        if (unitInfo != null) {
            this.mUnitActiveVideo = videoMgr.createVideoUnit(false, unitInfo);
            if (this.mUnitActiveVideo != null) {
                this.mUnitActiveVideo.setUnitName("ActiveVideo");
                this.mUnitActiveVideo.setVideoScene(this);
                boolean bShowUserName = this.isShowUserName(!this.mIsExchangedMode);
                boolean bShowNetworkStatus = bShowUserName && this.mUserCount > 1;
                this.mUnitActiveVideo.setUserNameVisible(bShowUserName, bShowNetworkStatus);
                this.mUnitActiveVideo.setBorderVisible(false);
                this.mUnitActiveVideo.setBackgroundColor(this.mIsExchangedMode ? -16777216 : 0);
                this.mUnitActiveVideo.setCanShowAudioOff(this.mIsExchangedMode || this.mUnitActiveVideo.isUserNameVisible());
                this.mUnitActiveVideo.setCanShowWaterMark(!this.mIsExchangedMode && this.isShowWaterMarkIfCan());
                videoMgr.setAspectMode(this.mUnitActiveVideo.getRendererInfo(), 3);
                this.addUnit(this.mUnitActiveVideo);
                this.mUnitActiveVideo.onCreate();
            }
        }
    }

    @Override
    protected void onUpdateUnits() {
        RendererUnitInfo unitInfo;
        long activeUserId;
        RendererUnitInfo unitInfo2;
        if (this.mUnitActiveVideo != null && (unitInfo2 = this.createActiveVideoUnitInfo((activeUserId = this.getVideoSceneMgr().getActiveUserId()) > 0L)) != null) {
            this.mUnitActiveVideo.updateUnitInfo(unitInfo2);
            this.mUnitActiveVideo.setCanShowWaterMark(!this.mIsExchangedMode && this.isShowWaterMarkIfCan());
            boolean bShowUserName = this.isShowUserName(!this.mIsExchangedMode);
            boolean bShowNetworkStatus = this.isShowUserName(bShowUserName) && this.mUserCount > 1;
            this.mUnitActiveVideo.setUserNameVisible(bShowUserName, bShowNetworkStatus);
            this.mUnitActiveVideo.setCanShowAudioOff(this.mIsExchangedMode || this.mUnitActiveVideo.isUserNameVisible());
        }
        if (this.mUnitPreview != null && (unitInfo = this.createPreviewVideoUnitInfo()) != null) {
            this.mUnitPreview.updateUnitInfo(unitInfo);
            this.mUnitPreview.setCanShowWaterMark(this.mIsExchangedMode && this.isShowWaterMarkIfCan());
            boolean bShowNetworkStatus = false;
            this.mUnitPreview.setUserNameVisible(this.isShowUserName(this.mIsExchangedMode), false);
            this.mUnitPreview.setCanShowAudioOff(!this.mIsExchangedMode || this.mUnitPreview.isUserNameVisible());
        }
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
            this.updateAccessibilitySceneDescription();
        }
        this.updateGLImageWaterMark();
    }

    @Override
    protected void onDestroyUnits() {
        this.mUnitActiveVideo = null;
        this.mUnitPreview = null;
        this.mGLImageWaterMark = null;
        this.mWaterMarkWidth = 0;
        this.mWaterMarkHeight = 0;
    }

    @Override
    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        if (!ConfMgr.getInstance().isConfConnected()) {
            return false;
        }
        if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() < 2) {
            return false;
        }
        if (this.isInSmallVideoRect(e)) {
            this.exchangeVideoUnits();
            return true;
        }
        return false;
    }

    private boolean isOtherSharing() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return false;
        }
        return shareMgr.getShareStatus() == 3;
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr != null && videoMgr.isManualMode() && sceneMgr.unPinVideo() && !ConfMgr.getInstance().isViewOnlyMeeting()) {
            if (this.isOtherSharing()) {
                this.pauseVideo();
            }
            this.showUnPinVideoAnimation();
            Toast toast = Toast.makeText((Context)this.getConfActivity(), (int)R.string.zm_msg_doubletap_leave_pinvideo, (int)3000);
            toast.setGravity(17, 0, 0);
            toast.show();
        }
    }

    private void showUnPinVideoAnimation() {
        ConfActivity activity = this.getConfActivity();
        final ImageView fadeViewLeft = (ImageView)activity.findViewById(R.id.fadeview);
        final ImageView fadeViewRight = (ImageView)activity.findViewById(R.id.fadeview1);
        ScaleAnimation fadeLeftAnim = new ScaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 1, 0.0f, 1, 0.5f);
        ScaleAnimation fadeRightAnim = new ScaleAnimation(0.0f, 1.0f, 1.0f, 1.0f, 1, 1.0f, 1, 0.5f);
        fadeLeftAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation arg0) {
                fadeViewLeft.setVisibility(8);
                fadeViewRight.setVisibility(8);
            }

            public void onAnimationRepeat(Animation arg0) {
            }

            public void onAnimationStart(Animation arg0) {
            }
        });
        fadeLeftAnim.setDuration(1000L);
        fadeRightAnim.setDuration(1000L);
        fadeLeftAnim.setRepeatCount(1);
        fadeRightAnim.setRepeatCount(1);
        fadeLeftAnim.setRepeatMode(2);
        fadeRightAnim.setRepeatMode(2);
        fadeViewLeft.setVisibility(0);
        fadeViewRight.setVisibility(0);
        fadeViewLeft.startAnimation((Animation)fadeLeftAnim);
        fadeViewRight.startAnimation((Animation)fadeRightAnim);
    }

    @Override
    public void onMyVideoRotationChanged(int action) {
        VideoSessionMgr videoMgr;
        long activeUserId = this.getVideoSceneMgr().getActiveUserId();
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isSameUser(activeUserId, myself.getNodeId())) {
            this.mActiveVideoSize = ConfMgr.getInstance().getVideoObj().getMyVideoSize();
        }
        if ((videoMgr = ConfMgr.getInstance().getVideoObj()) != null && videoMgr.isPreviewing() && this.mUnitActiveVideo != null) {
            videoMgr.rotateDevice(action, this.mUnitActiveVideo.getRendererInfo());
        }
        this.updateUnits();
    }

    @Override
    public void onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
            VideoUnit videoUnit = this.getActiveVideoUnit();
            if (videoUnit != null && videoUnit.getType() == 1) {
                videoUnit.setNetworkRestrictionMode(isNetworkRestrictionMode, true);
            }
        }
    }

    private boolean isInSmallVideoRect(MotionEvent e) {
        VideoUnit targetUnit = this.mUnitPreview;
        if (this.mIsExchangedMode) {
            targetUnit = this.mUnitActiveVideo;
        }
        if (targetUnit == null) {
            return false;
        }
        if (targetUnit.getUser() <= 0L) {
            return false;
        }
        float x = e.getX();
        float y = e.getY();
        return x > (float)targetUnit.getLeft() && x < (float)(targetUnit.getLeft() + targetUnit.getWidth()) && y > (float)targetUnit.getTop() && y < (float)(targetUnit.getTop() + targetUnit.getHeight());
    }

    private void exchangeVideoUnits() {
        this.mUserCount = ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount();
        this.setExchangedMode(!this.mIsExchangedMode);
    }

    private void showMyVideo() {
        if (!this.isCreated()) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (ConfMgr.getInstance().isConfConnected()) {
            RendererUnitInfo unitInfo;
            VideoUnit unit = this.getMyVideoUnit();
            if (unit == null) {
                return;
            }
            int unitType = 0;
            if (unit == this.mUnitActiveVideo) {
                unitInfo = this.createBigPreviewVideoUnitInfo();
                this.mUnitActiveVideo.updateUnitInfo(unitInfo);
                if (!this.mIsExchangedMode) {
                    unitType = 1;
                }
                if (this.mUnitPreview != null) {
                    this.mUnitPreview.stopVideo(true);
                    this.mUnitPreview.removeUser();
                    this.mUnitPreview.setBorderVisible(false);
                    this.mUnitPreview.setBackgroundColor(0);
                }
            } else {
                unitInfo = this.mIsExchangedMode ? this.createBigPreviewVideoUnitInfo() : this.createPreviewVideoUnitInfo();
                unit.updateUnitInfo(unitInfo);
                if (this.mIsExchangedMode) {
                    unitType = 1;
                }
            }
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmUserList userList = confMgr.getUserList();
            if (userList == null) {
                return;
            }
            CmmUser user = userList.getMyself();
            if (user == null) {
                return;
            }
            CmmConfContext confContext = confMgr.getConfContext();
            if (confContext == null) {
                return;
            }
            boolean isVideoMeeting = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting();
            boolean noOneIsSendingVideo = confMgr.noOneIsSendingVideo();
            if (!isVideoMeeting && noOneIsSendingVideo && this.mUserCount >= 2) {
                unit.stopVideo(true);
                unit.removeUser();
                unit.setBorderVisible(false);
                unit.setBackgroundColor(0);
            } else {
                unit.setType(unitType);
                unit.setUser(user.getNodeId());
                unit.setBorderVisible(unit == this.mUnitPreview && !this.mIsExchangedMode);
                unit.setBackgroundColor(unit == this.mUnitPreview && !this.mIsExchangedMode ? -16777216 : 0);
                unit.setCanShowWaterMark((unit == this.mUnitPreview && this.mIsExchangedMode || unit == this.mUnitActiveVideo && !this.mIsExchangedMode) && this.isShowWaterMarkIfCan());
                boolean bShowUserName = (unit == this.mUnitPreview && this.mIsExchangedMode || unit == this.mUnitActiveVideo && !this.mIsExchangedMode) && !this.getConfActivity().isToolbarShowing() && !ConfMgr.getInstance().isCallingOut();
                unit.setUserNameVisible(bShowUserName, false);
                unit.setCanShowAudioOff(unit.isUserNameVisible() || unit == this.mUnitPreview && !this.mIsExchangedMode);
            }
        } else {
            if (this.mUnitActiveVideo == null) {
                return;
            }
            if (videoMgr.isPreviewing()) {
                return;
            }
            this.mUnitActiveVideo.setCanShowWaterMark(false);
            this.mUnitActiveVideo.setUserNameVisible(false, false);
            if (!VideoBoxApplication.getInstance().isSDKMode()) {
                if (ConfUI.getInstance().isLaunchConfParamReady() && ConfMgr.getInstance().needPreviewVideoWhenStartMeeting() && ConfMgr.getInstance().getConfStatus() != 0 && ConfMgr.getInstance().getConfStatus() != 14) {
                    this.mUnitActiveVideo.startPreview(videoMgr.getDefaultCameraToUse());
                }
            } else if (this.mCanStartPreview && ConfUI.getInstance().isLaunchConfParamReady()) {
                boolean isJoinVideoOn;
                CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
                if (confContext == null) {
                    return;
                }
                boolean isStartVideoOn = ConfMgr.getInstance().needPreviewVideoWhenStartMeeting() && confContext.getLaunchReason() == 1;
                boolean bl = isJoinVideoOn = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting() && !confContext.isDirectShareClient() && confContext.isVideoOn();
                if (isStartVideoOn || isJoinVideoOn) {
                    this.mUnitActiveVideo.startPreview(videoMgr.getDefaultCameraToUse());
                }
            }
            RendererUnitInfo unitInfo = this.createBigPreviewVideoUnitInfo();
            this.mUnitActiveVideo.updateUnitInfo(unitInfo);
        }
    }

    private VideoUnit getMyVideoUnit() {
        VideoUnit unit = ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() >= 2 ? this.mUnitPreview : this.mUnitActiveVideo;
        return unit;
    }

    private VideoUnit getActiveVideoUnit() {
        VideoUnit unit = ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() >= 2 ? this.mUnitActiveVideo : null;
        return unit;
    }

    private void checkShowActiveVideo() {
        if (!this.isCreated()) {
            return;
        }
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        int userCount = ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount();
        long activeUserId = 0L;
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            if (this.getVideoSceneMgr().getActiveUserId() == 0L) {
                return;
            }
            activeUserId = 1L;
        } else {
            CmmUser user;
            activeUserId = this.getVideoSceneMgr().getActiveUserId();
            if (userCount == 1) {
                return;
            }
            if (userCount == 2 && (user = userList.getPeerUser(false, true)) != null) {
                activeUserId = user.getNodeId();
            }
        }
        boolean isNetworkRestrictionMode = this.getVideoSceneMgr().isNetworkRestrictionMode();
        if (activeUserId > 0L) {
            if (this.mUnitActiveVideo != null) {
                VideoSize size = this.getUserVideoSize(activeUserId);
                if (this.mActiveVideoSize == null || !this.mActiveVideoSize.similarTo(size)) {
                    this.mActiveVideoSize = size;
                    RendererUnitInfo unitInfo = this.createActiveVideoUnitInfo(true);
                    if (unitInfo != null) {
                        this.mUnitActiveVideo.updateUnitInfo(unitInfo);
                    }
                } else {
                    this.mActiveVideoSize = size;
                }
                if (!this.mIsExchangedMode) {
                    this.mUnitActiveVideo.setNetworkRestrictionMode(isNetworkRestrictionMode, false);
                    this.mUnitActiveVideo.setType(1);
                    this.mUnitActiveVideo.setIsFloating(false);
                } else {
                    this.mUnitActiveVideo.setType(0);
                    this.mUnitActiveVideo.setIsFloating(true);
                }
                VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                if (userCount == 2) {
                    this.mUnitActiveVideo.setUser(activeUserId);
                } else if (videoMgr != null && videoMgr.isManualMode()) {
                    this.mUnitActiveVideo.setUser(videoMgr.getSelectedUser());
                } else {
                    this.mUnitActiveVideo.setUser(1L);
                }
                this.mUnitActiveVideo.setBorderVisible(this.mIsExchangedMode);
                this.mUnitActiveVideo.setBackgroundColor(this.mIsExchangedMode ? -16777216 : 0);
                this.mUnitActiveVideo.setCanShowWaterMark(!this.mIsExchangedMode && this.isShowWaterMarkIfCan());
                boolean bShowUserName = this.isShowUserName(!this.mIsExchangedMode);
                boolean bShowNetworkStatus = bShowUserName && this.mUserCount > 1;
                this.mUnitActiveVideo.setUserNameVisible(bShowUserName, bShowNetworkStatus);
                this.mUnitActiveVideo.setCanShowAudioOff(this.mIsExchangedMode || this.mUnitActiveVideo.isUserNameVisible());
            }
            if (this.mUnitPreview != null) {
                VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
                if (videoMgr == null) {
                    return;
                }
                VideoUnit myVideoUnit = this.getMyVideoUnit();
                if (myVideoUnit == this.mUnitPreview) {
                    ConfMgr confMgr = ConfMgr.getInstance();
                    CmmConfContext confContext = confMgr.getConfContext();
                    if (confContext == null) {
                        return;
                    }
                    boolean isVideoMeeting = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting();
                    boolean noOneIsSendingVideo = confMgr.noOneIsSendingVideo();
                    if (!isVideoMeeting && noOneIsSendingVideo && userCount >= 2) {
                        myVideoUnit.stopVideo(true);
                        myVideoUnit.removeUser();
                        myVideoUnit.setBorderVisible(false);
                        myVideoUnit.setBackgroundColor(0);
                    } else {
                        CmmUser user = userList.getMyself();
                        if (user == null) {
                            return;
                        }
                        if (!this.mIsExchangedMode) {
                            myVideoUnit.setType(0);
                        } else {
                            myVideoUnit.setType(1);
                        }
                        myVideoUnit.setUser(user.getNodeId());
                        myVideoUnit.setBorderVisible(myVideoUnit == this.mUnitPreview && !this.mIsExchangedMode);
                        myVideoUnit.setBackgroundColor(myVideoUnit == this.mUnitPreview && !this.mIsExchangedMode ? -16777216 : 0);
                        myVideoUnit.setCanShowWaterMark(this.mIsExchangedMode && this.isShowWaterMarkIfCan());
                        myVideoUnit.setUserNameVisible(this.isShowUserName(this.mIsExchangedMode));
                        myVideoUnit.setCanShowAudioOff(!this.mIsExchangedMode || myVideoUnit.isUserNameVisible());
                    }
                } else {
                    this.mUnitPreview.stopVideo(true);
                    this.mUnitPreview.removeUser();
                    this.mUnitPreview.setBorderVisible(false);
                    this.mUnitPreview.setBackgroundColor(0);
                }
            }
        }
    }

    private void startOne2One() {
        if (!this.isCreated()) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        VideoSessionMgr videoMgr = confMgr.getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmUserList userList = confMgr.getUserList();
        if (userList == null) {
            return;
        }
        if (this.mUnitActiveVideo == null || this.mUnitPreview == null) {
            return;
        }
        if (ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount() > 1) {
            CmmUser peerUser = userList.getPeerUser(false, true);
            if (peerUser == null) {
                return;
            }
            long nodeId = peerUser.getNodeId();
            this.getVideoSceneMgr().setActiveUserId(nodeId);
            VideoSize size = this.getUserVideoSize(nodeId);
            if (this.mActiveVideoSize == null || !this.mActiveVideoSize.similarTo(size)) {
                this.mActiveVideoSize = size;
                RendererUnitInfo unitInfo = this.createActiveVideoUnitInfo(true);
                if (unitInfo != null) {
                    this.mUnitActiveVideo.updateUnitInfo(unitInfo);
                }
            } else {
                this.mActiveVideoSize = size;
            }
            CmmConfContext confContext = confMgr.getConfContext();
            if (confContext == null) {
                return;
            }
            boolean isVideoMeeting = !confContext.isAudioOnlyMeeting() && !confContext.isShareOnlyMeeting();
            boolean noOneIsSendingVideo = confMgr.noOneIsSendingVideo();
            this.mUnitActiveVideo.setType(1);
            this.mUnitActiveVideo.setUser(nodeId);
            this.mUnitActiveVideo.setBorderVisible(this.mIsExchangedMode && (isVideoMeeting || !noOneIsSendingVideo));
            this.mUnitActiveVideo.setBackgroundColor(this.mIsExchangedMode ? -16777216 : 0);
            CmmUser user = userList.getMyself();
            if (user == null) {
                return;
            }
            this.mUnitPreview.setType(0);
            this.mUnitPreview.setUser(user.getNodeId());
            this.mUnitPreview.setBorderVisible(!this.mIsExchangedMode && (isVideoMeeting || !noOneIsSendingVideo));
            this.mUnitPreview.setBackgroundColor(!this.mIsExchangedMode ? -16777216 : 0);
        }
    }

    private void checkUpdateUserVideo(long userId) {
        if (!this.isCreated()) {
            return;
        }
        if (this.mUnitActiveVideo == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        long activeUserId = 0L;
        if (ConfMgr.getInstance().isViewOnlyMeeting()) {
            activeUserId = 1L;
        } else {
            activeUserId = this.getVideoSceneMgr().getActiveUserId();
            CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
            if (user != null) {
                activeUserId = user.getNodeId();
            }
        }
        if (ConfLocalHelper.isViewOnlyButNotSpeakAttendee() || confStatus.isSameUser(userId, activeUserId)) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return;
            }
            if (activeUserId > 0L) {
                VideoSize size = this.getUserVideoSize(activeUserId);
                if (this.mActiveVideoSize == null || !this.mActiveVideoSize.similarTo(size)) {
                    this.mActiveVideoSize = size;
                    RendererUnitInfo unitInfo = this.createActiveVideoUnitInfo(true);
                    if (unitInfo != null) {
                        this.mUnitActiveVideo.updateUnitInfo(unitInfo);
                    }
                } else {
                    this.mActiveVideoSize = size;
                }
                if (!this.mIsExchangedMode) {
                    this.mUnitActiveVideo.setType(1);
                } else {
                    this.mUnitActiveVideo.setType(0);
                }
                if (ConfLocalHelper.getClientWithoutOnHoldExcludeAttendeeUserCount() <= 2) {
                    this.mUnitActiveVideo.setUser(activeUserId);
                } else if (videoMgr.isManualMode()) {
                    this.mUnitActiveVideo.setUser(videoMgr.getSelectedUser());
                } else {
                    this.mUnitActiveVideo.setUser(1L);
                }
                this.mUnitActiveVideo.setCanShowWaterMark(!this.mIsExchangedMode && this.isShowWaterMarkIfCan());
                boolean bShowUserName = this.isShowUserName(!this.mIsExchangedMode);
                boolean bShowNetworkStatus = ConfLocalHelper.getClientWithoutOnHoldIncludeAttendeeUserCount() >= 2 && bShowUserName;
                this.mUnitActiveVideo.setUserNameVisible(bShowUserName, bShowNetworkStatus);
                this.mUnitActiveVideo.setCanShowAudioOff(this.mIsExchangedMode || this.mUnitActiveVideo.isUserNameVisible());
            }
        }
        this.updateSwitchScenePanel();
        this.updateGLImageWaterMark();
    }

    private RendererUnitInfo createActiveVideoUnitInfo(boolean hasActiveUser) {
        if (!(this.mIsExchangedMode && hasActiveUser && ConfMgr.getInstance().isConfConnected())) {
            RendererUnitInfo unitInfo = ConfMgr.getInstance().isConfConnected() && hasActiveUser ? this.createBigVideoUnitInfo(this.mActiveVideoSize) : this.createBigPreviewVideoUnitInfo();
            return unitInfo;
        }
        VideoSize sizeUnit = null;
        if (this.mActiveVideoSize != null) {
            sizeUnit = this.getPreviewSize(this.mActiveVideoSize);
        }
        RendererUnitInfo unitInfo = this.createSmallVideoUnitInfo(sizeUnit);
        return unitInfo;
    }

    private RendererUnitInfo createBigVideoUnitInfo(VideoSize size) {
        int h;
        int w;
        int l;
        int t;
        float rRender;
        int videoWidth = 0;
        int videoHeight = 0;
        if (size == null || size.width == 0 && size.height == 0) {
            videoWidth = 16;
            videoHeight = 9;
        } else {
            videoWidth = size.width;
            videoHeight = size.height;
        }
        if (videoWidth == 0 || videoHeight == 0) {
            return null;
        }
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        boolean previewTop = false;
        int previewLeft = 0;
        float rVideo = videoWidth > videoHeight ? (float)videoWidth / (float)videoHeight : (float)videoHeight / (float)videoWidth;
        float f = rRender = videoWidth > videoHeight ? (float)renderWidth / (float)renderHeight : (float)renderHeight / (float)renderWidth;
        if ((double)Math.abs(rVideo - rRender) < 0.45) {
            t = 0;
            l = 0;
            w = renderWidth;
            h = renderHeight;
        } else if (renderWidth * videoHeight > renderHeight * videoWidth) {
            t = 0;
            h = renderHeight;
            w = h * videoWidth / videoHeight;
            l = (renderWidth - w) / 2;
            if (previewLeft > 0 && l + w > previewLeft && (l = previewLeft - w) < 0) {
                l = 0;
            }
        } else {
            l = 0;
            w = renderWidth;
            h = w * videoHeight / videoWidth;
            t = (renderHeight - h) / 2;
        }
        return new RendererUnitInfo(this.getLeft() + l, this.getTop() + t, w, h);
    }

    private RendererUnitInfo createBigPreviewVideoUnitInfo() {
        VideoSize size = this.getMyVideoSize();
        return this.createBigVideoUnitInfo(size);
    }

    private VideoSize getMyVideoSize() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return new VideoSize(100, 100);
        }
        VideoSize size = videoMgr.isVideoStarted() || videoMgr.isPreviewing() ? videoMgr.getMyVideoSize() : new VideoSize(100, 100);
        return size;
    }

    private VideoSize getPreviewSize() {
        VideoSize size = this.getMyVideoSize();
        if (size.width == 0 && size.height == 0) {
            size = UIMgr.isLargeMode((Context)this.getConfActivity()) ? new VideoSize(16, 9) : new VideoSize(4, 3);
        }
        return this.getPreviewSize(size);
    }

    private VideoSize getPreviewSize(VideoSize videoSize) {
        int widthPreview = 0;
        int heightPreview = 0;
        if (videoSize == null || videoSize.width == 0 && videoSize.height == 0) {
            return new VideoSize(4, 3);
        }
        int landscapeWidth = Math.max(UIUtil.getDisplayWidth((Context)this.getConfActivity()), UIUtil.getDisplayHeight((Context)this.getConfActivity())) / 8;
        int portraitWidth = Math.min(UIUtil.getDisplayWidth((Context)this.getConfActivity()), UIUtil.getDisplayHeight((Context)this.getConfActivity())) / 8;
        if (videoSize.width > videoSize.height) {
            int minWidth = UIUtil.dip2px((Context)this.getConfActivity(), (float)80.0f);
            widthPreview = Math.max(landscapeWidth, minWidth);
        } else {
            int minWidth = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            widthPreview = Math.max(portraitWidth, minWidth);
        }
        heightPreview = widthPreview * videoSize.height / videoSize.width;
        return new VideoSize(widthPreview, heightPreview);
    }

    private RendererUnitInfo createPreviewVideoUnitInfo() {
        RendererUnitInfo unitInfo = null;
        unitInfo = !this.mIsExchangedMode ? this.createSmallVideoUnitInfo(this.getPreviewSize()) : this.createBigVideoUnitInfo(this.getPreviewSize());
        return unitInfo;
    }

    private RendererUnitInfo createSmallVideoUnitInfo(VideoSize sizeUnit) {
        if (sizeUnit == null || sizeUnit.width == 0 || sizeUnit.height == 0) {
            sizeUnit = this.getPreviewSize(new VideoSize(16, 9));
        }
        int widthPreview = sizeUnit.width;
        int heightPreview = sizeUnit.height;
        int marginPreview = UIUtil.dip2px((Context)this.getConfActivity(), (float)5.0f);
        int leftPreview = this.getWidth() - marginPreview - widthPreview;
        int topPreview = this.getHeight() - heightPreview - marginPreview;
        int toolbarHeight = this.getConfActivity().getToolbarHeight();
        if (toolbarHeight > 0) {
            topPreview -= toolbarHeight;
        }
        return new RendererUnitInfo(this.getLeft() + leftPreview, this.getTop() + topPreview, widthPreview, heightPreview);
    }

    private void removeFadeView() {
        ConfActivity activity = this.getConfActivity();
        ImageView fadeView = (ImageView)activity.findViewById(R.id.fadeview);
        fadeView.setVisibility(8);
    }

    private void updateSwitchScenePanel() {
        if (this.isVideoPaused()) {
            return;
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        LinearLayout panelSwitchSceneButtons = (LinearLayout)activity.findViewById(R.id.panelSwitchSceneButtons);
        if (ConfMgr.getInstance().isCallingOut()) {
            panelSwitchScene.setVisibility(8);
            return;
        }
        this.mSwitchSceneButtons = new ImageButton[10];
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int sceneCount = sceneMgr.getSceneCount();
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        panelSwitchSceneButtons.removeAllViews();
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            this.mSwitchSceneButtons[i] = new ImageButton((Context)activity);
            this.mSwitchSceneButtons[i].setBackgroundColor(0);
            this.mSwitchSceneButtons[i].setImageResource(i == basicSceneCount - 1 ? R.drawable.zm_btn_switch_scene_selected : R.drawable.zm_btn_switch_scene_unselected);
            this.mSwitchSceneButtons[i].setVisibility(i < sceneCount ? 0 : 8);
            this.mSwitchSceneButtons[i].setOnClickListener((View.OnClickListener)this);
            this.mSwitchSceneButtons[i].setContentDescription((CharSequence)(i == basicSceneCount - 1 ? this.getConfActivity().getString(R.string.zm_description_scene_normal) : ((VideoSceneMgr)this.getVideoSceneMgr()).getAccessibliltyDescriptionSceneSwitch(i)));
            panelSwitchSceneButtons.addView((View)this.mSwitchSceneButtons[i], UIUtil.dip2px((Context)activity, (float)20.0f), UIUtil.dip2px((Context)activity, (float)40.0f));
        }
        this.positionSwitchScenePanel();
        panelSwitchScene.setVisibility(sceneCount <= 1 ? 4 : 0);
    }

    private void positionSwitchScenePanel() {
        ConfActivity activity;
        View panelSwitchScene;
        int top = this.getHeight() - UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (UIUtil.isPortraitMode((Context)this.getConfActivity())) {
            top -= UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        }
        if ((panelSwitchScene = (activity = this.getConfActivity()).findViewById(R.id.panelSwitchScene)).getPaddingTop() != top) {
            panelSwitchScene.setPadding(0, top, 0, 0);
            panelSwitchScene.getParent().requestLayout();
        }
    }

    public void onClick(View v) {
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            if (this.mSwitchSceneButtons[i] != v) continue;
            this.switchToScene(i);
        }
    }

    private void switchToScene(int i) {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        if (i == basicSceneCount - 1) {
            return;
        }
        ((VideoSceneMgr)this.getVideoSceneMgr()).switchToScene(i);
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
    }

    public void onBluetoothScoAudioStatus(boolean on) {
    }

    public boolean isExchangedMode() {
        return this.mIsExchangedMode;
    }

    public void setExchangedMode(boolean isExchangedMode) {
        if (this.mIsExchangedMode == isExchangedMode) {
            return;
        }
        this.mIsExchangedMode = isExchangedMode;
        if (this.isPreloadStatus()) {
            this.destroy(true);
        } else if (this.isVisible()) {
            this.stop();
            int width = this.getWidth();
            int height = this.getHeight();
            this.destroy(true);
            this.create(width, height);
            this.start();
        }
    }

    private boolean isShowWaterMarkIfCan() {
        return VideoBoxApplication.getInstance().isSDKMode() || this.getConfActivity().isToolbarShowing();
    }

    private boolean isShowUserName(boolean exchangeModeflag) {
        return exchangeModeflag && !this.getConfActivity().isToolbarShowing() && !ConfMgr.getInstance().isCallingOut();
    }

    private RendererUnitInfo createGLImageWaterMarkUnitInfo() {
        return new RendererUnitInfo(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
    }

    private void createGLImageWaterMark() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null && confContext.isSupportConfidentialWaterMarker()) {
            RendererUnitInfo unitInfo = this.createGLImageWaterMarkUnitInfo();
            this.mGLImageWaterMark = videoMgr.createGLImage(unitInfo);
            if (this.mGLImageWaterMark != null) {
                this.mGLImageWaterMark.setUnitName("mGLImageWaterMark");
                this.mGLImageWaterMark.setVideoScene(this);
                this.addUnit(this.mGLImageWaterMark);
                this.mGLImageWaterMark.onCreate();
                this.mGLImageWaterMark.setVisible(false);
            }
        }
    }

    private void updateGLImageWaterMark() {
        VideoUnit activevideoUnit;
        if (this.mGLImageWaterMark == null) {
            this.createGLImageWaterMark();
        }
        if (this.mGLImageWaterMark == null) {
            return;
        }
        RendererUnitInfo unitInfo = this.createGLImageWaterMarkUnitInfo();
        VideoUnit videoUnit = activevideoUnit = this.mIsExchangedMode ? this.mUnitPreview : this.mUnitActiveVideo;
        if (activevideoUnit != null && activevideoUnit.getmVideoType() == 2 && activevideoUnit.isVideoShowing()) {
            Bitmap bmpWaterMark;
            this.mGLImageWaterMark.updateUnitInfo(unitInfo);
            this.mGLImageWaterMark.setVisible(true);
            if ((this.mWaterMarkWidth != this.getWidth() || this.mWaterMarkHeight != this.getHeight()) && (bmpWaterMark = ConfLocalHelper.createWaterMarkBitmap(this.getWidth(), this.getHeight(), R.color.zm_video_text, 1.0f)) != null) {
                this.mGLImageWaterMark.setBackground(bmpWaterMark);
                this.mWaterMarkWidth = this.getWidth();
                this.mWaterMarkHeight = this.getHeight();
            }
        } else {
            this.mGLImageWaterMark.setVisible(false);
            this.mWaterMarkWidth = 0;
            this.mWaterMarkHeight = 0;
        }
    }

    public void setCanStartPreview(boolean enable) {
        this.mCanStartPreview = enable;
    }
}

