/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import android.widget.TextView;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmShareStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.ShareUnit;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.confapp.meeting.confhelper.CameraComponent;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ConfShareLocalHelper;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.VideoRenderer;
import java.util.ArrayList;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class LargeVideoScene
extends AbsVideoScene
implements GLButton.OnClickListener {
    private final String TAG = LargeVideoScene.class.getSimpleName();
    private static int MAX_GALLERY_ITEMS_COUNT = 4;
    private static final int GALLERY_UNIT_MARGIN_DIP = 20;
    private static final int MAX_SCALE_LEVEL_COUNT = 3;
    private static final int MAX_VELOCITY_IN_DIP = 1500;
    private VideoUnit mUnitBigVideo;
    private ShareUnit mUnitShare;
    private VideoUnit mUnitSmallSingleVideo;
    private ArrayList<VideoUnit> mListGalleryUnits = new ArrayList();
    private GLButton mGLBtnExpandVideo;
    private GLButton mGLBtnExpandGallery;
    private GLButton mGLBtnCloseGallery;
    private GLButton mGLBtnSwitchCamera;
    private VideoSize mActiveVideoSize;
    private VideoSize mShareSize;
    private double mZoomVal = 0.0;
    private float mContentX = 0.0f;
    private float mContentY = 0.0f;
    private float mScaleWidth = 0.0f;
    private float mScaleHeight = 0.0f;
    private boolean mIsNotWaiting_UnitShare = false;
    private Scroller mScroller;
    private Handler mFlingHandler = new Handler();
    private boolean mStopFling_UnitShare = false;
    private boolean mHasCachedData = false;
    private boolean mIsFitScreen = true;
    private boolean mIsVideoExpand = true;
    private boolean mIsVideoGalleryExpand = false;
    private int mCountUsers = 1;
    private int mGalleryScrollPos = 0;
    private boolean mIsScrollingGallery = false;
    private boolean mIsExchangedMode = false;
    private float mLastX1;
    private float mLastY1;
    private float mLastX2;
    private float mLastY2;
    private boolean mIsMultiTouchZooming = false;
    private Drawable mDrawableGalleryExpand = null;
    private Drawable mDrawableGalleryCollapse = null;

    public LargeVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
        DecelerateInterpolator interpolator = new DecelerateInterpolator(1.0f);
        this.mScroller = new Scroller((Context)VideoBoxApplication.getInstance(), (Interpolator)interpolator);
        if (!UIUtil.isLargeScreen((Context)VideoBoxApplication.getInstance()) && MAX_GALLERY_ITEMS_COUNT > 3) {
            MAX_GALLERY_ITEMS_COUNT = 3;
        }
    }

    @Override
    public long getPreviewRenderInfo() {
        if (this.mUnitBigVideo != null) {
            return this.mUnitBigVideo.getRendererInfo();
        }
        return 0L;
    }

    public boolean hasContent() {
        return this.mHasCachedData;
    }

    @Override
    protected void onCreateUnits() {
        this.createUnitShare();
        this.createUnitBigVideo();
        this.createSmallSingleVideoUnit();
        this.createGalleryUnits();
        this.createExpandVideoButton();
        this.createExpandGalleryButton();
        this.createCloseGalleryButton();
        this.createSwitchCameraButton();
    }

    private void createUnitBigVideo() {
        if (this.mUnitBigVideo != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        long activeUserId = this.getVideoSceneMgr().getActiveUserId();
        RendererUnitInfo unitInfo = this.createBigVideoUnitInfo(activeUserId > 0L);
        if (unitInfo != null) {
            this.mUnitBigVideo = videoMgr.createVideoUnit(false, unitInfo);
            if (this.mUnitBigVideo != null) {
                this.mUnitBigVideo.setUnitName("BigVideo");
                this.mUnitBigVideo.setVideoScene(this);
                this.mUnitBigVideo.setBorderVisible(false);
                this.mUnitBigVideo.setBackgroundColor(0);
                this.mUnitBigVideo.setUserNameVisible(false);
                this.mUnitBigVideo.setCanShowAudioOff(true);
                this.mUnitBigVideo.setCanShowWaterMark(true);
                this.addUnit(this.mUnitBigVideo);
                this.mUnitBigVideo.onCreate();
            }
        }
    }

    private void createSmallSingleVideoUnit() {
        if (this.mUnitSmallSingleVideo != null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        RendererUnitInfo unitInfo = this.createSmallSingleVideoUnitInfo();
        if (unitInfo != null) {
            this.mUnitSmallSingleVideo = videoMgr.createVideoUnit(false, unitInfo);
            if (this.mUnitSmallSingleVideo != null) {
                this.mUnitSmallSingleVideo.setUnitName("SmallSingleVideo");
                this.mUnitSmallSingleVideo.setVideoScene(this);
                this.mUnitSmallSingleVideo.setBorderVisible(false);
                this.mUnitSmallSingleVideo.setBackgroundColor(0);
                this.mUnitSmallSingleVideo.setUserNameVisible(true);
                this.mUnitSmallSingleVideo.setCanShowAudioOff(true);
                this.addUnit(this.mUnitSmallSingleVideo);
                this.mUnitSmallSingleVideo.onCreate();
            }
        }
    }

    private RendererUnitInfo createSmallSingleVideoUnitInfo() {
        VideoSize unitSize = null;
        if (this.getVideoSceneMgr().isViewingSharing()) {
            if (this.mActiveVideoSize == null || this.mActiveVideoSize.width == 0 || this.mActiveVideoSize.height == 0) {
                this.mActiveVideoSize = new VideoSize(16, 9);
            }
            unitSize = this.calcSmallSingleVideoUnitSize(this.mActiveVideoSize);
        } else {
            unitSize = this.calcSmallSingleVideoUnitSize(this.getMyVideoSize());
        }
        RendererUnitInfo unitInfo = this.createSmallSingleVideoUnitInfo(unitSize);
        return unitInfo;
    }

    private void createUnitShare() {
        if (this.mUnitShare != null) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        RendererUnitInfo shareUnitInfo = this.createShareUnitInfo();
        if (shareUnitInfo != null) {
            this.mUnitShare = shareMgr.createShareUnit(shareUnitInfo);
            if (this.mUnitShare != null) {
                this.mUnitShare.setVideoScene(this);
                this.addUnit(this.mUnitShare);
                this.mUnitShare.onCreate();
            }
        }
    }

    private void createGalleryUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        for (int i = 0; i <= MAX_GALLERY_ITEMS_COUNT; ++i) {
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            VideoUnit unit = videoMgr.createVideoUnit(false, unitInfo);
            if (unit == null) continue;
            this.mListGalleryUnits.add(unit);
            unit.setUnitName("GalleryUnit");
            unit.setVideoScene(this);
            unit.setBorderVisible(false);
            unit.setBackgroundColor(0);
            unit.setUserNameVisible(true);
            unit.setCanShowAudioOff(true);
            this.addUnit(unit);
            unit.onCreate();
        }
    }

    private void updateGalleryUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        for (int i = 0; i <= MAX_GALLERY_ITEMS_COUNT; ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            if (unit == null) continue;
            unit.updateUnitInfo(unitInfo);
        }
    }

    private RendererUnitInfo createGalleryUnitInfo(int index) {
        int sceneWidth = this.getWidth();
        int unitMargin = this.getGalleryUnitMargin();
        int unitWidth = this.getGalleryUnitWidth();
        int unitHeight = unitWidth * 9 / 16;
        int x = 0;
        int y = 0;
        int posFirstUnit = 0;
        posFirstUnit = this.mCountUsers <= MAX_GALLERY_ITEMS_COUNT ? (sceneWidth - this.mCountUsers * (unitWidth + unitMargin) - unitMargin) / 2 + unitMargin - this.mGalleryScrollPos : (this.mGalleryScrollPos < 0 ? -this.mGalleryScrollPos + unitMargin : unitMargin - this.mGalleryScrollPos % (unitWidth + unitMargin));
        x = posFirstUnit + index * (unitWidth + unitMargin);
        y = this.getHeight() - unitHeight - UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        if (index == MAX_GALLERY_ITEMS_COUNT && Math.abs(this.getWidth() - x) < 3) {
            x = this.getWidth();
        }
        return new RendererUnitInfo(x, y, unitWidth, unitHeight);
    }

    private int getGalleryUnitMargin() {
        return UIUtil.dip2px((Context)this.getConfActivity(), (float)20.0f);
    }

    private int getGalleryUnitWidth() {
        return (this.getWidth() - this.getGalleryUnitMargin() * (MAX_GALLERY_ITEMS_COUNT + 1)) / MAX_GALLERY_ITEMS_COUNT;
    }

    @Override
    protected void onUpdateUnits() {
        if (this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            PointF center = this.getCenterPixelPosOnContent();
            this.updateUnitsWithoutResetDestArea();
            if (center == null) {
                return;
            }
            this.resetDestAreaCenter(center.x, center.y);
        }
        this.updateUnitBigVideo();
        this.updateUnitSmallSingleVideo();
        this.updateExpandVideoButton();
        this.updateExpandGalleryButton();
        this.updateCloseGalleryButton();
        this.updateSwitchCameraButton();
        this.updateGalleryUnits();
    }

    private void updateUnitsWithoutResetDestArea() {
        this.updateUnitShare();
    }

    private void updateUnitBigVideo() {
        if (this.mUnitBigVideo != null) {
            long activeUserId = 0L;
            long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
            activeUserId = lockedUserId > 0L ? lockedUserId : this.getVideoSceneMgr().getActiveUserId();
            RendererUnitInfo unitInfo = this.createBigVideoUnitInfo(activeUserId > 0L);
            if (unitInfo != null) {
                this.mUnitBigVideo.updateUnitInfo(unitInfo);
            }
        }
    }

    private void updateUnitSmallSingleVideo() {
        RendererUnitInfo unitInfo;
        if (this.mUnitSmallSingleVideo != null && (unitInfo = this.createSmallSingleVideoUnitInfo()) != null) {
            this.mUnitSmallSingleVideo.updateUnitInfo(unitInfo);
        }
    }

    private void updateUnitShare() {
        RendererUnitInfo unitInfo;
        if (this.mUnitShare != null && (unitInfo = this.createShareUnitInfo()) != null) {
            this.mUnitShare.updateUnitInfo(unitInfo);
        }
    }

    @Override
    protected void onDestroyUnits() {
        this.mUnitBigVideo = null;
        this.mUnitSmallSingleVideo = null;
        this.mUnitShare = null;
        this.mHasCachedData = false;
        this.mListGalleryUnits.clear();
    }

    @Override
    protected void onStart() {
        this.mCountUsers = ConfLocalHelper.getTotalVideoCount();
        if (this.mCountUsers < 1) {
            this.mCountUsers = 1;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.updateContentSubscription();
            }
        });
    }

    @Override
    public void updateContentSubscription() {
        if (!this.isPreloadStatus()) {
            this.checkShowVideo();
            this.checkShowShare();
        }
    }

    @Override
    protected void onStop() {
        if (this.mUnitShare != null) {
            this.mUnitShare.removeUser();
        }
        if (this.mUnitBigVideo != null) {
            this.mUnitBigVideo.removeUser();
        }
        this.mShareSize = null;
        this.showWaiting(false);
        this.updateSharingTitle(0L);
    }

    @Override
    protected void onResumeVideo() {
        if (!this.mHasCachedData) {
            this.showWaiting(true);
        }
        this.updateContentSubscription();
        this.updateSharingTitle(this.getVideoSceneMgr().getShareActiveUserId());
    }

    @Override
    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        if (this.hasGrantedUnits() && this.isCreated()) {
            this.stopAndDestroyAllGrantedUnits();
        }
        super.onGLRendererChanged(renderer, width, height);
        if (this.mIsMultiTouchZooming) {
            this.onMultiTouchZoomEnd();
        }
    }

    @Override
    public void onActiveVideoChanged(long userId) {
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        if (lockedUserId != 0L && !this.getVideoSceneMgr().isViewingSharing()) {
            return;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserActiveVideoForDeck(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserVideoStatus(long userId) {
        super.onUserVideoStatus(userId);
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserVideoDataSizeChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.checkShowVideo();
            }
        });
    }

    @Override
    public void onUserVideoQualityChanged(long userId) {
        if (this.mUnitBigVideo != null && this.mUnitBigVideo.getCanShowNetworkStatus()) {
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return;
            }
            if (videoMgr.isSameVideo(this.mUnitBigVideo.getUser(), userId)) {
                this.mUnitBigVideo.onNetworkStatusChanged();
            }
        }
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        int unitWidth;
        int marginGallery;
        this.mIsExchangedMode = false;
        if (eventType == 1) {
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus == null) {
                return;
            }
            long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
            if (confStatus.isSameUser(userId, lockedUserId)) {
                this.getVideoSceneMgr().setLockedUserId(0L);
            }
        } else if (eventType == 2) {
            this.updateContentSubscription();
        }
        this.mCountUsers = ConfLocalHelper.getTotalVideoCount();
        if (this.mCountUsers <= 2) {
            this.mIsVideoGalleryExpand = false;
        }
        if (this.mCountUsers <= MAX_GALLERY_ITEMS_COUNT) {
            this.mGalleryScrollPos = 0;
        }
        if (this.mGalleryScrollPos + ((marginGallery = this.getGalleryUnitMargin()) + (unitWidth = this.getGalleryUnitWidth())) * MAX_GALLERY_ITEMS_COUNT > this.mCountUsers * (marginGallery + unitWidth)) {
            this.mGalleryScrollPos = this.mCountUsers * (marginGallery + unitWidth) - (marginGallery + unitWidth) * MAX_GALLERY_ITEMS_COUNT;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                LargeVideoScene.this.checkShowVideo();
            }
        });
        if (this.mIsVideoGalleryExpand) {
            this.onScrollGalleryEnd();
        }
    }

    @Override
    public void onMyVideoStatusChanged() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.showSwitchCameraButton(videoMgr.isVideoStarted());
        this.checkShowVideo();
    }

    private void showSwitchCameraButton(boolean show) {
        if (!show) {
            if (this.mGLBtnSwitchCamera != null) {
                this.mGLBtnSwitchCamera.setVisible(false);
            }
        } else {
            if (this.mGLBtnSwitchCamera == null) {
                this.createSwitchCameraButton();
            }
            if (this.mGLBtnSwitchCamera != null) {
                this.mGLBtnSwitchCamera.setVisible(true);
            }
        }
    }

    @Override
    public void onUserAudioStatus(long userId) {
        this.updateUserAudioStatus(userId);
    }

    @Override
    public void onAudioTypeChanged(long userId) {
        this.updateUserAudioStatus(userId);
    }

    private void updateUserAudioStatus(long userId) {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        long bigVideoUserId = 0L;
        if (this.mUnitBigVideo != null) {
            bigVideoUserId = this.mUnitBigVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(bigVideoUserId);
            if (user != null) {
                bigVideoUserId = user.getNodeId();
            }
        }
        long smallVideoUserId = 0L;
        if (this.mUnitSmallSingleVideo != null) {
            smallVideoUserId = this.mUnitSmallSingleVideo.getUser();
            CmmUser user = ConfMgr.getInstance().getUserById(smallVideoUserId);
            if (user != null) {
                smallVideoUserId = user.getNodeId();
            }
        }
        if (bigVideoUserId != 0L && confStatus.isSameUser(userId, bigVideoUserId)) {
            this.mUnitBigVideo.onUserAudioStatus();
        } else if (smallVideoUserId != 0L && confStatus.isSameUser(userId, smallVideoUserId)) {
            this.mUnitSmallSingleVideo.onUserAudioStatus();
        } else {
            for (int i = 0; i < this.mListGalleryUnits.size(); ++i) {
                VideoUnit unit = this.mListGalleryUnits.get(i);
                if (unit == null || unit.getUser() == 0L || !confStatus.isSameUser(userId, unit.getUser())) continue;
                unit.onUserAudioStatus();
                break;
            }
        }
    }

    @Override
    public void onShareActiveUser(long userId) {
        if (userId != 0L) {
            this.getVideoSceneMgr().setLockedUserId(0L);
            this.mIsExchangedMode = false;
        }
        if (userId == 0L && this.mCountUsers <= 2) {
            this.mIsVideoGalleryExpand = false;
        }
        if (this.mUnitShare == null && userId != 0L) {
            this.runOnRendererInited(new Runnable(){

                @Override
                public void run() {
                    LargeVideoScene.this.createUnitShare();
                    LargeVideoScene.this.checkShowShare();
                    LargeVideoScene.this.checkShowVideo();
                }
            });
        } else {
            this.runOnRendererInited(new Runnable(){

                @Override
                public void run() {
                    LargeVideoScene.this.checkShowShare();
                    LargeVideoScene.this.checkShowVideo();
                }
            });
        }
        this.updateSharingTitle(0L);
        if (userId == 0L) {
            this.showWaiting(false);
        }
    }

    private void showWaiting(boolean show) {
        ConfActivity activity = this.getConfActivity();
        View panelWaitingShare = activity.findViewById(R.id.panelWaitingShare);
        TextView txtMsgWaitingShare = (TextView)panelWaitingShare.findViewById(R.id.txtMsgWaitingShare);
        if (show) {
            CmmUser user = ConfMgr.getInstance().getUserById(this.getVideoSceneMgr().getShareActiveUserId());
            if (user == null) {
                return;
            }
            String name = user.getScreenName();
            if (name.endsWith("s")) {
                txtMsgWaitingShare.setText((CharSequence)activity.getString(R.string.zm_msg_waiting_share_s, new Object[]{name}));
            } else {
                txtMsgWaitingShare.setText((CharSequence)activity.getString(R.string.zm_msg_waiting_share, new Object[]{name}));
            }
            panelWaitingShare.setVisibility(0);
            this.mIsNotWaiting_UnitShare = false;
        } else {
            panelWaitingShare.setVisibility(4);
            this.mIsNotWaiting_UnitShare = true;
        }
    }

    @Override
    public void onShareUserReceivingStatus(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        CmmShareStatus shareStatus = user.getShareStatusObj();
        if (shareStatus == null) {
            return;
        }
        if (shareStatus.getIsReceiving()) {
            this.mHasCachedData = true;
            this.showWaiting(false);
            this.stopAndDestroyAllGrantedUnits();
        } else if (!this.mHasCachedData) {
            this.showWaiting(true);
        }
        this.updateSharingTitle(this.getVideoSceneMgr().getShareActiveUserId());
    }

    @Override
    protected void onGrantedUnitsDestroyed() {
        this.checkShowVideo();
    }

    @Override
    public void onShareDataSizeChanged(long userId) {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        boolean bFirst = this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0;
        this.mShareSize = shareMgr.getShareDataResolution(userId);
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return;
        }
        this.showWaiting(false);
        if (bFirst || this.mIsFitScreen) {
            this.zoomToFitUnit();
        } else {
            int countLevels;
            int level = this.getCurrentScaleLevel();
            if (level >= (countLevels = this.getScaleLevelsCount())) {
                level = countLevels - 1;
                this.mZoomVal = this.scaleLevelToZoomValue(level);
            }
            this.mIsFitScreen = this.checkFitScreen();
            this.updateUnitsWithoutResetDestArea();
            this.trimContentPos();
            if (this.mIsFitScreen) {
                this.mScaleWidth = this.mUnitShare.getWidth();
                this.mScaleHeight = this.mUnitShare.getHeight();
            } else {
                this.mScaleWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
                this.mScaleHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            }
            this.notifyDestAreaChanged();
        }
    }

    @Override
    public void onLaunchConfParamReady() {
        this.updateContentSubscription();
    }

    @Override
    public void beforeSwitchCamera() {
        if (this.mUnitBigVideo == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        this.mUnitBigVideo.stopVideo(false);
    }

    @Override
    public void afterSwitchCamera() {
        if (this.mUnitBigVideo == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        this.mUnitBigVideo.startVideo();
    }

    private void checkShowVideo() {
        RendererUnitInfo unitInfo;
        VideoSize size;
        long timeStart = System.currentTimeMillis();
        if (!this.isCreated()) {
            return;
        }
        if (this.hasGrantedUnits()) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (userList == null) {
            return;
        }
        if (!ConfMgr.getInstance().isConfConnected()) {
            if (this.mUnitBigVideo == null) {
                return;
            }
            if (videoMgr.isPreviewing()) {
                return;
            }
            if (ConfUI.getInstance().isLaunchConfParamReady() && ConfMgr.getInstance().needPreviewVideoWhenStartMeeting() && ConfMgr.getInstance().getConfStatus() != 0 && ConfMgr.getInstance().getConfStatus() != 14) {
                this.mUnitBigVideo.startPreview(videoMgr.getDefaultCameraToUse());
            }
            RendererUnitInfo unitInfo2 = this.createBigVideoUnitInfo(false);
            this.mUnitBigVideo.updateUnitInfo(unitInfo2);
            return;
        }
        long activeUserId = 0L;
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        activeUserId = lockedUserId > 0L ? lockedUserId : this.getVideoSceneMgr().getActiveUserId();
        if (this.mCountUsers == 2) {
            if (!this.mIsExchangedMode) {
                CmmUser peerUser = userList.getPeerUser(false, true);
                if (peerUser != null) {
                    activeUserId = peerUser.getNodeId();
                }
            } else {
                activeUserId = userList.getMyself().getNodeId();
            }
        }
        if (this.getVideoSceneMgr().isViewingSharing()) {
            this.mUnitBigVideo.stopVideo(true);
            this.mUnitBigVideo.removeUser();
            this.mUnitBigVideo.setBorderVisible(false);
            this.mUnitBigVideo.setBackgroundColor(0);
            this.mUnitBigVideo.setUserNameVisible(false, false);
            this.mUnitBigVideo.setCanShowAudioOff(false);
        } else if (activeUserId > 0L) {
            size = this.getUserVideoSize(activeUserId);
            if (size == null || size.width == 0 || size.height == 0) {
                size = this.getMyVideoSize();
            }
            if (this.mActiveVideoSize == null || !size.similarTo(new VideoSize(this.mUnitBigVideo.getWidth(), this.mUnitBigVideo.getHeight()))) {
                this.mActiveVideoSize = size;
                unitInfo = this.createBigVideoUnitInfo(true);
                if (unitInfo != null) {
                    this.mUnitBigVideo.updateUnitInfo(unitInfo);
                }
            } else {
                this.mActiveVideoSize = size;
            }
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (confStatus == null) {
                return;
            }
            boolean isMySelf = confStatus.isMyself(activeUserId);
            this.mUnitBigVideo.setType(1);
            this.mUnitBigVideo.setUser(activeUserId);
            this.mUnitBigVideo.setBorderVisible(false);
            this.mUnitBigVideo.setBackgroundColor(-16777216);
            this.mUnitBigVideo.setUserNameVisible(true, !isMySelf);
            this.mUnitBigVideo.setCanShowAudioOff(true);
        } else if (videoMgr.isVideoStarted()) {
            CmmUser user = userList.getMyself();
            if (user == null) {
                return;
            }
            if (this.mUnitBigVideo.getUser() != user.getNodeId() && (unitInfo = this.createPreviewVideoUnitInfo()) != null) {
                this.mUnitBigVideo.updateUnitInfo(unitInfo);
            }
            this.mUnitBigVideo.setType(1);
            this.mUnitBigVideo.setUser(user.getNodeId());
            this.mUnitBigVideo.setBorderVisible(false);
            this.mUnitBigVideo.setBackgroundColor(-16777216);
            this.mUnitBigVideo.setUserNameVisible(true, false);
            this.mUnitBigVideo.setCanShowAudioOff(true);
        }
        this.checkUpdateGalleryUnitsVideo();
        if (!this.mIsVideoExpand || this.mIsVideoGalleryExpand || this.mCountUsers == 1) {
            this.mUnitSmallSingleVideo.stopVideo(true);
            this.mUnitSmallSingleVideo.removeUser();
            this.mUnitSmallSingleVideo.setBorderVisible(false);
            this.mUnitSmallSingleVideo.setBackgroundColor(0);
            this.mUnitSmallSingleVideo.setUserNameVisible(false);
            this.mUnitSmallSingleVideo.setCanShowAudioOff(false);
            this.updateExpandVideoButton();
            this.mGLBtnExpandVideo.setVisible(this.mCountUsers > 1 && !this.mIsVideoExpand && !this.mIsVideoGalleryExpand);
            this.updateExpandGalleryButton();
            this.mGLBtnExpandGallery.setVisible(this.mCountUsers > 1 && this.mIsVideoExpand);
            this.updateCloseGalleryButton();
            this.mGLBtnCloseGallery.setVisible(this.mCountUsers > 1 && this.mIsVideoExpand);
        } else {
            if (this.getVideoSceneMgr().isViewingSharing() && activeUserId > 0L) {
                size = this.getUserVideoSize(activeUserId);
                if (size == null || size.width == 0 || size.height == 0) {
                    size = this.getMyVideoSize();
                }
                if (this.mActiveVideoSize == null || !this.mActiveVideoSize.similarTo(size)) {
                    this.mActiveVideoSize = size;
                    unitInfo = this.createSmallSingleVideoUnitInfo(this.calcSmallSingleVideoUnitSize(this.mActiveVideoSize));
                    this.mUnitSmallSingleVideo.updateUnitInfo(unitInfo);
                } else {
                    this.mActiveVideoSize = size;
                }
                this.mUnitSmallSingleVideo.setType(0);
                this.mUnitSmallSingleVideo.setUser(activeUserId);
                this.mUnitSmallSingleVideo.setBorderVisible(true);
                this.mUnitSmallSingleVideo.setBackgroundColor(-16777216);
                this.mUnitSmallSingleVideo.setUserNameVisible(true);
                this.mUnitSmallSingleVideo.setCanShowAudioOff(true);
                this.updateExpandGalleryButton();
                this.updateCloseGalleryButton();
                this.updateExpandVideoButton();
                this.mGLBtnExpandGallery.setVisible(true);
                this.mGLBtnCloseGallery.setVisible(true);
                this.mGLBtnExpandVideo.setVisible(false);
            } else {
                long userId = 0L;
                if (!this.mIsExchangedMode) {
                    CmmUser user = userList.getMyself();
                    if (user == null) {
                        return;
                    }
                    if (this.mUnitSmallSingleVideo.getUser() != user.getNodeId()) {
                        RendererUnitInfo unitInfo3 = this.createSmallSingleVideoUnitInfo(this.calcSmallSingleVideoUnitSize(this.getMyVideoSize()));
                        this.mUnitSmallSingleVideo.updateUnitInfo(unitInfo3);
                    }
                    userId = user.getNodeId();
                } else {
                    CmmUser peerUser = userList.getPeerUser(false, true);
                    if (peerUser != null) {
                        userId = peerUser.getNodeId();
                    }
                    VideoSize size2 = this.getUserVideoSize(userId);
                    RendererUnitInfo unitInfo4 = this.createSmallSingleVideoUnitInfo(this.calcSmallSingleVideoUnitSize(size2));
                    this.mUnitSmallSingleVideo.updateUnitInfo(unitInfo4);
                }
                this.mUnitSmallSingleVideo.setType(0);
                this.mUnitSmallSingleVideo.setUser(userId);
                this.mUnitSmallSingleVideo.setBorderVisible(true);
                this.mUnitSmallSingleVideo.setBackgroundColor(-16777216);
                this.mUnitSmallSingleVideo.setUserNameVisible(true);
                this.mUnitSmallSingleVideo.setCanShowAudioOff(true);
                this.updateExpandGalleryButton();
                this.updateCloseGalleryButton();
                this.updateExpandVideoButton();
                this.mGLBtnExpandGallery.setVisible(this.mCountUsers > 2);
                this.mGLBtnCloseGallery.setVisible(true);
                this.mGLBtnExpandVideo.setVisible(false);
            }
            this.updateSwitchCameraButton();
        }
    }

    private void checkUpdateGalleryUnitsVideo() {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        int unitWidth = this.getGalleryUnitWidth();
        int unitMargin = this.getGalleryUnitMargin();
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        for (int i = 0; i <= MAX_GALLERY_ITEMS_COUNT; ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            RendererUnitInfo unitInfo = this.createGalleryUnitInfo(i);
            unit.updateUnitInfo(unitInfo);
            if (!this.mIsVideoGalleryExpand || i >= this.mCountUsers) {
                unit.stopVideo(true);
                unit.removeUser();
                unit.setBorderVisible(false);
                unit.setBackgroundColor(0);
                continue;
            }
            long userId = 0L;
            if (this.mGalleryScrollPos >= 0) {
                int userIndex = this.mGalleryScrollPos / (unitWidth + unitMargin) + i;
                userId = this.getGalleryUnitUserId(userIndex);
            } else {
                userId = this.getGalleryUnitUserId(i);
            }
            if (userId == 0L) {
                unit.stopVideo(true);
                unit.removeUser();
                unit.setBorderVisible(false);
                unit.setBackgroundColor(0);
                continue;
            }
            boolean stop = false;
            if (unitInfo.left < -unitInfo.width * 2 / 3 || unitInfo.left + unitInfo.width > this.getWidth() + unitInfo.width * 2 / 3) {
                stop = true;
            }
            if (stop) {
                unit.removeUser();
            } else {
                if (this.mIsScrollingGallery) {
                    unit.pause();
                } else {
                    unit.resume();
                }
                unit.setType(0);
                unit.setUser(userId);
                long activeUserId = this.getVideoSceneMgr().getActiveSpeakerId();
                CmmUser user = ConfMgr.getInstance().getUserById(activeUserId);
                if (user != null) {
                    activeUserId = user.getNodeId();
                }
                if (lockedUserId == 0L && confStatus.isSameUser(userId, activeUserId)) {
                    unit.setBorderType(1);
                } else if (userId == lockedUserId) {
                    unit.setBorderType(2);
                } else {
                    unit.setBorderType(0);
                }
            }
            unit.setBorderVisible(true);
            unit.setBackgroundColor(-16777216);
        }
    }

    private long getGalleryUnitUserId(int userIndex) {
        if (userIndex == 0) {
            return ConfMgr.getInstance().getMyself().getNodeId();
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        int idx = 1;
        CmmUserList userList = ConfMgr.getInstance().getUserList();
        if (confStatus == null || userList == null) {
            return 0L;
        }
        for (int i = 0; i < userList.getUserCount(); ++i) {
            CmmUser user = userList.getUserAt(i);
            if (user.isMMRUser() || confStatus.isMyself(user.getNodeId())) continue;
            if (idx == userIndex) {
                return user.getNodeId();
            }
            ++idx;
        }
        return 0L;
    }

    private void checkShowShare() {
        if (!this.isCreated()) {
            return;
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr == null) {
            return;
        }
        if (this.mUnitShare == null) {
            return;
        }
        long shareActiveUser = this.getVideoSceneMgr().getShareActiveUserId();
        if (shareActiveUser != 0L) {
            RendererUnitInfo unitInfo = this.createShareUnitInfo();
            if (unitInfo != null) {
                this.mUnitShare.updateUnitInfo(unitInfo);
            }
            long oldUser = this.mUnitShare.getUser();
            CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
            if (this.getLeft() == 0 && confStatus != null && !confStatus.isSameUser(oldUser, shareActiveUser)) {
                this.mHasCachedData = false;
                this.showWaiting(true);
            }
            this.mUnitShare.setUser(shareActiveUser);
            this.updateSharingTitle(shareActiveUser);
        } else {
            this.mUnitShare.removeUser();
            this.mUnitShare.clearRenderer();
        }
    }

    private void updateSharingTitle(long shareActiveUser) {
        View panelSharingTitle = this.getConfActivity().findViewById(R.id.panelSharingTitle);
        ConfShareLocalHelper.updateShareTitle((Context)this.getConfActivity(), shareActiveUser, panelSharingTitle);
        if (this.isStarted() && this.hasContent() && shareActiveUser > 0L) {
            panelSharingTitle.setVisibility(0);
        } else {
            panelSharingTitle.setVisibility(8);
        }
    }

    private RendererUnitInfo createBigVideoUnitInfo(boolean hasActiveUser) {
        if (hasActiveUser && this.mActiveVideoSize != null) {
            return this.createBigVideoUnitInfoForVideoSize(this.mActiveVideoSize);
        }
        return this.createPreviewVideoUnitInfo();
    }

    private VideoSize getMyVideoSize() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return new VideoSize(16, 9);
        }
        VideoSize size = videoMgr.getMyVideoSize();
        return size;
    }

    private VideoSize calcBigVideoUnitSize(VideoSize videoSize) {
        int height;
        int width;
        float rRender;
        int sceneWidth = this.getWidth();
        int sceneHeight = this.getHeight();
        int videoWidth = videoSize.width;
        int videoHeight = videoSize.height;
        float rVideo = videoWidth > videoHeight ? (float)videoWidth / (float)videoHeight : (float)videoHeight / (float)videoWidth;
        float f = rRender = videoWidth > videoHeight ? (float)sceneWidth / (float)sceneHeight : (float)sceneHeight / (float)sceneWidth;
        if ((double)Math.abs(rVideo - rRender) < 0.3) {
            width = sceneWidth;
            height = sceneHeight;
        } else if (videoSize.width * sceneHeight > sceneWidth * videoSize.height) {
            width = sceneWidth;
            height = width * videoSize.height / videoSize.width;
        } else {
            height = sceneHeight;
            width = height * videoSize.width / videoSize.height;
        }
        return new VideoSize(width, height);
    }

    private VideoSize calcSmallSingleVideoUnitSize(VideoSize videoSize) {
        int height16x9;
        int width = this.getGalleryUnitWidth();
        int height = width * videoSize.height / videoSize.width;
        if (height > (height16x9 = width * 9 / 16)) {
            height = height16x9;
            width = height * videoSize.width / videoSize.height;
        }
        return new VideoSize(width, height);
    }

    private RendererUnitInfo createPreviewVideoUnitInfo() {
        VideoSize unitSize = this.calcBigVideoUnitSize(this.getMyVideoSize());
        RendererUnitInfo unitInfo = this.createBigVideoUnitInfoForUnitSize(unitSize);
        return unitInfo;
    }

    private RendererUnitInfo createBigVideoUnitInfoForVideoSize(VideoSize activeVideoSize) {
        VideoSize unitSize = this.calcBigVideoUnitSize(activeVideoSize);
        return this.createBigVideoUnitInfoForUnitSize(unitSize);
    }

    private RendererUnitInfo createBigVideoUnitInfoForUnitSize(VideoSize unitSize) {
        int x = (this.getWidth() - unitSize.width) / 2;
        int y = (this.getHeight() - unitSize.height) / 2;
        return new RendererUnitInfo(this.getLeft() + x, this.getTop() + y, unitSize.width, unitSize.height);
    }

    private RendererUnitInfo createSmallSingleVideoUnitInfo(VideoSize unitSize) {
        int x = this.getWidth() - unitSize.width - UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        int y = this.getHeight() - unitSize.height - UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        return new RendererUnitInfo(this.getLeft() + x, this.getTop() + y, unitSize.width, unitSize.height);
    }

    private RendererUnitInfo createShareUnitInfo() {
        RendererUnitInfo unitInfo = null;
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            shareSize = new VideoSize(16, 9);
        }
        unitInfo = this.createShareUnitInfo(shareSize);
        return unitInfo;
    }

    private RendererUnitInfo createShareUnitInfo(VideoSize size) {
        int l;
        int w;
        int h;
        int t;
        int shareWidth = size.width;
        int shareHeight = size.height;
        if (shareWidth == 0 || shareHeight == 0) {
            return null;
        }
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        if (this.mIsFitScreen && Math.abs(this.mZoomVal - this.getMinLevelZoomValue()) < 0.01) {
            if (renderWidth * shareHeight > renderHeight * shareWidth) {
                t = 0;
                h = renderHeight;
                w = h * shareWidth / shareHeight;
                l = (renderWidth - w) / 2;
            } else {
                l = 0;
                w = renderWidth;
                h = w * shareHeight / shareWidth;
                t = (renderHeight - h) / 2;
            }
        } else {
            float contentWidth = (float)((double)shareWidth * this.mZoomVal);
            float contentHeight = (float)((double)shareHeight * this.mZoomVal);
            if (contentWidth > (float)this.getWidth()) {
                l = 0;
                w = this.getWidth();
            } else {
                w = (int)contentWidth;
                l = (renderWidth - w) / 2;
            }
            if (contentHeight > (float)this.getHeight()) {
                t = 0;
                h = this.getHeight();
            } else {
                h = (int)contentHeight;
                t = (renderHeight - h) / 2;
            }
        }
        return new RendererUnitInfo(this.getLeft() + l, this.getTop() + t, w, h);
    }

    @Override
    public void onDown(MotionEvent e) {
        this.mStopFling_UnitShare = true;
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        this.mStopFling_UnitShare = true;
        if (!this.mIsNotWaiting_UnitShare) {
            return;
        }
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return;
        }
        int levelsCount = this.getScaleLevelsCount();
        int oldLevel = this.getCurrentScaleLevel();
        int newLevel = (oldLevel + 1) % levelsCount;
        if (newLevel == oldLevel) {
            return;
        }
        if (newLevel == 0) {
            this.zoomToFitUnit();
        } else {
            this.switchToLevel(newLevel, e.getX(), e.getY());
        }
    }

    @Override
    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        if (this.mIsVideoGalleryExpand && !this.getVideoSceneMgr().isViewingSharing()) {
            for (int i = MAX_GALLERY_ITEMS_COUNT; i >= 0; --i) {
                VideoUnit unit = this.mListGalleryUnits.get(i);
                if (!unit.isBorderVisible() || !((float)unit.getLeft() <= e.getX()) || !((float)unit.getRight() > e.getX()) || !((float)unit.getTop() <= e.getY()) || !((float)unit.getBottom() > e.getY())) continue;
                return this.onClickGalleryUnit(unit);
            }
        } else if (this.mIsVideoExpand && !this.getVideoSceneMgr().isViewingSharing() && this.mCountUsers == 2 && this.mUnitSmallSingleVideo != null && (float)this.mUnitSmallSingleVideo.getLeft() <= e.getX() && (float)this.mUnitSmallSingleVideo.getRight() > e.getX() && (float)this.mUnitSmallSingleVideo.getTop() <= e.getY() && (float)this.mUnitSmallSingleVideo.getBottom() > e.getY()) {
            return this.onClickSmallSingleVideoUnit();
        }
        return false;
    }

    private boolean onClickSmallSingleVideoUnit() {
        this.mIsExchangedMode = !this.mIsExchangedMode;
        this.mUnitBigVideo.stopVideo(true);
        this.mUnitBigVideo.removeUser();
        this.mUnitSmallSingleVideo.stopVideo(true);
        this.mUnitSmallSingleVideo.removeUser();
        this.checkShowVideo();
        return true;
    }

    private boolean onClickGalleryUnit(VideoUnit unit) {
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        if (lockedUserId == unit.getUser()) {
            this.getVideoSceneMgr().setLockedUserId(0L);
        } else {
            this.getVideoSceneMgr().setLockedUserId(unit.getUser());
        }
        this.checkShowVideo();
        return true;
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        if (super.onTouchEvent(e)) {
            return true;
        }
        if (this.mIsScrollingGallery && e.getPointerCount() == 1) {
            if (e.getActionMasked() == 1) {
                this.onScrollGalleryEnd();
            }
        } else {
            if (e.getPointerCount() == 2 && this.getVideoSceneMgr().isViewingSharing()) {
                if (e.getActionMasked() == 1 && this.mIsMultiTouchZooming) {
                    this.onMultiTouchZoomEnd();
                    return true;
                }
                float x1 = e.getX(0);
                float y1 = e.getY(0);
                float x2 = e.getX(1);
                float y2 = e.getY(1);
                if (this.mIsMultiTouchZooming) {
                    this.onMultiTouchZoom(x1, y1, x2, y2, this.mLastX1, this.mLastY1, this.mLastX2, this.mLastY2);
                }
                this.mIsMultiTouchZooming = true;
                this.mLastX1 = x1;
                this.mLastY1 = y1;
                this.mLastX2 = x2;
                this.mLastY2 = y2;
                return false;
            }
            if (this.mIsMultiTouchZooming) {
                this.onMultiTouchZoomEnd();
                return true;
            }
        }
        return false;
    }

    private void onScrollGalleryEnd() {
        int marginGallery = this.getGalleryUnitMargin();
        this.mIsScrollingGallery = false;
        VideoUnit lastUnit = this.mListGalleryUnits.get(MAX_GALLERY_ITEMS_COUNT);
        VideoUnit firstUnit = this.mListGalleryUnits.get(0);
        VideoUnit lastVisibleUnit = null;
        for (int i = MAX_GALLERY_ITEMS_COUNT; i >= 0; --i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (!unit.isBorderVisible()) continue;
            lastVisibleUnit = unit;
            break;
        }
        int unitWidth = firstUnit.getWidth();
        if (lastVisibleUnit != null && lastVisibleUnit.getRight() < MAX_GALLERY_ITEMS_COUNT * (marginGallery + unitWidth)) {
            int idx = this.mCountUsers - MAX_GALLERY_ITEMS_COUNT;
            if (idx == 0) {
                idx = 0;
            }
            this.scrollGalleryToUnitAt(idx, marginGallery, unitWidth);
        } else if (firstUnit.getLeft() > marginGallery) {
            this.scrollGalleryToUnitAt(0, marginGallery, unitWidth);
        } else if (marginGallery - firstUnit.getLeft() > unitWidth * 3 / 4) {
            firstUnit.stopVideo(true);
            firstUnit.removeUser();
            int idx = (firstUnit.getRight() + marginGallery + this.mGalleryScrollPos) / (marginGallery + unitWidth);
            this.scrollGalleryToUnitAt(idx, marginGallery, unitWidth);
            this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
        } else {
            lastUnit.stopVideo(true);
            lastUnit.removeUser();
            int idx = (firstUnit.getLeft() + this.mGalleryScrollPos) / (marginGallery + unitWidth);
            this.scrollGalleryToUnitAt(idx, marginGallery, unitWidth);
        }
        this.checkUpdateGalleryUnitsVideo();
        this.updateExpandGalleryButton();
        this.updateCloseGalleryButton();
        this.mGLBtnExpandGallery.setVisible(true);
        this.mGLBtnCloseGallery.setVisible(true);
        this.updateSwitchCameraButton();
    }

    private void scrollGalleryToUnitAt(int idx, int marginGallery, int unitWidth) {
        this.mGalleryScrollPos = idx * (marginGallery + unitWidth);
    }

    private void onMultiTouchZoom(float x1, float y1, float x2, float y2, float lastX1, float lastY1, float lastX2, float lastY2) {
        this.mIsMultiTouchZooming = true;
        float dx = x2 - x1;
        float dy = y2 - y1;
        float lastDx = lastX2 - lastX1;
        float lastDy = lastY2 - lastY1;
        double curDistance = Math.sqrt(dx * dx + dy * dy);
        double lastDistance = Math.sqrt(lastDx * lastDx + lastDy * lastDy);
        double newZoom = this.mZoomVal * (curDistance / lastDistance);
        float lastX1OnUnit = this.viewXToShareUnitX(lastX1);
        float lastY1OnUnit = this.viewYToShareUnitY(lastY1);
        PointF pixelLastPos1OnContent = this.unitPosToPixelPosOnContent(lastX1OnUnit, lastY1OnUnit, this.mZoomVal);
        float lastXPos1OnContentNew = (float)((double)pixelLastPos1OnContent.x * newZoom);
        float lastYPos1OnContentNew = (float)((double)pixelLastPos1OnContent.y * newZoom);
        this.mZoomVal = newZoom;
        this.mIsFitScreen = this.checkFitScreen();
        this.updateUnitsWithoutResetDestArea();
        float x1OnUnit = this.viewXToShareUnitX(x1);
        float y1OnUnit = this.viewYToShareUnitY(y1);
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return;
        }
        this.mScaleWidth = (float)((double)this.mShareSize.width * newZoom);
        this.mScaleHeight = (float)((double)this.mShareSize.height * newZoom);
        this.mContentX = x1OnUnit - lastXPos1OnContentNew;
        this.mContentY = y1OnUnit - lastYPos1OnContentNew;
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private void onMultiTouchZoomEnd() {
        this.mIsMultiTouchZooming = false;
        if (this.mZoomVal < this.getMinLevelZoomValue()) {
            this.zoomToFitUnit();
        } else if (this.mZoomVal > this.getMaxLevelZoomValue()) {
            if (this.mUnitShare == null) {
                return;
            }
            this.switchToLevel(this.getScaleLevelsCount() - 1, this.mUnitShare.getWidth() / 2 + this.mUnitShare.getLeft(), this.mUnitShare.getHeight() / 2 + this.mUnitShare.getTop());
        }
    }

    public boolean canDragSceneToLeft() {
        if (this.mUnitShare == null || !this.mHasCachedData || this.mShareSize == null) {
            return false;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
        return this.mContentX + contentWidth <= (float)this.mUnitShare.getWidth();
    }

    private boolean checkFitScreen() {
        if (this.mZoomVal < 0.01) {
            return true;
        }
        double zoomFit = this.scaleLevelToZoomValue(0);
        return Math.abs(this.mZoomVal - zoomFit) < 0.01;
    }

    private double getMaxLevelZoomValue() {
        float density = VideoBoxApplication.getInstance().getResources().getDisplayMetrics().density;
        float maxLevelZoomVal = density * 160.0f / 120.0f;
        return maxLevelZoomVal;
    }

    private double getMinLevelZoomValue() {
        if (this.mShareSize == null) {
            return 0.0;
        }
        int renderWidth = this.getWidth();
        int renderHeight = this.getHeight();
        double fitWidth = 0.0;
        if (renderWidth * this.mShareSize.height > renderHeight * this.mShareSize.width) {
            int fitHeight = renderHeight;
            fitWidth = (double)fitHeight * (double)this.mShareSize.width / (double)this.mShareSize.height;
        } else {
            fitWidth = renderWidth;
        }
        double minLevelZoomVal = fitWidth / (double)this.mShareSize.width;
        return minLevelZoomVal;
    }

    private int getScaleLevelsCount() {
        if (this.mShareSize == null || this.mShareSize.width == 0 || this.mShareSize.height == 0) {
            return 3;
        }
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        float maxContextDisplayWidth = (float)(maxLevelZoomVal * (double)this.mShareSize.width);
        float maxContextDisplayHeight = (float)(maxLevelZoomVal * (double)this.mShareSize.height);
        if (maxContextDisplayWidth <= (float)this.getWidth() && maxContextDisplayHeight < (float)this.getHeight()) {
            return 1;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        float mediumContextDisplayWidth = (float)(mediumLevelZoomVal * (double)this.mShareSize.width);
        float mediumContextDisplayHeight = (float)(mediumLevelZoomVal * (double)this.mShareSize.height);
        if (mediumContextDisplayWidth <= (float)this.getWidth() && mediumContextDisplayHeight < (float)this.getHeight()) {
            return 2;
        }
        return 3;
    }

    private int getCurrentScaleLevel() {
        int i;
        int levelsCount = this.getScaleLevelsCount();
        double[] levelZooms = new double[levelsCount];
        for (i = 0; i < levelsCount; ++i) {
            levelZooms[i] = this.scaleLevelToZoomValue(i);
        }
        for (i = 0; i < levelsCount - 1; ++i) {
            if (!(this.mZoomVal >= levelZooms[i]) || !(this.mZoomVal < levelZooms[i + 1])) continue;
            return i;
        }
        return levelsCount - 1;
    }

    private void switchToLevel(int level, float x, float y) {
        this.switchToZoom(this.scaleLevelToZoomValue(level), x, y);
    }

    private void switchToZoom(double zoomVal, float x, float y) {
        double oldZoom = this.mZoomVal;
        this.mZoomVal = zoomVal;
        this.mIsFitScreen = this.checkFitScreen();
        float xOnUnit = this.viewXToShareUnitX(x);
        float yOnUnit = this.viewYToShareUnitY(y);
        PointF pixelPosOnContent = this.unitPosToPixelPosOnContent(xOnUnit, yOnUnit, oldZoom);
        this.updateUnitsWithoutResetDestArea();
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return;
        }
        float pixelXOnContent = pixelPosOnContent.x;
        float pixelYOnContent = pixelPosOnContent.y;
        this.mScaleWidth = (float)((double)this.mShareSize.width * this.mZoomVal);
        this.mScaleHeight = (float)((double)this.mShareSize.height * this.mZoomVal);
        this.resetDestAreaCenter(pixelXOnContent, pixelYOnContent);
    }

    private PointF getCenterPixelPosOnContent() {
        if (this.mUnitShare == null) {
            return null;
        }
        return this.unitPosToPixelPosOnContent(this.mUnitShare.getWidth() / 2, this.mUnitShare.getHeight() / 2, this.mZoomVal);
    }

    private void resetDestAreaCenter(float pixelX, float pixelY) {
        if (this.mUnitShare == null) {
            return;
        }
        this.mContentX = (float)(this.mUnitShare.getWidth() / 2) - (float)((double)pixelX * this.mZoomVal);
        this.mContentY = (float)(this.mUnitShare.getHeight() / 2) - (float)((double)pixelY * this.mZoomVal);
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private PointF unitPosToPixelPosOnContent(float x, float y, double zoomVal) {
        float xOnContent = x - this.mContentX;
        float yOnContent = y - this.mContentY;
        float pixelXOnContent = (float)((double)xOnContent / zoomVal);
        float pixelYOnContent = (float)((double)yOnContent / zoomVal);
        return new PointF(pixelXOnContent, pixelYOnContent);
    }

    private void notifyDestAreaChanged() {
        VideoSize shareSize = this.mShareSize;
        if (shareSize == null || shareSize.width == 0 || shareSize.height == 0) {
            return;
        }
        if (this.mUnitShare == null) {
            return;
        }
        this.mUnitShare.destAreaChanged((int)this.mContentX, (int)this.mContentY, (int)this.mScaleWidth, (int)this.mScaleHeight);
    }

    private void zoomToFitUnit() {
        if (this.mUnitShare == null) {
            return;
        }
        this.mZoomVal = this.scaleLevelToZoomValue(0);
        this.mIsFitScreen = this.checkFitScreen();
        this.mContentX = 0.0f;
        this.mContentY = 0.0f;
        this.updateUnitsWithoutResetDestArea();
        this.mScaleWidth = this.mUnitShare.getWidth();
        this.mScaleHeight = this.mUnitShare.getHeight();
        this.notifyDestAreaChanged();
    }

    private float viewXToShareUnitX(float x) {
        if (this.mUnitShare == null) {
            return x;
        }
        return x - (float)this.mUnitShare.getLeft();
    }

    private float viewYToShareUnitY(float y) {
        if (this.mUnitShare == null) {
            return y;
        }
        return y - (float)this.mUnitShare.getTop();
    }

    private double scaleLevelToZoomValue(int level) {
        if (this.mShareSize == null || this.mShareSize.width == 0) {
            return 1.0;
        }
        double minLevelZoomVal = this.getMinLevelZoomValue();
        double maxLevelZoomVal = this.getMaxLevelZoomValue();
        double mediumLevelZoomVal = (minLevelZoomVal + maxLevelZoomVal) * 2.0 / 5.0;
        int levelsCount = this.getScaleLevelsCount();
        if (levelsCount == 1) {
            return Math.min(minLevelZoomVal, maxLevelZoomVal);
        }
        if (levelsCount == 2) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        if (levelsCount >= 3) {
            switch (level) {
                case 0: {
                    return minLevelZoomVal;
                }
                case 1: {
                    return mediumLevelZoomVal;
                }
            }
            return maxLevelZoomVal;
        }
        return 0.0;
    }

    @Override
    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isOnGallery(e2)) {
            this.onScrollGallery((int)distanceX);
        } else if (this.getVideoSceneMgr().isViewingSharing()) {
            this.onScrollShareUnit(distanceX, distanceY);
        }
    }

    private void onScrollShareUnit(float distanceX, float distanceY) {
        this.mStopFling_UnitShare = true;
        if (!this.mIsNotWaiting_UnitShare) {
            return;
        }
        this.mContentX -= distanceX;
        this.mContentY -= distanceY;
        this.trimContentPos();
        this.notifyDestAreaChanged();
    }

    private void onScrollGallery(int distanceX) {
        int i;
        int unitWidth;
        int unitMargin;
        int maxGalleryScrollPos;
        if (this.mCountUsers <= MAX_GALLERY_ITEMS_COUNT) {
            if (this.mIsScrollingGallery) {
                this.onScrollGalleryEnd();
            }
            return;
        }
        int lastScrollPos = this.mGalleryScrollPos;
        this.mGalleryScrollPos += distanceX;
        if (this.mGalleryScrollPos < 0) {
            this.mGalleryScrollPos = 0;
        }
        if (this.mGalleryScrollPos > (maxGalleryScrollPos = (this.mCountUsers - MAX_GALLERY_ITEMS_COUNT) * ((unitMargin = this.getGalleryUnitMargin()) + (unitWidth = this.getGalleryUnitWidth())))) {
            this.mGalleryScrollPos = maxGalleryScrollPos;
        }
        if (lastScrollPos == this.mGalleryScrollPos) {
            return;
        }
        distanceX = this.mGalleryScrollPos - lastScrollPos;
        int outCount = 0;
        for (i = 0; i <= MAX_GALLERY_ITEMS_COUNT; ++i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (unit.getRight() - distanceX <= 0) {
                unit.stopVideo(true);
                unit.removeUser();
                ++outCount;
                continue;
            }
            if (this.mGalleryScrollPos <= 0 || unit.getLeft() - distanceX <= this.getWidth()) continue;
            unit.stopVideo(true);
            unit.removeUser();
            ++outCount;
        }
        if (distanceX > 0) {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(this.mListGalleryUnits.remove(0));
            }
        } else {
            for (i = 0; i < outCount; ++i) {
                this.mListGalleryUnits.add(0, this.mListGalleryUnits.remove(MAX_GALLERY_ITEMS_COUNT));
            }
        }
        this.checkUpdateGalleryUnitsVideo();
        this.updateSwitchCameraButton();
        this.mGLBtnExpandGallery.setVisible(false);
        this.mGLBtnCloseGallery.setVisible(false);
        this.mIsScrollingGallery = true;
    }

    private boolean isOnGallery(MotionEvent evt) {
        if (!this.mIsVideoGalleryExpand) {
            return false;
        }
        float x = evt.getX();
        float y = evt.getY();
        VideoUnit firstUnit = this.mListGalleryUnits.get(0);
        VideoUnit lastUnit = null;
        for (int i = MAX_GALLERY_ITEMS_COUNT; i >= 0; --i) {
            VideoUnit unit = this.mListGalleryUnits.get(i);
            if (!unit.isBorderVisible()) continue;
            lastUnit = unit;
            break;
        }
        if (lastUnit == null) {
            lastUnit = firstUnit;
        }
        return x >= (float)firstUnit.getLeft() && x < (float)lastUnit.getRight() && y >= (float)firstUnit.getTop() && y < (float)firstUnit.getBottom();
    }

    private void trimContentPos() {
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
        float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
        if (this.mContentX > 0.0f) {
            if (contentWidth >= (float)this.mUnitShare.getWidth()) {
                this.mContentX = 0.0f;
            } else if (this.mContentX + contentWidth > (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
            }
        } else if (contentWidth >= (float)this.mUnitShare.getWidth() && this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
            this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
        } else if (contentWidth <= (float)this.mUnitShare.getWidth()) {
            this.mContentX = 0.0f;
        }
        if (this.mContentY > 0.0f) {
            if (contentHeight >= (float)this.mUnitShare.getHeight()) {
                this.mContentY = 0.0f;
            } else if (this.mContentY + contentHeight > (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
            }
        } else if (contentHeight >= (float)this.mUnitShare.getHeight() && this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
            this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
        } else if (contentHeight <= (float)this.mUnitShare.getHeight()) {
            this.mContentY = 0.0f;
        }
    }

    @Override
    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mIsNotWaiting_UnitShare || !this.isCreated()) {
            return;
        }
        if (this.mUnitShare == null || this.mShareSize == null) {
            return;
        }
        if (velocityX > 0.0f) {
            this.mScroller.setFinalX(0);
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            this.mScroller.setFinalX((int)((float)this.mUnitShare.getWidth() - contentWidth));
        }
        if (velocityY > 0.0f) {
            this.mScroller.setFinalY(0);
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            this.mScroller.setFinalY((int)((float)this.mUnitShare.getHeight() - contentHeight));
        }
        int maxVelocity = UIUtil.dip2px((Context)this.getConfActivity(), (float)1500.0f);
        if (Math.abs(velocityX) > Math.abs(velocityY)) {
            if (velocityX == 0.0f) {
                velocityX = 0.1f;
            }
            float rate = velocityY / velocityX;
            if (velocityX > (float)maxVelocity) {
                velocityX = maxVelocity;
            } else if (velocityX < (float)(-maxVelocity)) {
                velocityX = -maxVelocity;
            }
            velocityY = velocityX * rate;
        } else {
            if (velocityY == 0.0f) {
                velocityY = 0.1f;
            }
            float rate = velocityX / velocityY;
            if (velocityY > (float)maxVelocity) {
                velocityY = maxVelocity;
            } else if (velocityY < (float)(-maxVelocity)) {
                velocityY = -maxVelocity;
            }
            velocityX = velocityY * rate;
        }
        this.mScroller.fling((int)this.mContentX, (int)this.mContentY, (int)velocityX, (int)velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mStopFling_UnitShare = false;
        this.handleFling();
    }

    private void handleFling() {
        this.mFlingHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!LargeVideoScene.this.mStopFling_UnitShare && LargeVideoScene.this.updateContentPosOnFling()) {
                    LargeVideoScene.this.handleFling();
                }
            }
        }, 40L);
    }

    private boolean updateContentPosOnFling() {
        boolean xStopped = false;
        boolean yStopped = false;
        if (this.mUnitShare == null || this.mShareSize == null) {
            return false;
        }
        if (!this.mScroller.computeScrollOffset()) {
            return false;
        }
        this.mContentX = this.mScroller.getCurrX();
        if (this.mContentX > 0.0f) {
            this.mContentX = 0.0f;
            xStopped = true;
        } else {
            float contentWidth = (float)(this.mZoomVal * (double)this.mShareSize.width);
            if (this.mContentX + contentWidth < (float)this.mUnitShare.getWidth()) {
                this.mContentX = (float)this.mUnitShare.getWidth() - contentWidth;
                xStopped = true;
            }
        }
        this.mContentY = this.mScroller.getCurrY();
        if (this.mContentY > 0.0f) {
            this.mContentY = 0.0f;
            yStopped = true;
        } else {
            float contentHeight = (float)(this.mZoomVal * (double)this.mShareSize.height);
            if (this.mContentY + contentHeight < (float)this.mUnitShare.getHeight()) {
                this.mContentY = (float)this.mUnitShare.getHeight() - contentHeight;
                yStopped = true;
            }
        }
        this.notifyDestAreaChanged();
        return !xStopped && !yStopped;
    }

    public boolean needShowSwitchCameraButton() {
        return false;
    }

    private void createExpandVideoButton() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_expand_video);
        RendererUnitInfo unitInfo = this.createExpandVideoButtonUnitInfo(drawable2);
        this.mGLBtnExpandVideo = videoMgr.createGLButton(unitInfo);
        if (this.mGLBtnExpandVideo != null) {
            this.mGLBtnExpandVideo.setUnitName("ExpandVideo");
            this.mGLBtnExpandVideo.setVideoScene(this);
            this.addUnit(this.mGLBtnExpandVideo);
            this.mGLBtnExpandVideo.onCreate();
            this.mGLBtnExpandVideo.setVisible(false);
            this.mGLBtnExpandVideo.setBackground(drawable2);
            this.mGLBtnExpandVideo.setOnClickListener(this);
        }
    }

    private void updateExpandVideoButton() {
        if (this.mGLBtnExpandVideo == null) {
            return;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_expand_video);
        RendererUnitInfo unitInfo = this.createExpandVideoButtonUnitInfo(drawable2);
        this.mGLBtnExpandVideo.updateUnitInfo(unitInfo);
    }

    private RendererUnitInfo createExpandVideoButtonUnitInfo(Drawable background) {
        int h;
        int w;
        if (background != null && UIUtil.isXLargeScreen((Context)this.getConfActivity())) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        int margin = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        int x = this.getLeft() + this.getWidth() - w - margin;
        int y = this.getTop() + this.getHeight() - h - margin;
        return new RendererUnitInfo(x, y, w, h);
    }

    private void createExpandGalleryButton() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(this.mIsVideoGalleryExpand ? R.drawable.zm_btn_gallery_collapse : R.drawable.zm_btn_gallery_expand);
        RendererUnitInfo unitInfo = this.createExpandGalleryButtonUnitInfo(drawable2);
        this.mGLBtnExpandGallery = videoMgr.createGLButton(unitInfo);
        if (this.mGLBtnExpandGallery != null) {
            this.mGLBtnExpandGallery.setUnitName("ExpandGallery");
            this.mGLBtnExpandGallery.setVideoScene(this);
            this.addUnit(this.mGLBtnExpandGallery);
            this.mGLBtnExpandGallery.onCreate();
            this.mGLBtnExpandGallery.setVisible(false);
            this.mGLBtnExpandGallery.setBackground(drawable2);
            this.mGLBtnExpandGallery.setOnClickListener(this);
        }
    }

    private void updateExpandGalleryButton() {
        if (this.mGLBtnExpandGallery == null) {
            return;
        }
        Drawable drawable2 = null;
        if (this.mIsVideoGalleryExpand) {
            if (this.mDrawableGalleryCollapse == null) {
                this.mDrawableGalleryCollapse = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_gallery_collapse);
            }
            drawable2 = this.mDrawableGalleryCollapse;
        } else {
            if (this.mDrawableGalleryExpand == null) {
                this.mDrawableGalleryExpand = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_gallery_expand);
            }
            drawable2 = this.mDrawableGalleryExpand;
        }
        RendererUnitInfo unitInfo = this.createExpandGalleryButtonUnitInfo(drawable2);
        this.mGLBtnExpandGallery.setBackground(drawable2);
        this.mGLBtnExpandGallery.updateUnitInfo(unitInfo);
    }

    private RendererUnitInfo createExpandGalleryButtonUnitInfo(Drawable background) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        if (!this.mIsVideoExpand) {
            x = Integer.MAX_VALUE;
            y = 0;
        } else if (this.mIsVideoGalleryExpand) {
            VideoUnit unit = this.mListGalleryUnits.get(0);
            if (unit != null) {
                x = unit.getLeft() - w / 2;
                y = unit.getTop() - h / 2;
            }
        } else if (this.mUnitSmallSingleVideo != null) {
            x = this.mUnitSmallSingleVideo.getLeft() - w / 2;
            y = this.mUnitSmallSingleVideo.getTop() - h / 2;
        }
        return new RendererUnitInfo(x, y, w, h);
    }

    private void createCloseGalleryButton() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_gallery_close);
        RendererUnitInfo unitInfo = this.createCloseGalleryButtonUnitInfo(drawable2);
        this.mGLBtnCloseGallery = videoMgr.createGLButton(unitInfo);
        if (this.mGLBtnCloseGallery != null) {
            this.mGLBtnCloseGallery.setUnitName("CloseGallery");
            this.mGLBtnCloseGallery.setVideoScene(this);
            this.addUnit(this.mGLBtnCloseGallery);
            this.mGLBtnCloseGallery.onCreate();
            this.mGLBtnCloseGallery.setVisible(false);
            this.mGLBtnCloseGallery.setBackground(drawable2);
            this.mGLBtnCloseGallery.setOnClickListener(this);
        }
    }

    private void updateCloseGalleryButton() {
        if (this.mGLBtnCloseGallery == null) {
            return;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_gallery_close);
        RendererUnitInfo unitInfo = this.createCloseGalleryButtonUnitInfo(drawable2);
        this.mGLBtnCloseGallery.updateUnitInfo(unitInfo);
    }

    private RendererUnitInfo createCloseGalleryButtonUnitInfo(Drawable background) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        if (!this.mIsVideoExpand) {
            x = Integer.MAX_VALUE;
            y = 0;
        } else if (this.mIsVideoGalleryExpand) {
            VideoUnit unit = this.getLastVisibleGalleryUnit();
            if (unit != null) {
                x = unit.getLeft() + unit.getWidth() - w / 2;
                y = unit.getTop() - h / 2;
            }
        } else {
            x = this.mUnitSmallSingleVideo.getLeft() + this.mUnitSmallSingleVideo.getWidth() - w / 2;
            y = this.mUnitSmallSingleVideo.getTop() - h / 2;
        }
        return new RendererUnitInfo(x, y, w, h);
    }

    private VideoUnit getLastVisibleGalleryUnit() {
        if (this.mCountUsers <= MAX_GALLERY_ITEMS_COUNT) {
            return this.mListGalleryUnits.get(this.mCountUsers - 1);
        }
        VideoUnit lastUnit = this.mListGalleryUnits.get(MAX_GALLERY_ITEMS_COUNT - 1);
        if (lastUnit.getLeft() < this.getWidth()) {
            return lastUnit;
        }
        return this.mListGalleryUnits.get(MAX_GALLERY_ITEMS_COUNT - 2);
    }

    private void createSwitchCameraButton() {
        Drawable drawable2;
        RendererUnitInfo unitInfo;
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return;
        }
        CameraComponent cameraComponent = confActivity.getmCameraComponent();
        if (cameraComponent == null) {
            return;
        }
        if (cameraComponent.canSwitchCamera() && (unitInfo = this.createSwitchCameraButtonUnitInfo(null, drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_switch_camera))) != null) {
            this.mGLBtnSwitchCamera = videoMgr.createGLButton(unitInfo);
            if (this.mGLBtnSwitchCamera != null) {
                this.mGLBtnSwitchCamera.setUnitName("SwitchCamera");
                this.mGLBtnSwitchCamera.setVideoScene(this);
                this.addUnit(this.mGLBtnSwitchCamera);
                this.mGLBtnSwitchCamera.onCreate();
                this.mGLBtnSwitchCamera.setBackground(drawable2);
                this.mGLBtnSwitchCamera.setOnClickListener(this);
            }
        }
    }

    private void updateSwitchCameraButton() {
        if (this.mGLBtnSwitchCamera == null) {
            return;
        }
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity == null) {
            return;
        }
        CameraComponent cameraComponent = confActivity.getmCameraComponent();
        if (cameraComponent == null) {
            return;
        }
        if (cameraComponent.canSwitchCamera()) {
            VideoUnit myVideoUnit = null;
            long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
            if (lockedUserId == 0L && this.mUnitBigVideo != null && this.mUnitBigVideo.isMySelf()) {
                myVideoUnit = this.mUnitBigVideo;
            } else if (this.mUnitSmallSingleVideo != null && this.mUnitSmallSingleVideo.isMySelf()) {
                myVideoUnit = this.mUnitSmallSingleVideo;
            } else {
                VideoUnit unit = this.mListGalleryUnits.get(0);
                if (unit != null && unit.isMySelf()) {
                    myVideoUnit = unit;
                }
            }
            RendererUnitInfo myVideoUnitInfo = null;
            if (myVideoUnit != null) {
                this.mGLBtnSwitchCamera.setVisible(true);
                myVideoUnitInfo = new RendererUnitInfo(myVideoUnit.getLeft(), myVideoUnit.getTop(), myVideoUnit.getWidth(), myVideoUnit.getHeight());
                Drawable drawable2 = this.getConfActivity().getResources().getDrawable(R.drawable.zm_btn_switch_camera);
                RendererUnitInfo unitInfo = this.createSwitchCameraButtonUnitInfo(myVideoUnitInfo, drawable2);
                if (unitInfo != null) {
                    this.mGLBtnSwitchCamera.updateUnitInfo(unitInfo);
                }
            } else {
                this.mGLBtnSwitchCamera.setVisible(false);
            }
        }
    }

    private RendererUnitInfo createSwitchCameraButtonUnitInfo(RendererUnitInfo myVideoUnitInfo, Drawable background) {
        int y;
        int x;
        int h;
        int w;
        if (background == null && this.mGLBtnSwitchCamera != null) {
            background = this.mGLBtnSwitchCamera.getBackgroundDrawable();
        }
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        int margin = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (myVideoUnitInfo == null) {
            x = Integer.MAX_VALUE;
            y = 0;
        } else {
            x = myVideoUnitInfo.left + myVideoUnitInfo.width - w - margin;
            y = myVideoUnitInfo.top + margin;
            long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
            if (lockedUserId == 0L && this.mUnitBigVideo != null && this.mUnitBigVideo.isMySelf()) {
                y += this.getConfActivity().getToolbarHeight();
            }
        }
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    @Override
    public void onClick(GLButton button) {
        if (button == this.mGLBtnCloseGallery) {
            this.mIsVideoGalleryExpand = false;
            this.mIsVideoExpand = false;
            this.mGalleryScrollPos = 0;
            this.checkShowVideo();
        } else if (button == this.mGLBtnExpandGallery) {
            this.mIsVideoGalleryExpand = !this.mIsVideoGalleryExpand;
            this.mGalleryScrollPos = 0;
            this.checkShowVideo();
        } else if (button == this.mGLBtnExpandVideo) {
            this.mIsVideoGalleryExpand = false;
            this.mIsVideoExpand = true;
            this.mGalleryScrollPos = 0;
            this.checkShowVideo();
        } else if (button == this.mGLBtnSwitchCamera) {
            this.getConfActivity().onClickSwitchCamera();
        }
    }

    @Override
    public void onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
    }
}

