/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.zipow.nydus.VideoSize;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.CmmUserList;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.VideoLayoutHelper;
import com.zipow.videobox.view.video.VideoSceneMgr;
import java.util.List;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class GalleryVideoScene
extends AbsVideoScene
implements View.OnClickListener,
GLButton.OnClickListener {
    private String TAG = GalleryVideoScene.class.getSimpleName();
    private static final int UNITS_GAP = 2;
    public static final int BOTTOM_HEIGHT = 12;
    private VideoUnit[] mUnits = null;
    private int mPageIndex = 0;
    private ImageButton[] mSwitchSceneButtons;
    private GLButton mGLBtnSwitchCamera;
    private LayoutInfo mLayoutInfo = new LayoutInfo();
    private int mCountVideoUsers = 0;
    private int mLastWidth = 0;
    private int mLastHeight = 0;

    public GalleryVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
    }

    public void updateLayoutInfo() {
        this.updateLayoutInfo(this.mLayoutInfo);
    }

    private int getCapacity() {
        int cap = VideoLayoutHelper.getInstance().getGalleryViewCapacity();
        if (cap <= 0) {
            cap = 4;
        }
        return cap;
    }

    private void updateLayoutInfo(LayoutInfo info) {
        int capacity;
        ConfActivity context = this.getConfActivity();
        if (context == null || info == null) {
            return;
        }
        this.mCountVideoUsers = ConfLocalHelper.getTotalVideoCount();
        if (this.mCountVideoUsers == 0) {
            return;
        }
        int unitsGap = UIUtil.dip2px((Context)context, (float)2.0f);
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        int bottomHeight = UIUtil.dip2px((Context)context, (float)12.0f);
        viewHeight -= bottomHeight;
        int MAX_ROWS = capacity = this.getCapacity();
        int MAX_COLUMNS = capacity;
        int cols = 0;
        int rows = 0;
        VideoSize videoSize = new VideoSize();
        int totalVideoArea = 0;
        int totalUnits = 0;
        int minCount = Math.min(this.mCountVideoUsers, capacity);
        for (int col = 1; col <= MAX_COLUMNS; ++col) {
            for (int row = 1; row <= MAX_ROWS; ++row) {
                int count = row * col;
                if (count < minCount || count > capacity || (double)((float)viewWidth / (float)viewHeight) >= 1.6 && row > col) continue;
                VideoSize sizeUnit = new VideoSize();
                this.calVideoSize(row, col, viewWidth, viewHeight, unitsGap, unitsGap, sizeUnit);
                int countUsed = this.mCountVideoUsers > capacity ? row * col : this.mCountVideoUsers;
                int area = sizeUnit.width * sizeUnit.height * countUsed;
                int units = row * col;
                if (totalVideoArea >= area && (totalVideoArea != area || units >= totalUnits)) continue;
                videoSize.width = sizeUnit.width;
                videoSize.height = sizeUnit.height;
                totalVideoArea = area;
                totalUnits = row * col;
                rows = row;
                cols = col;
            }
        }
        info.cols = cols;
        info.rows = rows;
        info.unitWidth = videoSize.width;
        info.unitHeight = videoSize.height;
    }

    private void calVideoSize(int rows, int cols, int viewWidth, int viewHeight, int gapX, int gapY, VideoSize sz) {
        boolean bFitHeight;
        sz.width = 0;
        sz.height = 0;
        if (cols == 0 || rows == 0) {
            return;
        }
        int nMinMarginWidth = (cols + 1) * gapX;
        int nClientWidth = viewWidth - nMinMarginWidth;
        int nMinMarginHeight = (rows + 1) * gapY;
        int nClientHeight = viewHeight - nMinMarginHeight;
        boolean bl = bFitHeight = nClientWidth * rows * 9 >= nClientHeight * cols * 16;
        if (bFitHeight) {
            sz.height = nClientHeight / rows;
            int n = sz.height / 9;
            sz.height = n * 9;
            sz.width = n * 16;
        } else {
            sz.width = nClientWidth / cols;
            int n = sz.width / 16;
            sz.width = n * 16;
            sz.height = n * 9;
        }
    }

    public int getUnitsCount() {
        return this.mLayoutInfo.cols * this.mLayoutInfo.rows;
    }

    public void setPageIndex(int index) {
        int i;
        this.mPageIndex = index;
        if (this.mUnits == null) {
            return;
        }
        int visibleUnitCount = this.getVisibleUnitCount();
        for (i = 0; i < visibleUnitCount && i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null) continue;
            this.mUnits[i].setBorderVisible(true);
        }
        for (i = visibleUnitCount; i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null) continue;
            if (this.mUnits[i].getUser() != 0L) {
                this.mUnits[i].removeUser();
                this.mUnits[i].setBorderType(0);
                this.mUnits[i].clearRenderer();
            }
            this.mUnits[i].setBorderVisible(false);
            this.mUnits[i].setBackgroundColor(0);
        }
    }

    public int getPageIndex() {
        return this.mPageIndex;
    }

    public boolean hasPrevPage() {
        return this.mPageIndex > 0;
    }

    public boolean hasNextPage() {
        int userCount = ConfLocalHelper.getTotalVideoCount();
        int lastUserIndex = (this.mPageIndex + 1) * this.getUnitsCount();
        return lastUserIndex < userCount;
    }

    public int getVisibleUnitCount() {
        int count;
        int userCount = ConfLocalHelper.getTotalVideoCount();
        if (userCount == 0) {
            return 0;
        }
        int unitsCount = this.getUnitsCount();
        if (unitsCount == 0) {
            this.updateLayoutInfo();
            unitsCount = this.getUnitsCount();
        }
        if (unitsCount == 0) {
            return 0;
        }
        int pageCount = userCount / unitsCount + (userCount % unitsCount > 0 ? 1 : 0);
        if (this.mPageIndex == pageCount - 1) {
            count = userCount % unitsCount;
            if (count == 0) {
                count = unitsCount;
            }
        } else {
            count = unitsCount;
        }
        return count;
    }

    @Override
    protected void onCreateUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        if (this.mUnits != null) {
            return;
        }
        if (this.mLayoutInfo == null || !this.mLayoutInfo.isValid()) {
            this.updateLayoutInfo();
            if (this.isCreated()) {
                this.onCreateUnits();
            }
            return;
        }
        int unitsCount = this.getUnitsCount();
        this.mUnits = new VideoUnit[unitsCount];
        for (int i = 0; i < unitsCount; ++i) {
            VideoUnit unit;
            RendererUnitInfo unitInfo = this.createVideoUnitInfo(i);
            if (unitInfo == null) continue;
            this.mUnits[i] = unit = videoMgr.createVideoUnit(false, unitInfo);
            if (unit == null) continue;
            unit.setUnitName("GalleryUnit" + i);
            unit.setVideoScene(this);
            unit.setCanShowAudioOff(true);
            unit.setBorderVisible(false);
            unit.setBackgroundColor(-16777216);
            this.addUnit(unit);
            unit.onCreate();
        }
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
        }
    }

    @Override
    public void updateAccessibilitySceneDescription() {
        if (this.getConfActivity() != null) {
            if (this.getConfActivity().isToolbarShowing()) {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_gallery_video_toolbar_showed));
            } else {
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(this.getConfActivity().getString(R.string.zm_description_scene_gallery_video_toolbar_hided));
            }
        }
    }

    @Override
    public Rect getBoundsForAccessbilityViewIndex(int index) {
        if (this.mUnits == null || index >= this.mUnits.length) {
            return new Rect();
        }
        VideoUnit unit = this.mUnits[index];
        if (unit == null) {
            return new Rect();
        }
        return new Rect(unit.getLeft(), unit.getTop(), unit.getRight(), unit.getBottom());
    }

    @Override
    public int getAccessbilityViewIndexAt(float x, float y) {
        if (this.mUnits == null) {
            return -1;
        }
        int count = this.mUnits.length;
        if (count <= 0) {
            return -1;
        }
        for (int i = 0; i < count; ++i) {
            VideoUnit unit = this.mUnits[i];
            if (!unit.isPointInUnit(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public CharSequence getAccessibilityDescriptionForIndex(int index) {
        if (this.mUnits == null) {
            return "";
        }
        int count = this.mUnits.length;
        if (count <= 0) {
            return "";
        }
        if (index >= count) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        VideoUnit unit = this.mUnits[index];
        if (unit == null) {
            return "";
        }
        CmmUser user = ConfMgr.getInstance().getUserById(unit.getUser());
        if (user != null) {
            builder.append(user.getScreenName());
        }
        return builder.toString();
    }

    @Override
    public void getAccessibilityVisibleVirtualViews(List<Integer> virtualViewIds) {
        if (this.mUnits == null || this.mUnits.length <= 0) {
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            virtualViewIds.add(i);
        }
    }

    @Override
    protected void onUpdateUnits() {
        if (this.mLastWidth != 0 && this.mLastHeight != 0 && (this.getWidth() != this.mLastWidth || this.getHeight() != this.mLastHeight)) {
            this.mLastWidth = this.getWidth();
            this.mLastHeight = this.getHeight();
            this.updateContentSubscription();
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.mLastWidth = this.getWidth();
        this.mLastHeight = this.getHeight();
        int unitsCount = this.getUnitsCount();
        if (this.mUnits != null) {
            int i;
            VideoUnit[] units;
            if (this.mUnits.length < unitsCount) {
                units = new VideoUnit[unitsCount];
                for (i = 0; i < unitsCount; ++i) {
                    VideoUnit unit;
                    if (i < this.mUnits.length) {
                        units[i] = this.mUnits[i];
                        continue;
                    }
                    RendererUnitInfo unitInfo = this.createVideoUnitInfo(i);
                    if (unitInfo == null) continue;
                    units[i] = unit = videoMgr.createVideoUnit(false, unitInfo);
                    if (unit == null) continue;
                    unit.setUnitName("GalleryUnit" + i);
                    unit.setVideoScene(this);
                    unit.setCanShowAudioOff(true);
                    unit.setBorderVisible(false);
                    unit.setBackgroundColor(-16777216);
                    this.addUnit(unit);
                    unit.onCreate();
                }
                this.mUnits = units;
            } else if (this.mUnits.length > unitsCount) {
                units = new VideoUnit[unitsCount];
                for (i = 0; i < this.mUnits.length; ++i) {
                    if (i < unitsCount) {
                        units[i] = this.mUnits[i];
                        continue;
                    }
                    if (this.mUnits[i] == null) continue;
                    this.mUnits[i].removeUser();
                    this.mUnits[i].onDestroy();
                    this.removeUnit(this.mUnits[i]);
                }
                this.mUnits = units;
            }
        }
        if (this.mUnits == null) {
            this.mUnits = new VideoUnit[unitsCount];
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            RendererUnitInfo unitInfo = this.createVideoUnitInfo(i);
            if (unitInfo == null) continue;
            if (this.mUnits[i] == null) {
                VideoUnit unit;
                this.mUnits[i] = unit = videoMgr.createVideoUnit(false, unitInfo);
                if (unit == null) continue;
                unit.setUnitName("GalleryUnit" + i);
                unit.setVideoScene(this);
                unit.setCanShowAudioOff(true);
                unit.setBorderVisible(false);
                unit.setBackgroundColor(-16777216);
                this.addUnit(unit);
                unit.onCreate();
                continue;
            }
            this.mUnits[i].updateUnitInfo(unitInfo);
        }
        this.updateSwitchCameraButton();
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
            this.updateAccessibilitySceneDescription();
        }
    }

    @Override
    protected void onDestroyUnits() {
        if (this.mUnits != null) {
            for (int i = 0; i < this.mUnits.length; ++i) {
                this.mUnits[i] = null;
            }
        }
        this.mUnits = null;
        this.mGLBtnSwitchCamera = null;
    }

    @Override
    protected void onStart() {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                GalleryVideoScene.this.updateContentSubscription();
            }
        });
        if (this.isVisible()) {
            this.updateSwitchScenePanel();
        }
    }

    @Override
    public void updateContentSubscription() {
        this.checkShowVideo();
    }

    @Override
    protected void onStop() {
        if (this.mUnits == null) {
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null) continue;
            this.mUnits[i].removeUser();
        }
    }

    @Override
    public void onUserVideoStatus(long userId) {
        super.onUserVideoStatus(userId);
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                GalleryVideoScene.this.updateContentSubscription();
            }
        });
    }

    @Override
    public void onUserVideoDataSizeChanged(long userId) {
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                GalleryVideoScene.this.updateContentSubscription();
            }
        });
    }

    @Override
    public void onUserPicReady(long userId) {
        this.updateUserPic(userId);
    }

    private void updateUserPic(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnits == null) {
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null || this.mUnits[i].getUser() == 0L || !confStatus.isSameUser(userId, this.mUnits[i].getUser())) continue;
            this.mUnits[i].updateAvatar();
        }
    }

    @Override
    public void onActiveVideoChanged(long userId) {
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        if (lockedUserId != 0L) {
            return;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                GalleryVideoScene.this.updateContentSubscription();
            }
        });
    }

    @Override
    public void onUserActiveVideoForDeck(long userId) {
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        if (lockedUserId != 0L) {
            return;
        }
        this.runOnRendererInited(new Runnable(){

            @Override
            public void run() {
                GalleryVideoScene.this.updateContentSubscription();
            }
        });
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        switch (eventType) {
            case 0: 
            case 1: {
                if (ConfLocalHelper.isMeetSwitchToGalleryView()) {
                    this.updateContentSubscription();
                } else if (!VideoLayoutHelper.getInstance().isSwitchVideoLayoutAccordingToUserCountEnabled()) {
                    ((VideoSceneMgr)this.getVideoSceneMgr()).switchToDefaultScene();
                }
                this.updateSwitchScenePanel();
                break;
            }
            case 2: {
                this.updateContentSubscription();
            }
        }
    }

    @Override
    public void onDoubleTap(MotionEvent e) {
        float x = e.getX();
        float y = e.getY();
        if (this.mUnits == null) {
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null || this.mUnits[i].getUser() == 0L || !(x > (float)this.mUnits[i].getLeft()) || !(x < (float)(this.mUnits[i].getLeft() + this.mUnits[i].getWidth())) || !(y > (float)this.mUnits[i].getTop()) || !(y < (float)(this.mUnits[i].getTop() + this.mUnits[i].getHeight()))) continue;
            long userId = this.mUnits[i].getUser();
            final VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
            if (sceneMgr == null) {
                return;
            }
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr == null) {
                return;
            }
            if (videoMgr.isSelectedUser(userId)) {
                return;
            }
            CmmConfStatus status = ConfMgr.getInstance().getConfStatusObj();
            if (status != null && status.isMyself(userId)) {
                return;
            }
            if (sceneMgr.pinVideo(userId) && !ConfMgr.getInstance().isViewOnlyMeeting()) {
                final ConfActivity activity = this.getConfActivity();
                View confView = activity.findViewById(R.id.confView);
                ImageView fadeView = (ImageView)activity.findViewById(R.id.fadeview);
                float centrex = (x - (float)confView.getLeft()) / (float)confView.getWidth();
                float centrey = (y - (float)confView.getTop()) / (float)confView.getHeight();
                ScaleAnimation animation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, centrex, 1, centrey);
                animation.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationEnd(Animation arg0) {
                        sceneMgr.showPinModeInNormalScene();
                        Toast toast = Toast.makeText((Context)activity, (int)R.string.zm_msg_doubletap_enter_pinvideo, (int)3000);
                        toast.setGravity(17, 0, 0);
                        toast.show();
                    }

                    public void onAnimationRepeat(Animation arg0) {
                    }

                    public void onAnimationStart(Animation arg0) {
                    }
                });
                animation.setDuration(200L);
                fadeView.setVisibility(0);
                fadeView.startAnimation((Animation)animation);
            }
            return;
        }
    }

    @Override
    public void onUserAudioStatus(long userId) {
        this.updateUserAudioStatus(userId);
    }

    @Override
    public void onAudioTypeChanged(long userId) {
        this.updateUserAudioStatus(userId);
    }

    private void updateUserAudioStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (this.mUnits == null) {
            return;
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            if (this.mUnits[i] == null || this.mUnits[i].getUser() == 0L || !confStatus.isSameUser(userId, this.mUnits[i].getUser())) continue;
            this.mUnits[i].onUserAudioStatus();
        }
    }

    @Override
    public void beforeSwitchCamera() {
        if (this.mUnits == null || this.mUnits.length == 0 || this.mUnits[0] == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(this.mUnits[0].getUser())) {
            this.mUnits[0].stopVideo(false);
        }
    }

    @Override
    public void afterSwitchCamera() {
        if (this.mUnits == null || this.mUnits.length == 0 || this.mUnits[0] == null) {
            return;
        }
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (confStatus.isMyself(this.mUnits[0].getUser())) {
            this.mUnits[0].startVideo();
        }
    }

    private void checkShowVideo() {
        ConfMgr confMgr;
        CmmUserList userList;
        if (!this.isCreated()) {
            return;
        }
        int pageSize = this.mLayoutInfo.rows * this.mLayoutInfo.cols;
        if (pageSize == 0) {
            return;
        }
        int videoCount = ConfLocalHelper.getTotalVideoCount();
        if (videoCount == 0) {
            ((VideoSceneMgr)this.getVideoSceneMgr()).switchToDefaultScene();
            return;
        }
        int countPages = (videoCount + pageSize - 1) / pageSize;
        if (this.mPageIndex >= countPages) {
            this.mPageIndex = countPages - 1;
            this.updateSwitchScenePanel();
        }
        if ((userList = (confMgr = ConfMgr.getInstance()).getUserList()) == null) {
            return;
        }
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        long lockedUserId = this.getVideoSceneMgr().getLockedUserId();
        long activeSpeakerId = 0L;
        VideoSessionMgr videoSessionMgr = confMgr.getVideoObj();
        if (videoSessionMgr != null) {
            activeSpeakerId = videoSessionMgr.getActiveDeckUserID(false);
        }
        LayoutInfo oldInfo = new LayoutInfo(this.mLayoutInfo);
        this.updateLayoutInfo(this.mLayoutInfo);
        if (!oldInfo.equals(this.mLayoutInfo) || this.mUnits == null || this.mUnits.length != this.getUnitsCount()) {
            this.updateUnits();
            this.updateContentSubscription();
            return;
        }
        this.updateUnits();
        if (this.mUnits == null) {
            return;
        }
        boolean showNoVideoUsers = !ConfLocalHelper.isHideNoVideoUsers();
        int unitsCount = this.getUnitsCount();
        boolean isInBOMeeting = false;
        BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
        if (boMgr != null) {
            isInBOMeeting = boMgr.isInBOMeeting();
        }
        for (int i = 0; i < this.mUnits.length; ++i) {
            CmmUser user;
            if (this.mUnits[i] == null) continue;
            if (this.mPageIndex < 0) {
                if (this.mUnits[i].getUser() == 0L) continue;
                this.mUnits[i].removeUser();
                this.mUnits[i].clearRenderer();
                continue;
            }
            CmmUser cmmUser = user = showNoVideoUsers ? ConfLocalHelper.getUserAt(userList, confStatus, unitsCount, this.mPageIndex, i, isInBOMeeting) : ConfLocalHelper.getHasVideoUserAt(userList, confStatus, unitsCount, this.mPageIndex, i, isInBOMeeting);
            if (user != null) {
                if (!this.isPreloadStatus()) {
                    long userId = user.getNodeId();
                    this.mUnits[i].setType(0);
                    this.mUnits[i].setUser(userId);
                    this.mUnits[i].setBackgroundColor(-16777216);
                    if (lockedUserId == 0L && confStatus.isSameUser(userId, activeSpeakerId)) {
                        this.mUnits[i].setBorderType(1);
                    } else if (userId == lockedUserId) {
                        this.mUnits[i].setBorderType(2);
                    } else {
                        this.mUnits[i].setBorderType(0);
                    }
                    this.mUnits[i].setBorderVisible(true);
                    continue;
                }
                if (this.mUnits[i].getUser() != 0L) {
                    this.mUnits[i].removeUser();
                }
                this.mUnits[i].setBorderType(0);
                this.mUnits[i].clearRenderer();
                this.mUnits[i].setBorderVisible(true);
                this.mUnits[i].setBackgroundColor(-16777216);
                continue;
            }
            if (this.mUnits[i].getUser() != 0L) {
                this.mUnits[i].removeUser();
                this.mUnits[i].setBorderType(0);
                this.mUnits[i].clearRenderer();
            }
            this.mUnits[i].setBorderVisible(false);
            this.mUnits[i].setBackgroundColor(0);
        }
        if (!this.isPreloadStatus()) {
            this.updateSwitchScenePanel();
        }
    }

    private RendererUnitInfo createVideoUnitInfo(int index) {
        int countLastRow;
        boolean isLastRow;
        double t;
        double l;
        double w;
        double h;
        if (this.mLayoutInfo == null || !this.mLayoutInfo.isValid()) {
            return null;
        }
        int rowsCount = this.mLayoutInfo.rows;
        int colsCount = this.mLayoutInfo.cols;
        int unitsGap = UIUtil.dip2px((Context)this.getConfActivity(), (float)2.0f);
        double cellWidth = this.mLayoutInfo.unitWidth;
        double cellHeight = this.mLayoutInfo.unitHeight;
        double totalCellsWidth = cellWidth * (double)colsCount + (double)(unitsGap * (colsCount - 1));
        double totalCellsHeight = cellHeight * (double)rowsCount + (double)(unitsGap * (rowsCount - 1));
        int bottomHeight = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        double xWallOffset = ((double)this.getWidth() - totalCellsWidth) * 1.0 / 2.0;
        double yWallOffset = ((double)(this.getHeight() - bottomHeight) - totalCellsHeight) * 1.0 / 2.0;
        int rowIdx = index / colsCount;
        int colIdx = index % colsCount;
        double xCellOffset = xWallOffset + (double)colIdx * cellWidth + (double)(colIdx * unitsGap);
        double yCellOffset = yWallOffset + (double)rowIdx * cellHeight + (double)(rowIdx * unitsGap);
        VideoSize size = new VideoSize(16, 9);
        if (cellWidth * (double)size.height > (double)size.width * cellHeight) {
            h = cellHeight;
            w = h * (double)size.width * 1.0 / (double)size.height;
            l = xCellOffset + (cellWidth - w) * 1.0 / 2.0;
            t = yCellOffset;
        } else {
            w = cellWidth;
            h = w * (double)size.height * 1.0 / (double)size.width;
            l = xCellOffset;
            t = yCellOffset + (cellHeight - h) * 1.0 / 2.0;
        }
        int pageSize = this.mLayoutInfo.rows * this.mLayoutInfo.cols;
        int countPages = (this.mCountVideoUsers + pageSize - 1) / pageSize;
        boolean isLastPage = countPages == this.getPageIndex() + 1;
        boolean bl = isLastRow = index / this.mLayoutInfo.cols == this.mLayoutInfo.rows - 1;
        if (isLastPage && isLastRow && (countLastRow = this.mCountVideoUsers % this.mLayoutInfo.cols) != 0) {
            double totalWidth = (double)countLastRow * cellWidth + (double)((countLastRow - 1) * unitsGap);
            l -= xWallOffset;
            l += ((double)this.getWidth() - totalWidth) / 2.0;
        }
        return new RendererUnitInfo(Math.round((float)((double)this.getLeft() + l)), Math.round((float)((double)this.getTop() + t)), Math.round((float)w), Math.round((float)h));
    }

    private String getLogTag() {
        return this.TAG + "[" + this.mPageIndex + "]";
    }

    private void updateSwitchScenePanel() {
        if (this.isVideoPaused()) {
            return;
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        LinearLayout panelSwitchSceneButtons = (LinearLayout)activity.findViewById(R.id.panelSwitchSceneButtons);
        this.mSwitchSceneButtons = new ImageButton[10];
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int sceneCount = sceneMgr.getSceneCount();
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        panelSwitchSceneButtons.removeAllViews();
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            this.mSwitchSceneButtons[i] = new ImageButton((Context)activity);
            this.mSwitchSceneButtons[i].setBackgroundColor(0);
            this.mSwitchSceneButtons[i].setImageResource(i == this.getPageIndex() + basicSceneCount ? R.drawable.zm_btn_switch_scene_selected : R.drawable.zm_btn_switch_scene_unselected);
            this.mSwitchSceneButtons[i].setVisibility(i < sceneCount ? 0 : 8);
            this.mSwitchSceneButtons[i].setOnClickListener((View.OnClickListener)this);
            this.mSwitchSceneButtons[i].setContentDescription((CharSequence)(i == this.getPageIndex() + basicSceneCount ? this.getConfActivity().getString(R.string.zm_description_scene_gallery_video) : ((VideoSceneMgr)this.getVideoSceneMgr()).getAccessibliltyDescriptionSceneSwitch(i)));
            panelSwitchSceneButtons.addView((View)this.mSwitchSceneButtons[i], UIUtil.dip2px((Context)activity, (float)20.0f), UIUtil.dip2px((Context)activity, (float)40.0f));
        }
        this.positionSwitchScenePanel();
        panelSwitchScene.setVisibility(sceneCount <= 0 ? 4 : 0);
    }

    private void positionSwitchScenePanel() {
        int top = this.getHeight() - UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (UIUtil.isPortraitMode((Context)this.getConfActivity())) {
            top -= UIUtil.dip2px((Context)this.getConfActivity(), (float)5.0f);
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        panelSwitchScene.setPadding(0, top, 0, 0);
        panelSwitchScene.getParent().requestLayout();
    }

    public void onClick(View v) {
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            if (this.mSwitchSceneButtons[i] != v) continue;
            this.switchToScene(i);
        }
    }

    private void switchToScene(int i) {
        VideoSceneMgr sceneMgr = (VideoSceneMgr)this.getVideoSceneMgr();
        if (sceneMgr == null) {
            return;
        }
        int basicSceneCount = sceneMgr.getBasicSceneCount();
        if (i == this.getPageIndex() + basicSceneCount) {
            return;
        }
        this.getVideoSceneMgr().switchToScene(i);
    }

    @Override
    protected void onResumeVideo() {
        this.updateContentSubscription();
        this.updateSwitchScenePanel();
    }

    @Override
    public void onMyVideoStatusChanged() {
    }

    private void updateSwitchCameraButton() {
        if (this.mGLBtnSwitchCamera == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        RendererUnitInfo unitInfo = this.createSwitchCameraButtonUnitInfo();
        if (unitInfo != null) {
            this.mGLBtnSwitchCamera.updateUnitInfo(unitInfo);
        }
    }

    private RendererUnitInfo createSwitchCameraButtonUnitInfo() {
        return this.createSwitchCameraButtonUnitInfo(null);
    }

    private RendererUnitInfo createSwitchCameraButtonUnitInfo(Drawable background) {
        int h;
        int w;
        if (this.mUnits == null || this.mUnits.length == 0 || this.mUnits[0] == null) {
            return null;
        }
        if (background == null && this.mGLBtnSwitchCamera != null) {
            background = this.mGLBtnSwitchCamera.getBackgroundDrawable();
        }
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        int margin = UIUtil.dip2px((Context)this.getConfActivity(), (float)2.0f);
        int x = this.mUnits[0].getLeft() + this.mUnits[0].getWidth() - w - margin;
        int y = this.mUnits[0].getTop() + margin;
        return new RendererUnitInfo(x, y, w, h);
    }

    @Override
    public void onClick(GLButton button) {
        this.getConfActivity().onClickSwitchCamera();
    }

    public void checkGalleryUnits(int width, int height) {
        if (this.getUnitsCount() == 0) {
            this.stop();
            this.destroy();
            this.create(width, height);
            this.setLocation(0, 0);
            this.start();
        }
    }

    static class LayoutInfo {
        int cols;
        int rows;
        int unitWidth;
        int unitHeight;

        public LayoutInfo() {
        }

        public LayoutInfo(int cols, int rows, int unitWidth, int unitHeight) {
            this.cols = cols;
            this.rows = rows;
            this.unitWidth = unitWidth;
            this.unitHeight = unitHeight;
        }

        public LayoutInfo(LayoutInfo info) {
            this.cols = info.cols;
            this.rows = info.rows;
            this.unitWidth = info.unitWidth;
            this.unitHeight = info.unitHeight;
        }

        public boolean isValid() {
            return this.rows > 0 && this.cols > 0 && this.unitWidth > 0 && this.unitHeight > 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LayoutInfo)) {
                return false;
            }
            LayoutInfo info = (LayoutInfo)o;
            return this.cols == info.cols && this.rows == info.rows && this.unitWidth == info.unitWidth && this.unitHeight == info.unitHeight;
        }
    }
}

