/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmAudioStatus;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.GLButton;
import com.zipow.videobox.confapp.GLImage;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.TextDrawable;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.AbsVideoSceneMgr;
import com.zipow.videobox.view.video.VideoRenderer;
import com.zipow.videobox.view.video.VideoSceneMgr;
import java.util.List;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class DriverModeVideoScene
extends AbsVideoScene
implements View.OnClickListener,
GLImage.OnClickListener,
GLButton.OnClickListener,
HeadsetUtil.IHeadsetConnectionListener {
    private static final String TAG = DriverModeVideoScene.class.getSimpleName();
    private static final int SPEAKER_NAME_DISPLAY_TIMEOUT = 2000;
    private static int MESSAGE_TEXT_COLOR_MUTED;
    private static int MESSAGE_TEXT_COLOR_UNMUTED;
    private static int TITLE_TEXT_COLOR;
    private static int LINE_COLOR;
    private static int BTN_TAP_SPEAK_TEXT_COLOR;
    private static int BTN_DONE_SPEAK_TEXT_COLOR;
    private static int ACTIVE_SPEAKER_TEXT_COLOR;
    private static int TITLE_MARGIN_TOP;
    private static int TITLE_MARGIN_TOP_FOR_TRANSLUCENT_STATUS;
    private static final int TEXT_PADDING_VERTICAL = 2;
    private static final int TITLE_TEXT_SIZE = 48;
    private static final int MESSAGE_TEXT_SIZE = 16;
    private static final int TITLE_TOP_MARGIN_PORTRAIT = 15;
    private static final int TITLE_TOP_MARGIN_LANDSCAPE = 2;
    private static final int TITLE_HORIZONTAL_MARGIN_MIN = 160;
    private static final int TITLE_LINE_GAP = 3;
    private static final int MESSAGES_GAP = 3;
    private static final int LINE_BOTTOM_SPACE_PORTRAIT = 50;
    private static final int LINE_BOTTOM_SPACE_LANDSCAPE = 5;
    private static final int LINE_BUTTON_GAP_MIN = 10;
    private static final int LINE_STROKE = 1;
    private static final int BTN_SIZE = 170;
    private static final int BTN_TEXT_SIZE = 30;
    private static final int ACTIVE_SPEAKER_TEXT_SIZE = 16;
    private static final int ACTIVE_SPEAKER_BOTTOM_MAX_MARGIN = 60;
    private static final int INDEX_ACCESSIBILITY_VIEW_LEAVE = 0;
    private static final int INDEX_ACCESSIBILITY_VIEW_AUDIO_SOURCE = 1;
    private ImageButton[] mSwitchSceneButtons;
    private GLImage mGLBtnMuteUnmute;
    private GLImage mGLImgTitle;
    private GLImage mGLImgAudioMessage;
    private GLImage mGLImgVideoMessage;
    private GLImage mGLImgLine;
    private GLImage mGLImgActiveSpeaker;
    private GLButton mGLBtnSwitchAudioSource;
    private GLButton mGLBtnLeave;
    private Bitmap mTitleBitmap;
    private Bitmap mLineBitmap;
    private Bitmap mAudioMessageBitmap;
    private Bitmap mVideoMessageBitmap;
    private Bitmap mMuteUnmuteBtnBitmap;
    private Bitmap mActiveSpeakerBitmap;
    private Drawable mDrawableSwitchAudioSource;
    private Drawable mDrawableBtnLeave;
    private int mResIdSwitchAudioSource = 0;
    private TextPaint mTitleTextPaint;
    private TextPaint mMessageTextPaint;
    private TextPaint mBtnTextPaint;
    private TextPaint mActiveSpeakerTextPaint;
    private Typeface mTypeface;
    private int mTitleTextHeight;
    private boolean mIsMicMuted = true;
    private String mActiveSpeakerName = null;
    private Handler mHandler = new Handler();
    private int mAudioSourceType = -1;
    private boolean mIsVoIP = false;
    private boolean mbUIMuteStatus = true;
    private long mlResumeTime = 0L;
    private boolean mIsHost = false;
    private boolean mbConnectAudioManual = false;
    private boolean mbVideoOnPrevDriveMode = false;
    private boolean mbPressed = false;
    private float mLastDownX = -1.0f;
    private float mLastDownY = -1.0f;
    private Runnable mRunnableHideActiveSpeaker = new Runnable(){

        @Override
        public void run() {
            if (DriverModeVideoScene.this.mGLImgActiveSpeaker == null) {
                return;
            }
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            if (videoMgr != null) {
                DriverModeVideoScene.this.mGLImgActiveSpeaker.setVisible(false);
                DriverModeVideoScene.this.mActiveSpeakerName = null;
            }
        }
    };

    public DriverModeVideoScene(AbsVideoSceneMgr sceneMgr) {
        super(sceneMgr);
        this.initDefaultResources();
    }

    public void setIsVideoOnPrevDrivingMode(boolean bOn) {
        this.mbVideoOnPrevDriveMode = bOn;
    }

    public void initDefaultResources() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        Resources res = context.getResources();
        if (res != null) {
            MESSAGE_TEXT_COLOR_MUTED = res.getColor(R.color.zm_white);
            MESSAGE_TEXT_COLOR_UNMUTED = res.getColor(R.color.zm_drivermode_text_color_highlight);
            TITLE_TEXT_COLOR = res.getColor(R.color.zm_white);
            LINE_COLOR = 0x37FFFFFF;
            BTN_TAP_SPEAK_TEXT_COLOR = res.getColor(R.color.zm_drivermode_text_color_highlight);
            BTN_DONE_SPEAK_TEXT_COLOR = res.getColor(R.color.zm_white);
            ACTIVE_SPEAKER_TEXT_COLOR = res.getColor(R.color.zm_white);
            TITLE_MARGIN_TOP_FOR_TRANSLUCENT_STATUS = UIUtil.getStatusBarHeight((Context)context);
        }
        this.mTitleTextPaint = new TextPaint();
        this.mTypeface = new TextView((Context)context).getTypeface();
        this.mTitleTextPaint.setTypeface(this.mTypeface);
        this.mTitleTextPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)48.0f));
        this.mTitleTextPaint.setColor(TITLE_TEXT_COLOR);
        this.mTitleTextPaint.setAntiAlias(true);
        Paint.FontMetrics fontMetrics = this.mTitleTextPaint.getFontMetrics();
        this.mTitleTextHeight = (int)(fontMetrics.bottom - fontMetrics.top) + UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)4.0f);
        this.mMessageTextPaint = new TextPaint();
        this.mMessageTextPaint.setTypeface(this.mTypeface);
        this.mMessageTextPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)16.0f));
        this.mMessageTextPaint.setAntiAlias(true);
        this.mBtnTextPaint = new TextPaint();
        this.mBtnTextPaint.setTypeface(this.mTypeface);
        this.mBtnTextPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)30.0f));
        this.mBtnTextPaint.setAntiAlias(true);
        this.mActiveSpeakerTextPaint = new TextPaint();
        this.mActiveSpeakerTextPaint.setTypeface(this.mTypeface);
        this.mActiveSpeakerTextPaint.setTextSize((float)UIUtil.sp2px((Context)VideoBoxApplication.getInstance(), (float)16.0f));
        this.mActiveSpeakerTextPaint.setColor(ACTIVE_SPEAKER_TEXT_COLOR);
        this.mActiveSpeakerTextPaint.setAntiAlias(true);
    }

    @Override
    protected void onCreateUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        this.createTitleImage(videoMgr);
        this.createLineImage(videoMgr);
        this.createAudioMessageImage(videoMgr);
        this.createVideoMessageImage(videoMgr);
        this.createMuteUnmuteButton(videoMgr);
        this.createActiveSpeakerImage(videoMgr);
        this.createSwitchAudioSourceButton(videoMgr);
        this.createLeaveButton(videoMgr);
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
        }
    }

    @Override
    protected void onUpdateUnits() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        ConfActivity confActivity = this.getConfActivity();
        TITLE_MARGIN_TOP = confActivity != null && confActivity.isImmersedModeEnabled() && UIUtil.isPortraitMode((Context)VideoBoxApplication.getInstance()) ? TITLE_MARGIN_TOP_FOR_TRANSLUCENT_STATUS : 0;
        this.updateTitleImage(videoMgr);
        this.updateLineImage(videoMgr);
        this.updateAudioMessageImage(videoMgr);
        this.updateVideoMessageImage(videoMgr);
        this.updateMuteUnmuteButton(videoMgr);
        this.updateActiveSpeakerImage(videoMgr);
        this.updateSwitchAudioSourceButton();
        this.updateLeaveButton();
        if (this.isVisible()) {
            this.positionSwitchScenePanel();
            this.updateAccessibilitySceneDescription();
        }
    }

    @Override
    protected void onDestroyUnits() {
        this.mGLBtnMuteUnmute = null;
        this.mGLImgTitle = null;
        this.mGLImgAudioMessage = null;
        this.mGLImgVideoMessage = null;
        this.mGLImgLine = null;
        this.mGLImgActiveSpeaker = null;
        this.mGLBtnSwitchAudioSource = null;
        this.mGLBtnLeave = null;
        this.mTitleBitmap = null;
        this.mLineBitmap = null;
        this.mActiveSpeakerBitmap = null;
        this.mAudioMessageBitmap = null;
        this.mVideoMessageBitmap = null;
        this.mMuteUnmuteBtnBitmap = null;
        this.mDrawableSwitchAudioSource = null;
        this.mDrawableBtnLeave = null;
        this.mbVideoOnPrevDriveMode = false;
    }

    @Override
    protected void onStart() {
        this.updateSwitchScenePanel();
        if (this.isVideoPaused()) {
            return;
        }
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user != null) {
            CmmAudioStatus audioStatus = user.getAudioStatusObj();
            if (audioStatus != null) {
                this.mIsVoIP = audioStatus.getAudiotype() == 0L;
            }
            this.updateMyAudioStatus(user.getNodeId());
        }
        this.updateSwitchAudioSourceButton();
    }

    @Override
    protected void onStop() {
        this.mIsMicMuted = true;
        if (this.mGLBtnMuteUnmute != null) {
            Bitmap icon = this.getMuteButtonBitmap(true);
            this.mGLBtnMuteUnmute.setBackground(icon);
        }
        if (this.mRunnableHideActiveSpeaker != null) {
            this.mRunnableHideActiveSpeaker.run();
        }
    }

    @Override
    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        this.mTitleBitmap = null;
        this.mLineBitmap = null;
        this.mActiveSpeakerBitmap = null;
        this.mAudioMessageBitmap = null;
        this.mVideoMessageBitmap = null;
        this.mMuteUnmuteBtnBitmap = null;
        this.mDrawableSwitchAudioSource = null;
        this.mDrawableBtnLeave = null;
        super.onGLRendererChanged(renderer, width, height);
    }

    @Override
    public void onAutoStartVideo() {
        this.updateSwitchScenePanel();
    }

    @Override
    public void onUserEvent(int eventType, long userId, int flag) {
        if (this.isPreloadStatus()) {
            return;
        }
        this.updateSwitchScenePanel();
    }

    @Override
    public void onUserAudioStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            CmmAudioStatus audioStatus;
            CmmUser user = ConfMgr.getInstance().getMyself();
            if (user != null && (audioStatus = user.getAudioStatusObj()) != null) {
                boolean bl = this.mIsVoIP = audioStatus.getAudiotype() == 0L;
            }
            if (this.isVideoPaused()) {
                return;
            }
            this.updateMyAudioStatus(userId);
            this.updateSwitchAudioSourceButton();
        }
    }

    @Override
    public void onAudioTypeChanged(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            CmmUser user = ConfMgr.getInstance().getMyself();
            if (user != null) {
                CmmAudioStatus audioStatus = user.getAudioStatusObj();
                if (audioStatus != null) {
                    ConfActivity confActivity;
                    boolean bl = this.mIsVoIP = audioStatus.getAudiotype() == 0L;
                    if (this.mIsVoIP && audioStatus.getIsMuted() && (confActivity = this.getConfActivity()) != null && this.mbConnectAudioManual) {
                        confActivity.muteAudio(false);
                    }
                }
                this.mbConnectAudioManual = false;
            }
            if (this.isVideoPaused()) {
                return;
            }
            this.updateMyAudioStatus(userId);
            this.updateSwitchAudioSourceButton();
        }
    }

    private void updateMyAudioStatus(long userId) {
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        CmmConfStatus confStatus = confMgr.getConfStatusObj();
        if (confStatus == null) {
            return;
        }
        if (!confStatus.isMyself(userId)) {
            return;
        }
        CmmUser user = confMgr.getMyself();
        if (user == null) {
            return;
        }
        CmmAudioStatus audioStatus = user.getAudioStatusObj();
        if (audioStatus == null) {
            return;
        }
        boolean muted = audioStatus.getIsMuted();
        if (this.mIsMicMuted != muted) {
            this.mIsMicMuted = muted;
            this.mAudioMessageBitmap = null;
            this.mMuteUnmuteBtnBitmap = null;
            VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
            this.updateAudioMessageImage(videoMgr);
            this.updateVideoMessageImage(videoMgr);
            this.updateMuteUnmuteButton(videoMgr);
            this.updateActiveSpeakerImage(videoMgr);
            this.getVideoSceneMgr().announceAccessibilityAtActiveScene();
        }
    }

    @Override
    public void onUserActiveAudio(long userId) {
        VideoSessionMgr videoMgr;
        if (this.isVideoPaused()) {
            return;
        }
        ConfMgr confMgr = ConfMgr.getInstance();
        if (confMgr == null) {
            return;
        }
        String newSpeakerName = confMgr.getTalkingUserName();
        if (StringUtil.isEmptyOrNull((String)newSpeakerName)) {
            this.mActiveSpeakerName = null;
            return;
        }
        CmmUser myself = confMgr.getMyself();
        if (myself == null) {
            return;
        }
        if (newSpeakerName.contains(myself.getScreenName()) && this.isUIMuteStatus() && System.currentTimeMillis() - this.mlResumeTime < 3000L) {
            return;
        }
        if (StringUtil.isSameString((String)newSpeakerName, (String)this.mActiveSpeakerName)) {
            this.mHandler.removeCallbacks(this.mRunnableHideActiveSpeaker);
            this.mHandler.postDelayed(this.mRunnableHideActiveSpeaker, 2000L);
            return;
        }
        this.mActiveSpeakerName = newSpeakerName;
        if (this.mActiveSpeakerBitmap != null) {
            this.mActiveSpeakerBitmap = null;
        }
        if ((videoMgr = ConfMgr.getInstance().getVideoObj()) != null) {
            if (this.mGLImgActiveSpeaker == null) {
                return;
            }
            this.mGLImgActiveSpeaker.setVisible(true);
            this.updateActiveSpeakerImage(videoMgr);
        }
    }

    private boolean isUIMuteStatus() {
        return this.mbUIMuteStatus;
    }

    @Override
    public void onShareActiveUser(long userId) {
        this.updateSwitchScenePanel();
    }

    @Override
    public void onHostChanged(long userId, boolean isCurUserHost) {
        boolean oldIsHost = this.mIsHost;
        this.mIsHost = isCurUserHost;
        if (oldIsHost != this.mIsHost) {
            this.mDrawableBtnLeave = null;
            this.updateLeaveButton();
        }
    }

    @Override
    protected void onResumeVideo() {
        this.updateSwitchScenePanel();
        this.mlResumeTime = System.currentTimeMillis();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (DriverModeVideoScene.this.isVideoPaused() || !DriverModeVideoScene.this.isVisible() || !DriverModeVideoScene.this.isStarted()) {
                    return;
                }
                CmmUser user = ConfMgr.getInstance().getMyself();
                if (user != null) {
                    CmmAudioStatus audioStatus = user.getAudioStatusObj();
                    if (audioStatus != null) {
                        DriverModeVideoScene.this.mIsVoIP = audioStatus.getAudiotype() == 0L;
                    }
                    DriverModeVideoScene.this.updateMyAudioStatus(user.getNodeId());
                }
                DriverModeVideoScene.this.updateSwitchAudioSourceButton();
            }
        }, 300L);
    }

    @Override
    protected void onDraggingIn() {
        super.onDraggingIn();
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        this.setIsVideoOnPrevDrivingMode(confContext.isVideoOn());
        CmmUser user = ConfMgr.getInstance().getMyself();
        if (user != null) {
            boolean oldIsHost = this.mIsHost;
            this.mIsHost = user.isHost();
            if (oldIsHost != this.mIsHost) {
                this.mDrawableBtnLeave = null;
                this.updateLeaveButton();
            }
        }
    }

    @Override
    protected void onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
        this.updateSwitchScenePanel();
    }

    private void createMuteUnmuteButton(VideoSessionMgr videoMgr) {
        Bitmap drawable2 = this.getMuteButtonBitmap(true);
        RendererUnitInfo unitInfo = this.createMuteUnmuteButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnMuteUnmute = videoMgr.createGLImage(unitInfo);
            if (this.mGLBtnMuteUnmute != null) {
                this.mGLBtnMuteUnmute.setUnitName("MuteUnmuteButton");
                this.mGLBtnMuteUnmute.setVideoScene(this);
                this.addUnit(this.mGLBtnMuteUnmute);
                this.mGLBtnMuteUnmute.onCreate();
                this.mGLBtnMuteUnmute.setBackground(drawable2);
                this.mGLBtnMuteUnmute.setOnClickListener(this);
                this.mGLBtnMuteUnmute.setVisible(true);
            }
        }
    }

    private void updateMuteUnmuteButton(VideoSessionMgr videoMgr) {
        if (this.mGLBtnMuteUnmute == null) {
            return;
        }
        Bitmap drawable2 = this.getMuteButtonBitmap(false);
        RendererUnitInfo unitInfo = this.createMuteUnmuteButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnMuteUnmute.setBackground(drawable2);
            this.mGLBtnMuteUnmute.updateUnitInfo(unitInfo);
            this.mGLBtnMuteUnmute.setVisible(true);
            if (this.isVisible()) {
                String textSpeak = this.getConfActivity().getString(this.mIsMicMuted ? R.string.zm_description_tap_speak : R.string.zm_description_done_speaking);
                this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(textSpeak);
            }
        }
    }

    private void createTitleImage(VideoSessionMgr videoMgr) {
        Bitmap titleBitmap = this.getTitleImageBitmap();
        RendererUnitInfo unitInfo = this.createTitleImageUnitInfo(titleBitmap);
        if (unitInfo != null) {
            this.mGLImgTitle = videoMgr.createGLImage(unitInfo);
            if (this.mGLImgTitle != null) {
                this.mGLImgTitle.setUnitName("Title");
                this.mGLImgTitle.setVideoScene(this);
                this.addUnit(this.mGLImgTitle);
                this.mGLImgTitle.onCreate();
                this.mGLImgTitle.setBackground(titleBitmap);
                this.mGLImgTitle.setVisible(true);
            }
        }
    }

    private void updateTitleImage(VideoSessionMgr videoMgr) {
        if (this.mGLImgTitle == null) {
            return;
        }
        Bitmap titleBitmap = this.getTitleImageBitmap();
        RendererUnitInfo unitInfo = this.createTitleImageUnitInfo(titleBitmap);
        if (unitInfo != null) {
            this.mGLImgTitle.updateUnitInfo(unitInfo);
            this.mGLImgTitle.setVisible(true);
        }
    }

    private void createAudioMessageImage(VideoSessionMgr videoMgr) {
        Bitmap bitmap = this.getAudioMessageImageBitmap();
        RendererUnitInfo unitInfo = this.createAudioMessageImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgAudioMessage = videoMgr.createGLImage(unitInfo);
            if (this.mGLImgAudioMessage != null) {
                this.mGLImgAudioMessage.setUnitName("AudioMessage");
                this.mGLImgAudioMessage.setVideoScene(this);
                this.addUnit(this.mGLImgAudioMessage);
                this.mGLImgAudioMessage.onCreate();
                this.mGLImgAudioMessage.setBackground(bitmap);
                this.mGLImgAudioMessage.setVisible(true);
            }
        }
    }

    private void updateAudioMessageImage(VideoSessionMgr videoMgr) {
        if (this.mGLImgAudioMessage == null) {
            return;
        }
        Bitmap bitmap = this.getAudioMessageImageBitmap();
        RendererUnitInfo unitInfo = this.createAudioMessageImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgAudioMessage.setBackground(bitmap);
            this.mGLImgAudioMessage.updateUnitInfo(unitInfo);
            this.mGLImgAudioMessage.setVisible(true);
        }
    }

    private void createVideoMessageImage(VideoSessionMgr videoMgr) {
        Bitmap bitmap = this.getVideoMessageImageBitmap();
        RendererUnitInfo unitInfo = this.createVideoMessageImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgVideoMessage = videoMgr.createGLImage(unitInfo);
            if (this.mGLImgVideoMessage != null) {
                this.mGLImgVideoMessage.setUnitName("VideoMessage");
                this.mGLImgVideoMessage.setVideoScene(this);
                this.addUnit(this.mGLImgVideoMessage);
                this.mGLImgVideoMessage.onCreate();
                this.mGLImgVideoMessage.setBackground(bitmap);
                this.mGLImgVideoMessage.setVisible(this.mbVideoOnPrevDriveMode);
            }
        }
    }

    private void updateVideoMessageImage(VideoSessionMgr videoMgr) {
        if (this.mGLImgVideoMessage == null) {
            return;
        }
        Bitmap bitmap = this.getVideoMessageImageBitmap();
        RendererUnitInfo unitInfo = this.createVideoMessageImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgVideoMessage.setBackground(bitmap);
            this.mGLImgVideoMessage.updateUnitInfo(unitInfo);
            this.mGLImgVideoMessage.setVisible(this.mbVideoOnPrevDriveMode);
        }
    }

    private void createLineImage(VideoSessionMgr videoMgr) {
        this.mLineBitmap = this.getLineImageBitmap();
        RendererUnitInfo unitInfo = this.createLineImageUnitInfo(this.mLineBitmap);
        if (unitInfo != null) {
            this.mGLImgLine = videoMgr.createGLImage(unitInfo);
            if (this.mGLImgLine != null) {
                this.mGLImgLine.setUnitName("Line");
                this.mGLImgLine.setVideoScene(this);
                this.addUnit(this.mGLImgLine);
                this.mGLImgLine.onCreate();
                this.mGLImgLine.setBackground(this.mLineBitmap);
                this.mGLImgLine.setVisible(true);
            }
        }
    }

    private void updateLineImage(VideoSessionMgr videoMgr) {
        if (this.mGLImgLine == null) {
            return;
        }
        Bitmap bitmap = this.getLineImageBitmap();
        RendererUnitInfo unitInfo = this.createLineImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgLine.updateUnitInfo(unitInfo);
            this.mGLImgLine.setVisible(true);
        }
    }

    private void createActiveSpeakerImage(VideoSessionMgr videoMgr) {
        Bitmap bitmap = this.getActiveSpeakerImageBitmap();
        RendererUnitInfo unitInfo = this.createActiveSpeakerImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgActiveSpeaker = videoMgr.createGLImage(unitInfo);
            if (this.mGLImgActiveSpeaker != null) {
                this.mGLImgActiveSpeaker.setUnitName("ActiveSpeaker");
                this.mGLImgActiveSpeaker.setVideoScene(this);
                this.addUnit(this.mGLImgActiveSpeaker);
                this.mGLImgActiveSpeaker.onCreate();
                this.mGLImgActiveSpeaker.setBackground(bitmap);
                this.mGLImgActiveSpeaker.setVisible(bitmap != null);
                if (this.mGLImgActiveSpeaker.isVisible()) {
                    this.mHandler.removeCallbacks(this.mRunnableHideActiveSpeaker);
                    this.mHandler.postDelayed(this.mRunnableHideActiveSpeaker, 2000L);
                }
            }
        }
    }

    private void updateActiveSpeakerImage(VideoSessionMgr videoMgr) {
        if (this.mGLImgActiveSpeaker == null) {
            return;
        }
        Bitmap bitmap = this.getActiveSpeakerImageBitmap();
        RendererUnitInfo unitInfo = this.createActiveSpeakerImageUnitInfo(bitmap);
        if (unitInfo != null) {
            this.mGLImgActiveSpeaker.setBackground(bitmap);
            this.mGLImgActiveSpeaker.updateUnitInfo(unitInfo);
        }
        if (this.mGLImgActiveSpeaker.isVisible()) {
            this.mHandler.removeCallbacks(this.mRunnableHideActiveSpeaker);
            this.mHandler.postDelayed(this.mRunnableHideActiveSpeaker, 2000L);
        }
    }

    private Bitmap getMuteButtonBitmap(boolean bSetUIMuteStatus) {
        int h;
        if (this.mMuteUnmuteBtnBitmap != null) {
            return this.mMuteUnmuteBtnBitmap;
        }
        Drawable drawable2 = this.getConfActivity().getResources().getDrawable(this.mIsMicMuted ? R.drawable.zm_btn_tap_speak_normal : R.drawable.zm_btn_done_speak_normal);
        int w = h = UIUtil.dip2px((Context)this.getConfActivity(), (float)170.0f);
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, w - 1, h - 1);
        drawable2.draw(canvas);
        String text = this.mIsMicMuted ? this.getConfActivity().getString(R.string.zm_btn_tap_speak) : this.getConfActivity().getString(R.string.zm_btn_done_speak);
        this.mBtnTextPaint.setColor(this.mIsMicMuted ? BTN_TAP_SPEAK_TEXT_COLOR : BTN_DONE_SPEAK_TEXT_COLOR);
        float desiredWidth = StaticLayout.getDesiredWidth((CharSequence)text, (TextPaint)this.mBtnTextPaint);
        int width = (int)(desiredWidth + 0.5f);
        int marginMin = UIUtil.dip2px((Context)this.getConfActivity(), (float)10.0f);
        if (w < width + marginMin) {
            width = w - marginMin;
        }
        StaticLayout layout2 = new StaticLayout((CharSequence)text, this.mBtnTextPaint, width, Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        int height = layout2.getHeight();
        int y = (h - height) / 2;
        int x = (w - width) / 2;
        canvas.save();
        canvas.translate((float)x, (float)y);
        layout2.draw(canvas);
        canvas.restore();
        if (bSetUIMuteStatus) {
            this.mbUIMuteStatus = this.mIsMicMuted;
        }
        this.mMuteUnmuteBtnBitmap = bitmap;
        return bitmap;
    }

    private RendererUnitInfo createMuteUnmuteButtonUnitInfo(Bitmap background) {
        int lineBtnGapMin;
        int bottomLine;
        GLImage aboveGLImg;
        int h;
        int w = h = UIUtil.dip2px((Context)this.getConfActivity(), (float)170.0f);
        int x = this.getLeft() + (this.getWidth() - w) / 2;
        int y = this.getTop() + (this.getHeight() - h) / 2;
        GLImage gLImage = aboveGLImg = this.mbVideoOnPrevDriveMode ? this.mGLImgVideoMessage : this.mGLImgAudioMessage;
        if (aboveGLImg != null && y < (bottomLine = aboveGLImg.getBottom()) + (lineBtnGapMin = UIUtil.dip2px((Context)this.getConfActivity(), (float)10.0f))) {
            y = bottomLine + lineBtnGapMin;
        }
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private Bitmap getTitleImageBitmap() {
        if (this.mTitleBitmap != null) {
            return this.mTitleBitmap;
        }
        String text = this.getConfActivity().getString(R.string.zm_msg_driving_mode_title);
        this.mTitleBitmap = this.createTextBmp(text, 0, this.mTitleTextPaint, this.mTitleTextHeight);
        return this.mTitleBitmap;
    }

    private RendererUnitInfo createTitleImageUnitInfo(Bitmap bitmap) {
        int wScene = this.getWidth();
        int wBitmap = bitmap.getWidth();
        int hBitmap = bitmap.getHeight();
        int w = wScene < wBitmap ? wScene : wBitmap;
        int marginMin = UIUtil.dip2px((Context)this.getConfActivity(), (float)160.0f);
        if (wScene - wBitmap < marginMin) {
            w = wScene - marginMin;
        }
        int h = hBitmap * w / wBitmap;
        boolean isPortrait = UIUtil.isPortraitMode((Context)this.getConfActivity());
        int x = this.getLeft() + (this.getWidth() - w) / 2;
        int y = this.getTop() + TITLE_MARGIN_TOP + UIUtil.dip2px((Context)this.getConfActivity(), (float)(isPortrait ? 15.0f : 2.0f));
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private Bitmap getAudioMessageImageBitmap() {
        if (this.mAudioMessageBitmap != null) {
            return this.mAudioMessageBitmap;
        }
        String text = this.getConfActivity().getString(this.mIsMicMuted ? R.string.zm_msg_driving_mode_message_muted : R.string.zm_msg_driving_mode_message_unmuted);
        this.mMessageTextPaint.setColor(this.mIsMicMuted ? MESSAGE_TEXT_COLOR_MUTED : MESSAGE_TEXT_COLOR_UNMUTED);
        this.mAudioMessageBitmap = this.createMultiLineTextBmp(text, this.mMessageTextPaint, this.getWidth(), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        return this.mAudioMessageBitmap;
    }

    private RendererUnitInfo createAudioMessageImageUnitInfo(Bitmap bitmap) {
        if (this.mGLImgLine == null) {
            return null;
        }
        int yOffset = this.mGLImgLine.getBottom();
        int wScene = this.getWidth();
        int wBitmap = bitmap.getWidth();
        int hBitmap = bitmap.getHeight();
        int w = wScene < wBitmap ? wScene : wBitmap;
        int h = hBitmap * w / wBitmap;
        boolean isPortrait = UIUtil.isPortraitMode((Context)this.getConfActivity());
        int x = this.getLeft() + (this.getWidth() - w) / 2;
        int y = yOffset + UIUtil.dip2px((Context)this.getConfActivity(), (float)(isPortrait ? 50.0f : 5.0f));
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private Bitmap getVideoMessageImageBitmap() {
        if (this.mVideoMessageBitmap != null) {
            return this.mVideoMessageBitmap;
        }
        String text = this.getConfActivity().getString(R.string.zm_msg_driving_mode_message_video_stopped);
        this.mMessageTextPaint.setColor(MESSAGE_TEXT_COLOR_MUTED);
        this.mVideoMessageBitmap = this.createMultiLineTextBmp(text, this.mMessageTextPaint, this.getWidth(), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        return this.mVideoMessageBitmap;
    }

    private RendererUnitInfo createVideoMessageImageUnitInfo(Bitmap bitmap) {
        if (this.mGLImgAudioMessage == null) {
            return null;
        }
        int yOffset = this.mGLImgAudioMessage.getBottom();
        int wScene = this.getWidth();
        int wBitmap = bitmap.getWidth();
        int hBitmap = bitmap.getHeight();
        int w = wScene < wBitmap ? wScene : wBitmap;
        int h = hBitmap * w / wBitmap;
        int x = this.getLeft() + (this.getWidth() - w) / 2;
        int y = yOffset + UIUtil.dip2px((Context)this.getConfActivity(), (float)3.0f);
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private Bitmap getLineImageBitmap() {
        if (this.mLineBitmap != null) {
            return this.mLineBitmap;
        }
        int w = 16;
        int h = UIUtil.dip2px((Context)this.getConfActivity(), (float)1.0f);
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(LINE_COLOR);
        return bitmap;
    }

    private RendererUnitInfo createLineImageUnitInfo(Bitmap bitmap) {
        if (this.mGLImgTitle == null) {
            return null;
        }
        int yOffset = this.mGLImgTitle.getBottom();
        int w = this.getWidth();
        int h = UIUtil.dip2px((Context)this.getConfActivity(), (float)1.0f);
        int x = this.getLeft();
        int y = yOffset + UIUtil.dip2px((Context)this.getConfActivity(), (float)3.0f);
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private Bitmap getActiveSpeakerImageBitmap() {
        if (StringUtil.isEmptyOrNull((String)this.mActiveSpeakerName)) {
            return null;
        }
        if (this.mActiveSpeakerBitmap != null) {
            return this.mActiveSpeakerBitmap;
        }
        String text = this.getConfActivity().getString(R.string.zm_msg_xxx_is_speaking, new Object[]{this.mActiveSpeakerName});
        this.mActiveSpeakerBitmap = this.createMultiLineTextBmp(text, this.mActiveSpeakerTextPaint, this.getWidth(), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
        return this.mActiveSpeakerBitmap;
    }

    private RendererUnitInfo createActiveSpeakerImageUnitInfo(Bitmap bitmap) {
        if (bitmap == null) {
            return new RendererUnitInfo(Integer.MIN_VALUE, 0, 16, 16);
        }
        if (this.mGLBtnMuteUnmute == null) {
            return null;
        }
        int totalWidth = this.getWidth();
        int totalHeight = this.getHeight();
        int yOffset = this.mGLBtnMuteUnmute.getBottom() - this.getTop();
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int bottomMaxMargin = UIUtil.dip2px((Context)this.getConfActivity(), (float)60.0f);
        int dotsHeight = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (UIUtil.isPortraitMode((Context)this.getConfActivity())) {
            dotsHeight += UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        }
        int y = 0;
        y = ((totalHeight -= dotsHeight) - yOffset - h) / 2 > bottomMaxMargin ? totalHeight - bottomMaxMargin + this.getTop() : yOffset + (totalHeight - yOffset - h) / 2 + this.getTop();
        int x = (totalWidth - w) / 2 + this.getLeft();
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private void createSwitchAudioSourceButton(VideoSessionMgr videoMgr) {
        Drawable drawable2 = this.getSwitchAudioSourceButtonDrawable();
        RendererUnitInfo unitInfo = this.createSwitchAudioSourceButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnSwitchAudioSource = videoMgr.createGLButton(unitInfo);
            if (this.mGLBtnSwitchAudioSource != null) {
                this.mGLBtnSwitchAudioSource.setUnitName("SwitchAudioSource");
                this.mGLBtnSwitchAudioSource.setVideoScene(this);
                this.addUnit(this.mGLBtnSwitchAudioSource);
                this.mGLBtnSwitchAudioSource.onCreate();
                this.mGLBtnSwitchAudioSource.setBackground(drawable2);
                this.mGLBtnSwitchAudioSource.setOnClickListener(this);
                this.mGLBtnSwitchAudioSource.setVisible(!this.getConfActivity().isToolbarShowing() && this.getConfActivity().canSwitchAudioSource());
            }
        }
    }

    private Drawable getSwitchAudioSourceButtonDrawable() {
        Drawable drawable2 = null;
        int audioSourceType = ConfUI.getInstance().getCurrentAudioSourceType();
        if (this.mAudioSourceType == audioSourceType && this.mGLBtnSwitchAudioSource != null && (drawable2 = this.mGLBtnSwitchAudioSource.getBackgroundDrawable()) != null) {
            return drawable2;
        }
        this.mAudioSourceType = audioSourceType;
        int resId = R.drawable.zm_ic_speaker_off;
        switch (this.mAudioSourceType) {
            case 0: {
                resId = R.drawable.zm_ic_speaker_on;
                break;
            }
            case 3: {
                resId = R.drawable.zm_ic_current_bluetooth;
                break;
            }
            case 1: {
                resId = R.drawable.zm_ic_speaker_off;
                break;
            }
            case 2: {
                resId = R.drawable.zm_ic_current_headset;
            }
        }
        if (this.mResIdSwitchAudioSource == resId && this.mDrawableSwitchAudioSource != null) {
            return this.mDrawableSwitchAudioSource;
        }
        this.mDrawableSwitchAudioSource = drawable2 = this.getConfActivity().getResources().getDrawable(resId);
        this.mResIdSwitchAudioSource = resId;
        return drawable2;
    }

    private void updateSwitchAudioSourceButton() {
        if (this.mGLBtnSwitchAudioSource == null) {
            return;
        }
        if (!this.getConfActivity().canSwitchAudioSource()) {
            this.mGLBtnSwitchAudioSource.setVisible(false);
            this.getVideoSceneMgr().onAccessibilityViewUpdated(1);
            return;
        }
        Drawable drawable2 = this.getSwitchAudioSourceButtonDrawable();
        RendererUnitInfo unitInfo = this.createSwitchAudioSourceButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnSwitchAudioSource.setBackground(drawable2);
            this.mGLBtnSwitchAudioSource.updateUnitInfo(unitInfo);
            this.mGLBtnSwitchAudioSource.setVisible(!this.getConfActivity().isToolbarShowing() && this.mIsVoIP);
        }
        this.getVideoSceneMgr().onAccessibilityViewUpdated(1);
        this.getVideoSceneMgr().announceAccessibilityAtView(1);
    }

    private RendererUnitInfo createSwitchAudioSourceButtonUnitInfo(Drawable background) {
        int h;
        int w;
        if (background == null && this.mGLBtnSwitchAudioSource != null) {
            background = this.mGLBtnSwitchAudioSource.getBackgroundDrawable();
        }
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        int margin = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        boolean isPortrait = UIUtil.isPortraitMode((Context)this.getConfActivity());
        int x = this.getLeft() + margin;
        int y = this.getTop() + TITLE_MARGIN_TOP + UIUtil.dip2px((Context)this.getConfActivity(), (float)(isPortrait ? 15.0f : 2.0f));
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private void createLeaveButton(VideoSessionMgr videoMgr) {
        Drawable drawable2 = this.getLeaveButtonDrawable();
        RendererUnitInfo unitInfo = this.createLeaveButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnLeave = videoMgr.createGLButton(unitInfo);
            if (this.mGLBtnLeave != null) {
                this.mGLBtnLeave.setUnitName("LeaveButton");
                this.mGLBtnLeave.setVideoScene(this);
                this.addUnit(this.mGLBtnLeave);
                this.mGLBtnLeave.onCreate();
                this.mGLBtnLeave.setBackground(drawable2);
                this.mGLBtnLeave.setOnClickListener(this);
            }
        }
    }

    private Drawable getLeaveButtonDrawable() {
        if (this.mDrawableBtnLeave != null) {
            return this.mDrawableBtnLeave;
        }
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        String text = context.getString(this.mIsHost ? R.string.zm_btn_end_meeting : R.string.zm_btn_leave_meeting);
        Typeface typeface = new TextView((Context)context).getTypeface();
        int colorNormal = context.getResources().getColor(R.color.zm_warn);
        int colorPressed = context.getResources().getColor(R.color.zm_warn_pressed);
        int paddingTopBottom = UIUtil.dip2px((Context)context, (float)5.0f);
        final TextDrawable drawableNormal = new TextDrawable((Context)context, text, typeface, UIUtil.sp2px((Context)context, (float)18.0f), colorNormal);
        TextDrawable drawablePressed = new TextDrawable((Context)context, text, typeface, UIUtil.sp2px((Context)context, (float)18.0f), colorPressed);
        drawableNormal.setPadding(0, paddingTopBottom, 0, paddingTopBottom);
        drawablePressed.setPadding(0, paddingTopBottom, 0, paddingTopBottom);
        StateListDrawable drawable2 = new StateListDrawable(){

            public int getIntrinsicWidth() {
                return drawableNormal.getIntrinsicWidth();
            }

            public int getIntrinsicHeight() {
                return drawableNormal.getIntrinsicHeight();
            }
        };
        drawable2.addState(new int[]{16842910, -16842919}, (Drawable)drawableNormal);
        drawable2.addState(new int[]{16842910, 16842919}, (Drawable)drawablePressed);
        this.mDrawableBtnLeave = drawable2;
        return this.mDrawableBtnLeave;
    }

    private RendererUnitInfo createLeaveButtonUnitInfo(Drawable background) {
        int h;
        int w;
        if (background == null && this.mGLBtnLeave != null) {
            background = this.mGLBtnLeave.getBackgroundDrawable();
        }
        if (background != null) {
            w = background.getIntrinsicWidth();
            h = background.getIntrinsicHeight();
        } else {
            w = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
            h = UIUtil.dip2px((Context)this.getConfActivity(), (float)45.0f);
        }
        int marginRight = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        int marginTop = UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f) + TITLE_MARGIN_TOP;
        int top = this.getTop() + marginTop;
        int x = this.getRight() - w - marginRight;
        int y = top;
        RendererUnitInfo unitInfo = new RendererUnitInfo(x, y, w, h);
        return unitInfo;
    }

    private void updateLeaveButton() {
        if (this.mGLBtnLeave == null) {
            return;
        }
        Drawable drawable2 = this.getLeaveButtonDrawable();
        RendererUnitInfo unitInfo = this.createLeaveButtonUnitInfo(drawable2);
        if (unitInfo != null) {
            this.mGLBtnLeave.updateUnitInfo(unitInfo);
            this.mGLBtnLeave.setBackground(drawable2);
        }
        this.getVideoSceneMgr().onAccessibilityViewUpdated(0);
    }

    private Bitmap createTextBmp(String text, int paddingLeft, TextPaint textPaint, int height) {
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        int horizontalPadding = UIUtil.dip2px((Context)VideoBoxApplication.getInstance(), (float)6.0f);
        int textWidth = (int)textPaint.measureText(text);
        int width = textWidth + horizontalPadding + paddingLeft;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Paint paint = new Paint();
        paint.setColor(-16777216);
        canvas.drawRect(rect, paint);
        canvas.drawText(text, (float)(paddingLeft + horizontalPadding / 2), (float)(canvas.getHeight() / 2) - ((fontMetrics.bottom - fontMetrics.top) / 2.0f + fontMetrics.top), (Paint)textPaint);
        return bitmap;
    }

    private Bitmap createMultiLineTextBmp(CharSequence text, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        float desiredWidth = StaticLayout.getDesiredWidth((CharSequence)text, (TextPaint)paint);
        if ((float)width > desiredWidth) {
            width = (int)(desiredWidth + 0.5f);
        }
        StaticLayout layout2 = new StaticLayout(text, paint, width, align, spacingmult, spacingadd, includepad);
        int height = layout2.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        layout2.draw(canvas);
        return bitmap;
    }

    private void updateSwitchScenePanel() {
        if (this.isVideoPaused()) {
            return;
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        LinearLayout panelSwitchSceneButtons = (LinearLayout)activity.findViewById(R.id.panelSwitchSceneButtons);
        this.mSwitchSceneButtons = new ImageButton[10];
        int sceneCount = ((VideoSceneMgr)this.getVideoSceneMgr()).getSceneCount();
        panelSwitchSceneButtons.removeAllViews();
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            this.mSwitchSceneButtons[i] = new ImageButton((Context)activity);
            this.mSwitchSceneButtons[i].setBackgroundColor(0);
            this.mSwitchSceneButtons[i].setImageResource(i == 0 ? R.drawable.zm_btn_switch_scene_selected : R.drawable.zm_btn_switch_scene_unselected);
            this.mSwitchSceneButtons[i].setVisibility(i < sceneCount ? 0 : 8);
            this.mSwitchSceneButtons[i].setOnClickListener((View.OnClickListener)this);
            this.mSwitchSceneButtons[i].setContentDescription((CharSequence)(i == 0 ? this.getConfActivity().getString(R.string.zm_description_scene_driving) : ((VideoSceneMgr)this.getVideoSceneMgr()).getAccessibliltyDescriptionSceneSwitch(i)));
            panelSwitchSceneButtons.addView((View)this.mSwitchSceneButtons[i], UIUtil.dip2px((Context)activity, (float)20.0f), UIUtil.dip2px((Context)activity, (float)40.0f));
        }
        this.positionSwitchScenePanel();
        panelSwitchScene.setVisibility(sceneCount <= 1 ? 4 : 0);
    }

    private void positionSwitchScenePanel() {
        int top = this.getHeight() - UIUtil.dip2px((Context)this.getConfActivity(), (float)12.0f);
        if (UIUtil.isPortraitMode((Context)this.getConfActivity())) {
            top -= UIUtil.dip2px((Context)this.getConfActivity(), (float)22.0f);
        }
        ConfActivity activity = this.getConfActivity();
        View panelSwitchScene = activity.findViewById(R.id.panelSwitchScene);
        panelSwitchScene.setPadding(0, top, 0, 0);
        panelSwitchScene.getParent().requestLayout();
    }

    public void onClick(View v) {
        for (int i = 0; i < this.mSwitchSceneButtons.length; ++i) {
            if (this.mSwitchSceneButtons[i] != v) continue;
            this.switchToScene(i);
        }
    }

    private void switchToScene(int i) {
        if (i == 0) {
            return;
        }
        ((VideoSceneMgr)this.getVideoSceneMgr()).switchToScene(i);
    }

    @Override
    public void onClick(GLImage button) {
        if (button == this.mGLBtnMuteUnmute) {
            this.onClickBtnMuteUnmute();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        boolean res = super.onTouchEvent(e);
        if (res) {
            return true;
        }
        if (e == null) {
            return false;
        }
        if (e.getActionMasked() == 0) {
            this.mbPressed = true;
            this.mLastDownX = e.getX();
            this.mLastDownY = e.getY();
        } else if (e.getActionMasked() == 2) {
            float x = e.getX();
            float y = e.getY();
            float dx = x - this.mLastDownX;
            float dy = y - this.mLastDownY;
            float threshold = UIUtil.dip2px((Context)this.getConfActivity(), (float)5.0f);
            if (Math.abs(dx) >= threshold || Math.abs(dy) >= threshold) {
                this.mbPressed = false;
            }
        } else if (e.getActionMasked() == 1 && this.mbPressed) {
            this.mbPressed = false;
            this.onClickBtnMuteUnmute();
            return true;
        }
        return false;
    }

    private void onClickBtnMuteUnmute() {
        if (this.isAudioConnected()) {
            ConfActivity confActivity = this.getConfActivity();
            if (confActivity != null) {
                confActivity.muteAudio(!this.mIsMicMuted);
            }
        } else {
            this.mbConnectAudioManual = true;
            ConfActivity confActivity = this.getConfActivity();
            if (confActivity != null) {
                confActivity.onClickBtnAudio();
            }
        }
    }

    private boolean isAudioConnected() {
        CmmUser myself = ConfMgr.getInstance().getMyself();
        if (myself == null) {
            return false;
        }
        CmmAudioStatus audioStatus = myself.getAudioStatusObj();
        if (audioStatus == null) {
            return false;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        long audioType = audioStatus.getAudiotype();
        return 2L != audioType;
    }

    @Override
    public Rect getBoundsForAccessbilityViewIndex(int index) {
        switch (index) {
            case 0: {
                if (this.mGLBtnLeave == null) break;
                return new Rect(this.mGLBtnLeave.getLeft(), this.mGLBtnLeave.getTop(), this.mGLBtnLeave.getRight(), this.mGLBtnLeave.getBottom());
            }
            case 1: {
                if (this.mGLBtnSwitchAudioSource == null) break;
                return new Rect(this.mGLBtnSwitchAudioSource.getLeft(), this.mGLBtnSwitchAudioSource.getTop(), this.mGLBtnSwitchAudioSource.getRight(), this.mGLBtnSwitchAudioSource.getBottom());
            }
        }
        return new Rect();
    }

    @Override
    public int getAccessbilityViewIndexAt(float x, float y) {
        if (this.mGLBtnLeave != null && this.mGLBtnLeave.isVisible() && this.mGLBtnLeave.contains(x, y)) {
            return 0;
        }
        if (this.mGLBtnSwitchAudioSource != null && this.mGLBtnSwitchAudioSource.isVisible() && this.mGLBtnSwitchAudioSource.contains(x, y)) {
            return 1;
        }
        return -1;
    }

    private CharSequence getAudioSourceAccessibilityDescription() {
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        String text = "";
        switch (this.mAudioSourceType) {
            case 0: {
                text = context.getString(R.string.zm_description_btn_audio_source_speaker_phone);
                break;
            }
            case 3: {
                text = context.getString(R.string.zm_description_btn_audio_source_bluetooth);
                break;
            }
            case 1: {
                text = context.getString(R.string.zm_description_btn_audio_source_ear_phone);
                break;
            }
            case 2: {
                text = context.getString(R.string.zm_description_btn_audio_source_wired);
            }
        }
        return text;
    }

    @Override
    public CharSequence getAccessibilityDescriptionForIndex(int index) {
        switch (index) {
            case 0: {
                if (this.mGLBtnLeave == null || !this.mGLBtnLeave.isVisible()) break;
                VideoBoxApplication context = VideoBoxApplication.getInstance();
                String text = context.getString(this.mIsHost ? R.string.zm_btn_end_meeting : R.string.zm_btn_leave_meeting);
                return text;
            }
            case 1: {
                if (this.mGLBtnSwitchAudioSource == null || !this.mGLBtnSwitchAudioSource.isVisible()) break;
                return this.getAudioSourceAccessibilityDescription();
            }
        }
        return "";
    }

    @Override
    public void getAccessibilityVisibleVirtualViews(List<Integer> virtualViewIds) {
        if (this.mGLBtnLeave != null && this.mGLBtnLeave.isVisible()) {
            virtualViewIds.add(0);
        }
        if (this.mGLBtnSwitchAudioSource != null && this.mGLBtnSwitchAudioSource.isVisible()) {
            virtualViewIds.add(1);
        }
    }

    @Override
    public void updateAccessibilitySceneDescription() {
        if (this.getConfActivity() != null) {
            String contentDescription = this.getConfActivity().getString(R.string.zm_description_scene_driving);
            if (this.mbVideoOnPrevDriveMode) {
                contentDescription = contentDescription + this.getConfActivity().getString(R.string.zm_description_video_stopped);
            }
            contentDescription = contentDescription + this.getConfActivity().getString(this.mIsMicMuted ? R.string.zm_description_tap_speak : R.string.zm_description_done_speaking);
            this.getVideoSceneMgr().updateAccessibilityDescriptionForActiveScece(contentDescription);
        }
    }

    @Override
    public void onClick(GLButton button) {
        ConfActivity confActivity = this.getConfActivity();
        if (confActivity != null) {
            if (button == this.mGLBtnSwitchAudioSource) {
                ConfLocalHelper.switchAudio(confActivity, confActivity.getMyAudioType());
            } else if (button == this.mGLBtnLeave) {
                confActivity.onClickLeave();
            }
        }
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
        if (this.isVisible()) {
            this.updateSwitchAudioSourceButton();
        }
    }

    public void onBluetoothScoAudioStatus(boolean on) {
        if (this.isVisible()) {
            this.updateSwitchAudioSourceButton();
        }
    }

    static {
        TITLE_MARGIN_TOP = 0;
        TITLE_MARGIN_TOP_FOR_TRANSLUCENT_STATUS = 0;
    }
}

