/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.video;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ExploreByTouchHelper;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmConfStatus;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ConfUI;
import com.zipow.videobox.confapp.RendererUnitInfo;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.confapp.VideoSessionMgr;
import com.zipow.videobox.confapp.VideoUnit;
import com.zipow.videobox.view.video.AbsVideoScene;
import com.zipow.videobox.view.video.VideoRenderer;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.AccessibilityUtil;

public abstract class AbsVideoSceneMgr {
    private static final String TAG = AbsVideoSceneMgr.class.getSimpleName();
    protected List<AbsVideoScene> mSceneList = new ArrayList<AbsVideoScene>();
    protected VideoRenderer mRenderer;
    private ConfActivity mConfActivity;
    private VideoUnit mKeyVideoUnit;
    private long mActiveUserId = 0L;
    private long mActiveSpeakerId = 0L;
    private long mShareActiveUserId = 0L;
    private boolean mIsVideoShareInProgress = false;
    private long mLockedUserId = 0L;
    private boolean mbDestroyed = true;
    private boolean mbNetworkRestrictionMode = false;
    private VideoAccessibilityHelper mVideoAccessibilityHelper;
    private View mVideoView;

    public boolean isInShareVideoScene() {
        return false;
    }

    public boolean isInNormalVideoScene() {
        return false;
    }

    public boolean isInDriveModeScence() {
        return false;
    }

    public long getActiveUserId() {
        return this.mActiveUserId;
    }

    public void setActiveUserId(long id2) {
        this.mActiveUserId = id2;
    }

    public long getActiveSpeakerId() {
        return this.mActiveSpeakerId;
    }

    public long getShareActiveUserId() {
        return this.mShareActiveUserId;
    }

    public void setShareActiveUserId(long id2) {
        this.mShareActiveUserId = id2;
    }

    public boolean isVideoShareInProgress() {
        return this.mIsVideoShareInProgress;
    }

    public void setIsVideoShareInProgress(boolean b) {
        this.mIsVideoShareInProgress = b;
    }

    public void setLockedUserId(long userId) {
        this.mLockedUserId = userId;
        ConfUI.getInstance().setLockedUserId(this.mLockedUserId);
    }

    public long getLockedUserId() {
        return this.mLockedUserId;
    }

    public VideoRenderer getVideoRenderer() {
        return this.mRenderer;
    }

    public ConfActivity getConfActivity() {
        return this.mConfActivity;
    }

    public boolean isViewingSharing() {
        return false;
    }

    public boolean isDestroyed() {
        return this.mbDestroyed;
    }

    public void setVideoView(View v) {
        this.mVideoView = v;
    }

    public void onConfActivityCreated(ConfActivity confActivity) {
        this.mConfActivity = confActivity;
        if (confActivity != null) {
            this.mbNetworkRestrictionMode = confActivity.isNetworkRestrictionMode();
            if (this.mVideoView != null) {
                this.mVideoAccessibilityHelper = new VideoAccessibilityHelper(this.mVideoView);
                ViewCompat.setAccessibilityDelegate((View)this.mVideoView, (AccessibilityDelegateCompat)this.mVideoAccessibilityHelper);
            }
        }
    }

    public void onConfActivityResume(ConfActivity confActivity) {
        CmmConfStatus confStatus;
        this.mLockedUserId = ConfUI.getInstance().getLockedUserId();
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible()) continue;
            scene.start();
        }
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        long shareActiveUser = 0L;
        if (shareMgr != null) {
            shareActiveUser = shareMgr.getActiveUserID();
        }
        long activeVideo = ConfUI.getInstance().getActiveVideo();
        long activeSpeaker = ConfUI.getInstance().getActiveSpeaker();
        if (shareActiveUser != this.mShareActiveUserId && (confStatus = ConfMgr.getInstance().getConfStatusObj()) != null && !confStatus.isMyself(shareActiveUser)) {
            this.onShareActiveUser(shareActiveUser);
        }
        if (activeVideo != this.mActiveUserId) {
            this.onActiveVideoChanged(activeVideo);
        }
        if (activeSpeaker != this.mActiveSpeakerId) {
            this.onUserActiveVideoForDeck(activeSpeaker);
        }
    }

    public void onConfActivityPause(ConfActivity confActivity) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible()) continue;
            scene.stop();
        }
    }

    public void onConfUIRelayout(ConfActivity confActivity) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible()) continue;
            scene.onConfUIRelayout(confActivity);
        }
    }

    public void updateVisibleScenes() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible()) continue;
            scene.updateUnits();
        }
    }

    public void onGLRendererCreated(VideoRenderer renderer) {
        this.mRenderer = renderer;
    }

    public void onGLRendererChanged(VideoRenderer renderer, int width, int height) {
        this.mRenderer = renderer;
        this.mbDestroyed = false;
        if (this.mKeyVideoUnit == null) {
            this.createKeyVideoUnit();
        } else {
            this.mKeyVideoUnit.onGLViewSizeChanged(width, height);
        }
        this.beforeNotifyScenesGLRendererChanged(renderer, width, height);
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() && !scene.isCachedEnabled() && !scene.hasUnits() && !scene.isPreloadStatus()) continue;
            scene.onGLRendererChanged(renderer, width, height);
        }
    }

    protected void beforeNotifyScenesGLRendererChanged(VideoRenderer renderer, int width, int height) {
    }

    public void onGLRendererNeedDestroy() {
        this.destroyKeyVideoUnit();
        for (int i = 0; i < this.mSceneList.size(); ++i) {
            AbsVideoScene scene = this.mSceneList.get(i);
            if (scene.isVisible() || scene.hasUnits()) {
                scene.destroy();
            }
            if (!scene.isCachedEnabled()) continue;
            scene.destroyCachedUnits();
        }
        this.mbDestroyed = true;
    }

    public void onIdle() {
        for (int i = 0; i < this.mSceneList.size(); ++i) {
            AbsVideoScene scene = this.mSceneList.get(i);
            if (!scene.isVisible()) continue;
            scene.onIdle();
        }
    }

    public void onActiveVideoChanged(long userId) {
        if (this.getActiveUserId() == userId) {
            return;
        }
        this.setActiveUserId(userId);
        this.beforeNotifyScenesActiveVideoChanged(userId);
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onActiveVideoChanged(userId);
        }
    }

    public void onUserActiveVideoForDeck(long userId) {
        this.mActiveSpeakerId = userId;
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserActiveVideoForDeck(userId);
        }
        if (ConfMgr.getInstance().noOneIsSendingVideo()) {
            this.onActiveVideoChanged(userId);
        }
    }

    public void onUserTalkingVideo(long userId) {
        this.onUserActiveVideoForDeck(userId);
    }

    protected void beforeNotifyScenesActiveVideoChanged(long userId) {
    }

    public void onShareActiveUser(long userId) {
        this.setShareActiveUserId(userId);
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (shareMgr != null) {
            this.setIsVideoShareInProgress(shareMgr.isVideoSharingInProgress());
        }
        this.beforeNotifyScenesShareActiveUser(userId);
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onShareActiveUser(userId);
        }
    }

    protected void beforeNotifyScenesShareActiveUser(long userId) {
    }

    public void onShareUserReceivingStatus(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onShareUserReceivingStatus(userId);
        }
    }

    public void onShareUserSendingStatus(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onShareUserSendingStatus(userId);
        }
    }

    public void onShareDataSizeChanged(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onShareDataSizeChanged(userId);
        }
    }

    public void onUserEvent(int eventType, long userId, int flag) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() && !scene.isPreloadEnabled() || !scene.isStarted()) continue;
            scene.onUserEvent(eventType, userId, flag);
        }
    }

    public abstract void attendeeVideoControlChange(long var1);

    public abstract void attendeeVideoLayoutChange(long var1);

    public void onDoubleTap(MotionEvent e) {
    }

    public abstract void scrollHorizontal(boolean var1);

    public int getSceneCount() {
        return 1;
    }

    public void switchToScene(int index) {
    }

    public boolean isInDefaultScene() {
        return true;
    }

    public void onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
    }

    public void onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
    }

    public void onDown(MotionEvent e) {
    }

    public boolean onHoverEvent(MotionEvent e) {
        return this.mVideoAccessibilityHelper != null && this.mVideoAccessibilityHelper.dispatchHoverEvent(e);
    }

    public boolean onTouchEvent(MotionEvent e) {
        return false;
    }

    public boolean onVideoViewSingleTapConfirmed(MotionEvent e) {
        return false;
    }

    public void onUserVideoStatus(long userId) {
        CmmConfStatus confStatus = ConfMgr.getInstance().getConfStatusObj();
        if (confStatus != null && confStatus.isMyself(userId)) {
            this.onMyVideoStatusChanged();
        }
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() && !scene.isPreloadEnabled() || !scene.isStarted()) continue;
            scene.onUserVideoStatus(userId);
        }
    }

    public void onUserVideoDataSizeChanged(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserVideoDataSizeChanged(userId);
        }
    }

    public void onUserVideoQualityChanged(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserVideoQualityChanged(userId);
        }
    }

    public void onUserAudioStatus(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserAudioStatus(userId);
        }
    }

    public void onAudioTypeChanged(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onAudioTypeChanged(userId);
        }
    }

    public void onUserActiveAudio(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserActiveAudio(userId);
        }
    }

    public void onUserPicReady(long userId) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onUserPicReady(userId);
        }
    }

    public void onConfReady() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onConfReady();
        }
    }

    public void onAutoStartVideo() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onAutoStartVideo();
        }
    }

    public void onConfOne2One() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onConfOne2One();
        }
    }

    public void beforeSwitchCamera() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.beforeSwitchCamera();
        }
    }

    public void afterSwitchCamera() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.afterSwitchCamera();
        }
    }

    public void stopAllScenes() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.stop();
        }
    }

    public void startActiveScene() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible()) continue;
            scene.start();
        }
    }

    public void onMyVideoStatusChanged() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onMyVideoStatusChanged();
        }
    }

    public void onMyVideoRotationChanged(int action) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onMyVideoRotationChanged(action);
        }
    }

    public void onLaunchConfParamReady() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onLaunchConfParamReady();
        }
    }

    public void onConfVideoSendingStatusChanged() {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onConfVideoSendingStatusChanged();
        }
    }

    public void onConfLeaving() {
    }

    public long getPreviewRenderInfo() {
        AbsVideoScene activeScene = this.getActiveScene();
        if (activeScene != null) {
            return activeScene.getPreviewRenderInfo();
        }
        return 0L;
    }

    public boolean isInDriverMode() {
        return false;
    }

    public void setNetworkRestrictionMode(boolean bNetworkRestrictionMode) {
        this.mbNetworkRestrictionMode = bNetworkRestrictionMode;
    }

    public boolean isNetworkRestrictionMode() {
        return this.mbNetworkRestrictionMode;
    }

    public boolean onNetworkRestrictionModeChanged(boolean isNetworkRestrictionMode) {
        if (this.mbNetworkRestrictionMode != isNetworkRestrictionMode) {
            this.mbNetworkRestrictionMode = isNetworkRestrictionMode;
            return true;
        }
        return false;
    }

    public void onConfSilentModeChanged() {
        boolean inSilentMode = false;
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            inSilentMode = confContext.inSilentMode();
        }
        if (inSilentMode) {
            for (AbsVideoScene scene : this.mSceneList) {
                if (!scene.isVisible() || !scene.isStarted()) continue;
                scene.stop();
            }
        } else {
            for (AbsVideoScene scene : this.mSceneList) {
                if (!scene.isVisible()) continue;
                scene.start();
            }
        }
    }

    public void onHostChanged(long userId, boolean isCurUserHost) {
        for (AbsVideoScene scene : this.mSceneList) {
            if (!scene.isVisible() || !scene.isStarted()) continue;
            scene.onHostChanged(userId, isCurUserHost);
        }
    }

    public abstract AbsVideoScene getActiveScene();

    private void createKeyVideoUnit() {
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        RendererUnitInfo unitInfo = new RendererUnitInfo(0, 0, 1, 1);
        this.mKeyVideoUnit = videoMgr.createVideoUnit(true, unitInfo);
    }

    private void destroyKeyVideoUnit() {
        if (this.mKeyVideoUnit == null) {
            return;
        }
        VideoSessionMgr videoMgr = ConfMgr.getInstance().getVideoObj();
        if (videoMgr == null) {
            return;
        }
        videoMgr.destroyVideoUnit(this.mKeyVideoUnit);
        this.mKeyVideoUnit = null;
    }

    public void onAccessibilityRootViewUpdated() {
        if (!AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getConfActivity())) {
            return;
        }
        if (this.mVideoAccessibilityHelper != null) {
            this.mVideoAccessibilityHelper.invalidateRoot();
        }
    }

    public void onAccessibilityViewUpdated(int virtualViewId) {
        if (!AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getConfActivity())) {
            return;
        }
        if (this.mVideoAccessibilityHelper != null) {
            this.mVideoAccessibilityHelper.invalidateVirtualView(virtualViewId);
        }
    }

    public void announceAccessibilityAtView(int virtualViewId) {
        if (!AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getConfActivity())) {
            return;
        }
        if (this.mVideoAccessibilityHelper != null && this.mVideoAccessibilityHelper.getFocusedVirtualView() == virtualViewId) {
            this.mVideoAccessibilityHelper.sendEventForVirtualView(virtualViewId, 16384);
        }
    }

    public void announceAccessibilityAtActiveScene() {
        if (this.mVideoView == null || this.getConfActivity() == null) {
            return;
        }
        if (!AccessibilityUtil.isSpokenFeedbackEnabled((Context)this.getConfActivity())) {
            return;
        }
        try {
            this.mVideoView.sendAccessibilityEvent(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateAccessibilityDescriptionForActiveScece(String content) {
        if (this.mVideoView == null || this.getConfActivity() == null) {
            return;
        }
        this.mVideoView.setContentDescription((CharSequence)content);
    }

    private class VideoAccessibilityHelper
    extends ExploreByTouchHelper {
        public VideoAccessibilityHelper(View parentView) {
            super(parentView);
        }

        private int getViewIndexAt(float x, float y) {
            AbsVideoScene activeScene = AbsVideoSceneMgr.this.getActiveScene();
            if (activeScene != null) {
                return activeScene.getAccessbilityViewIndexAt(x, y);
            }
            return -1;
        }

        private Rect getBoundsForIndex(int virtualViewId) {
            AbsVideoScene activeScene = AbsVideoSceneMgr.this.getActiveScene();
            if (activeScene != null) {
                return activeScene.getBoundsForAccessbilityViewIndex(virtualViewId);
            }
            return new Rect();
        }

        private CharSequence getDescriptionForIndex(int index) {
            AbsVideoScene activeScene = AbsVideoSceneMgr.this.getActiveScene();
            if (activeScene != null) {
                return activeScene.getAccessibilityDescriptionForIndex(index);
            }
            return "";
        }

        protected int getVirtualViewAt(float x, float y) {
            int index = this.getViewIndexAt(x, y);
            if (index >= 0) {
                return index;
            }
            return Integer.MIN_VALUE;
        }

        protected void getVisibleVirtualViews(List<Integer> virtualViewIds) {
            AbsVideoScene activeScene = AbsVideoSceneMgr.this.getActiveScene();
            if (activeScene != null) {
                AbsVideoSceneMgr.this.getActiveScene().getAccessibilityVisibleVirtualViews(virtualViewIds);
            }
        }

        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            CharSequence desc = this.getDescriptionForIndex(virtualViewId);
            event.setContentDescription(desc);
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfoCompat node) {
            CharSequence desc = this.getDescriptionForIndex(virtualViewId);
            node.setContentDescription(desc);
            Rect bounds = this.getBoundsForIndex(virtualViewId);
            if (bounds.isEmpty()) {
                bounds.left = 1;
                bounds.right = 2;
                bounds.top = 1;
                bounds.bottom = 2;
            }
            node.setBoundsInParent(bounds);
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            return false;
        }
    }
}

