/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.ptapp.mm.ZMSortUtil;
import com.zipow.videobox.view.IMAddrBookItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;

public class ZoomSipPhoneAdapter
extends BaseAdapter {
    private String mFilter;
    private List<IMAddrBookItem> mData;
    private List<IMAddrBookItem> mDisplayData = new ArrayList<IMAddrBookItem>();
    private Context mContext;
    private static final int MAX_DISPLAY_NUM = 200;

    public ZoomSipPhoneAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.mDisplayData.size();
    }

    public IMAddrBookItem getItem(int position) {
        if (position < 0 || position >= this.mDisplayData.size()) {
            return null;
        }
        return this.mDisplayData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        IMAddrBookItem item = this.getItem(position);
        return item.getSipView(this.mContext, convertView, true, false);
    }

    public void setData(List<IMAddrBookItem> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    public void filter(String key) {
        this.mFilter = !StringUtil.isEmptyOrNull((String)key) ? key.toLowerCase() : "";
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.updateDisplayData();
        super.notifyDataSetChanged();
    }

    private void updateDisplayData() {
        this.mDisplayData.clear();
        HashMap<String, IMAddrBookItem> cache = new HashMap<String, IMAddrBookItem>();
        if (!StringUtil.isEmptyOrNull((String)this.mFilter) && !CollectionsUtil.isListEmpty(this.mData)) {
            for (IMAddrBookItem item : this.mData) {
                if (cache.size() >= 200) break;
                String str = item.getScreenName();
                if (!StringUtil.isEmptyOrNull((String)str) && str.toLowerCase().contains(this.mFilter)) {
                    cache.put(item.getJid(), item);
                    continue;
                }
                str = item.getSipPhoneNumber();
                if (StringUtil.isEmptyOrNull((String)str) || !str.toLowerCase().contains(this.mFilter)) continue;
                cache.put(item.getJid(), item);
            }
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(cache.keySet());
        List<String> jids = ZMSortUtil.sortBuddies(keys, 0, this.mFilter);
        for (String jid : jids) {
            this.mDisplayData.add((IMAddrBookItem)cache.get(jid));
        }
    }
}

