/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.SipCallItem;
import com.zipow.videobox.sip.server.SipAudioMgr;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.sip.server.ZoomAssistantIPCMessageUI;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.NotificationMgr;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AudioClip;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.sip.DialKeyboardView;
import java.io.File;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.HeadsetUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class SipInCallActivity
extends ZMActivity
implements View.OnClickListener,
DialKeyboardView.OnKeyDialListener,
HeadsetUtil.IHeadsetConnectionListener {
    private static final String ARGS_SIP_NUMBER = "ARGS_SIP_NUMBER";
    private static final String TAG = SipInCallActivity.class.getSimpleName();
    private static final String ARGS_WAIT_PERMISSION_FOR_CALLOUT = "waitPermissionForCallOut";
    private TextView mTxtBuddyName;
    private TextView mTxtDialState;
    private Button mBtnHide;
    private DialKeyboardView mPanelKeybord;
    private View mPanelInCall;
    private View mPanelMute;
    private View mPanelDtmf;
    private View mPanelSpeakeron;
    private ImageView mImgAvatar;
    private View mBtnAcceptCall;
    private View mBtnEndCall;
    private ImageView mImgMute;
    private ImageView mImgSpeaker;
    private TextView mTxtMute;
    private String mDTMFNum;
    private boolean mIsDTMFMode;
    private String mCallNo;
    private IMAddrBookItem mBuddy;
    private AudioClip mRingClip = null;
    private static final int REQUEST_PERMISSION_ACCEPT_CALL = 100;
    private static final int REQUEST_PERMISSION_NEW_CALL = 101;
    private Vibrator mVibrator;
    private static final long[] VIBRATES = new long[]{2000L, 1000L, 2000L, 1000L};
    private static final int MSG_REFRESH_CALL_TIME = 1;
    private ZoomAssistantIPCMessageUI.IZoomAssistantIPCMessageUIListener mZoomAssistantIPCMessageUIListener = new ZoomAssistantIPCMessageUI.SimpleZoomAssistantIPCMessageUIListener(){

        @Override
        public void HandleSIPMuteCallResponse(boolean muted) {
            SipInCallActivity.this.HandleSIPMuteCallResponse(muted);
        }
    };
    private SipCallManager.OnSipCallEventListener mOnSipCallEventListener = new SipCallManager.OnSipCallEventListener(){

        @Override
        public void onSipCallEvent(int event, String callId) {
            SipInCallActivity.this.onSipCallEvent(event, callId);
        }
    };
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SipInCallActivity.this.mTxtDialState.setText((CharSequence)TimeUtil.formateDuration((long)(SipCallManager.getInstance().getActivityCallTimeLong() / 1000L)));
                    this.sendEmptyMessageDelayed(1, 1000L);
                    break;
                }
            }
        }
    };

    public static void show(Context context, String sipNo) {
        SipInCallActivity.show(context, sipNo, false);
    }

    public static void show(Context context, String sipNo, boolean waitPermissionForCallOut) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, SipInCallActivity.class);
        intent.addFlags(0x10000000);
        intent.putExtra(ARGS_SIP_NUMBER, sipNo);
        intent.putExtra(ARGS_WAIT_PERMISSION_FOR_CALLOUT, waitPermissionForCallOut);
        context.startActivity(intent);
    }

    public static void returnToSip(Context context) {
        SipCallItem item;
        if (!SipCallManager.getInstance().isInSIPCall()) {
            NotificationMgr.removeSipNotification(context);
            return;
        }
        Intent intent = new Intent(context, SipInCallActivity.class);
        intent.addFlags(131072);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if ((item = SipCallManager.getInstance().getActiveCallInfo()) == null) {
            return;
        }
        intent.putExtra(ARGS_SIP_NUMBER, item.getPeerNumber());
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        SipCallItem activityCall;
        ZoomMessenger messenger;
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(6815745);
        this.setContentView(R.layout.zm_sip_in_call);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mCallNo = intent.getStringExtra(ARGS_SIP_NUMBER);
            if (intent.getBooleanExtra(ARGS_WAIT_PERMISSION_FOR_CALLOUT, false) && Build.VERSION.SDK_INT >= 23 && this.zm_checkSelfPermission("android.permission.RECORD_AUDIO") != 0) {
                this.zm_requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 101);
            }
        }
        if (!StringUtil.isEmptyOrNull((String)this.mCallNo) && (messenger = PTApp.getInstance().getZoomMessenger()) != null) {
            ZoomBuddy buddy = messenger.getBuddyWithSipPhone(this.mCallNo);
            this.mBuddy = buddy != null ? IMAddrBookItem.fromZoomBuddy(buddy) : IMAddrBookItem.fromZoomBuddy(messenger.getMyself());
        }
        this.mTxtBuddyName = (TextView)this.findViewById(R.id.txtBuddyName);
        this.mTxtDialState = (TextView)this.findViewById(R.id.txtDialState);
        this.mBtnHide = (Button)this.findViewById(R.id.btnHide);
        this.mPanelKeybord = (DialKeyboardView)this.findViewById(R.id.panelKeybord);
        this.mPanelInCall = this.findViewById(R.id.panelInCall);
        this.mPanelMute = this.findViewById(R.id.panelMute);
        this.mPanelDtmf = this.findViewById(R.id.panelDtmf);
        this.mPanelSpeakeron = this.findViewById(R.id.panelSpeakeron);
        this.mImgAvatar = (ImageView)this.findViewById(R.id.imgAvatar);
        this.mBtnAcceptCall = this.findViewById(R.id.btnAcceptCall);
        this.mBtnEndCall = this.findViewById(R.id.btnEndCall);
        this.mImgMute = (ImageView)this.findViewById(R.id.imgMute);
        this.mTxtMute = (TextView)this.findViewById(R.id.txtMute);
        this.mImgSpeaker = (ImageView)this.findViewById(R.id.imgSpeaker);
        this.mBtnEndCall.setOnClickListener((View.OnClickListener)this);
        this.mPanelMute.setOnClickListener((View.OnClickListener)this);
        this.mPanelDtmf.setOnClickListener((View.OnClickListener)this);
        this.mPanelSpeakeron.setOnClickListener((View.OnClickListener)this);
        this.mBtnHide.setOnClickListener((View.OnClickListener)this);
        this.mPanelKeybord.setOnKeyDialListener(this);
        this.mBtnAcceptCall.setOnClickListener((View.OnClickListener)this);
        this.mPanelKeybord.setOnDrakMode();
        if (savedInstanceState != null) {
            this.mDTMFNum = savedInstanceState.getString("mDTMFNum");
            this.mIsDTMFMode = savedInstanceState.getBoolean("mIsDTMFMode");
        }
        SipCallManager.getInstance().addListener(this.mOnSipCallEventListener);
        if (this.isInRinging() || this.isOutRinging()) {
            this.startRing();
        }
        if ((activityCall = SipCallManager.getInstance().getActiveCallInfo()) == null || !StringUtil.isSameString((String)activityCall.getPeerNumber(), (String)this.mCallNo)) {
            this.dismiss();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        SipCallManager.getInstance().removeListener(this.mOnSipCallEventListener);
        this.stopRing();
        this.mHandler.removeMessages(1);
        if (this.isInRinging()) {
            SipCallManager.getInstance().declineCall();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mDTMFNum", this.mDTMFNum);
            outState.putBoolean("mIsDTMFMode", this.mIsDTMFMode);
        }
    }

    private void startRing() {
        AudioManager audioManager2;
        int ringerMode = 2;
        try {
            audioManager2 = (AudioManager)this.getSystemService("audio");
            if (audioManager2 == null) {
                return;
            }
            ringerMode = audioManager2.getRingerMode();
        }
        catch (Exception audioManager2) {
            // empty catch block
        }
        if (ringerMode == 2 && this.mRingClip == null) {
            if (this.isOutRinging()) {
                this.mRingClip = new AudioClip(R.raw.zm_dudu, 0);
                audioManager2 = (AudioManager)VideoBoxApplication.getInstance().getSystemService("audio");
                if (audioManager2 != null) {
                    audioManager2.setSpeakerphoneOn(false);
                }
            } else {
                this.mRingClip = new AudioClip(R.raw.zm_ring, 2);
            }
            this.mRingClip.startPlay();
        }
        if (this.isInRinging() && (ringerMode == 2 || ringerMode == 1) && this.mVibrator == null) {
            this.mVibrator = (Vibrator)this.getSystemService("vibrator");
            if (this.mVibrator != null) {
                this.mVibrator.vibrate(VIBRATES, 0);
            }
        }
    }

    private void stopRing() {
        if (this.mRingClip != null) {
            this.mRingClip.stopPlay();
            this.mRingClip = null;
        }
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
            this.mVibrator = null;
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnEndCall) {
            this.onClickEndCall();
        } else if (id2 == R.id.panelMute) {
            this.onClickTxtMute();
        } else if (id2 == R.id.panelDtmf) {
            this.onClickTxtDtmf();
        } else if (id2 == R.id.panelSpeakeron) {
            this.onClickTxtSpeakeron();
        } else if (id2 == R.id.btnHide) {
            this.onClickTxtHide();
        } else if (id2 == R.id.btnAcceptCall) {
            this.onClickBtnAcceptCall();
        }
    }

    public void onPause() {
        super.onPause();
        this.mHandler.removeMessages(1);
        HeadsetUtil.getInstance().removeListener((HeadsetUtil.IHeadsetConnectionListener)this);
        UIUtil.stopProximityScreenOffWakeLock();
    }

    public void onResume() {
        super.onResume();
        ZoomAssistantIPCMessageUI.getInstance().addListener(this.mZoomAssistantIPCMessageUIListener);
        this.updateUI();
        HeadsetUtil.getInstance().addListener((HeadsetUtil.IHeadsetConnectionListener)this);
        if (!(this.isInRinging() || HeadsetUtil.getInstance().isBluetoothHeadsetOn() || HeadsetUtil.getInstance().isWiredHeadsetOn())) {
            UIUtil.startProximityScreenOffWakeLock((Context)this);
        }
    }

    public void HandleSIPMuteCallResponse(boolean muted) {
        this.updatePanelInCall();
    }

    public void onSipCallEvent(int event, String callId) {
        if (!SipCallManager.getInstance().isInSIPCall()) {
            this.dismiss();
            return;
        }
        SipCallItem current = SipCallManager.getInstance().getActiveCallInfo();
        if (current == null || !StringUtil.isSameString((String)callId, (String)current.getCallID())) {
            return;
        }
        if (event == 12) {
            this.startRing();
        } else if (event == 8) {
            this.stopRing();
        }
        this.updateUI();
    }

    private void updateUI() {
        this.updateBtnHide();
        this.updatePanelAvatar();
        this.updatePanelBuddyInfo();
        this.updatePanelCallBtns();
        this.updatePanelInCall();
        this.updatePanelKeybord();
    }

    private void updatePanelAvatar() {
        if (this.mBuddy != null) {
            this.mImgAvatar.setVisibility(0);
            this.mImgAvatar.setImageBitmap(ImageUtil.blurBitmap(this.getAvatarBitmapFromContact(this.mBuddy)));
            this.mImgAvatar.setContentDescription((CharSequence)BuddyNameUtil.getBuddyDisplayName(null, this.mBuddy));
        } else {
            this.mImgAvatar.setVisibility(8);
        }
    }

    private Bitmap getAvatarBitmapFromContact(IMAddrBookItem contact) {
        if (contact == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null) {
            String avatar = null;
            String jid = contact.getJid();
            ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
            if (buddy != null) {
                avatar = buddy.getLocalBigPicturePath();
            }
            if (ImageUtil.isValidImageFile(avatar)) {
                Bitmap bitmap = ZMBitmapFactory.decodeFile(avatar);
                if (bitmap != null) {
                    return bitmap;
                }
            } else {
                Bitmap bitmap;
                File file;
                if (!StringUtil.isEmptyOrNull((String)avatar) && (file = new File(avatar)).exists()) {
                    file.delete();
                }
                if (buddy != null) {
                    avatar = buddy.getLocalPicturePath();
                }
                if (ImageUtil.isValidImageFile(avatar) && (bitmap = ZMBitmapFactory.decodeFile(avatar)) != null) {
                    return bitmap;
                }
            }
        }
        return contact.getAvatarBitmap((Context)this);
    }

    private String getDisplayName() {
        SipCallManager mgr = SipCallManager.getInstance();
        SipCallItem callItem = mgr.getActiveCallInfo();
        if (callItem == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return callItem.getPeerDisplayName();
        }
        ZoomBuddy buddy = messenger.getBuddyWithSipPhone(callItem.getPeerNumber());
        if (buddy == null) {
            return callItem.getPeerNumber();
        }
        return BuddyNameUtil.getBuddyDisplayName(buddy, null);
    }

    private void updatePanelBuddyInfo() {
        this.mHandler.removeMessages(1);
        SipCallManager mgr = SipCallManager.getInstance();
        SipCallItem callItem = mgr.getActiveCallInfo();
        if (callItem == null) {
            return;
        }
        if (mgr.isInCall() && !this.isOutRinging()) {
            this.mTxtDialState.setText((CharSequence)TimeUtil.formateDuration((long)(SipCallManager.getInstance().getActivityCallTimeLong() / 1000L)));
            this.mHandler.sendEmptyMessageDelayed(1, 1000L);
            if (this.mIsDTMFMode && !StringUtil.isEmptyOrNull((String)this.mDTMFNum)) {
                this.mTxtBuddyName.setText((CharSequence)this.mDTMFNum);
            } else {
                this.mTxtBuddyName.setText((CharSequence)this.getDisplayName());
            }
        } else {
            if (this.isInRinging()) {
                this.mTxtDialState.setText((CharSequence)this.mCallNo);
            } else if (StringUtil.isSameString((String)this.getDisplayName(), (String)this.mCallNo)) {
                this.mTxtDialState.setText(R.string.zm_mm_msg_sip_calling_14480);
            } else {
                this.mTxtDialState.setText((CharSequence)this.getString(R.string.zm_callout_msg_calling, new Object[]{this.mCallNo}));
            }
            this.mTxtBuddyName.setVisibility(0);
            this.mTxtDialState.setVisibility(0);
            this.mTxtBuddyName.setText((CharSequence)this.getDisplayName());
        }
    }

    private void updateBtnHide() {
        if (this.isInRinging()) {
            this.mBtnHide.setVisibility(8);
            return;
        }
        this.mBtnHide.setVisibility(this.mIsDTMFMode ? 0 : 8);
    }

    private void updatePanelCallBtns() {
        if (this.isInRinging()) {
            this.mBtnAcceptCall.setVisibility(0);
            this.mBtnEndCall.setVisibility(0);
        } else {
            this.mBtnAcceptCall.setVisibility(8);
            this.mBtnEndCall.setVisibility(this.mIsDTMFMode ? 8 : 0);
        }
    }

    private void updatePanelKeybord() {
        if (this.isInRinging()) {
            this.mPanelKeybord.setVisibility(8);
        } else {
            this.mPanelKeybord.setVisibility(this.mIsDTMFMode ? 0 : 8);
        }
    }

    private void updatePanelInCall() {
        if (this.isInRinging() || this.mIsDTMFMode) {
            this.mPanelInCall.setVisibility(8);
            return;
        }
        this.mPanelInCall.setVisibility(0);
        if (SipCallManager.getInstance().isCallMuted()) {
            this.mImgMute.setImageResource(R.drawable.zm_btn_sip_mic_unmute);
            this.mTxtMute.setText(R.string.zm_btn_unmute_14480);
        } else {
            this.mImgMute.setImageResource(R.drawable.zm_btn_sip_mic_mute);
            this.mTxtMute.setText(R.string.zm_btn_mute_14480);
        }
        this.mImgSpeaker.setSelected(SipAudioMgr.getInstance().isSpeakerPhoneOn());
    }

    private boolean isOutRinging() {
        SipCallManager mgr = SipCallManager.getInstance();
        SipCallItem callItem = mgr.getActiveCallInfo();
        if (callItem == null) {
            return false;
        }
        return callItem.getCallStatus() == 20;
    }

    private boolean isInRinging() {
        SipCallManager mgr = SipCallManager.getInstance();
        SipCallItem callItem = mgr.getActiveCallInfo();
        if (callItem == null) {
            return false;
        }
        return callItem.getCallStatus() == 15;
    }

    private void onClickBtnAcceptCall() {
        if (this.isInRinging()) {
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.RECORD_AUDIO") == -1) {
                this.zm_requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 100);
                return;
            }
            SipCallManager.getInstance().acceptCall();
            this.stopRing();
        }
    }

    public void onRequestPermissionsResult(final int requestCode, final String[] permissions, final int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EventTaskManager eventTaskManager = this.getEventTaskManager();
        if (eventTaskManager != null) {
            eventTaskManager.pushLater("SipInCallActivityPermissionResult", new EventAction("SipInCallActivityPermissionResult"){

                public void run(IUIElement ui) {
                    ((SipInCallActivity)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
                }
            });
        }
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        if (requestCode == 100) {
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.RECORD_AUDIO") == 0) {
                if (this.isInRinging()) {
                    SipCallManager.getInstance().acceptCall();
                    this.stopRing();
                }
            } else {
                this.onClickEndCall();
            }
        } else if (requestCode == 101) {
            if (Build.VERSION.SDK_INT < 23 || this.checkSelfPermission("android.permission.RECORD_AUDIO") == 0) {
                SipCallManager.getInstance().callPeer(this.mCallNo);
            } else {
                this.dismiss();
            }
        }
    }

    private void onClickTxtHide() {
        this.mIsDTMFMode = false;
        this.updateUI();
    }

    private void onClickTxtMute() {
        SipCallManager mgr = SipCallManager.getInstance();
        mgr.muteCall(mgr.getActiveCallId(), !SipCallManager.getInstance().isCallMuted());
    }

    private void onClickTxtDtmf() {
        this.mIsDTMFMode = true;
        this.updateUI();
    }

    private void onClickTxtSpeakeron() {
        SipAudioMgr audioMgr;
        boolean res = audioMgr.toggleSpeakerPhone(!(audioMgr = SipAudioMgr.getInstance()).isSpeakerPhoneOn());
        if (res) {
            this.updatePanelInCall();
        }
    }

    private void onClickEndCall() {
        this.stopRing();
        if (this.isInRinging()) {
            SipCallManager.getInstance().declineCall();
        } else {
            SipCallManager.getInstance().hangupActiveCall();
        }
    }

    public void dismiss() {
        this.finish();
    }

    @Override
    public void onKeyDial(String key) {
        if (this.mDTMFNum == null) {
            this.mDTMFNum = "";
        }
        SipCallManager mgr = SipCallManager.getInstance();
        mgr.sendDTMF(mgr.getActiveCallId(), key);
        this.mDTMFNum = this.mDTMFNum + key;
        this.updateUI();
    }

    public void onHeadsetStatusChanged(boolean wiredHeadsetConnected, boolean bluetoothHeadsetConnected) {
        SipCallManager sipMgr = SipCallManager.getInstance();
        if (!sipMgr.isInCall()) {
            return;
        }
        SipAudioMgr audioMgr = SipAudioMgr.getInstance();
        if (wiredHeadsetConnected || bluetoothHeadsetConnected) {
            audioMgr.setPreferedLoudSpeakerStatus(-1);
        }
        audioMgr.checkOpenLoudSpeaker();
        audioMgr.notifyHeadsetStatusChanged(wiredHeadsetConnected || bluetoothHeadsetConnected);
    }

    public void onBluetoothScoAudioStatus(boolean on) {
    }
}

