/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.fragment.InviteFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.sip.CallHistory;
import com.zipow.videobox.sip.CallHistoryMgr;
import com.zipow.videobox.sip.server.SipCallManager;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.sip.PhoneCallFragment;
import com.zipow.videobox.view.sip.PhoneCallsAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class PhoneCallsListview
extends ListView
implements AdapterView.OnItemClickListener {
    private PhoneCallsAdapter mAdapter;
    private PhoneCallFragment mParentFragment;
    private static final String TAG = PhoneCallsListview.class.getSimpleName();
    private boolean mIsShowMissedHistory = false;

    public PhoneCallsListview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public PhoneCallsListview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mAdapter = new PhoneCallsAdapter(this.getContext(), this);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    public void setShowMissedHistory(boolean isShowMissedHistory) {
        this.mIsShowMissedHistory = isShowMissedHistory;
    }

    public void setParentFragment(PhoneCallFragment fragment) {
        this.mParentFragment = fragment;
    }

    public void setDeleteMode(boolean mode) {
        this.mAdapter.setDeleteMode(mode);
        this.mAdapter.notifyDataSetChanged();
    }

    public void loadAllRecentCalls() {
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        if (mgr == null) {
            return;
        }
        List<CallHistory> items = mgr.getCallHistory(this.mIsShowMissedHistory);
        if (items == null) {
            return;
        }
        Collections.reverse(items);
        this.mAdapter.updateData(items);
        this.mAdapter.notifyDataSetChanged();
    }

    public void updateZoomBuddyInfo(List<String> buddyJids) {
        this.mAdapter.updateZoomBuddyInfo(buddyJids);
    }

    public void onDeleteHistoryCall(String jid) {
        if (this.mAdapter.removeCall(jid)) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void deleteHistoryCall(String jid) {
        CallHistoryMgr mgr = PTApp.getInstance().getCallHistoryMgr();
        boolean res = mgr.deleteCallHistory(jid);
        if (res) {
            if (this.mParentFragment != null) {
                this.mParentFragment.onCallHistoryDeleted(jid);
            }
            if (this.mAdapter.removeCall(jid)) {
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        CallsListMenuItem menuItem;
        if (this.mAdapter == null) {
            return;
        }
        CallHistory item = this.mAdapter.getItem(position);
        if (item == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        String phoneNum = null;
        String buddyJid = null;
        boolean isZoomRoom = false;
        int type = item.getType();
        if (type == 3) {
            phoneNum = item.getNumber();
            ZoomBuddy buddy = messenger.getBuddyWithSipPhone(phoneNum);
            if (buddy != null) {
                buddyJid = buddy.getJid();
                isZoomRoom = buddy.isZoomRoom();
            }
        } else {
            ZoomBuddy buddy;
            String jid;
            String string2 = jid = item.getDirection() == 2 ? item.getCalleeJid() : item.getCallerJid();
            if (!StringUtil.isEmptyOrNull((String)jid) && (buddy = messenger.getBuddyWithJID(jid)) != null) {
                buddyJid = jid;
                phoneNum = buddy.getSipPhoneNumber();
                isZoomRoom = buddy.isZoomRoom();
            }
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<CallsListMenuItem> items = new ArrayList<CallsListMenuItem>();
        if (!StringUtil.isEmptyOrNull((String)phoneNum)) {
            menuItem = new CallsListMenuItem(activity.getString(R.string.zm_msg_call_phonenum, new Object[]{phoneNum}), 0);
            menuItem.number = phoneNum;
            items.add(menuItem);
        }
        if (!StringUtil.isEmptyOrNull((String)buddyJid)) {
            if (!isZoomRoom && PTApp.getInstance().hasMessenger() && PTApp.getInstance().getZoomMessenger().imChatGetOption() != 2) {
                menuItem = new CallsListMenuItem(activity.getString(R.string.zm_btn_mm_chat), 1);
                menuItem.jid = buddyJid;
                items.add(menuItem);
            }
            long callStatus = PTApp.getInstance().getCallStatus();
            switch ((int)callStatus) {
                case 1: {
                    break;
                }
                case 2: {
                    menuItem = new CallsListMenuItem(activity.getString(R.string.zm_btn_invite_to_conf), 4);
                    menuItem.jid = buddyJid;
                    items.add(menuItem);
                    break;
                }
                default: {
                    menuItem = new CallsListMenuItem(activity.getString(R.string.zm_btn_video_call), 3);
                    menuItem.jid = buddyJid;
                    items.add(menuItem);
                    menuItem = new CallsListMenuItem(activity.getString(R.string.zm_btn_audio_call), 2);
                    menuItem.jid = buddyJid;
                    items.add(menuItem);
                }
            }
        }
        if (items.size() > 0) {
            menuAdapter.addAll(items);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CallsListMenuItem mi = (CallsListMenuItem)((Object)menuAdapter.getItem(which));
                    PhoneCallsListview.this.onSelectContextMenuItem(mi);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            dialog.show();
        }
    }

    private void onSelectContextMenuItem(CallsListMenuItem item) {
        if (item == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        int action = item.getAction();
        if (action == 0) {
            if (!StringUtil.isEmptyOrNull((String)item.number)) {
                this.sendSipCall(item.number);
            }
        } else if (action == 1) {
            if (StringUtil.isEmptyOrNull((String)item.jid)) {
                return;
            }
            ZoomBuddy buddy = messenger.getBuddyWithJID(item.jid);
            MMChatActivity.showAsOneToOneChat((ZMActivity)this.getContext(), IMAddrBookItem.fromZoomBuddy(buddy), item.jid);
        } else if (action == 2) {
            if (StringUtil.isEmptyOrNull((String)item.jid)) {
                return;
            }
            this.startAudioCall(item.jid);
        } else if (action == 3) {
            if (StringUtil.isEmptyOrNull((String)item.jid)) {
                return;
            }
            this.startVideoCall(item.jid);
        } else if (action == 4) {
            if (StringUtil.isEmptyOrNull((String)item.jid)) {
                return;
            }
            this.inviteToConf(item.jid);
        }
    }

    private void sendSipCall(String number) {
        if (!SipCallManager.getInstance().isSipAvailable()) {
            new ZMAlertDialog.Builder(this.getContext()).setTitle(R.string.zm_mm_msg_sip_unavailable_14480).setPositiveButton(R.string.zm_btn_ok, null).show();
            return;
        }
        SipCallManager.getInstance().callPeer(number);
    }

    private void inviteToConf(String jid) {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 1 || callStatus == 2) {
            this.inviteABContact(jid);
        }
    }

    private void startVideoCall(String jid) {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.callABContact(1, jid);
        }
    }

    private void startAudioCall(String jid) {
        int callStatus = PTApp.getInstance().getCallStatus();
        if (callStatus == 0) {
            this.callABContact(0, jid);
        }
    }

    private void callABContact(int abCallType, String jid) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        int ret = ConfActivity.inviteToVideoCall((Context)activity, jid, abCallType);
        if (ret != 0) {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)activity).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    private void inviteABContact(String jid) {
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        Activity activity = (Activity)this.getContext();
        if (activity == null) {
            return;
        }
        String[] buddyJids = new String[]{jid};
        String confId = PTApp.getInstance().getActiveCallId();
        long meetingNum = PTApp.getInstance().getActiveMeetingNo();
        int ret = PTAppDelegation.getInstance().inviteBuddiesToConf(buddyJids, null, confId, meetingNum, activity.getString(R.string.zm_msg_invitation_message_template));
        if (ret != 0) {
            this.onSentInvitationFailed();
        } else {
            this.onSentInvitationDone(activity);
        }
    }

    private void onSentInvitationFailed() {
        ZMActivity activity = (ZMActivity)this.getContext();
        new InviteFragment.InviteFailedDialog().show(activity.getSupportFragmentManager(), InviteFragment.InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(Activity activity) {
        ConfActivity.returnToConf((Context)activity);
        activity.finish();
    }

    public static class CallsListMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_SIP_CALL = 0;
        public static final int ACTION_CHAT = 1;
        public static final int ACTION_AUDIO_CALL = 2;
        public static final int ACTION_VIDEO_CALL = 3;
        public static final int ACTION_INVITE_CALL = 4;
        private String number;
        private String jid;

        public CallsListMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

