/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.sip;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class DialPadNumView
extends LinearLayout {
    private TextView mTxtNum;
    private TextView mTxtNumDes;
    private String mDialKey;
    private ImageView mImgNum;
    private ImageView mImgNumDes;
    private boolean mIsOnDark;

    public DialPadNumView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public DialPadNumView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DialPadNumView(Context context) {
        super(context);
        this.init(context, null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.findViewById(R.id.panelKey).setEnabled(enabled);
    }

    public void setOnDrakMode() {
        this.mIsOnDark = true;
        this.mTxtNum.setTextColor(this.getResources().getColor(R.color.zm_white));
        this.mTxtNumDes.setTextColor(this.getResources().getColor(R.color.zm_white));
        if (this.mDialKey != null) {
            this.setDialKey(this.mDialKey);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        if (context == null) {
            return;
        }
        View.inflate((Context)this.getContext(), (int)R.layout.zm_sip_dialpad_num, (ViewGroup)this);
        this.mTxtNum = (TextView)this.findViewById(R.id.txtNum);
        this.mTxtNumDes = (TextView)this.findViewById(R.id.txtNumDes);
        this.mImgNum = (ImageView)this.findViewById(R.id.imgNum);
        this.mImgNumDes = (ImageView)this.findViewById(R.id.imgNumDes);
        if (!this.isInEditMode() && attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DialpadNum);
            this.setDialKey(a.getString(R.styleable.DialpadNum_zm_dial_num));
            a.recycle();
        }
    }

    public String getDialKey() {
        return this.mDialKey;
    }

    public void setDialKey(String num) {
        if (StringUtil.isEmptyOrNull((String)num) || num.length() != 1) {
            return;
        }
        char key = num.charAt(0);
        this.mDialKey = key + "";
        this.mTxtNumDes.setVisibility(0);
        switch (key) {
            case '1': {
                this.mTxtNum.setText((CharSequence)"1");
                this.mTxtNumDes.setText((CharSequence)"");
                break;
            }
            case '2': {
                this.mTxtNum.setText((CharSequence)"2");
                this.mTxtNumDes.setText((CharSequence)"ABC");
                break;
            }
            case '3': {
                this.mTxtNum.setText((CharSequence)"3");
                this.mTxtNumDes.setText((CharSequence)"DEF");
                break;
            }
            case '4': {
                this.mTxtNum.setText((CharSequence)"4");
                this.mTxtNumDes.setText((CharSequence)"GHI");
                break;
            }
            case '5': {
                this.mTxtNum.setText((CharSequence)"5");
                this.mTxtNumDes.setText((CharSequence)"JKL");
                break;
            }
            case '6': {
                this.mTxtNum.setText((CharSequence)"6");
                this.mTxtNumDes.setText((CharSequence)"MNO");
                break;
            }
            case '7': {
                this.mTxtNum.setText((CharSequence)"7");
                this.mTxtNumDes.setText((CharSequence)"PQRS");
                break;
            }
            case '8': {
                this.mTxtNum.setText((CharSequence)"8");
                this.mTxtNumDes.setText((CharSequence)"TUV");
                break;
            }
            case '9': {
                this.mTxtNum.setText((CharSequence)"9");
                this.mTxtNumDes.setText((CharSequence)"WXYZ");
                break;
            }
            case '0': {
                this.mTxtNum.setText((CharSequence)"0");
                this.mTxtNumDes.setVisibility(8);
                this.mImgNumDes.setVisibility(0);
                this.mImgNumDes.setImageResource(this.mIsOnDark ? R.drawable.zm_ic_pad_add_ondark : R.drawable.zm_ic_pad_add);
                break;
            }
            case '*': {
                this.mTxtNum.setVisibility(8);
                this.mImgNum.setImageResource(this.mIsOnDark ? R.drawable.zm_ic_pad_star_ondark : R.drawable.zm_ic_pad_star);
                this.mImgNum.setContentDescription((CharSequence)"*");
                this.mImgNum.setVisibility(0);
                this.mImgNumDes.setVisibility(8);
                this.mImgNumDes.setVisibility(8);
                break;
            }
            case '#': {
                this.mTxtNum.setVisibility(8);
                this.mImgNum.setImageResource(this.mIsOnDark ? R.drawable.zm_ic_pad_no_ondark : R.drawable.zm_ic_pad_no);
                this.mImgNum.setContentDescription((CharSequence)"#");
                this.mImgNum.setVisibility(0);
                this.mImgNumDes.setVisibility(8);
                this.mImgNumDes.setVisibility(8);
                break;
            }
        }
    }
}

