/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerPanelView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class ZoomEmojiPanelView
extends StickerPanelView
implements View.OnClickListener {
    private List<StickerEvent> mStickers;

    public ZoomEmojiPanelView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setGravity(17);
        this.setOrientation(1);
    }

    private void createPanel() {
        if (CollectionsUtil.isListEmpty(this.mStickers)) {
            return;
        }
        ArrayList<EmojiHelper.EmojiIndex> emojis = new ArrayList<EmojiHelper.EmojiIndex>();
        for (StickerEvent sticker : this.mStickers) {
            if (sticker.getEventType() != 1) continue;
            emojis.add(sticker.getEmoji());
        }
        if (emojis.size() == 0) {
            return;
        }
        LinearLayout panelRow = null;
        for (int i = 0; i < 20; ++i) {
            if (panelRow == null || panelRow.getChildCount() == 7) {
                panelRow = new LinearLayout(this.getContext());
                panelRow.setOrientation(0);
                panelRow.setGravity(16);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.getContext(), (float)50.0f));
                this.addView((View)panelRow, (ViewGroup.LayoutParams)lp);
            }
            ImageView cell = new ImageView(this.getContext());
            int padding = UIUtil.dip2px((Context)this.getContext(), (float)8.0f);
            cell.setPadding(padding, padding, padding, padding);
            cell.setScaleType(ImageView.ScaleType.FIT_CENTER);
            cell.setBackgroundColor(0);
            if (i < emojis.size()) {
                EmojiHelper.EmojiIndex emoji = (EmojiHelper.EmojiIndex)emojis.get(i);
                cell.setImageResource(emoji.getDrawResource());
                cell.setTag((Object)emoji);
                cell.setOnClickListener((View.OnClickListener)this);
            }
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
            lp.weight = 1.0f;
            panelRow.addView((View)cell, (ViewGroup.LayoutParams)lp);
        }
        ImageView cell = new ImageView(this.getContext());
        int padding = UIUtil.dip2px((Context)this.getContext(), (float)8.0f);
        cell.setPadding(padding, padding, padding, padding);
        cell.setScaleType(ImageView.ScaleType.FIT_CENTER);
        cell.setBackgroundColor(0);
        cell.setImageResource(R.drawable.zm_mm_delete_btn);
        cell.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ZoomEmojiPanelView.this.mOnStickerEventLisener != null) {
                    ZoomEmojiPanelView.this.mOnStickerEventLisener.onStickerEvent(new StickerEvent());
                }
            }
        });
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
        lp.weight = 1.0f;
        panelRow.addView((View)cell, (ViewGroup.LayoutParams)lp);
    }

    @Override
    public void setContent(List<StickerEvent> stickers) {
        this.mStickers = stickers;
        this.createPanel();
    }

    @Override
    public int getCategory() {
        return 1;
    }

    @Override
    public int getMaxStickerSize() {
        return 20;
    }

    public void onClick(View v) {
        this.onEmojiClicker(v);
    }

    private void onEmojiClicker(View v) {
        Object tag = v.getTag();
        if (tag == null || !(tag instanceof EmojiHelper.EmojiIndex)) {
            return;
        }
        EmojiHelper.EmojiIndex emoji = (EmojiHelper.EmojiIndex)tag;
        if (this.mOnStickerEventLisener != null) {
            this.mOnStickerEventLisener.onStickerEvent(new StickerEvent(emoji));
        }
    }
}

