/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.util.SparseIntArray;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import com.zipow.videobox.view.mm.sticker.PrivateStickerPanelView;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerPanelView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class StickerManager {
    public static final int CATEGROY_STICKER_ZOOM_EMOJI = 1;
    public static final int CATEGROY_STICKER_PRIVATE = 2;
    public static final int EMOJI_CELL_HEIGHT_DP = 50;
    public static final int PRIVATE_STICKER_CELL_HEIGHT_DP = 70;
    public static final int PRIVATE_STICKER_MAX_SIZE = 0x800000;
    private boolean mIsE2EMode;
    private Context mContext;
    private List<StickerPanelView> mStickerPanelViews;
    private SparseIntArray mCateCount = new SparseIntArray();
    private static final String TAG = StickerManager.class.getSimpleName();
    private static Map<String, String> mPendingDownloadPreviewStickers = new HashMap<String, String>();
    private static Map<String, String> mPendingDownloadLocalPathStickers = new HashMap<String, String>();

    public static boolean isStickerPreviewDownloading(String stickerId) {
        return mPendingDownloadPreviewStickers.containsKey(stickerId);
    }

    public static boolean isStickerLocalPathDownloading(String stickerId) {
        return mPendingDownloadLocalPathStickers.containsKey(stickerId);
    }

    public static String getStickerPreviewFileIdByReqId(String reqId) {
        for (Map.Entry<String, String> entry : mPendingDownloadPreviewStickers.entrySet()) {
            if (!entry.getValue().equals(reqId)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getStickerLocalPathFileIdByReqId(String reqId) {
        for (Map.Entry<String, String> entry : mPendingDownloadLocalPathStickers.entrySet()) {
            if (!entry.getValue().equals(reqId)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void removeStickerPendingDownloadByReqId(String reqId) {
        String fileId = StickerManager.getStickerLocalPathFileIdByReqId(reqId);
        if (!StringUtil.isEmptyOrNull((String)fileId)) {
            mPendingDownloadLocalPathStickers.remove(fileId);
        } else {
            fileId = StickerManager.getStickerPreviewFileIdByReqId(reqId);
            if (!StringUtil.isEmptyOrNull((String)fileId)) {
                mPendingDownloadPreviewStickers.remove(fileId);
            }
        }
    }

    public static void addStickerPreviewReqId(String stickerId, String reqId) {
        if (StringUtil.isEmptyOrNull((String)stickerId) || StringUtil.isEmptyOrNull((String)reqId)) {
            return;
        }
        mPendingDownloadPreviewStickers.put(stickerId, reqId);
    }

    public static void addStickerLocalPathReqId(String stickerId, String reqId) {
        if (StringUtil.isEmptyOrNull((String)stickerId) || StringUtil.isEmptyOrNull((String)reqId)) {
            return;
        }
        mPendingDownloadLocalPathStickers.put(stickerId, reqId);
    }

    public static void FT_OnDownloadByFileIDTimeOutImpl(String reqID, String webFileID) {
        if (StringUtil.isEmptyOrNull((String)reqID) || StringUtil.isEmptyOrNull((String)webFileID)) {
            return;
        }
        String stickerId = StickerManager.getStickerLocalPathFileIdByReqId(reqID);
        if (StringUtil.isSameString((String)stickerId, (String)webFileID)) {
            MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
            if (mgr == null) {
                return;
            }
            MMFileContentMgr fileMgr = PTApp.getInstance().getZoomFileContentMgr();
            if (fileMgr == null) {
                return;
            }
            ZoomFile file = fileMgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            String reqId = mgr.downloadSticker(stickerId, PendingFileDataHelper.getContenFilePath(webFileID, file.getFileName()));
            if (StringUtil.isEmptyOrNull((String)reqId)) {
                return;
            }
            StickerManager.removeStickerPendingDownloadByReqId(reqID);
            StickerManager.addStickerLocalPathReqId(webFileID, reqID);
            fileMgr.destroyFileObject(file);
        }
    }

    public StickerManager(Context context) {
        this.mContext = context;
        this.init();
    }

    public int getPanelMiniHeight() {
        return UIUtil.dip2px((Context)this.mContext, (float)215.0f);
    }

    private void init() {
        this.mStickerPanelViews = this.generatorAllStickerView();
    }

    public List<StickerPanelView> getAllStickerView() {
        return this.mStickerPanelViews;
    }

    public int getCountByCategory(int category) {
        return this.mCateCount.get(category);
    }

    public void setInE2EMode() {
        this.mIsE2EMode = true;
    }

    public int getFirstItemPositionAtCategory(int category) {
        if (CollectionsUtil.isListEmpty(this.mStickerPanelViews)) {
            return -1;
        }
        for (int i = 0; i < this.mStickerPanelViews.size(); ++i) {
            if (this.mStickerPanelViews.get(i).getCategory() != category) continue;
            return i;
        }
        return -1;
    }

    public void refreshAllStickerView() {
        this.mStickerPanelViews = this.generatorAllStickerView();
    }

    private List<StickerPanelView> generatorAllStickerView() {
        ArrayList<StickerPanelView> views = new ArrayList<StickerPanelView>();
        if (this.mIsE2EMode || PTApp.getInstance().isFileTransferDisabled()) {
            return views;
        }
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr != null) {
            PTAppProtos.StickerInfoList stickers = mgr.getStickers();
            if (stickers != null && stickers.getStickersCount() > 0) {
                PrivateStickerPanelView panelView = new PrivateStickerPanelView(this.mContext);
                int stickerCount = 0;
                ArrayList<StickerEvent> stickerEvents = new ArrayList<StickerEvent>();
                for (int i = 0; i < stickers.getStickersCount(); ++i) {
                    PTAppProtos.StickerInfo info = stickers.getStickers(i);
                    if (info == null) continue;
                    StickerEvent event = new StickerEvent(info.getFileId());
                    event.setStickerPath(info.getUploadingPath());
                    event.setStatus(info.getStatus());
                    stickerEvents.add(event);
                }
                Collections.sort(stickerEvents, new PrivateStickerComparator());
                ArrayList<StickerEvent> tmpStickers = new ArrayList<StickerEvent>();
                for (int i = 0; i < stickerEvents.size(); ++i) {
                    tmpStickers.add((StickerEvent)stickerEvents.get(i));
                    if (tmpStickers.size() < ((StickerPanelView)panelView).getMaxStickerSize() && i != stickers.getStickersCount() - 1) continue;
                    ((StickerPanelView)panelView).setContent(tmpStickers);
                    panelView.setIndexInCategory(stickerCount);
                    views.add(panelView);
                    ++stickerCount;
                    if (i == stickerEvents.size() - 1) continue;
                    panelView = new PrivateStickerPanelView(this.mContext);
                    tmpStickers = new ArrayList();
                }
                this.mCateCount.put(2, stickerCount);
            } else {
                PrivateStickerPanelView panelView = new PrivateStickerPanelView(this.mContext);
                ((StickerPanelView)panelView).setContent(new ArrayList<StickerEvent>());
                views.add(panelView);
                this.mCateCount.put(2, 1);
            }
        }
        return views;
    }

    public static class PrivateStickerComparator
    implements Comparator<StickerEvent> {
        private Map<String, Long> mCreateTimes = new HashMap<String, Long>();
        private MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();

        @Override
        public int compare(StickerEvent lhs, StickerEvent rhs) {
            if (lhs == null || rhs == null) {
                return 0;
            }
            long diff = this.getStickerFileCreateTime(lhs) - this.getStickerFileCreateTime(rhs);
            if (diff > 0L) {
                return 1;
            }
            if (diff == 0L) {
                return 0;
            }
            return -1;
        }

        private long getStickerFileCreateTime(StickerEvent event) {
            if (event == null) {
                return 0L;
            }
            String stickerId = event.getStickerId();
            if (StringUtil.isEmptyOrNull((String)stickerId)) {
                return 0L;
            }
            Long time = this.mCreateTimes.get(stickerId);
            if (time != null) {
                return time;
            }
            if (this.mgr == null) {
                return 0L;
            }
            ZoomFile file = this.mgr.getFileWithWebFileID(stickerId);
            if (file == null) {
                String uploadPath = event.getStickerPath();
                if (!StringUtil.isEmptyOrNull((String)uploadPath)) {
                    time = this.mCreateTimes.get(stickerId);
                    if (time == null) {
                        time = CmmTime.getMMNow();
                        this.mCreateTimes.put(stickerId, time);
                    }
                    return time;
                }
                return 0L;
            }
            time = file.getTimeStamp();
            this.mgr.destroyFileObject(file);
            this.mCreateTimes.put(stickerId, time);
            return time;
        }
    }
}

