/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.GiphyPreviewView;
import com.zipow.videobox.view.mm.sticker.CommonEmoji;
import com.zipow.videobox.view.mm.sticker.CommonEmojiHelper;
import com.zipow.videobox.view.mm.sticker.CommonEmojiPanelView;
import com.zipow.videobox.view.mm.sticker.StickerAdapter;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerManager;
import com.zipow.videobox.view.mm.sticker.StickerPanelView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.videomeetings.R;

public class StickerInputView
extends LinearLayout
implements View.OnClickListener,
CommonEmojiPanelView.OnCommonEmojiClickListener {
    private EditText mEditText;
    private LinearLayout mPanelIndicator;
    private ZMViewPager mStickerPager;
    private GiphyPreviewView mGiphyPreview;
    private int mKeyboardHeight;
    private StickerManager mStickerManager;
    private StickerAdapter mStickerAdapter;
    private View mPanelEmoji;
    private View mPanelLinear;
    private View mPanelEmojiType;
    private View mPanelGiphyType;
    private View mPanelStickerType;
    private OnStickerSelectListener mOnGiphySelectListener;
    private OnGiphyPreviewBackClickListener mOnGiphyPreviewBackClickListener;
    private OnPrivateStickerSelectListener mOnPrivateStickerSelectListener;
    private GiphyPreviewView.OnSearchListener mOnsearchListener;
    private GiphyPreviewView.OnGiphyPreviewItemClickListener mGiphyPreviewItemClickListener;
    private CommonEmojiPanelView mPanelCommonEmojisView;
    public static final int MODE_STICK_EMOJI = 0;
    public static final int MODE_STICK_GIPHY = 1;
    public static final int MODE_STICK_GIPHT_HIDE = 2;
    public static final int MODE_STICK_GIPHY_BLOCK = 3;
    private int mode = 0;
    public static final int CATE_ZOOM_EMOJI = 1;
    public static final int CATE_PRIVATE_STICKER = 2;
    private static final String TAG = StickerInputView.class.getSimpleName();

    public StickerInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StickerInputView(Context context) {
        super(context);
        this.init();
    }

    public int getMode() {
        return this.mode;
    }

    public void setKeyboardHeight(int height) {
        if (this.getResources().getConfiguration().orientation == 1 && this.getResources().getDisplayMetrics().heightPixels - height > UIUtil.dip2px((Context)this.getContext(), (float)100.0f)) {
            if (height != this.mKeyboardHeight) {
                PreferenceUtil.saveIntValue("keyboard_height", height);
            }
            this.mKeyboardHeight = height;
        }
    }

    public void setOnPrivateStickerSelectListener(OnPrivateStickerSelectListener listener) {
        this.mOnPrivateStickerSelectListener = listener;
    }

    public void setmOnGiphySelectListener(OnStickerSelectListener mOnGiphySelectListener) {
        this.mOnGiphySelectListener = mOnGiphySelectListener;
    }

    public void setmGiphyPreviewItemClickListener(GiphyPreviewView.OnGiphyPreviewItemClickListener mGiphyPreviewItemClickListener) {
        this.mGiphyPreviewItemClickListener = mGiphyPreviewItemClickListener;
    }

    public void setmOnGiphyPreviewBackClickListener(OnGiphyPreviewBackClickListener mOnGiphyPreviewBackClickListener) {
        this.mOnGiphyPreviewBackClickListener = mOnGiphyPreviewBackClickListener;
    }

    public void onStickerDownloaded(String req_id, int result) {
        this.mStickerAdapter.onStickerDownloaded(req_id, result);
    }

    public void disableCustomSticker() {
        this.mPanelStickerType.setVisibility(8);
        this.mStickerManager.setInE2EMode();
        this.mStickerManager.refreshAllStickerView();
        this.mPanelEmojiType.setSelected(true);
        this.reloadAll();
    }

    public void disableGiphy() {
        this.mGiphyPreview.setVisibility(8);
        this.mPanelGiphyType.setVisibility(8);
    }

    public void setmGiphyPreviewVisible(int visible) {
        this.mGiphyPreview.setPreviewVisible(visible);
        this.mPanelLinear.setVisibility(visible);
        this.mode = visible == 0 ? 1 : 2;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mode == 2) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int height;
            int n = height = this.mode == 0 ? this.mStickerManager.getPanelMiniHeight() + UIUtil.dip2px((Context)this.getContext(), (float)55.0f) : this.mKeyboardHeight + UIUtil.dip2px((Context)this.getContext(), (float)55.0f);
            if (this.getResources().getConfiguration().orientation == 1) {
                height = this.mode == 0 ? (height > this.mKeyboardHeight ? height : this.mKeyboardHeight) : (height > this.mStickerManager.getPanelMiniHeight() + UIUtil.dip2px((Context)this.getContext(), (float)55.0f) ? height : this.mStickerManager.getPanelMiniHeight() + UIUtil.dip2px((Context)this.getContext(), (float)55.0f));
            } else if (this.mode != 0) {
                height = height > this.mStickerManager.getPanelMiniHeight() + UIUtil.dip2px((Context)this.getContext(), (float)55.0f) ? height : this.mStickerManager.getPanelMiniHeight() + UIUtil.dip2px((Context)this.getContext(), (float)55.0f);
            }
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
        }
    }

    public void setEmojiInputEditText(EditText editText) {
        this.mEditText = editText;
    }

    public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        if (result == 0) {
            this.reloadAll();
        }
    }

    public void OnMakePrivateSticker(int result, String src_file_id, String stickerId) {
        if (result == 0) {
            this.reloadAll();
        }
    }

    public void OnDiscardPrivateSticker(int result, String stickerId) {
        if (result == 0) {
            this.reloadAll();
        }
    }

    public void OnPrivateStickersUpdated() {
        this.reloadAll();
    }

    public void onStickerEvent(StickerEvent event) {
        if (event == null) {
            return;
        }
        switch (event.getEventType()) {
            case 2: {
                this.onStickerDelete();
                break;
            }
            case 3: {
                if (this.mOnPrivateStickerSelectListener == null) break;
                this.mOnPrivateStickerSelectListener.onPrivateStickerSelect(event);
                break;
            }
            case 1: {
                this.onEmojiInput(event.getEmoji());
                break;
            }
            case 4: {
                this.onEmojiInput(event.getCommonEmoji());
                break;
            }
        }
    }

    public void reloadAll() {
        this.mStickerManager.refreshAllStickerView();
        int position = this.mStickerPager.getCurrentItem();
        this.mStickerPager.removeAllViews();
        this.mStickerAdapter.updatePanelStickerViews(this.mStickerManager.getAllStickerView());
        this.mStickerAdapter.notifyDataSetChanged();
        if (position >= this.mStickerAdapter.getCount()) {
            position = this.mStickerAdapter.getCount() - 1;
        }
        this.mStickerPager.setCurrentItem(position, false);
    }

    public void onBackPressed() {
        if (this.mode != 0) {
            this.mode = 3;
        }
    }

    private void init() {
        this.mStickerManager = new StickerManager(this.getContext());
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_emoji_input_view, (ViewGroup)this);
        this.mStickerPager = (ZMViewPager)this.findViewById(R.id.emojiPager);
        this.mStickerPager.setDisableScroll(true);
        this.mGiphyPreview = (GiphyPreviewView)this.findViewById(R.id.panelGiphyPreview);
        this.mStickerAdapter = new StickerAdapter(this.getContext(), this.mStickerManager.getAllStickerView(), this);
        this.mStickerPager.setAdapter((PagerAdapter)this.mStickerAdapter);
        this.mPanelLinear = this.findViewById(R.id.panelType);
        this.mPanelEmojiType = this.findViewById(R.id.panelEmojiType);
        this.mPanelGiphyType = this.findViewById(R.id.panelGiphyType);
        this.mPanelStickerType = this.findViewById(R.id.panelStickerType);
        this.mPanelIndicator = (LinearLayout)this.findViewById(R.id.panelEmojiIndicator);
        this.mPanelEmojiType.setSelected(true);
        this.mPanelCommonEmojisView = (CommonEmojiPanelView)this.findViewById(R.id.panelCommonEmojisView);
        this.mPanelEmoji = this.findViewById(R.id.panelEmoji);
        if (PreferenceUtil.readIntValue("giphy_opthion", 0) != 1 || PTApp.getInstance().isFileTransferDisabled()) {
            this.mPanelGiphyType.setVisibility(8);
        } else {
            this.mPanelGiphyType.setVisibility(0);
        }
        this.mPanelCommonEmojisView.setOnCommonEmojiClickListener(this);
        this.mGiphyPreview.setmGiphyPreviewItemClickListener(new GiphyPreviewView.OnGiphyPreviewItemClickListener(){

            @Override
            public void onGiphyPreviewItemClick(GiphyPreviewView.GiphyPreviewItem item) {
                if (StickerInputView.this.mGiphyPreviewItemClickListener != null) {
                    StickerInputView.this.mGiphyPreviewItemClickListener.onGiphyPreviewItemClick(item);
                }
            }
        });
        this.mGiphyPreview.setmOnBackClickListener(new GiphyPreviewView.OnBackClickListener(){

            @Override
            public void onBackClick(View v) {
                if (StickerInputView.this.mOnGiphyPreviewBackClickListener != null) {
                    StickerInputView.this.mode = 3;
                    StickerInputView.this.mOnGiphyPreviewBackClickListener.onGiphyPreviewBack();
                }
            }
        });
        this.mGiphyPreview.setOnSearchListener(new GiphyPreviewView.OnSearchListener(){

            @Override
            public void onSearch(String content) {
                if (StickerInputView.this.mOnsearchListener != null) {
                    StickerInputView.this.mOnsearchListener.onSearch(content);
                }
            }
        });
        this.mStickerPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int position) {
                StickerInputView.this.refreshIndicator();
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mKeyboardHeight = PreferenceUtil.readIntValue("keyboard_height", 0);
        this.mPanelEmojiType.setOnClickListener((View.OnClickListener)this);
        this.mPanelGiphyType.setOnClickListener((View.OnClickListener)this);
        this.mPanelStickerType.setOnClickListener((View.OnClickListener)this);
        Context context = this.getContext();
        if (context instanceof ZMActivity) {
            ((ZMActivity)context).addDisableGestureFinishView((View)this);
        }
    }

    public void onStickerDelete() {
        if (this.mEditText == null) {
            return;
        }
        this.mEditText.dispatchKeyEvent(new KeyEvent(0, 67));
    }

    public void onEmojiInput(EmojiHelper.EmojiIndex emoji) {
        if (this.mEditText == null || emoji == null) {
            return;
        }
        int start = this.mEditText.getSelectionStart();
        int end = this.mEditText.getSelectionEnd();
        CommonEmojiHelper helper = CommonEmojiHelper.getInstance();
        Editable value = this.mEditText.getText();
        value.replace(start, end, helper.formatImgEmojiSize(this.mEditText.getTextSize(), emoji.getShortCut(), true));
    }

    public void onEmojiInput(CommonEmoji emoji) {
        if (this.mEditText == null || emoji == null) {
            return;
        }
        int start = this.mEditText.getSelectionStart();
        int end = this.mEditText.getSelectionEnd();
        Editable value = this.mEditText.getText();
        CharSequence input = CommonEmojiHelper.getInstance().formatImgEmojiSize(this.mEditText.getTextSize(), emoji.getOutput(), true);
        value.replace(start, end, input);
    }

    private void refreshIndicator() {
        int selectPos = this.mStickerPager.getCurrentItem();
        StickerPanelView view = this.mStickerAdapter.getItem(selectPos);
        if (view == null) {
            return;
        }
        int index = view.getIndexInCategory();
        int category = view.getCategory();
        int count = this.mStickerManager.getCountByCategory(category);
        this.mPanelIndicator.removeAllViews();
        this.mPanelEmojiType.setSelected(category == 1);
        this.mPanelStickerType.setSelected(category == 2);
        if (count < 2) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            ImageView imageView = new ImageView(this.getContext());
            int imageRes = R.drawable.zm_btn_switch_scene_selected_normal;
            if (i == index) {
                imageRes = R.drawable.zm_btn_switch_scene_unselected_normal;
            }
            imageView.setImageResource(imageRes);
            int padding = UIUtil.dip2px((Context)this.getContext(), (float)3.0f);
            imageView.setPadding(padding, 0, padding, 0);
            this.mPanelIndicator.addView((View)imageView);
        }
    }

    public void setOnsearchListener(GiphyPreviewView.OnSearchListener mOnsearchListener) {
        this.mOnsearchListener = mOnsearchListener;
    }

    public void Indicate_GetGIFFromGiphyResultIml(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        if (result == 0) {
            ArrayList<PTAppProtos.GiphyMsgInfo> list = new ArrayList<PTAppProtos.GiphyMsgInfo>();
            if (giphyIds != null && !giphyIds.isEmpty()) {
                for (String id2 : giphyIds) {
                    PTAppProtos.GiphyMsgInfo item;
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null || TextUtils.isEmpty((CharSequence)id2) || (item = messenger.getGiphyInfo(id2)) == null) continue;
                    list.add(item);
                }
            }
            this.mGiphyPreview.setDatas(msgStr, list);
        } else {
            this.mGiphyPreview.updateEmptyViewMode(2);
        }
    }

    public void Indicate_GetHotGiphyInfoResult(int result, String reqID, List<String> giphyIds, String msgStr, String sessionID) {
        if (result == 0) {
            ArrayList<PTAppProtos.GiphyMsgInfo> list = new ArrayList<PTAppProtos.GiphyMsgInfo>();
            if (giphyIds != null && !giphyIds.isEmpty()) {
                for (String id2 : giphyIds) {
                    PTAppProtos.GiphyMsgInfo item;
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null || TextUtils.isEmpty((CharSequence)id2) || (item = messenger.getGiphyInfo(id2)) == null) continue;
                    list.add(item);
                }
            }
            if (list.size() >= 7) {
                ArrayList oddList = new ArrayList();
                ArrayList evenList = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    if (i % 2 == 0) {
                        evenList.add(list.get(i));
                        continue;
                    }
                    oddList.add(list.get(i));
                }
                list.clear();
                list.addAll(evenList);
                list.addAll(oddList);
            }
            this.mGiphyPreview.setDatas(msgStr, list);
        } else {
            this.mGiphyPreview.updateEmptyViewMode(2);
        }
    }

    public boolean hasGiphyData() {
        return this.mGiphyPreview != null && this.mGiphyPreview.hasData();
    }

    public void setGiphyVisiable(int visiable) {
        if (this.mPanelGiphyType != null) {
            this.mPanelGiphyType.setVisibility(visiable);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.panelEmojiType) {
            this.mode = 0;
            this.mPanelEmojiType.setSelected(true);
            this.mPanelStickerType.setSelected(false);
            this.mPanelGiphyType.setSelected(false);
            this.mGiphyPreview.setVisibility(8);
            this.mPanelEmoji.setVisibility(8);
            this.mPanelCommonEmojisView.setVisibility(0);
        } else if (id2 == R.id.panelStickerType) {
            this.mode = 0;
            this.mPanelEmojiType.setSelected(false);
            this.mPanelGiphyType.setSelected(false);
            this.mPanelStickerType.setSelected(true);
            this.mGiphyPreview.setVisibility(8);
            this.mPanelEmoji.setVisibility(0);
            int postion = this.mStickerManager.getFirstItemPositionAtCategory(2);
            if (postion != -1) {
                this.mStickerPager.setCurrentItem(postion, true);
            }
            this.mPanelCommonEmojisView.setVisibility(8);
        } else if (id2 == R.id.panelGiphyType) {
            this.mode = 1;
            this.mPanelEmojiType.setSelected(false);
            this.mPanelGiphyType.setSelected(true);
            this.mPanelStickerType.setSelected(false);
            this.mGiphyPreview.setVisibility(0);
            this.mPanelEmoji.setVisibility(8);
            this.mPanelCommonEmojisView.setVisibility(8);
        }
        this.requestLayout();
        if (this.mOnGiphySelectListener != null) {
            this.mOnGiphySelectListener.onStickerSelect(v);
        }
    }

    @Override
    public void onCommonEmojiClick(CommonEmoji emoji) {
        this.onEmojiInput(emoji);
    }

    @Override
    public void onZoomEmojiClick(EmojiHelper.EmojiIndex emoji) {
        this.onEmojiInput(emoji);
    }

    public static interface OnStickerSelectListener {
        public void onStickerSelect(View var1);
    }

    public static interface OnGiphyPreviewBackClickListener {
        public void onGiphyPreviewBack();
    }

    public static interface OnPrivateStickerSelectListener {
        public void onPrivateStickerSelect(StickerEvent var1);
    }
}

