/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerInputView;
import com.zipow.videobox.view.mm.sticker.StickerPanelView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;

public class StickerAdapter
extends PagerAdapter
implements StickerPanelView.OnStickerEventLisener {
    private Context mContext;
    private List<StickerPanelView> mPanelStickerViews;
    private StickerInputView mEmojiInputView;

    public StickerAdapter(Context context, List<StickerPanelView> panelStickerViews, StickerInputView emojiInputView) {
        this.mContext = context;
        this.mPanelStickerViews = panelStickerViews;
        this.mEmojiInputView = emojiInputView;
        this.registerListener();
    }

    public void updatePanelStickerViews(List<StickerPanelView> panelStickerViews) {
        if (panelStickerViews == null) {
            return;
        }
        if (this.mPanelStickerViews == null) {
            this.mPanelStickerViews = new ArrayList<StickerPanelView>();
        } else {
            this.mPanelStickerViews.clear();
        }
        this.mPanelStickerViews.addAll(panelStickerViews);
        this.registerListener();
    }

    private void registerListener() {
        if (!CollectionsUtil.isListEmpty(this.mPanelStickerViews)) {
            for (StickerPanelView view : this.mPanelStickerViews) {
                view.setOnStickerEventListener(this);
            }
        }
    }

    public void onStickerDownloaded(String req_id, int result) {
        if (this.mPanelStickerViews == null) {
            return;
        }
        for (StickerPanelView view : this.mPanelStickerViews) {
            view.onStickerDownloaded(req_id, result);
        }
    }

    public StickerPanelView getItem(int position) {
        if (CollectionsUtil.isListEmpty(this.mPanelStickerViews)) {
            return null;
        }
        if (position < 0 || position >= this.mPanelStickerViews.size()) {
            return null;
        }
        return this.mPanelStickerViews.get(position);
    }

    public int getItemPosition(Object object) {
        if (this.mPanelStickerViews != null && !this.mPanelStickerViews.contains(object)) {
            return -2;
        }
        return -1;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.mPanelStickerViews == null || this.mPanelStickerViews.size() <= position) {
            return;
        }
        container.removeView((View)this.mPanelStickerViews.get(position));
    }

    public Object instantiateItem(ViewGroup container, int position) {
        if (this.mPanelStickerViews == null || this.mPanelStickerViews.size() <= position) {
            return null;
        }
        View view = (View)this.mPanelStickerViews.get(position);
        if (view == null) {
            view = new View(this.mContext);
        }
        container.addView(view);
        return view;
    }

    public int getCount() {
        if (CollectionsUtil.isListEmpty(this.mPanelStickerViews)) {
            return 0;
        }
        return this.mPanelStickerViews.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public void onStickerEvent(StickerEvent event) {
        if (this.mEmojiInputView == null) {
            return;
        }
        this.mEmojiInputView.onStickerEvent(event);
    }
}

