/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.MMPrivateStickerMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import com.zipow.videobox.view.mm.sticker.MMPrivateStickerFragment;
import com.zipow.videobox.view.mm.sticker.StickerEvent;
import com.zipow.videobox.view.mm.sticker.StickerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMPrivateStickerGridView
extends GridView
implements AdapterView.OnItemClickListener {
    private ArrayList<String> mSelectStickers = new ArrayList();
    private StickerAdapter mStickerAdapter;
    private MMPrivateStickerFragment mFragment;

    public MMPrivateStickerGridView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMPrivateStickerGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMPrivateStickerGridView(Context context) {
        super(context);
        this.init();
    }

    public void setParentFragment(MMPrivateStickerFragment fragment) {
        this.mFragment = fragment;
    }

    public void onAddSticker(String stickerId) {
        this.mStickerAdapter.onAddSticker(this.createStickerCell(PTApp.getInstance().getZoomFileContentMgr(), stickerId, NetworkUtil.getDataNetworkType((Context)this.getContext()) == 1, PTApp.getInstance().getZoomPrivateStickerMgr()));
        this.mStickerAdapter.notifyDataSetChanged();
    }

    public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        this.mStickerAdapter.removeSticker(req_id);
        if (result == 0) {
            this.onAddSticker(stickerId);
        }
        this.mStickerAdapter.notifyDataSetChanged();
    }

    public void onRemoveSticker(String stickerId) {
        if (this.mStickerAdapter.removeSticker(stickerId) != null) {
            this.mStickerAdapter.notifyDataSetChanged();
        }
    }

    public void updateOrAddUploadSticker(String reqId, int ratio) {
        boolean find = false;
        List<PendingFileDataHelper.PendingFileInfo> infos = PendingFileDataHelper.getInstance().getUploadPendingStickerInfos();
        for (PendingFileDataHelper.PendingFileInfo info : infos) {
            if (!StringUtil.isSameString((String)info.getReqId(), (String)reqId) || reqId == null) continue;
            this.mStickerAdapter.updateOrAddUploadSticker(reqId, ratio);
            find = true;
        }
        if (find) {
            this.mStickerAdapter.notifyDataSetChanged();
        }
    }

    public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        if (result != 0) {
            this.mStickerAdapter.removeSticker(webFileID);
        }
    }

    public void removeSticker(List<String> stickerIds) {
        if (CollectionsUtil.isListEmpty(stickerIds)) {
            return;
        }
        for (int i = 0; i < stickerIds.size(); ++i) {
            String stickerId = stickerIds.get(i);
            this.mStickerAdapter.removeSticker(stickerId);
            this.mSelectStickers.remove(stickerId);
            --i;
        }
        this.mStickerAdapter.notifyDataSetChanged();
        if (this.mFragment != null) {
            this.mFragment.onStickerSelected(this.mSelectStickers);
        }
    }

    public void onUpdateSticker(String stickerId) {
        ItemBean bean = this.createStickerCell(PTApp.getInstance().getZoomFileContentMgr(), stickerId, NetworkUtil.getDataNetworkType((Context)this.getContext()) == 1, PTApp.getInstance().getZoomPrivateStickerMgr());
        this.mStickerAdapter.updateOrAddSticker(bean);
        this.mStickerAdapter.notifyDataSetChanged();
    }

    public boolean hasSticker(String stickerId) {
        return this.mStickerAdapter.hasSticker(stickerId);
    }

    public List<String> getSelectStickers() {
        return this.mSelectStickers;
    }

    public void refreshData() {
        MMPrivateStickerMgr mgr = PTApp.getInstance().getZoomPrivateStickerMgr();
        if (mgr == null) {
            return;
        }
        PTAppProtos.StickerInfoList stickers = mgr.getStickers();
        if (stickers == null) {
            return;
        }
        boolean isWifiMode = NetworkUtil.getDataNetworkType((Context)this.getContext()) == 1;
        ArrayList<ItemBean> data = new ArrayList<ItemBean>();
        data.add(new ItemBean(1, null));
        MMFileContentMgr fileMgr = PTApp.getInstance().getZoomFileContentMgr();
        if (fileMgr == null) {
            return;
        }
        ArrayList<StickerEvent> stickerEvents = new ArrayList<StickerEvent>();
        for (int i = 0; i < stickers.getStickersCount(); ++i) {
            PTAppProtos.StickerInfo info = stickers.getStickers(i);
            if (info == null) continue;
            StickerEvent event = new StickerEvent(info.getFileId());
            event.setStickerPath(info.getUploadingPath());
            event.setStatus(info.getStatus());
            stickerEvents.add(event);
        }
        Collections.sort(stickerEvents, new StickerManager.PrivateStickerComparator());
        for (StickerEvent event : stickerEvents) {
            String id2 = event.getStickerId();
            String path = event.getStickerPath();
            ItemBean item = null;
            if (StringUtil.isEmptyOrNull((String)path)) {
                item = this.createStickerCell(fileMgr, id2, isWifiMode, mgr);
            } else {
                item = new ItemBean(0, id2);
                item.path = path;
            }
            if (item == null) continue;
            data.add(item);
        }
        List<PendingFileDataHelper.PendingFileInfo> uploads = PendingFileDataHelper.getInstance().getUploadPendingStickerInfos();
        if (!CollectionsUtil.isListEmpty(uploads)) {
            for (PendingFileDataHelper.PendingFileInfo info : uploads) {
                ItemBean item = new ItemBean(2, info.getReqId());
                item.ratio = info.getRatio();
                data.add(item);
            }
        }
        this.mStickerAdapter = new StickerAdapter(data, this.getContext());
        this.setAdapter((ListAdapter)this.mStickerAdapter);
        this.mStickerAdapter.setSelectStickes(this.mSelectStickers);
    }

    private ItemBean createStickerCell(MMFileContentMgr fileMgr, String id2, boolean isWifiMode, MMPrivateStickerMgr stickerMgr) {
        String reqId;
        ZoomFile file = fileMgr.getFileWithWebFileID(id2);
        if (file == null) {
            return null;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, fileMgr);
        if (mmFile == null) {
            return null;
        }
        ItemBean item = new ItemBean(0, id2);
        String previewPath = mmFile.getPicturePreviewPath();
        String localPath = mmFile.getLocalPath();
        if (isWifiMode && StringUtil.isEmptyOrNull((String)localPath) && !StickerManager.isStickerLocalPathDownloading(id2)) {
            reqId = stickerMgr.downloadSticker(id2, PendingFileDataHelper.getContenFilePath(id2, file.getFileName()));
            StickerManager.addStickerLocalPathReqId(id2, reqId);
        }
        if (StringUtil.isEmptyOrNull((String)previewPath)) {
            if (!StickerManager.isStickerPreviewDownloading(id2)) {
                reqId = stickerMgr.downloadStickerPreview(id2);
                StickerManager.addStickerPreviewReqId(id2, reqId);
            }
            if (!StringUtil.isEmptyOrNull((String)localPath)) {
                item.path = localPath;
            }
        } else {
            item.path = previewPath;
        }
        return item;
    }

    public void onStickerDownloaded(String req_id) {
        String id2 = StickerManager.getStickerPreviewFileIdByReqId(req_id);
        if (StringUtil.isEmptyOrNull((String)id2)) {
            id2 = StickerManager.getStickerLocalPathFileIdByReqId(req_id);
        }
        if (!StringUtil.isEmptyOrNull((String)id2)) {
            this.mStickerAdapter.updateOrAddSticker(this.createStickerCell(PTApp.getInstance().getZoomFileContentMgr(), id2, NetworkUtil.getDataNetworkType((Context)this.getContext()) == 1, PTApp.getInstance().getZoomPrivateStickerMgr()));
            this.mStickerAdapter.notifyDataSetChanged();
        }
    }

    private void init() {
        this.setColumnWidth(UIUtil.dip2px((Context)this.getContext(), (float)80.0f));
        this.setNumColumns(-1);
        this.setStretchMode(2);
        this.setVerticalSpacing(UIUtil.dip2px((Context)this.getContext(), (float)10.0f));
        this.setHorizontalSpacing(UIUtil.dip2px((Context)this.getContext(), (float)5.0f));
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new ColorDrawable(this.getResources().getColor(R.color.zm_transparent)));
        this.refreshData();
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        ItemBean bean = this.mStickerAdapter.getItem(position);
        if (bean == null) {
            return;
        }
        switch (bean.type) {
            case 1: {
                this.onAddStickerClick();
                break;
            }
            case 0: {
                this.onStickerSelect(bean.stickerId);
                break;
            }
        }
    }

    private void onAddStickerClick() {
        if (this.mFragment != null) {
            this.mFragment.onAddStickerClick();
        }
    }

    private void onStickerSelect(String sticker) {
        if (StringUtil.isEmptyOrNull((String)sticker)) {
            return;
        }
        if (this.mSelectStickers.contains(sticker)) {
            this.mSelectStickers.remove(sticker);
        } else {
            this.mSelectStickers.add(sticker);
        }
        this.mStickerAdapter.setSelectStickes(this.mSelectStickers);
        this.mStickerAdapter.notifyDataSetChanged();
        if (this.mFragment != null) {
            this.mFragment.onStickerSelected(this.mSelectStickers);
        }
    }

    static class StickerAdapter
    extends BaseAdapter {
        private static final String TAG_ADD_STICKER = "addSticker";
        private static final String TAG_STICKER = "sticker";
        private static final String TAG_UPLOAD_STICKER = "uploadSticker";
        private Context mContext;
        private List<ItemBean> mStickers;
        private List<String> mSelectStickers = new ArrayList<String>();

        StickerAdapter(List<ItemBean> stickers, Context context) {
            this.mStickers = stickers;
            this.mContext = context;
        }

        public void setSelectStickes(List<String> stickers) {
            if (stickers == null) {
                this.mSelectStickers.clear();
            } else {
                this.mSelectStickers = stickers;
            }
        }

        public void addSelectSticker(String sticker) {
            if (this.mSelectStickers == null) {
                this.mSelectStickers = new ArrayList<String>();
            }
            this.mSelectStickers.add(sticker);
        }

        public boolean hasSticker(String sticker) {
            for (int i = 0; i < this.mStickers.size(); ++i) {
                ItemBean bean = this.mStickers.get(i);
                if (!StringUtil.isSameString((String)bean.stickerId, (String)sticker)) continue;
                return true;
            }
            return false;
        }

        public void updateOrAddSticker(ItemBean item) {
            if (item == null) {
                return;
            }
            if (this.mStickers == null) {
                this.mStickers = new ArrayList<ItemBean>();
            }
            boolean isFind = false;
            for (int i = 0; i < this.mStickers.size(); ++i) {
                ItemBean bean = this.mStickers.get(i);
                if (!StringUtil.isSameString((String)bean.stickerId, (String)item.stickerId)) continue;
                this.mStickers.set(i, item);
                isFind = true;
                break;
            }
            if (!isFind) {
                this.mStickers.add(item);
            }
        }

        public void updateOrAddUploadSticker(String reqId, int ratio) {
            if (this.mStickers == null) {
                return;
            }
            ItemBean target = null;
            for (ItemBean bean : this.mStickers) {
                if (bean.type != 2 || !StringUtil.isSameString((String)reqId, (String)bean.stickerId)) continue;
                target = bean;
                break;
            }
            if (target == null) {
                target = new ItemBean(2, reqId);
                this.mStickers.add(target);
            }
            target.ratio = ratio;
        }

        public void onAddSticker(ItemBean bean) {
            if (this.mStickers == null) {
                this.mStickers = new ArrayList<ItemBean>();
            }
            this.mStickers.add(bean);
        }

        public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
            ItemBean target = null;
            for (ItemBean bean : this.mStickers) {
                if (bean.type != 2 || !StringUtil.isSameString((String)req_id, (String)bean.stickerId)) continue;
                target = bean;
                break;
            }
            if (result != 0) {
                if (target != null) {
                    this.mStickers.remove(target);
                }
                return;
            }
            if (target != null) {
                target.type = 0;
                target.stickerId = stickerId;
            } else {
                ItemBean bean = new ItemBean(0, stickerId);
                this.mStickers.add(bean);
            }
        }

        public ItemBean removeSticker(String stickerId) {
            if (this.mStickers == null) {
                return null;
            }
            ItemBean deleted = null;
            for (int i = 0; i < this.mStickers.size(); ++i) {
                ItemBean item = this.mStickers.get(i);
                if (item == null) {
                    this.mStickers.remove(i);
                    --i;
                    continue;
                }
                if (!StringUtil.isSameString((String)stickerId, (String)item.stickerId)) continue;
                this.mStickers.remove(i);
                --i;
                deleted = item;
            }
            return deleted;
        }

        public int getItemViewType(int position) {
            ItemBean bean = this.getItem(position);
            if (bean == null) {
                return 0;
            }
            return bean.type;
        }

        public int getViewTypeCount() {
            return 3;
        }

        public int getCount() {
            return this.mStickers == null ? 0 : this.mStickers.size();
        }

        public ItemBean getItem(int position) {
            if (this.mStickers == null) {
                return null;
            }
            if (this.mStickers.size() == 0 || this.mStickers.size() <= position) {
                return null;
            }
            return this.mStickers.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ItemBean bean = this.getItem(position);
            if (bean == null) {
                return new View(this.mContext);
            }
            if (bean.type == 0) {
                return this.createStickerView(bean, convertView, parent);
            }
            if (bean.type == 1) {
                return this.createAddStickerView(convertView, parent);
            }
            if (bean.type == 2) {
                return this.createUploadView(bean, convertView, parent);
            }
            return new View(this.mContext);
        }

        private View createUploadView(ItemBean bean, View convertView, ViewGroup parent) {
            int p;
            if (bean == null) {
                return new View(this.mContext);
            }
            LinearLayout cell = null;
            ImageView ratioImg = null;
            if (convertView == null || !TAG_UPLOAD_STICKER.equals(convertView.getTag())) {
                cell = new LinearLayout(this.mContext);
                cell.setTag((Object)TAG_UPLOAD_STICKER);
                cell.setGravity(17);
                cell.setPadding(0, UIUtil.dip2px((Context)this.mContext, (float)5.0f), 0, UIUtil.dip2px((Context)this.mContext, (float)5.0f));
                LinearLayout bgView = new LinearLayout(this.mContext);
                bgView.setGravity(17);
                AbsListView.LayoutParams lp = new AbsListView.LayoutParams(UIUtil.dip2px((Context)this.mContext, (float)80.0f), UIUtil.dip2px((Context)this.mContext, (float)80.0f));
                cell.addView((View)bgView, (ViewGroup.LayoutParams)lp);
                int radius = UIUtil.dip2px((Context)this.mContext, (float)20.0f);
                float[] radii = new float[8];
                for (int i = 0; i < radii.length; ++i) {
                    radii[i] = radius;
                }
                RoundRectShape shape = new RoundRectShape(radii, null, null);
                ShapeDrawable bg = new ShapeDrawable((Shape)shape);
                bg.getPaint().setColor(this.mContext.getResources().getColor(R.color.zm_gray_3));
                bgView.setBackground((Drawable)bg);
                ratioImg = new ImageView(this.mContext);
                bgView.addView((View)ratioImg);
            } else {
                cell = (LinearLayout)convertView;
                ratioImg = (ImageView)((LinearLayout)cell.getChildAt(0)).getChildAt(0);
            }
            Object tag = ratioImg.getTag();
            if (tag != null && tag instanceof Integer && (p = ((Integer)tag).intValue()) == bean.ratio) {
                return cell;
            }
            int radius = UIUtil.dip2px((Context)this.mContext, (float)25.0f);
            Bitmap map = Bitmap.createBitmap((int)(radius * 2), (int)(radius * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(map);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(this.mContext.getResources().getColor(R.color.zm_white));
            canvas.drawCircle((float)radius, (float)radius, (float)radius, paint);
            paint.setColor(this.mContext.getResources().getColor(R.color.zm_gray_3));
            int stokeWidth = UIUtil.dip2px((Context)this.mContext, (float)5.0f);
            RectF oval = new RectF((float)stokeWidth, (float)stokeWidth, (float)(radius * 2 - stokeWidth), (float)(radius * 2 - stokeWidth));
            float angel = (float)bean.ratio * 3.6f;
            canvas.drawArc(oval, -90.0f + angel, 360.0f - angel, true, paint);
            ratioImg.setImageBitmap(map);
            return cell;
        }

        private View createAddStickerView(View convertView, ViewGroup parent) {
            if (convertView == null || !TAG_ADD_STICKER.equals(convertView.getTag())) {
                LinearLayout panel = new LinearLayout(this.mContext);
                panel.setTag((Object)TAG_ADD_STICKER);
                panel.setMinimumHeight(UIUtil.dip2px((Context)this.mContext, (float)90.0f));
                panel.setMinimumWidth(UIUtil.dip2px((Context)this.mContext, (float)80.0f));
                ImageView imageView = new ImageView(this.mContext);
                imageView.setImageResource(R.drawable.zm_mm_sticker_add);
                panel.addView((View)imageView);
                panel.setGravity(17);
                convertView = panel;
            }
            return convertView;
        }

        private View createStickerView(ItemBean bean, View convertView, ViewGroup parent) {
            if (convertView == null || !TAG_STICKER.equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_sticker_setting_item, null);
                convertView.setTag((Object)TAG_STICKER);
            }
            if (bean == null) {
                return convertView;
            }
            String stickerId = bean.stickerId;
            if (StringUtil.isEmptyOrNull((String)stickerId)) {
                return convertView;
            }
            String path = bean.path;
            View bar = convertView.findViewById(R.id.progressBar);
            View selectBgView = convertView.findViewById(R.id.selectBGView);
            View selectLineView = convertView.findViewById(R.id.selectBGLineView);
            ImageView image = (ImageView)convertView.findViewById(R.id.imgSticker);
            boolean isSelect = this.mSelectStickers.contains(bean.stickerId);
            selectBgView.setVisibility(isSelect ? 0 : 4);
            selectLineView.setVisibility(isSelect ? 0 : 4);
            if (StringUtil.isEmptyOrNull((String)path) || !ImageUtil.isValidImageFile(path)) {
                bar.setVisibility(0);
                image.setVisibility(4);
            } else {
                bar.setVisibility(4);
                image.setVisibility(0);
                LazyLoadDrawable drawable2 = new LazyLoadDrawable(path);
                drawable2.setMaxArea(UIUtil.dip2px((Context)this.mContext, (float)6400.0f));
                image.setImageDrawable((Drawable)drawable2);
            }
            return convertView;
        }
    }

    static class ItemBean {
        public static final int TYPE_UPLOAD = 2;
        public static final int TYPE_ACTION_ADD_STICKER = 1;
        public static final int TYPE_DATA = 0;
        private int type;
        private String stickerId;
        private int ratio;
        private String path;

        ItemBean(int type, String stickerId) {
            this.type = type;
            this.stickerId = stickerId;
        }

        boolean isSameBean(ItemBean bean) {
            if (bean == null) {
                return false;
            }
            return this.type == bean.type && StringUtil.isSameString((String)this.stickerId, (String)bean.stickerId);
        }
    }
}

