/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm.sticker;

import android.app.DownloadManager;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.TypefaceSpan;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.mm.sticker.CommonEmoji;
import com.zipow.videobox.view.mm.sticker.EmojiCategory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class CommonEmojiHelper {
    private ListenerList mListenerList = new ListenerList();
    private static final String EMOJI_ONE_PATH = "emoji_one_path";
    private static final String TAG = CommonEmojiHelper.class.getSimpleName();
    private static CommonEmojiHelper mInstance;
    private Map<String, CommonEmoji> mEmojiOneUnicodes = new HashMap<String, CommonEmoji>();
    private Map<Character, MatchEmojiBean> mMatchedEmojiOneUnicodes = new HashMap<Character, MatchEmojiBean>();
    private List<EmojiCategory> mEmojiCategories = new ArrayList<EmojiCategory>();
    private static final HashMap<String, String> mShortNameToUnicode;
    private static final Pattern SHORTNAME_PATTERN;
    private String mUpgradeReqId;
    private Typeface mEmojiTypeface;
    private Handler mHandle = new Handler();
    private Runnable mCheckDownloadRunnable = new Runnable(){

        @Override
        public void run() {
            CommonEmojiHelper.this.onDowloadChange();
        }
    };
    private static final Pattern EMOJI_PATTERN;
    private ZoomMessengerUI.IZoomMessengerUIListener messengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_DownloadFileByUrlIml(String reqID, int result) {
            CommonEmojiHelper.this.Indicate_DownloadFileByUrlIml(reqID, result);
        }
    };

    public static String shortnameToUnicode(String input) {
        Matcher matcher = SHORTNAME_PATTERN.matcher(input);
        while (matcher.find()) {
            String unicode = mShortNameToUnicode.get(matcher.group(1));
            if (unicode == null) continue;
            input = input.replace(":" + matcher.group(1) + ":", unicode);
        }
        return input;
    }

    private CommonEmojiHelper() {
        this.checkDownloadingPkg();
        this.parseConfigFile();
        this.checkUpgradePkg();
    }

    public static synchronized CommonEmojiHelper getInstance() {
        if (mInstance == null) {
            mInstance = new CommonEmojiHelper();
        }
        return mInstance;
    }

    public synchronized Typeface getEmojiTypeFace() {
        return this.mEmojiTypeface;
    }

    public void addListener(OnEmojiPackageInstallListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = this.mListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != l) continue;
            this.removeListener((OnEmojiPackageInstallListener)listeners[i]);
        }
        this.mListenerList.add((IListener)l);
    }

    public void removeListener(OnEmojiPackageInstallListener l) {
        this.mListenerList.remove((IListener)l);
    }

    public void parseConfigFile() {
        this.mEmojiCategories.clear();
        this.mEmojiOneUnicodes.clear();
        this.parseEmojiConfig();
        this.parseEmojiCategoryConfig();
        this.addZoomBuildInEmojis();
        String ttfPath = this.getCommonEmojiTTFPath();
        if (OsUtil.isAtLeastKLP() && !StringUtil.isEmptyOrNull((String)ttfPath) && new File(ttfPath).exists()) {
            try {
                this.mEmojiTypeface = Typeface.createFromFile((String)ttfPath);
            }
            catch (Exception e) {
                this.mEmojiCategories.clear();
                this.mEmojiOneUnicodes.clear();
            }
        }
    }

    private void addZoomBuildInEmojis() {
        EmojiCategory category = new EmojiCategory();
        Context context = VideoBoxApplication.getGlobalContext();
        if (context == null) {
            return;
        }
        category.setName(context.getString(R.string.zm_app_name));
        category.setLabel(context.getString(R.string.zm_app_name));
        category.setIconResource(R.drawable.zm_mm_emoji_category_zoom);
        List<CommonEmoji> emojis = category.getEmojis();
        EmojiHelper emojiHelper = EmojiHelper.getInstance();
        for (EmojiHelper.EmojiIndex emoji : emojiHelper.getZMEmojis()) {
            CommonEmoji e = new CommonEmoji();
            String output = emoji.getShortCut();
            EmojiHelper.ZoomEmojiSpan span = new EmojiHelper.ZoomEmojiSpan(ContextCompat.getDrawable((Context)context, (int)emoji.getDrawResource()));
            SpannableString str = new SpannableString((CharSequence)output);
            str.setSpan((Object)span, 0, str.length(), 33);
            e.setCategory(context.getString(R.string.zm_app_name));
            e.setOutput((CharSequence)str);
            e.setShortName(emoji.getShortCut());
            emojis.add(e);
        }
        this.mEmojiCategories.add(category);
    }

    public List<EmojiCategory> getEmojiCategories() {
        return this.mEmojiCategories;
    }

    public CharSequence formatImgEmojiSize(float textSize, CharSequence text, boolean needReParse) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        int size = (int)(1.25f * textSize);
        ZMEmojiSpannableStringBuilder value = !needReParse && this.isTransferToEmoji(text) ? (ZMEmojiSpannableStringBuilder)((Object)text) : CommonEmojiHelper.getInstance().tranToEmojiText(text);
        EmojiHelper.ZoomEmojiSpan[] spans = (EmojiHelper.ZoomEmojiSpan[])value.getSpans(0, value.length(), EmojiHelper.ZoomEmojiSpan.class);
        if (spans != null) {
            for (EmojiHelper.ZoomEmojiSpan span : spans) {
                span.updateSize(size, size);
            }
        }
        return value;
    }

    public boolean isAllEmojis(CharSequence source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return false;
        }
        if (!this.isTransferToEmoji((CharSequence)source)) {
            source = this.tranToEmojiText((CharSequence)source);
        }
        boolean[] mask = new boolean[source.length()];
        SpannableString spannableString = new SpannableString((CharSequence)source);
        CommonEmojiSpan[] spans = (CommonEmojiSpan[])spannableString.getSpans(0, source.length(), CommonEmojiSpan.class);
        if (spans != null) {
            for (CommonEmojiSpan span : spans) {
                int end = spannableString.getSpanEnd((Object)span);
                for (int i = spannableString.getSpanStart((Object)span); i < end; ++i) {
                    mask[i] = true;
                }
            }
        }
        EmojiHelper.ZoomEmojiSpan[] zoomSpans = (EmojiHelper.ZoomEmojiSpan[])spannableString.getSpans(0, spannableString.length(), EmojiHelper.ZoomEmojiSpan.class);
        if (spans != null) {
            for (EmojiHelper.ZoomEmojiSpan span : zoomSpans) {
                int end = spannableString.getSpanEnd((Object)span);
                for (int i = spannableString.getSpanStart((Object)span); i < end; ++i) {
                    mask[i] = true;
                }
            }
        }
        for (boolean b : mask) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public boolean isTransferToEmoji(CharSequence source) {
        return source instanceof ZMEmojiSpannableStringBuilder;
    }

    public ZMEmojiSpannableStringBuilder tranToEmojiText(CharSequence source) {
        if (source == null || source.length() == 0 || this.mEmojiTypeface == null) {
            return EmojiHelper.getInstance().tranToEmojiText(source);
        }
        ZMEmojiSpannableStringBuilder spannableString = new ZMEmojiSpannableStringBuilder(source);
        CommonEmojiSpan[] spans = (CommonEmojiSpan[])spannableString.getSpans(0, source.length(), CommonEmojiSpan.class);
        if (spans != null) {
            for (CommonEmojiSpan span : spans) {
                spannableString.removeSpan((Object)span);
            }
        }
        block1: for (int i = 0; i < source.length(); ++i) {
            int maxLength;
            char cKey = source.charAt(i);
            MatchEmojiBean bean = this.mMatchedEmojiOneUnicodes.get(Character.valueOf(cKey));
            if (bean == null) continue;
            for (int j = maxLength = bean.emojiMaxLength > source.length() - i ? source.length() - i : bean.emojiMaxLength; j > 0; --j) {
                String key = source.subSequence(i, i + j).toString();
                CommonEmoji emoji = bean.emojis.get(key);
                if (emoji == null) continue;
                CommonEmojiSpan is = new CommonEmojiSpan();
                spannableString.setSpan((Object)is, i, i + j, 33);
                i += j - 1;
                continue block1;
            }
        }
        return EmojiHelper.getInstance().tranToEmojiText((CharSequence)((Object)spannableString));
    }

    private void checkUpgradePkg() {
        if (!this.isEmojiInstalled()) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String conf = messenger.emojiVersionGetJsonStr();
        if (StringUtil.isEmptyOrNull((String)conf)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(conf);
            String emojiOneVersion = jsonObject.getJSONObject("emojione").optString("version");
            if (StringUtil.isEmptyOrNull((String)emojiOneVersion)) {
                return;
            }
            String localVersion = PreferenceUtil.readStringValue("common_emoji_version", null);
            if (StringUtil.isSameString((String)localVersion, (String)emojiOneVersion)) {
                return;
            }
            this.mUpgradeReqId = messenger.downloadFileByUrl(this.getDownloadUrl(emojiOneVersion), AppUtil.getCachePath() + File.separator + "emojione.zip", true);
            if (!StringUtil.isEmptyOrNull((String)this.mUpgradeReqId)) {
                ZoomMessengerUI.getInstance().addListener(this.messengerUIListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void Indicate_DownloadFileByUrlIml(String reqID, int result) {
        if (StringUtil.isSameString((String)reqID, (String)this.mUpgradeReqId)) {
            if (result == 0 && this.parseEmojiPackage(AppUtil.getCachePath() + File.separator + "emojione.zip")) {
                this.parseConfigFile();
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                String conf = messenger.emojiVersionGetJsonStr();
                if (StringUtil.isEmptyOrNull((String)conf)) {
                    return;
                }
                try {
                    JSONObject jsonObject = new JSONObject(conf);
                    String emojiOneVersion = jsonObject.getJSONObject("emojione").optString("version");
                    if (StringUtil.isEmptyOrNull((String)emojiOneVersion)) {
                        return;
                    }
                    PreferenceUtil.saveStringValue("common_emoji_version", emojiOneVersion);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ZoomMessengerUI.getInstance().removeListener(this.messengerUIListener);
        }
    }

    private void checkDownloadingPkg() {
        long downloadId = PreferenceUtil.readLongValue("common_emoji_download_id", -2L);
        if (downloadId == -2L) {
            return;
        }
        int process = this.getDownloadProcess();
        if (process < 0) {
            PreferenceUtil.removeValue("common_emoji_download_id");
            return;
        }
        if (process == 100) {
            this.onCommonEmojiPackageDownload(downloadId);
        } else {
            this.mHandle.removeCallbacks(this.mCheckDownloadRunnable);
            this.mHandle.post(this.mCheckDownloadRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEmojiConfig() {
        JsonParser parser = new JsonParser();
        Reader reader = null;
        try {
            File confFile = this.getCommonEmojiConfFile();
            if (!confFile.exists()) {
                return;
            }
            reader = new InputStreamReader(new FileInputStream(confFile));
            JsonObject element = parser.parse(reader).getAsJsonObject();
            for (Map.Entry item : element.entrySet()) {
                JsonObject code_points;
                String outPut;
                String oupPutCode;
                JsonElement genders;
                JsonArray diversities;
                String key = (String)item.getKey();
                JsonObject value = (JsonObject)item.getValue();
                CommonEmoji emoji = new CommonEmoji();
                emoji.setKey(key);
                emoji.setCategory(value.get("category").getAsString());
                emoji.setOrder(value.get("order").getAsInt());
                emoji.setName(value.get("name").getAsString());
                emoji.setShortName(value.get("shortname").getAsString());
                JsonElement diversity = value.get("diversity");
                if (!diversity.isJsonNull()) {
                    emoji.setDiversity(value.get("diversity").getAsString());
                }
                if ((diversities = value.get("diversities").getAsJsonArray()).size() > 0) {
                    ArrayList<String> diversitiesList = new ArrayList<String>();
                    for (Object e : diversities) {
                        diversitiesList.add(e.getAsString());
                    }
                    emoji.setDiversities(diversitiesList);
                }
                if (!(genders = value.get("genders")).isJsonNull()) {
                    Object e;
                    ArrayList<String> gendersList = new ArrayList<String>();
                    e = genders.getAsJsonArray().iterator();
                    while (e.hasNext()) {
                        JsonElement e2 = (JsonElement)e.next();
                        gendersList.add(e2.getAsString());
                    }
                    emoji.setGenders(gendersList);
                }
                if (!StringUtil.isEmptyOrNull((String)(oupPutCode = this.getUnicodeFromConfigStr(outPut = (code_points = value.getAsJsonObject("code_points")).get("output").getAsString())))) {
                    emoji.setOutput(oupPutCode);
                    mShortNameToUnicode.put(emoji.getShortName(), oupPutCode);
                }
                JsonArray matches = code_points.getAsJsonArray("default_matches");
                ArrayList<String> matchesList = new ArrayList<String>();
                for (JsonElement s : matches) {
                    String match = s.getAsString();
                    matchesList.add(match);
                    String matchCode = this.getUnicodeFromConfigStr(match);
                    char[] cc = matchCode.toCharArray();
                    if (cc.length == 1 && cc[0] < '\u00c8') continue;
                    MatchEmojiBean bean = this.mMatchedEmojiOneUnicodes.get(Character.valueOf(cc[0]));
                    if (bean == null) {
                        bean = new MatchEmojiBean();
                        this.mMatchedEmojiOneUnicodes.put(Character.valueOf(cc[0]), bean);
                    }
                    bean.emojis.put(matchCode, emoji);
                    if (matchCode.length() <= bean.emojiMaxLength) continue;
                    bean.emojiMaxLength = matchCode.length();
                }
                emoji.setMatches(matchesList);
                this.mEmojiOneUnicodes.put(key, emoji);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.parseSexAndColors();
    }

    private String getUnicodeFromConfigStr(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer unincode = new StringBuffer();
        for (String c : str.split("-")) {
            unincode.append(new String(Character.toChars(Integer.parseInt(c, 16))));
        }
        return unincode.toString();
    }

    private void parseSexAndColors() {
        for (Map.Entry<String, CommonEmoji> entry : this.mEmojiOneUnicodes.entrySet()) {
            CommonEmoji emoji = entry.getValue();
            if (emoji.getGenders() != null) {
                for (String gender : emoji.getGenders()) {
                    if (gender.endsWith("2642")) {
                        emoji.setManEmoji(this.mEmojiOneUnicodes.get(gender));
                        continue;
                    }
                    emoji.setWomanEmoji(this.mEmojiOneUnicodes.get(gender));
                }
            }
            if (emoji.getDiversities() == null) continue;
            for (String diversity : emoji.getDiversities()) {
                emoji.addDiversityEmoji(this.mEmojiOneUnicodes.get(diversity));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEmojiCategoryConfig() {
        JsonParser parser = new JsonParser();
        Reader reader = null;
        HashMap<String, EmojiCategory> categoryIndex = new HashMap<String, EmojiCategory>();
        try {
            File confFile = this.getCommonEmojiCategoryConfFile();
            if (!confFile.exists()) {
                return;
            }
            reader = new InputStreamReader(new FileInputStream(confFile));
            JsonArray jsonArray = parser.parse(reader).getAsJsonArray();
            Context context = VideoBoxApplication.getGlobalContext();
            if (context != null) {
                Resources resources = context.getResources();
                for (JsonElement e : jsonArray) {
                    JsonObject o = e.getAsJsonObject();
                    EmojiCategory c = new EmojiCategory();
                    c.setLabel(o.get("category_label").getAsString());
                    c.setName(o.get("category").getAsString());
                    int id2 = resources.getIdentifier(String.format("zm_mm_emoji_category_%s", c.getName()), "drawable", context.getPackageName());
                    c.setIconResource(id2);
                    this.mEmojiCategories.add(c);
                    categoryIndex.put(c.getName(), c);
                }
            }
        }
        catch (Exception confFile) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (Map.Entry entry : this.mEmojiOneUnicodes.entrySet()) {
            EmojiCategory category;
            CommonEmoji e = (CommonEmoji)entry.getValue();
            if (e.getManEmoji() != null && e.getWomanEmoji() != null || e.getDiversity() != null || (category = (EmojiCategory)categoryIndex.get(e.getCategory())) == null) continue;
            category.getEmojis().add(e);
        }
        EmojiComparetor comparetor = new EmojiComparetor();
        for (EmojiCategory c : this.mEmojiCategories) {
            Collections.sort(c.getEmojis(), comparetor);
        }
    }

    private File getCommonEmojiDir() {
        return new File(AppUtil.getDataPath(), EMOJI_ONE_PATH);
    }

    private String getCommonEmojiTTFPath() {
        File dir = this.getCommonEmojiDir();
        if (!dir.exists()) {
            return null;
        }
        if (!dir.isDirectory()) {
            dir.delete();
            return null;
        }
        File ttfFile = new File(dir, "emojione_android.ttf");
        if (!ttfFile.exists()) {
            return null;
        }
        return ttfFile.getAbsolutePath();
    }

    private File getCommonEmojiConfFile() {
        return new File(this.getCommonEmojiDir(), "common_emoji.json");
    }

    private File getCommonEmojiCategoryConfFile() {
        return new File(this.getCommonEmojiDir(), "common_emoji_category.json");
    }

    private void onDowloadChange() {
        boolean isFinsh;
        block17: {
            Cursor c;
            block19: {
                block18: {
                    long id2 = PreferenceUtil.readLongValue("common_emoji_download_id", -2L);
                    if (id2 == -2L) {
                        return;
                    }
                    Context context = VideoBoxApplication.getGlobalContext();
                    if (context == null) {
                        return;
                    }
                    DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
                    if (downloadManager == null) {
                        return;
                    }
                    isFinsh = false;
                    DownloadManager.Query query = new DownloadManager.Query();
                    query.setFilterById(new long[]{id2});
                    c = downloadManager.query(query);
                    if (c == null) break block17;
                    if (!c.moveToFirst()) break block18;
                    int status = c.getInt(c.getColumnIndex("status"));
                    switch (status) {
                        case 8: {
                            isFinsh = true;
                            this.onCommonEmojiPackageDownload(id2);
                            PreferenceUtil.removeValue("common_emoji_download_id");
                            break;
                        }
                        case 2: 
                        case 4: {
                            int fileSizeIdx = c.getColumnIndex("total_size");
                            int bytesDLIdx = c.getColumnIndex("bytes_so_far");
                            int fileSize = c.getInt(fileSizeIdx);
                            int bytesDL = c.getInt(bytesDLIdx);
                            int process = 0;
                            if (fileSize == 0) {
                                isFinsh = true;
                                PreferenceUtil.removeValue("common_emoji_download_id");
                            } else {
                                process = bytesDL * 100 / fileSize;
                            }
                            IListener[] listeners = this.mListenerList.getAll();
                            if (listeners == null) break;
                            for (IListener lTmp : listeners) {
                                OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                                if (isFinsh) {
                                    l.onEmojiPkgDownloadFailed();
                                    continue;
                                }
                                l.onEmojiPkgDownload(process);
                            }
                            break block19;
                        }
                        case 16: {
                            isFinsh = true;
                            IListener[] listeners1 = this.mListenerList.getAll();
                            if (listeners1 != null) {
                                for (IListener lTmp : listeners1) {
                                    OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                                    l.onEmojiPkgDownloadFailed();
                                }
                            }
                            PreferenceUtil.removeValue("common_emoji_download_id");
                        }
                    }
                    break block19;
                }
                isFinsh = true;
                IListener[] listeners1 = this.mListenerList.getAll();
                if (listeners1 != null) {
                    for (IListener lTmp : listeners1) {
                        OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                        l.onEmojiPkgDownloadFailed();
                    }
                }
                PreferenceUtil.removeValue("common_emoji_download_id");
            }
            c.close();
        }
        if (!isFinsh) {
            this.mHandle.postDelayed(this.mCheckDownloadRunnable, 1000L);
        }
    }

    private void onCommonEmojiPackageDownload(long downloadId) {
        this.mHandle.removeCallbacks(this.mCheckDownloadRunnable);
        Context context = VideoBoxApplication.getGlobalContext();
        if (context == null) {
            return;
        }
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        if (downloadManager == null) {
            return;
        }
        DownloadManager.Query myDownloadQuery = new DownloadManager.Query();
        myDownloadQuery.setFilterById(new long[]{downloadId});
        Cursor myDownload = downloadManager.query(myDownloadQuery);
        if (myDownload != null) {
            if (myDownload.moveToFirst()) {
                int fileNameIdx = myDownload.getColumnIndex("local_uri");
                String fileUrl = myDownload.getString(fileNameIdx);
                if (this.parseEmojiPackage(fileUrl)) {
                    this.parseConfigFile();
                    String version = PreferenceUtil.readStringValue("common_emoji_peding_version", null);
                    PreferenceUtil.saveStringValue("common_emoji_version", version);
                    IListener[] listeners1 = this.mListenerList.getAll();
                    if (listeners1 != null) {
                        for (IListener lTmp : listeners1) {
                            OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                            l.onEmojiPkgInstalled();
                        }
                    }
                } else {
                    IListener[] listeners1 = this.mListenerList.getAll();
                    if (listeners1 != null) {
                        for (IListener lTmp : listeners1) {
                            OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                            l.onEmojiPkgDownloadFailed();
                        }
                    }
                }
            } else {
                IListener[] listeners1 = this.mListenerList.getAll();
                if (listeners1 != null) {
                    for (IListener lTmp : listeners1) {
                        OnEmojiPackageInstallListener l = (OnEmojiPackageInstallListener)lTmp;
                        l.onEmojiPkgDownloadFailed();
                    }
                }
            }
            myDownload.close();
        }
        PreferenceUtil.removeValue("common_emoji_download_id");
    }

    public boolean isEmojiInstalled() {
        return this.mEmojiTypeface != null;
    }

    public int getDownloadProcess() {
        long id2 = PreferenceUtil.readLongValue("common_emoji_download_id", -2L);
        if (id2 == -2L) {
            return -1;
        }
        Context context = VideoBoxApplication.getGlobalContext();
        if (context == null) {
            return -1;
        }
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        if (downloadManager == null) {
            return -1;
        }
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{id2});
        Cursor c = downloadManager.query(query);
        int process = -1;
        if (c != null && c.moveToFirst()) {
            int status = c.getInt(c.getColumnIndex("status"));
            switch (status) {
                case 2: 
                case 4: {
                    int fileSizeIdx = c.getColumnIndex("total_size");
                    int bytesDLIdx = c.getColumnIndex("bytes_so_far");
                    int fileSize = c.getInt(fileSizeIdx);
                    int bytesDL = c.getInt(bytesDLIdx);
                    process = bytesDL * 100 / fileSize;
                    break;
                }
                case 8: {
                    process = 100;
                    break;
                }
                default: {
                    process = -1;
                }
            }
            c.close();
        }
        return process;
    }

    public boolean containCommonEmoji(CharSequence source) {
        if (source == null) {
            return false;
        }
        return EMOJI_PATTERN.matcher(source).find();
    }

    public void cancelInstallEmoji() {
        long id2 = PreferenceUtil.readLongValue("common_emoji_download_id", -2L);
        if (id2 == -2L) {
            return;
        }
        Context context = VideoBoxApplication.getGlobalContext();
        if (context == null) {
            return;
        }
        DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
        if (downloadManager != null) {
            downloadManager.remove(new long[]{id2});
        }
        PreferenceUtil.removeValue("common_emoji_download_id");
    }

    public void installEmoji() {
        int process = this.getDownloadProcess();
        if (process >= 0 && process < 100) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String conf = messenger.emojiVersionGetJsonStr();
        if (StringUtil.isEmptyOrNull((String)conf)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(conf);
            String emojiOneVersion = jsonObject.getJSONObject("emojione").optString("version");
            if (StringUtil.isEmptyOrNull((String)emojiOneVersion)) {
                return;
            }
            String localVersion = PreferenceUtil.readStringValue("common_emoji_version", null);
            if (StringUtil.isSameString((String)localVersion, (String)emojiOneVersion) && this.isEmojiInstalled()) {
                return;
            }
            Context context = VideoBoxApplication.getGlobalContext();
            if (context == null) {
                return;
            }
            DownloadManager downloadManager = (DownloadManager)context.getSystemService("download");
            if (downloadManager == null) {
                return;
            }
            this.mHandle.removeCallbacks(this.mCheckDownloadRunnable);
            Uri uri = Uri.parse((String)this.getDownloadUrl(emojiOneVersion));
            DownloadManager.Request request = new DownloadManager.Request(uri);
            request.setDestinationInExternalFilesDir(VideoBoxApplication.getGlobalContext(), "file", "zoomEmojiPkg");
            request.setTitle((CharSequence)context.getString(R.string.zm_lbl_emoji_pkg_title_23626));
            long reference = downloadManager.enqueue(request);
            PreferenceUtil.saveStringValue("common_emoji_peding_version", emojiOneVersion);
            PreferenceUtil.saveLongValue("common_emoji_download_id", reference);
            this.mHandle.post(this.mCheckDownloadRunnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getDownloadUrl(String version) {
        if (StringUtil.isEmptyOrNull((String)version)) {
            return null;
        }
        return String.format("%s/emoji/%s/emojione_android_%s.zip", PTApp.getInstance().getZoomDomain(), version, version);
    }

    private boolean parseEmojiPackage(String fileUrl) {
        if (StringUtil.isEmptyOrNull((String)fileUrl)) {
            return false;
        }
        Uri uri = Uri.parse((String)fileUrl);
        String path = uri.getPath();
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        File dir = this.getCommonEmojiDir();
        if (dir.exists() && !dir.isDirectory()) {
            dir.delete();
        }
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        return FileUtils.unzipFile((String)path, (String)dir.getAbsolutePath());
    }

    static {
        mShortNameToUnicode = new HashMap();
        SHORTNAME_PATTERN = Pattern.compile(":([-+\\w]+):");
        EMOJI_PATTERN = Pattern.compile("[\ud83c\udc00-\ud83c\udfff]|[\ud83d\udc00-\ud83d\udfff]|[\u2600-\u27ff]", 66);
    }

    private static class EmojiComparetor
    implements Comparator<CommonEmoji> {
        private EmojiComparetor() {
        }

        @Override
        public int compare(CommonEmoji commonEmoji, CommonEmoji t1) {
            return commonEmoji.getOrder() - t1.getOrder();
        }
    }

    static class CommonEmojiSpan
    extends TypefaceSpan {
        public static final Parcelable.Creator<CommonEmojiSpan> CREATOR = new Parcelable.Creator<CommonEmojiSpan>(){

            public CommonEmojiSpan createFromParcel(Parcel in) {
                return new CommonEmojiSpan(in);
            }

            public CommonEmojiSpan[] newArray(int size) {
                return new CommonEmojiSpan[size];
            }
        };

        public CommonEmojiSpan(Parcel src) {
            super(src);
        }

        public CommonEmojiSpan() {
            super("CommonEomji");
        }

        public void updateDrawState(TextPaint ds) {
            CommonEmojiSpan.apply((Paint)ds);
        }

        public void updateMeasureState(TextPaint paint) {
            CommonEmojiSpan.apply((Paint)paint);
        }

        private static void apply(Paint paint) {
            Typeface typeface = CommonEmojiHelper.getInstance().mEmojiTypeface;
            if (typeface != null) {
                paint.setTypeface(typeface);
            }
        }
    }

    public static class ZMEmojiSpannableStringBuilder
    extends SpannableStringBuilder {
        public ZMEmojiSpannableStringBuilder(CharSequence source) {
            super(source);
        }
    }

    public static interface OnEmojiPackageInstallListener
    extends IListener {
        public void onEmojiPkgDownload(int var1);

        public void onEmojiPkgInstalled();

        public void onEmojiPkgDownloadFailed();
    }

    private static class MatchEmojiBean {
        Map<String, CommonEmoji> emojis = new HashMap<String, CommonEmoji>();
        int emojiMaxLength = 0;

        private MatchEmojiBean() {
        }
    }
}

