/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import com.zipow.cmmlib.AppUtil;
import com.zipow.videobox.ptapp.PrivateStickerUICallBack;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import us.zoom.androidlib.util.StringUtil;

public class PendingFileDataHelper {
    public static final String CONTENT_FILE_LOCAL_PATH = "contentFile";
    private static final String TAG = ZoomMessengerUI.class.getSimpleName();
    private static PendingFileDataHelper instance;
    private HashMap<String, PendingFileInfo> mUploadPendingFileInfos = new HashMap();
    private ArrayList<String> mUploadFailedFile = new ArrayList();
    private HashMap<String, PendingFileInfo> mDownloadPendingFileInfos = new HashMap();

    private PendingFileDataHelper() {
        ZoomMessengerUI.getInstance().addListener(new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

            @Override
            public void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
                PendingFileDataHelper.this.FT_UploadToMyList_OnProgress(reqID, ratio, completeSize, bitPerSecond);
            }

            @Override
            public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
                PendingFileDataHelper.this.FT_DownloadByFileID_OnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
            }

            @Override
            public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
                PendingFileDataHelper.this.Indicate_FileDownloaded(reqID, webFileID, result);
            }

            @Override
            public void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
                PendingFileDataHelper.this.Indicate_UploadToMyFiles_Sent(reqID, webFileID, result);
            }

            @Override
            public void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
                PendingFileDataHelper.this.FT_OnDownloadByFileIDTimeOut(reqID, webFileID);
            }

            @Override
            public void FT_UploadToMyList_TimeOut(String reqID) {
                PendingFileDataHelper.this.FT_UploadToMyList_TimeOut(reqID);
            }
        });
        PrivateStickerUICallBack.getInstance().addListener(new PrivateStickerUICallBack.SimpleZoomPrivateStickerUIListener(){

            @Override
            public void OnNewStickerUploaded(String req_id, int result, String stickerId) {
                PendingFileDataHelper.this.OnNewStickerUploaded(req_id, result, stickerId);
            }
        });
    }

    public static PendingFileDataHelper getInstance() {
        if (instance == null) {
            instance = new PendingFileDataHelper();
        }
        return instance;
    }

    private void FT_UploadToMyList_OnProgress(String reqID, int ratio, int completeSize, int bitPerSecond) {
        PendingFileInfo info = this.mUploadPendingFileInfos.get(reqID);
        if (info != null) {
            info.bitPerSecond = bitPerSecond;
            info.ratio = ratio;
            info.completeSize = completeSize;
        }
    }

    private void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        PendingFileInfo info = this.mDownloadPendingFileInfos.get(webFileID);
        if (info == null) {
            info = new PendingFileInfo();
            this.mDownloadPendingFileInfos.put(webFileID, info);
        }
        info.reqId = reqId;
        info.bitPerSecond = bitPerSecond;
        info.ratio = ratio;
        info.completeSize = completeSize;
    }

    private void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        this.mDownloadPendingFileInfos.remove(reqID);
    }

    public PendingFileInfo getDownloadPendingInfoByWebFileId(String webFileId) {
        return this.mDownloadPendingFileInfos.get(webFileId);
    }

    private void Indicate_UploadToMyFiles_Sent(String reqID, String webFileID, int result) {
        PendingFileInfo info = this.mUploadPendingFileInfos.remove(reqID);
        if (result != 0 && info != null) {
            this.addUploadFailedFile(info.path);
        }
    }

    private void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
        this.mDownloadPendingFileInfos.remove(reqID);
    }

    private void FT_UploadToMyList_TimeOut(String reqID) {
        PendingFileInfo info = this.mUploadPendingFileInfos.remove(reqID);
        if (info != null) {
            this.addUploadFailedFile(info.path);
        }
    }

    private void OnNewStickerUploaded(String req_id, int result, String stickerId) {
        this.mUploadPendingFileInfos.remove(req_id);
    }

    public ArrayList<String> getUploadFailedFiles() {
        return this.mUploadFailedFile;
    }

    public void addUploadFailedFile(String path) {
        if (this.mUploadFailedFile.size() >= 5) {
            return;
        }
        this.mUploadFailedFile.add(path);
    }

    public void clearUploadFailedFiles() {
        this.mUploadFailedFile.clear();
    }

    public void addUploadPendingFile(String reqId, String fileName, int totalSize, String path, boolean isSticker) {
        PendingFileInfo info = new PendingFileInfo();
        info.reqId = reqId;
        info.name = fileName;
        info.path = path;
        info.timestamp = System.currentTimeMillis();
        info.totalSize = totalSize;
        info.isSticker = isSticker;
        this.mUploadPendingFileInfos.put(reqId, info);
    }

    public void removeUploadPendingFile(String reqId) {
        this.mUploadPendingFileInfos.remove(reqId);
    }

    public void removeDownloadPendingFile(String webFileId) {
        this.mDownloadPendingFileInfos.remove(webFileId);
    }

    public List<PendingFileInfo> getUploadPendingFileInfos() {
        ArrayList<PendingFileInfo> infos = new ArrayList<PendingFileInfo>();
        for (PendingFileInfo info : this.mUploadPendingFileInfos.values()) {
            if (info.isSticker) continue;
            infos.add(info);
        }
        return infos;
    }

    public List<PendingFileInfo> getUploadPendingStickerInfos() {
        ArrayList<PendingFileInfo> infos = new ArrayList<PendingFileInfo>();
        for (PendingFileInfo info : this.mUploadPendingFileInfos.values()) {
            if (!info.isSticker) continue;
            infos.add(info);
        }
        return infos;
    }

    public int getUploadPendingFileSize() {
        return this.getUploadPendingFileInfos().size();
    }

    public boolean isFileUploadNow(String fileId) {
        return this.mUploadPendingFileInfos.containsKey(fileId);
    }

    public static String getContenFilePreviewPath(String fileId) {
        String path = AppUtil.getDataPath();
        File dir = new File(path, CONTENT_FILE_LOCAL_PATH);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        if (!(dir = new File(dir, "preview")).exists() && !dir.mkdirs()) {
            return null;
        }
        dir = new File(dir, "preview-" + fileId);
        return dir.getAbsolutePath();
    }

    public static String getContenFilePath(String fileId, String fileName) {
        String path = AppUtil.getDataPath();
        File dir = new File(path, CONTENT_FILE_LOCAL_PATH);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        dir = new File(dir, fileId + "-" + fileName);
        return dir.getAbsolutePath();
    }

    public static String getContentLocalImgDir() {
        String path = AppUtil.getDataPath();
        File dir = new File(path, CONTENT_FILE_LOCAL_PATH);
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        dir = new File(path, "localImg");
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    public static String getContenFileRandomPath() {
        String parent = PendingFileDataHelper.getContentLocalImgDir();
        if (StringUtil.isEmptyOrNull((String)parent)) {
            return null;
        }
        String path = "url-" + UUID.randomUUID().toString();
        return new File(parent, path).getAbsolutePath();
    }

    public static class PendingFileInfo {
        boolean isSticker;
        String reqId;
        String name;
        String path;
        long timestamp;
        int ratio;
        int completeSize;
        int bitPerSecond;
        int totalSize;

        public String getReqId() {
            return this.reqId;
        }

        public int getRatio() {
            return this.ratio;
        }
    }
}

