/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomShareAction;
import java.io.Serializable;
import us.zoom.androidlib.util.StringUtil;

public class MMZoomShareAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long shareTime;
    private String sharee;
    private String webFileID;
    private boolean mIsGroup;
    private boolean mIsMUC;

    public static MMZoomShareAction createWithZoomShareAction(ZoomShareAction action) {
        if (action == null) {
            return null;
        }
        MMZoomShareAction shareAction = new MMZoomShareAction();
        shareAction.setSharee(action.getSharee());
        shareAction.setShareTime(action.getShareTime());
        shareAction.setWebFileID(action.getWebFileID());
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomGroup group = messenger.getGroupById(action.getSharee());
        if (group != null) {
            shareAction.setIsGroup(true);
            shareAction.setIsMUC(!group.isRoom());
        }
        return shareAction;
    }

    public long getShareTime() {
        return this.shareTime;
    }

    public void setShareTime(long shareTime) {
        this.shareTime = shareTime;
    }

    public String getSharee() {
        return this.sharee;
    }

    public String getShareeName(Context context) {
        if (StringUtil.isEmptyOrNull((String)this.sharee) || context == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(this.sharee);
        if (buddy != null) {
            return buddy.getScreenName();
        }
        ZoomGroup group = messenger.getGroupById(this.sharee);
        if (group != null) {
            return group.getGroupDisplayName(context);
        }
        return null;
    }

    public void setSharee(String sharee) {
        this.sharee = sharee;
    }

    public String getWebFileID() {
        return this.webFileID;
    }

    public void setWebFileID(String webFileID) {
        this.webFileID = webFileID;
    }

    public boolean isGroup() {
        return this.mIsGroup;
    }

    public void setIsGroup(boolean isGroup) {
        this.mIsGroup = isGroup;
    }

    public boolean isMUC() {
        return this.mIsMUC;
    }

    public void setIsMUC(boolean isMUC) {
        this.mIsMUC = isMUC;
    }
}

