/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.LazyLoadDrawable;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMZoomFileView
extends LinearLayout {
    private OnContentFileOperatorListener mOnClickOperatorListener;
    private ImageView mImgFileLogo;
    private TextView mTxtFileName;
    private TextView mTxtFileOwner;
    private TextView mTxtFileShareIn;
    private ImageView mImgShare;
    private TextView mTxtTranslateSpeed;
    private View mBtnCancel;
    private View mPanelTranslate;
    private ProgressBar mProgressBarPending;
    private ImageView mImgPendingType;
    private String myJid;
    private MMZoomFile mFile;
    private OnShowAllShareActionListener mOnMoreShareActionListener;

    public MMZoomFileView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMZoomFileView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mImgFileLogo = (ImageView)this.findViewById(R.id.imgFileLogo);
        this.mTxtFileName = (TextView)this.findViewById(R.id.txtFileName);
        this.mTxtFileOwner = (TextView)this.findViewById(R.id.txtFileOwner);
        this.mTxtFileShareIn = (TextView)this.findViewById(R.id.txtFileGroups);
        this.mImgShare = (ImageView)this.findViewById(R.id.imgShare);
        this.mTxtTranslateSpeed = (TextView)this.findViewById(R.id.txtTranslateSpeed);
        this.mBtnCancel = this.findViewById(R.id.btnCancel);
        this.mPanelTranslate = this.findViewById(R.id.panelTranslate);
        this.mProgressBarPending = (ProgressBar)this.findViewById(R.id.progressBarPending);
        this.mImgPendingType = (ImageView)this.findViewById(R.id.imgPendingType);
        this.mTxtFileShareIn.setHighlightColor(this.getContext().getResources().getColor(R.color.zm_transparent));
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy mySelf = messenger.getMyself();
        if (mySelf != null) {
            this.myJid = mySelf.getJid();
        }
    }

    public void setOnMoreShareActionListener(OnShowAllShareActionListener onMoreShareActionListener) {
        this.mOnMoreShareActionListener = onMoreShareActionListener;
    }

    public void setOnClickOperatorListener(OnContentFileOperatorListener onClickOperatorListener) {
        this.mOnClickOperatorListener = onClickOperatorListener;
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_content_file_item, (ViewGroup)this);
    }

    private CharSequence getFileScreenName(MMZoomFile file) {
        List<MMZoomFile.FileMatchInfo> matchInfos = file.getMatchInfos();
        SpannableStringBuilder spBuilder = new SpannableStringBuilder((CharSequence)file.getFileName());
        if (matchInfos != null) {
            for (MMZoomFile.FileMatchInfo info : matchInfos) {
                if (info.mHighlightPositions == null || info.mType != 1) continue;
                ForegroundColorSpan span = new ForegroundColorSpan(this.getContext().getResources().getColor(R.color.zm_highlight));
                for (MMZoomFile.HighlightPosition hPosition : info.mHighlightPositions) {
                    spBuilder.setSpan((Object)span, hPosition.start, hPosition.end, 33);
                }
            }
        }
        return spBuilder;
    }

    public void setMMZoomFile(MMZoomFile file, boolean isPersonalMode) {
        this.setMMZoomFile(file, isPersonalMode, null);
    }

    public void setMMZoomFile(MMZoomFile file, boolean isPersonalMode, String sessionId) {
        this.mFile = file;
        Context context = this.getContext();
        boolean isFileTransferDisable = PTApp.getInstance().isFileTransferDisabled();
        if (ZmPtUtils.isImageFile(file.getFileType())) {
            int area;
            LazyLoadDrawable drawable2;
            if (ImageUtil.isValidImageFile(file.getPicturePreviewPath())) {
                drawable2 = new LazyLoadDrawable(file.getPicturePreviewPath());
                area = this.mImgFileLogo.getWidth();
                if (area == 0) {
                    area = UIUtil.dip2px((Context)this.getContext(), (float)40.0f);
                }
                drawable2.setMaxArea(area * area);
                this.mImgFileLogo.setImageDrawable((Drawable)drawable2);
            } else if (ImageUtil.isValidImageFile(file.getLocalPath())) {
                drawable2 = new LazyLoadDrawable(file.getLocalPath());
                area = this.mImgFileLogo.getWidth();
                if (area == 0) {
                    area = UIUtil.dip2px((Context)this.getContext(), (float)40.0f);
                }
                drawable2.setMaxArea(area * area);
                this.mImgFileLogo.setImageDrawable((Drawable)drawable2);
            } else {
                this.mImgFileLogo.setImageResource(AndroidAppUtil.getIconForFile((String)file.getFileName()));
            }
        } else {
            this.mImgFileLogo.setImageResource(AndroidAppUtil.getIconForFile((String)file.getFileName()));
        }
        this.mTxtFileName.setText(this.getFileScreenName(file));
        String timeStr = null;
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            timeStr = this.formatSharedTime(file.getEarliestShareTime());
        } else {
            long time = file.getShareTimeInSession(sessionId);
            timeStr = this.formatSharedTime(time);
        }
        if (StringUtil.isSameString((String)file.getOwnerJid(), (String)this.myJid)) {
            if (isPersonalMode) {
                this.mTxtFileOwner.setText((CharSequence)timeStr);
            } else {
                this.mTxtFileOwner.setText((CharSequence)context.getString(R.string.zm_lbl_content_share_by_me, new Object[]{context.getString(R.string.zm_lbl_content_me), timeStr}));
            }
        } else {
            this.mTxtFileOwner.setText((CharSequence)context.getString(R.string.zm_lbl_content_share_by, new Object[]{file.getOwnerName(), timeStr}));
        }
        CharSequence sharedInStr = "";
        List<MMZoomShareAction> actions = file.getShareAction();
        if (actions != null) {
            ArrayList<MMZoomShareAction> actionsInRoom = new ArrayList<MMZoomShareAction>();
            SpannableStringBuilder buff = new SpannableStringBuilder();
            for (MMZoomShareAction action : actions) {
                if (!action.isGroup() || action.isMUC()) continue;
                actionsInRoom.add(action);
            }
            if (actionsInRoom.isEmpty()) {
                sharedInStr = StringUtil.isSameString((String)file.getOwnerJid(), (String)this.myJid) ? "" : context.getString(R.string.zm_lbl_content_share_in_buddy, new Object[]{file.getOwnerName()});
            } else if (isFileTransferDisable || CollectionsUtil.isListEmpty(file.getOperatorAbleSessions()) && !StringUtil.isSameString((String)file.getOwnerJid(), (String)this.myJid)) {
                for (MMZoomShareAction action : actionsInRoom) {
                    String shareeName = action.getShareeName(context);
                    if (StringUtil.isEmptyOrNull((String)shareeName)) continue;
                    buff.append((CharSequence)shareeName);
                    buff.append((CharSequence)",");
                }
                sharedInStr = buff.length() == 0 ? (StringUtil.isSameString((String)file.getOwnerJid(), (String)this.myJid) ? "" : context.getString(R.string.zm_lbl_content_share_in_buddy, new Object[]{file.getOwnerName()})) : context.getString(R.string.zm_lbl_content_share_in_group, new Object[]{buff.subSequence(0, buff.length() - 1)});
                int width = this.mTxtFileShareIn.getWidth();
                if (width == 0) {
                    width = UIUtil.getDisplayWidth((Context)this.getContext());
                }
                sharedInStr = TextUtils.ellipsize((CharSequence)sharedInStr, (TextPaint)this.mTxtFileShareIn.getPaint(), (float)width, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            } else {
                List<String> operatorAbleSessions = file.getOperatorAbleSessions();
                boolean isMyFile = StringUtil.isSameString((String)file.getOwnerJid(), (String)this.myJid);
                if (actionsInRoom.size() > 3 && !this.mFile.isShowAllShareActions()) {
                    SpannableStringBuilder actionsBuffers = new SpannableStringBuilder();
                    for (int i = 0; i < 2; ++i) {
                        MMZoomShareAction action = (MMZoomShareAction)actionsInRoom.get(i);
                        String shareeName = action.getShareeName(context);
                        if (StringUtil.isEmptyOrNull((String)shareeName)) continue;
                        if (isMyFile || operatorAbleSessions.contains(action.getSharee())) {
                            SpannableString str = new SpannableString((CharSequence)shareeName);
                            ShareActionClickableSpan span = new ShareActionClickableSpan(action);
                            str.setSpan((Object)span, 0, shareeName.length(), 33);
                            actionsBuffers.append((CharSequence)str);
                        } else {
                            actionsBuffers.append((CharSequence)shareeName);
                        }
                        if (i != 0) continue;
                        actionsBuffers.append((CharSequence)",");
                    }
                    SpannableString moreString = new SpannableString((CharSequence)this.getContext().getString(R.string.zm_lbl_content_share_in_more_group, new Object[]{actionsInRoom.size() - 2}));
                    moreString.setSpan((Object)new MoreShareActionClickableSpan(), 0, moreString.length(), 33);
                    String tempAction = "&&&&&&&&&&&&&$$$$$";
                    String tempMore = "$$$$$$$$$$$$&&&&";
                    sharedInStr = context.getString(R.string.zm_mm_group_names_list_and, new Object[]{tempAction, tempMore});
                    sharedInStr = context.getString(R.string.zm_lbl_content_share_in_group, new Object[]{sharedInStr});
                    String[] source = new String[]{tempAction, tempMore};
                    CharSequence[] dest = new CharSequence[]{actionsBuffers, moreString};
                    sharedInStr = TextUtils.replace((CharSequence)sharedInStr, (String[])source, (CharSequence[])dest);
                } else if (actionsInRoom.size() > 0) {
                    for (MMZoomShareAction action : actionsInRoom) {
                        String shareeName = action.getShareeName(context);
                        if (StringUtil.isEmptyOrNull((String)shareeName)) continue;
                        if (isMyFile || operatorAbleSessions.contains(action.getSharee())) {
                            SpannableString str = new SpannableString((CharSequence)shareeName);
                            ShareActionClickableSpan span = new ShareActionClickableSpan(action);
                            str.setSpan((Object)span, 0, shareeName.length(), 33);
                            buff.append((CharSequence)str);
                        } else {
                            buff.append((CharSequence)shareeName);
                        }
                        buff.append((CharSequence)",");
                    }
                    if (buff.length() > 0) {
                        String temp = "&&&&&&&&&&&&&";
                        sharedInStr = context.getString(R.string.zm_lbl_content_share_in_group, new Object[]{temp});
                        String[] source = new String[]{temp};
                        CharSequence[] dest = new CharSequence[]{buff.subSequence(0, buff.length() - 1)};
                        sharedInStr = TextUtils.replace((CharSequence)sharedInStr, (String[])source, (CharSequence[])dest);
                    }
                }
            }
        }
        if (sharedInStr != null && sharedInStr.length() > 0) {
            this.mTxtFileShareIn.setText(sharedInStr);
            if (sharedInStr instanceof Spanned) {
                ShareActionClickableSpan[] spans = (ShareActionClickableSpan[])((Spanned)sharedInStr).getSpans(0, sharedInStr.length(), ShareActionClickableSpan.class);
                if (spans == null || spans.length == 0) {
                    this.mTxtFileShareIn.setMovementMethod(null);
                } else {
                    this.mTxtFileShareIn.setMovementMethod(LinkMovementMethod.getInstance());
                }
            } else {
                this.mTxtFileShareIn.setMovementMethod(null);
            }
        } else {
            this.mTxtFileShareIn.setText((CharSequence)context.getString(R.string.zm_lbl_content_no_share));
            this.mTxtFileShareIn.setMovementMethod(null);
        }
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View v) {
                int id2 = v.getId();
                if (id2 == R.id.imgShare) {
                    if (MMZoomFileView.this.mOnClickOperatorListener != null) {
                        MMZoomFileView.this.mOnClickOperatorListener.onZoomFileShared(MMZoomFileView.this.mFile.getWebID());
                    }
                } else if (id2 == R.id.btnCancel && MMZoomFileView.this.mOnClickOperatorListener != null) {
                    MMZoomFileView.this.mOnClickOperatorListener.onZoomFileCancelTransfer(MMZoomFileView.this.mFile.getWebID());
                }
            }
        };
        this.mBtnCancel.setOnClickListener(listener);
        this.mImgShare.setVisibility(file.isPending() && !file.isFileDownloading() ? 8 : 0);
        if (file.isPending() || file.isFileDownloading()) {
            this.mProgressBarPending.setVisibility(0);
            this.mProgressBarPending.setProgress(file.getRatio());
            this.mBtnCancel.setVisibility(0);
            this.mImgShare.setVisibility(8);
            this.mPanelTranslate.setVisibility(0);
            this.mTxtFileOwner.setVisibility(8);
            this.mTxtFileShareIn.setVisibility(8);
            String completeSize = FileUtils.toFileSizeString((Context)context, (long)file.getCompleteSize());
            String totalSize = FileUtils.toFileSizeString((Context)context, (long)file.getFileSize());
            String speed = FileUtils.toFileSizeString((Context)context, (long)file.getBitPerSecond());
            this.mTxtTranslateSpeed.setText((CharSequence)context.getString(R.string.zm_lbl_translate_speed, new Object[]{completeSize, totalSize, speed}));
            this.mImgPendingType.setVisibility(file.isPending() && !file.isFileDownloading() ? 0 : 8);
        } else {
            this.mProgressBarPending.setVisibility(8);
            this.mBtnCancel.setVisibility(8);
            this.mImgShare.setVisibility(0);
            this.mPanelTranslate.setVisibility(8);
            this.mTxtFileOwner.setVisibility(0);
            this.mTxtFileShareIn.setVisibility(0);
        }
        if (isFileTransferDisable) {
            this.mImgShare.setVisibility(8);
        } else {
            this.mImgShare.setVisibility(0);
            this.mImgShare.setOnClickListener(listener);
        }
    }

    private String formatSharedTime(long timeStamp) {
        int dayDiff = TimeUtil.dateDiff((long)timeStamp, (long)System.currentTimeMillis());
        SimpleDateFormat df = new SimpleDateFormat("h:mm a", CompatUtils.getLocalDefault());
        Date time = new Date(timeStamp);
        String timeStr = df.format(time);
        if (dayDiff == 0) {
            return this.getContext().getString(R.string.zm_lbl_content_time_today_format, new Object[]{timeStr});
        }
        df = new SimpleDateFormat("MMM d", CompatUtils.getLocalDefault());
        String dayStr = df.format(time);
        return this.getContext().getString(R.string.zm_lbl_content_time_other_day_format, new Object[]{dayStr, timeStr});
    }

    class MoreShareActionClickableSpan
    extends ClickableSpan {
        MoreShareActionClickableSpan() {
        }

        public void onClick(View widget) {
            if (MMZoomFileView.this.mOnMoreShareActionListener != null) {
                MMZoomFileView.this.mOnMoreShareActionListener.onShowAllShareAction(MMZoomFileView.this.mFile.getWebID());
            }
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(MMZoomFileView.this.getContext().getResources().getColor(R.color.zm_black));
            ds.setUnderlineText(true);
        }
    }

    class ShareActionClickableSpan
    extends ClickableSpan {
        private MMZoomShareAction mAction;

        ShareActionClickableSpan(MMZoomShareAction action) {
            this.mAction = action;
        }

        public void onClick(View widget) {
            if (MMZoomFileView.this.mOnClickOperatorListener != null) {
                MMZoomFileView.this.mOnClickOperatorListener.onZoomFileSharerAction(MMZoomFileView.this.mFile.getWebID(), this.mAction);
            }
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(MMZoomFileView.this.getContext().getResources().getColor(R.color.zm_black));
            ds.setUnderlineText(true);
        }
    }

    public static interface OnShowAllShareActionListener {
        public void onShowAllShareAction(String var1);
    }
}

