/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import java.util.ArrayList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMShareZoomFileDialogFragment
extends DialogFragment {
    public static final String RESULT_ARG_REQUEST_ID = "reqId";
    private static final String ARG_SHAREE = "sharee";
    private static final String ARG_fILE_ID = "fileId";
    private static final String ARG_XMPP_ID = "xmppid";
    private static final String ARG_SESSION_ID = "sessionid";

    public static void showShareFileDialog(FragmentManager fm, ArrayList<String> sharees, String fileId, String xmppid, String sessionid, Fragment targetFragment, int requestCode) {
        if (fm == null || sharees == null || sharees.size() == 0 || StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMShareZoomFileDialogFragment dialog = new MMShareZoomFileDialogFragment();
        Bundle args = new Bundle();
        args.putString(ARG_fILE_ID, fileId);
        args.putStringArrayList(ARG_SHAREE, sharees);
        args.putString(ARG_XMPP_ID, xmppid);
        args.putString(ARG_SESSION_ID, sessionid);
        dialog.setArguments(args);
        if (targetFragment != null) {
            dialog.setTargetFragment(targetFragment, requestCode);
        }
        dialog.show(fm, MMShareZoomFileDialogFragment.class.getName());
    }

    public static void showShareFileDialog(FragmentManager fm, ArrayList<String> sharees, String fileId, Fragment targetFragment, int requestCode) {
        MMShareZoomFileDialogFragment.showShareFileDialog(fm, sharees, fileId, "", "", targetFragment, requestCode);
    }

    public static void showShareFileDialog(FragmentManager fm, ArrayList<String> sharees, String fileId) {
        MMShareZoomFileDialogFragment.showShareFileDialog(fm, sharees, fileId, null, 0);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        ZoomFile file;
        MMFileContentMgr mgr;
        ArrayList sharees = null;
        String fileID = null;
        Bundle args = this.getArguments();
        if (args != null) {
            sharees = args.getStringArrayList(ARG_SHAREE);
            fileID = args.getString(ARG_fILE_ID);
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        StringBuffer buffer = new StringBuffer();
        if (sharees != null && messenger != null) {
            for (String sharee : sharees) {
                String name;
                ZoomGroup group = messenger.getGroupById(sharee);
                if (group != null) {
                    String name2 = group.getGroupDisplayName((Context)this.getActivity());
                    if (StringUtil.isEmptyOrNull((String)name2)) continue;
                    buffer.append(name2).append(",");
                    continue;
                }
                ZoomBuddy buddy = messenger.getBuddyWithJID(sharee);
                if (buddy == null || StringUtil.isEmptyOrNull((String)(name = buddy.getScreenName()))) continue;
                buffer.append(name).append(",");
            }
        }
        String msg = "";
        if (buffer.length() > 0) {
            msg = buffer.substring(0, buffer.length() - 1);
        }
        msg = this.getString(R.string.zm_lbl_content_send_to, new Object[]{msg});
        String title = null;
        if (!StringUtil.isEmptyOrNull((String)fileID) && (mgr = PTApp.getInstance().getZoomFileContentMgr()) != null && (file = mgr.getFileWithWebFileID(fileID)) != null) {
            title = file.getFileName();
            mgr.destroyFileObject(file);
        }
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(title).setMessage(msg).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMShareZoomFileDialogFragment.this.doShareFile();
            }
        }).setNegativeButton(R.string.zm_btn_cancel, null).create();
        return dialog;
    }

    private void doShareFile() {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        String sessionid = null;
        String xmppid = null;
        ArrayList sharees = args.getStringArrayList(ARG_SHAREE);
        String fileID = args.getString(ARG_fILE_ID);
        sessionid = args.getString(ARG_SESSION_ID);
        xmppid = args.getString(ARG_XMPP_ID);
        if (sharees == null || sharees.size() == 0 || StringUtil.isEmptyOrNull((String)fileID)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileID);
        if (file == null) {
            return;
        }
        String reqId = null;
        reqId = TextUtils.isEmpty((CharSequence)sessionid) || TextUtils.isEmpty((CharSequence)xmppid) ? mgr.shareFile(fileID, (String)sharees.get(0)) : mgr.forwardFileMessage(sessionid, xmppid, (String)sharees.get(0));
        mgr.destroyFileObject(file);
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            Fragment fragment = this.getTargetFragment();
            if (fragment != null) {
                fragment.onActivityResult(this.getTargetRequestCode(), 0, null);
            }
            ErrorMsgDialog.newInstance(this.getString(R.string.zm_alert_share_file_failed), -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
        } else {
            Intent data = new Intent();
            data.putExtra(RESULT_ARG_REQUEST_ID, reqId);
            Fragment fragment = this.getTargetFragment();
            if (fragment != null) {
                fragment.onActivityResult(this.getTargetRequestCode(), -1, data);
            }
        }
    }
}

