/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.fragment.ErrorMsgDialog;
import com.zipow.videobox.fragment.MMSelectSessionAndBuddyFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.view.mm.MMContentFileViewerFragment;
import com.zipow.videobox.view.mm.MMContentFilesListView;
import com.zipow.videobox.view.mm.MMContentImagesListview;
import com.zipow.videobox.view.mm.MMShareZoomFileDialogFragment;
import com.zipow.videobox.view.mm.MMZoomShareAction;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMSessionContentsFragment
extends ZMDialogFragment
implements View.OnClickListener,
OnContentFileOperatorListener {
    private static final String ARGS_EXTRA_SESSION_ID = "sessionid";
    private static final String ARGS_EXTRA_FILE_MODE = "fileMode";
    public static final int FILE_MODE_ALL_FILES = 0;
    public static final int FILE_MODE_IMAGES = 1;
    public static final int REQUEST_VIEW_FILE_DETAIL = 3001;
    public static final int REQUEST_GET_SHAREER = 2014;
    public static final int REQUEST_DO_SHAREER = 2015;
    private static final String ARGS_SHARE_FILE_ID = "shareFileId";
    private WaitingDialog mWaitingDialog;
    private String mUnshareReqId;
    private String mShareReqId;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
            MMSessionContentsFragment.this.FT_DownloadByFileID_OnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
        }

        @Override
        public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
            MMSessionContentsFragment.this.Indicate_PreviewDownloaded(reqId, webFileID, result);
        }

        @Override
        public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
            MMSessionContentsFragment.this.Indicate_FileDownloaded(reqID, webFileID, result);
        }

        @Override
        public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
            MMSessionContentsFragment.this.Indicate_FileDeleted(reqID, webFileID, result);
        }

        @Override
        public void Indicate_FileShared(String reqID, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
            MMSessionContentsFragment.this.Indicate_FileShared(reqID, webFileID, sharee, newSession, newMsgXmppID, result);
        }

        @Override
        public void Indicate_FileUnshared(String reqId, String webFileID, int result) {
            MMSessionContentsFragment.this.Indicate_FileUnshared(reqId, webFileID, result);
        }

        @Override
        public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
            MMSessionContentsFragment.this.Indicate_RenameFileResponse(result, reqId, fileId, newName);
        }

        @Override
        public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
            MMSessionContentsFragment.this.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
        }

        @Override
        public void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
            MMSessionContentsFragment.this.Indicate_QuerySessionFilesResponse(reqId, session, result, arrWebFileID, queryEndTime);
        }

        @Override
        public void Indicate_NewFileSharedByOthers(String fileID) {
            MMSessionContentsFragment.this.Indicate_NewFileSharedByOthers(fileID);
        }

        @Override
        public void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long eraseTime) {
            MMSessionContentsFragment.this.NotifyOutdatedHistoryRemoved(sessionIDs, eraseTime);
        }
    };
    private String mSessionId;
    private int mFileMode;
    private MMContentFilesListView mFileListview;
    private MMContentImagesListview mImagesListview;
    private TextView mTxtTitle;
    private TextView mTxtLoadingError;

    public static void showAsActivity(Fragment fragment, String sessionid, int fileMode, int requestCode) {
        if (StringUtil.isEmptyOrNull((String)sessionid)) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(ARGS_EXTRA_SESSION_ID, sessionid);
        args.putInt(ARGS_EXTRA_FILE_MODE, fileMode);
        SimpleActivity.show(fragment, MMSessionContentsFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_session_content, container, false);
        view.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mFileListview = (MMContentFilesListView)view.findViewById(R.id.listViewFiles);
        this.mImagesListview = (MMContentImagesListview)view.findViewById(R.id.listViewImages);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txtTitle);
        this.mFileListview.setOnContentFileOperatorListener(this);
        this.mImagesListview.setOnContentFileOperatorListener(this);
        View panelEmptyView = view.findViewById(R.id.panelEmptyView);
        this.mFileListview.setupEmptyView(panelEmptyView);
        this.mTxtLoadingError = (TextView)view.findViewById(R.id.txtLoadingError);
        this.mTxtLoadingError.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.zm_lbl_content_load_error)));
        this.mTxtLoadingError.setOnClickListener((View.OnClickListener)this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mSessionId = args.getString(ARGS_EXTRA_SESSION_ID);
            this.mFileMode = args.getInt(ARGS_EXTRA_FILE_MODE, 0);
        }
        if (savedInstanceState != null) {
            this.mUnshareReqId = savedInstanceState.getString("mUnshareReqId");
            this.mShareReqId = savedInstanceState.getString("mShareReqId");
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        this.mFileListview.setSessionId(this.mSessionId);
        this.mImagesListview.setSessionId(this.mSessionId);
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mUnshareReqId", this.mUnshareReqId);
            outState.putString("mShareReqId", this.mShareReqId);
        }
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void onResume() {
        super.onResume();
        this.refreshUI();
    }

    private void refreshUI() {
        if (StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            return;
        }
        switch (this.mFileMode) {
            case 0: {
                this.mFileListview.setVisibility(0);
                this.mImagesListview.setVisibility(8);
                this.mTxtTitle.setText(R.string.zm_mm_lbl_group_files);
                this.mFileListview.loadData(false);
                break;
            }
            case 1: {
                this.mFileListview.setVisibility(8);
                this.mImagesListview.setVisibility(0);
                this.mTxtTitle.setText(R.string.zm_mm_lbl_group_images);
                this.mImagesListview.loadData(false);
                break;
            }
        }
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.dismiss();
        } else if (id2 == R.id.txtLoadingError) {
            this.onClickTxtLoadingError();
        }
    }

    private void onClickTxtLoadingError() {
        this.mFileListview.loadData(true);
    }

    public void FT_DownloadByFileID_OnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        this.mFileListview.onDownloadByFileIDOnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        this.mFileListview.Indicate_PreviewDownloaded(reqId, webFileID, result);
        this.mImagesListview.Indicate_PreviewDownloaded(reqId, webFileID, result);
    }

    public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
        this.mFileListview.Indicate_FileDownloaded(reqID, webFileID, result);
    }

    private void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mFileListview.Indicate_FileDeleted(reqID, webFileID, result);
        this.mImagesListview.Indicate_FileDeleted(reqID, webFileID, result);
    }

    private void Indicate_FileShared(String reqId, String webFileID, String sharee, String newSession, String newMsgXmppID, int result) {
        if (StringUtil.isSameString((String)reqId, (String)this.mShareReqId)) {
            this.mFileListview.Indicate_FileShared(reqId, webFileID, sharee, newSession, newMsgXmppID, result);
        }
    }

    private void Indicate_FileUnshared(String reqId, String webFileID, int result) {
        if (StringUtil.isSameString((String)reqId, (String)this.mUnshareReqId)) {
            this.mFileListview.Indicate_FileUnshared(reqId, webFileID, result);
        }
    }

    public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        this.mFileListview.Indicate_RenameFileResponse(result, reqId, fileId, newName);
    }

    public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        this.mFileListview.Indicate_FileActionStatus(actionType, fileId, actionOwner, fileName, sessionId, msgId);
    }

    public void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        this.mFileListview.Indicate_QuerySessionFilesResponse(reqId, session, result, arrWebFileID, queryEndTime);
        this.mImagesListview.Indicate_QuerySessionFilesResponse(reqId, session, result, arrWebFileID, queryEndTime);
    }

    public void Indicate_NewFileSharedByOthers(String fileID) {
        this.mFileListview.Indicate_NewFileSharedByOthers(fileID);
    }

    public void NotifyOutdatedHistoryRemoved(List<String> sessionIDs, long eraseTime) {
        if (sessionIDs != null && sessionIDs.contains(this.mSessionId)) {
            this.mFileListview.setEraseTime(eraseTime, true);
            this.mFileListview.notifyDataSetChanged(true);
        }
    }

    private void showWaitDialog() {
        this.mWaitingDialog = new WaitingDialog(this.getString(R.string.zm_msg_waiting));
        this.mWaitingDialog.setCancelable(true);
        this.mWaitingDialog.show(this.getFragmentManager(), "WaitingDialog");
    }

    private void dismissWaitingDialog() {
        if (this.mWaitingDialog == null) {
            FragmentManager fm = this.getFragmentManager();
            if (fm == null) {
                return;
            }
            this.mWaitingDialog = (WaitingDialog)fm.findFragmentByTag("WaitingDialog");
        }
        if (this.mWaitingDialog != null) {
            this.mWaitingDialog.dismissAllowingStateLoss();
        }
        this.mWaitingDialog = null;
    }

    public void dismiss() {
        this.finishFragment(true);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 2014: {
                if (resultCode != -1 || data == null) break;
                Bundle bundle = data.getExtras();
                if (bundle == null) {
                    return;
                }
                String messageId = bundle.getString(ARGS_SHARE_FILE_ID);
                if (StringUtil.isEmptyOrNull((String)messageId)) {
                    return;
                }
                String jid = data.getStringExtra("selectedItem");
                if (StringUtil.isEmptyOrNull((String)jid)) {
                    return;
                }
                ArrayList<String> sharees = new ArrayList<String>();
                sharees.add(jid);
                if (sharees.size() <= 0) break;
                this.doShareFile(sharees, messageId);
                break;
            }
            case 3001: {
                if (resultCode != -1 || data == null) break;
                int action = data.getIntExtra("action", 0);
                String fileWebId = data.getStringExtra("zoomFileWebId");
                String reqId = data.getStringExtra("reqId");
                this.dealResultForZoomFileViewer(action, fileWebId, reqId);
                break;
            }
            case 2015: {
                if (resultCode != -1 || data == null) break;
                this.mShareReqId = data.getStringExtra("reqId");
            }
        }
    }

    private void dealResultForZoomFileViewer(int action, String fileWebId, String reqId) {
        if (StringUtil.isEmptyOrNull((String)fileWebId)) {
            return;
        }
        switch (action) {
            case 1: {
                this.Indicate_FileDeleted(reqId, fileWebId, 0);
                break;
            }
        }
    }

    private void doShareFile(ArrayList<String> sharees, String fileID) {
        MMShareZoomFileDialogFragment.showShareFileDialog(this.getFragmentManager(), sharees, fileID, (Fragment)this, 2015);
    }

    @Override
    public void onZoomFileClick(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMContentFileViewerFragment.showAsActivity((Fragment)this, this.mSessionId, "", "", fileId, 3001);
    }

    @Override
    public void onZoomFileShared(String fileId) {
        Bundle bundle = new Bundle();
        bundle.putString(ARGS_SHARE_FILE_ID, fileId);
        MMSelectSessionAndBuddyFragment.showAsFragment((Fragment)this, bundle, false, false, 2014);
    }

    @Override
    public void onZoomFileCancelTransfer(String fileId) {
        boolean res;
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        String reqId = null;
        boolean isUpload = PendingFileDataHelper.getInstance().isFileUploadNow(fileId);
        if (!isUpload) {
            PendingFileDataHelper.PendingFileInfo info = PendingFileDataHelper.getInstance().getDownloadPendingInfoByWebFileId(fileId);
            if (info != null) {
                reqId = info.reqId;
            }
        } else {
            reqId = fileId;
        }
        if (StringUtil.isEmptyOrNull((String)reqId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr != null && (res = mgr.cancelFileTransfer(reqId, fileId))) {
            this.mFileListview.endFileTransfer(fileId);
            PendingFileDataHelper.getInstance().removeUploadPendingFile(fileId);
            PendingFileDataHelper.getInstance().removeDownloadPendingFile(fileId);
        }
    }

    @Override
    public void onZoomFileSharerAction(String fileId, MMZoomShareAction action) {
    }

    private void onSelectSharerActionContextMenuItem(SharerActionContextMenuItem mi) {
        if (mi == null) {
            return;
        }
        switch (mi.getAction()) {
            case 0: {
                MMChatActivity.showAsGroupChat((ZMActivity)this.getActivity(), mi.mShareAction.getSharee());
                break;
            }
            case 1: {
                UnshareAlertDialog.showUnshareAlertDialog(this.getFragmentManager(), mi.mFileId, mi.mShareAction);
                break;
            }
        }
    }

    private void unshareZoomFile(String fileId, MMZoomShareAction action) {
        if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<String> sharees = new ArrayList<String>();
        sharees.add(action.getSharee());
        this.mUnshareReqId = mgr.unshareFile(fileId, sharees);
        if (StringUtil.isEmptyOrNull((String)this.mUnshareReqId)) {
            this.handelFileUnsharedErrorCode(-1);
        }
    }

    private void showConnectionError() {
        FragmentActivity context = this.getActivity();
        if (context == null) {
            return;
        }
        Toast.makeText((Context)context, (int)R.string.zm_msg_disconnected_try_again, (int)0).show();
    }

    private void handelFileUnsharedErrorCode(int code) {
        if (code == 0) {
            return;
        }
        String msg = this.getString(R.string.zm_alert_unshare_file_failed);
        ErrorMsgDialog.newInstance(msg, -1).show(this.getFragmentManager(), ErrorMsgDialog.class.getName());
    }

    public static class UnshareAlertDialog
    extends ZMDialogFragment {
        static final String ARG_FILE_ID = "fileId";
        static final String ARG_SHARE_ACTION = "shareAction";
        private String mFileId;
        private MMZoomShareAction mAction;

        public static void showUnshareAlertDialog(FragmentManager fm, String fileId, MMZoomShareAction action) {
            if (StringUtil.isEmptyOrNull((String)fileId) || action == null) {
                return;
            }
            UnshareAlertDialog dialog = new UnshareAlertDialog();
            Bundle args = new Bundle();
            args.putString(ARG_FILE_ID, fileId);
            args.putSerializable(ARG_SHARE_ACTION, (Serializable)action);
            dialog.setArguments(args);
            dialog.show(fm, UnshareAlertDialog.class.getName());
        }

        public UnshareAlertDialog() {
            this.setCancelable(true);
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            if (args != null) {
                this.mFileId = args.getString(ARG_FILE_ID);
                this.mAction = (MMZoomShareAction)args.getSerializable(ARG_SHARE_ACTION);
            }
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_alert_unshare_msg).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MMSessionContentsFragment fragment = (MMSessionContentsFragment)UnshareAlertDialog.this.getFragmentManager().findFragmentByTag(MMSessionContentsFragment.class.getName());
                    if (fragment != null) {
                        fragment.unshareZoomFile(UnshareAlertDialog.this.mFileId, UnshareAlertDialog.this.mAction);
                    }
                }
            }).setNegativeButton(R.string.zm_btn_cancel, null).create();
        }
    }

    public static class SharerActionContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_JUMP = 0;
        public static final int ACTION_UNSHARE = 1;
        private String mFileId;
        private MMZoomShareAction mShareAction;

        public SharerActionContextMenuItem(String label, int action, String fileId, MMZoomShareAction shareAction) {
            super(action, label);
            this.mFileId = fileId;
            this.mShareAction = shareAction;
        }
    }
}

