/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.fragment.MMSelectSessionFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMSelectSessionListAdapter;
import com.zipow.videobox.view.mm.MMSelectSessionListItem;
import us.zoom.androidlib.util.StringUtil;

public class MMSelectSessionListView
extends ListView
implements AdapterView.OnItemClickListener {
    private static final String TAG = MMSelectSessionListView.class.getSimpleName();
    private MMSelectSessionListAdapter mAdapter;
    private boolean mLoaded = false;
    private MMSelectSessionFragment mParentFragment;
    private MemCache<String, Drawable> mAvatarCache = new MemCache(10);
    private Handler mHandler = new Handler();
    private Runnable mTaskLazyNotifyDataSetChanged = null;

    public MMSelectSessionListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMSelectSessionListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMSelectSessionListView(Context context) {
        super(context);
        this.initView();
    }

    public void setParentFragment(MMSelectSessionFragment fragment) {
        this.mParentFragment = fragment;
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    public void onParentFragmentResume() {
        this.loadData(false);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onParentFragmentStart() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onParentFragmentPause() {
        this.mAvatarCache.clear();
    }

    private void initView() {
        this.mAdapter = new MMSelectSessionListAdapter(this.getContext());
        this.mAdapter.setAvatarCache(this.mAvatarCache);
        if (this.isInEditMode()) {
            this._editmode_loadData(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
    }

    private void _editmode_loadData(MMSelectSessionListAdapter adapter) {
        for (int i = 0; i < 5; ++i) {
            MMSelectSessionListItem item = new MMSelectSessionListItem();
            item.setSessionId(String.valueOf(i));
            item.setTitle("Buddy " + (i + 1));
            item.setIsGroup(false);
            adapter.addItem(item);
        }
    }

    public void loadData(boolean ignoreIfLoaded) {
        if (this.mLoaded && ignoreIfLoaded) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mAdapter.clear();
        int cntSessions = messenger.getChatSessionCount();
        for (int i = 0; i < cntSessions; ++i) {
            ZoomChatSession session = messenger.getSessionAt(i);
            if (session == null) continue;
            this.addSessionToAdapter(this.mAdapter, session, messenger, false);
        }
        this.mLoaded = true;
    }

    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(false);
    }

    public void notifyDataSetChanged(boolean disableLazyLoadAvatar) {
        if (disableLazyLoadAvatar) {
            this.mAdapter.setLazyLoadAvatarDisabled(true);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MMSelectSessionListView.this.mAdapter.setLazyLoadAvatarDisabled(false);
                }
            }, 1000L);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void onIndicateBuddyInfoUpdated(String phoneNumber) {
        if (!this.mParentFragment.isResumed()) {
            this.loadData(false);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean dataUpdated = false;
        int count = this.mAdapter.getChatsItemsCount();
        for (int i = 0; i < count; ++i) {
            MMSelectSessionListItem item = this.mAdapter.getChatsItem(i);
            if (item == null || !item.isBuddyWithPhoneNumberInSession(phoneNumber)) continue;
            ZoomChatSession session = messenger.getSessionById(item.getSessionId());
            this.mAvatarCache.removeItem(item.getSessionId());
            if (session != null) {
                this.addSessionToAdapter(this.mAdapter, session, messenger, true);
            }
            dataUpdated = true;
        }
        if (dataUpdated && this.mParentFragment.isResumed()) {
            this.lazyNotifyDataSetChanged();
        }
    }

    public void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (!this.mParentFragment.isResumed()) {
            this.loadData(false);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean dataUpdated = false;
        int count = this.mAdapter.getChatsItemsCount();
        for (int i = 0; i < count; ++i) {
            MMSelectSessionListItem item = this.mAdapter.getChatsItem(i);
            if (item == null || !item.isBuddyWithJIDInSession(jid)) continue;
            ZoomChatSession session = messenger.getSessionById(item.getSessionId());
            this.mAvatarCache.removeItem(item.getSessionId());
            if (session != null) {
                this.addSessionToAdapter(this.mAdapter, session, messenger, true);
            }
            dataUpdated = true;
        }
        if (dataUpdated && this.mParentFragment.isResumed()) {
            this.lazyNotifyDataSetChanged();
        }
    }

    private void lazyNotifyDataSetChanged() {
        if (this.mTaskLazyNotifyDataSetChanged == null) {
            this.mTaskLazyNotifyDataSetChanged = new Runnable(){

                @Override
                public void run() {
                    if (MMSelectSessionListView.this.mParentFragment.isResumed()) {
                        MMSelectSessionListView.this.notifyDataSetChanged(true);
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mTaskLazyNotifyDataSetChanged);
        this.mHandler.postDelayed(this.mTaskLazyNotifyDataSetChanged, 1000L);
    }

    public void filter(String filter) {
        this.mAdapter.filter(filter);
    }

    private void addSessionToAdapter(MMSelectSessionListAdapter adapter, ZoomChatSession session, ZoomMessenger messenger, boolean override) {
        ZoomMessage message;
        String title = "";
        boolean isGroup = session.isGroup();
        ZoomGroup group = null;
        ZoomBuddy buddy = null;
        if (isGroup) {
            group = session.getSessionGroup();
            if (group == null) {
                return;
            }
            title = group.getGroupDisplayName(this.getContext());
        } else {
            buddy = session.getSessionBuddy();
            if (buddy == null) {
                return;
            }
            title = BuddyNameUtil.getBuddyDisplayName(buddy, null);
        }
        MMSelectSessionListItem item = new MMSelectSessionListItem();
        item.setSessionId(session.getSessionId());
        item.setTitle(title);
        item.setIsGroup(isGroup);
        String avatar = null;
        if (!isGroup) {
            avatar = buddy.getLocalPicturePath();
            item.setAvatar(avatar);
            IMAddrBookItem abItem = IMAddrBookItem.fromZoomBuddy(buddy);
            if (abItem != null) {
                abItem.setJid(buddy.getJid());
                item.setFromContact(abItem);
            }
        }
        if ((message = session.getLastMessage()) == null) {
            item.setTimeStamp(0L);
            if (override) {
                adapter.removeItem(session.getSessionId());
            }
            if (!session.isGroup()) {
                return;
            }
            adapter.addItem(item);
            return;
        }
        item.setTimeStamp(message.getStamp());
        adapter.addItem(item);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position);
        if (oItem instanceof MMSelectSessionListItem) {
            this.onClickChatItem((MMSelectSessionListItem)oItem);
        }
    }

    private void onClickChatItem(MMSelectSessionListItem item) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(item.getSessionId());
        if (session == null) {
            return;
        }
        if (session.isGroup()) {
            ZoomGroup group = session.getSessionGroup();
            if (group == null) {
                return;
            }
            String groupId = group.getGroupID();
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            this.startGroupChat(groupId);
        } else {
            ZoomBuddy buddy = session.getSessionBuddy();
            if (buddy == null) {
                return;
            }
            this.startOneToOneChat(buddy);
        }
    }

    private void startOneToOneChat(ZoomBuddy buddy) {
        if (this.mParentFragment != null) {
            this.mParentFragment.startOneToOneChat(buddy);
        }
    }

    private void startGroupChat(String groupId) {
        if (this.mParentFragment != null) {
            this.mParentFragment.startGroupChat(groupId);
        }
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String sessionId = action.getGroupId();
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mAdapter.removeItem(sessionId);
        } else {
            this.addSessionToAdapter(this.mAdapter, session, messenger, true);
        }
        switch (action.getActionType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mAvatarCache.removeItem(sessionId);
            }
        }
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)groupID)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(groupID);
        if (session == null) {
            this.mAdapter.removeItem(groupID);
        } else {
            this.addSessionToAdapter(this.mAdapter, session, messenger, true);
        }
        this.mAvatarCache.removeItem(groupID);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }
}

