/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import com.zipow.videobox.view.mm.MMZoomGroupComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectGroupListView
extends ListView {
    private MMSelectGroupAdapter mAdapter;

    public MMSelectGroupListView(Context context) {
        super(context);
        this.init();
    }

    public MMSelectGroupListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMSelectGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mAdapter = new MMSelectGroupAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void updateUI() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<MMZoomGroup> groups = new ArrayList<MMZoomGroup>();
        for (int i = 0; i < messenger.getGroupCount(); ++i) {
            ZoomGroup group = messenger.getGroupAt(i);
            groups.add(MMZoomGroup.initWithZoomGroup(group));
        }
        this.mAdapter.setData(groups);
        this.mAdapter.notifyDataSetChanged();
    }

    public MMZoomGroup getItem(int position) {
        Object o = this.mAdapter.getItem(position - this.getHeaderViewsCount());
        if (o instanceof MMZoomGroup) {
            return (MMZoomGroup)o;
        }
        return null;
    }

    public void updateGroup(String groupId) {
        if (!StringUtil.isEmptyOrNull((String)groupId)) {
            this.mAdapter.updateGroup(groupId);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void removeGroup(String groupId) {
        if (!StringUtil.isEmptyOrNull((String)groupId)) {
            this.mAdapter.removeGroup(groupId);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setFilter(String filter) {
        this.mAdapter.setFilter(filter);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onItemClicked(String groupId) {
        this.mAdapter.onItemClicked(groupId);
        this.mAdapter.notifyDataSetChanged();
    }

    public void unselectBuddy(String groupId) {
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return;
        }
        this.mAdapter.unselectBuddy(groupId);
        this.mAdapter.notifyDataSetChanged();
    }

    public void setIsMultSelect(boolean mIsMultSelect) {
        this.mAdapter.setIsMultSelect(mIsMultSelect);
    }

    public void setPreSelects(List<String> mPreSelects) {
        this.mAdapter.setPreSelects(mPreSelects);
    }

    public ArrayList<String> getSelectedBuddies() {
        return this.mAdapter.getSelectedBuddies();
    }

    public boolean isGroupSelected(String grougId) {
        return this.mAdapter.isGroupSelected(grougId);
    }

    static class MMSelectGroupAdapter
    extends BaseAdapter {
        private static final String TAG_GROUPS_LABEL = "label";
        private static final String TAG_GROUPS_ITEM = "item";
        private Context mContext;
        private List<MMZoomGroup> mData = new ArrayList<MMZoomGroup>();
        private List<MMZoomGroup> mDisplayData = new ArrayList<MMZoomGroup>();
        private ArrayList<String> mSelects = new ArrayList();
        private String mKey;
        private boolean mIsMultSelect = false;
        private List<String> mPreSelects = null;

        public MMSelectGroupAdapter(Context context) {
            this.mContext = context;
        }

        public void setFilter(String key) {
            this.mKey = key;
        }

        public boolean isGroupSelected(String grougId) {
            return this.mSelects.contains(grougId);
        }

        public void updateGroup(String groupId) {
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            ZoomGroup group = messenger.getGroupById(groupId);
            if (group == null) {
                return;
            }
            if (!group.amIInGroup() || group.getBuddyCount() <= 2) {
                this.removeGroup(groupId);
                this.mSelects.remove(groupId);
            } else {
                this.mData.add(MMZoomGroup.initWithZoomGroup(group));
            }
        }

        public void removeGroup(String groupId) {
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            this.mSelects.remove(groupId);
            for (int i = 0; i < this.mData.size(); ++i) {
                MMZoomGroup group = this.mData.get(i);
                if (!StringUtil.isSameString((String)groupId, (String)group.getGroupId())) continue;
                this.mData.remove(i);
                break;
            }
        }

        public void setData(List<MMZoomGroup> groups) {
            if (CollectionsUtil.isListEmpty(groups)) {
                return;
            }
            this.mData.clear();
            for (MMZoomGroup group : groups) {
                if (group.getMemberCount() <= 2) continue;
                this.mData.add(group);
            }
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(this.mData, comparator);
        }

        public void onItemClicked(String groupId) {
            if (StringUtil.isEmptyOrNull((String)groupId) || this.mPreSelects != null && this.mPreSelects.contains(groupId)) {
                return;
            }
            if (!this.mSelects.contains(groupId)) {
                this.mSelects.add(groupId);
            } else {
                this.mSelects.remove(groupId);
            }
        }

        public void unselectBuddy(String groupId) {
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            this.mSelects.remove(groupId);
        }

        public void setIsMultSelect(boolean mIsMultSelect) {
            this.mIsMultSelect = mIsMultSelect;
        }

        public void setPreSelects(List<String> mPreSelects) {
            this.mPreSelects = mPreSelects;
        }

        public ArrayList<String> getSelectedBuddies() {
            return this.mSelects;
        }

        public int getCount() {
            return this.mDisplayData.size();
        }

        public Object getItem(int position) {
            if (position < 0 || position >= this.mDisplayData.size()) {
                return null;
            }
            return this.mDisplayData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            Object o = this.getItem(position);
            if (o instanceof MMZoomGroup) {
                return 0;
            }
            return 1;
        }

        public void notifyDataSetChanged() {
            this.sortAll();
            super.notifyDataSetChanged();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object item = this.getItem(position);
            if (item == null) {
                return null;
            }
            if (item instanceof MMZoomGroup) {
                return this.createGroupsItem((MMZoomGroup)item, convertView, parent);
            }
            return this.createGroupsLabel(item.toString(), convertView, parent);
        }

        private View createGroupsLabel(String label, View convertView, ViewGroup parent) {
            if (convertView == null || !TAG_GROUPS_LABEL.equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
                convertView.setTag((Object)TAG_GROUPS_LABEL);
            }
            TextView txtHeaderLabel = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
            txtHeaderLabel.setText((CharSequence)label);
            return convertView;
        }

        private View createGroupsItem(MMZoomGroup group, View convertView, ViewGroup parent) {
            if (convertView == null || !TAG_GROUPS_ITEM.equals(convertView.getTag())) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_contacts_group_item, null);
                convertView.setTag((Object)TAG_GROUPS_LABEL);
            }
            AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
            TextView txtGroupName = (TextView)convertView.findViewById(R.id.txtGroupName);
            TextView txtMemberNo = (TextView)convertView.findViewById(R.id.txtMemberNo);
            TextView txtGroupDes = (TextView)convertView.findViewById(R.id.txtGroupdes);
            CheckedTextView checked = (CheckedTextView)convertView.findViewById(R.id.check);
            avatarView.setAvatar(new GroupAvatarDrawable_v2(group.getGroupId()));
            txtGroupName.setText((CharSequence)group.getGroupName());
            txtMemberNo.setText((CharSequence)String.format("(%s)", group.getMemberCount()));
            if (this.mIsMultSelect) {
                checked.setVisibility(0);
                if (this.mPreSelects != null && this.mPreSelects.contains(group.getGroupId())) {
                    checked.setEnabled(false);
                    checked.setChecked(true);
                } else {
                    checked.setEnabled(true);
                    checked.setChecked(this.mSelects.contains(group.getGroupId()));
                }
            } else {
                checked.setVisibility(8);
            }
            txtGroupDes.setVisibility(8);
            return convertView;
        }

        private void sortAll() {
            this.mDisplayData.clear();
            for (MMZoomGroup group : this.mData) {
                if (StringUtil.isEmptyOrNull((String)group.getGroupName()) || !StringUtil.isEmptyOrNull((String)this.mKey) && !group.getGroupName().contains(this.mKey) || this.mPreSelects.contains(group.getGroupId())) continue;
                this.mDisplayData.add(group);
            }
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(this.mDisplayData, comparator);
        }
    }
}

