/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.PresenceStateView;
import com.zipow.videobox.view.mm.MMSelectContactsListItem;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSelectContactsListItemView
extends LinearLayout {
    private MMSelectContactsListItem mItem;
    private TextView mTxtScreenName;
    private TextView mTxtNotes;
    private AvatarView mAvatarView;
    private CheckedTextView mCheckbox;
    private ProgressBar mProgressBar;
    private TextView mTxtContactsDescrption;
    private boolean mShowPresence = false;
    private boolean mIsHidePresencePanel = false;
    private PresenceStateView mPresenceStateView;
    private Handler mHandler = new Handler();

    public MMSelectContactsListItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMSelectContactsListItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtNotes = (TextView)this.findViewById(R.id.txtEmail);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBarLoading);
        this.mCheckbox = (CheckedTextView)this.findViewById(R.id.check);
        this.mPresenceStateView = (PresenceStateView)this.findViewById(R.id.presenceStateView);
        this.mTxtContactsDescrption = (TextView)this.findViewById(R.id.txtContactsDescrption);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_select_contacts_list_item, (ViewGroup)this);
    }

    public void setContactsDesc(String descrption) {
        this.mTxtContactsDescrption.setText((CharSequence)descrption);
        this.mTxtContactsDescrption.setVisibility(StringUtil.isEmptyOrNull((String)descrption) ? 8 : 0);
    }

    public void setScreenName(CharSequence name) {
        if (name != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText(name);
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(name);
        }
    }

    public void setNotes(String notes, boolean isShowLoading) {
        if (this.mTxtNotes != null) {
            if (notes != null) {
                if (isShowLoading) {
                    this.mProgressBar.setVisibility(4);
                    this.mCheckbox.setVisibility(0);
                }
                this.mTxtNotes.setText((CharSequence)notes);
                this.mTxtNotes.setVisibility(0);
            } else {
                if (isShowLoading) {
                    this.mProgressBar.setVisibility(0);
                    this.mCheckbox.setVisibility(4);
                }
                this.mTxtNotes.setVisibility(8);
            }
        }
    }

    public void setAvatar(String imgPathName) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(imgPathName);
        }
    }

    public void setAvatar(Drawable drawable2) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(drawable2, 0);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    private void setChecked(boolean bChecked) {
        if (this.mCheckbox != null) {
            this.mCheckbox.setChecked(bChecked);
        }
    }

    public void setSlashCommand(MMSelectContactsListItem item) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        IMAddrBookItem addrBookItem = this.mItem.getAddrBookItem();
        if (addrBookItem == null) {
            return;
        }
        this.setContactsDesc(addrBookItem.getRobotCmdPrefix());
    }

    public void setContactItem(MMSelectContactsListItem item, MemCache<String, Bitmap> avatarCache, boolean disableLazyLoadAvatar, boolean isShowEmail, boolean isShowLoading) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        String name = this.mItem.screenName;
        String notes = this.mItem.phoneNumber;
        if (notes == null) {
            notes = this.mItem.email;
        }
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = notes;
            this.setNotes(null, isShowLoading);
        } else {
            this.setNotes(this.mItem.isShowNotes() ? notes : null, isShowLoading);
        }
        if (isShowEmail && !StringUtil.isEmptyOrNull((String)this.mItem.email)) {
            this.setNotes(this.mItem.email, isShowLoading);
        }
        this.setScreenName(name);
        if (this.mAvatarView != null) {
            this.mAvatarView.setBgColorSeedString(this.mItem.buddyJid);
        }
        this.setChecked(this.mItem.isChecked());
        this.loadPresenceStatus();
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        if (disableLazyLoadAvatar) {
            this.loadAvatar(this.mItem, context, false, avatarCache);
        } else if (!this.loadAvatar(this.mItem, context, true, avatarCache)) {
            this.lazyLoadAvatar(this.mItem, context, avatarCache);
        }
    }

    private void loadPresenceStatus() {
        if (this.mIsHidePresencePanel) {
            this.mPresenceStateView.setVisibility(8);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            this.mPresenceStateView.setVisibility(8);
            return;
        }
        IMAddrBookItem addrItem = this.mItem.getAddrBookItem();
        if (addrItem == null) {
            return;
        }
        boolean isBuddy = messenger.isMyContact(addrItem.getJid());
        if (!(isBuddy || PTApp.getInstance().isPhoneNumberRegistered() && addrItem.getContactId() >= 0)) {
            this.mPresenceStateView.setVisibility(4);
            return;
        }
        if (this.mShowPresence) {
            this.mPresenceStateView.setState(addrItem);
        }
    }

    private void lazyLoadAvatar(final MMSelectContactsListItem item, final Context context, final MemCache<String, Bitmap> avatarCache) {
        this.setAvatar((String)null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (MMSelectContactsListItemView.this.mItem != item) {
                    return;
                }
                MMSelectContactsListItemView.this.loadAvatar(item, context, false, avatarCache);
            }
        }, 300L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadAvatar(MMSelectContactsListItem item, Context context, boolean fromMemCacheOnly, MemCache<String, Bitmap> avatarCache) {
        Bitmap bitmap;
        String avatar = item.getAvatar();
        if (StringUtil.isEmptyOrNull((String)avatar)) {
            Bitmap bitmap2;
            if (!item.isAddrBookItem()) return true;
            IMAddrBookItem abItem = item.getAddrBookItem();
            if (abItem == null) return false;
            if (avatarCache != null && (bitmap2 = avatarCache.getCachedItem(String.valueOf(abItem.getContactId()))) != null) {
                this.setAvatar(bitmap2);
                return true;
            }
            bitmap2 = abItem.getAvatarBitmap(context, fromMemCacheOnly);
            this.setAvatar(bitmap2);
            if (bitmap2 == null) return false;
            if (avatarCache == null) return true;
            avatarCache.cacheItem(String.valueOf(abItem.getContactId()), bitmap2);
            return true;
        }
        if (avatarCache != null && (bitmap = avatarCache.getCachedItem(avatar)) != null) {
            this.setAvatar(bitmap);
            return true;
        }
        File file = new File(avatar);
        if (!file.exists() || !file.isFile()) return false;
        Bitmap bitmap3 = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly);
        if (bitmap3 != null) {
            this.setAvatar(bitmap3);
            if (avatarCache == null) return true;
            avatarCache.cacheItem(avatar, bitmap3);
            return true;
        }
        this.setAvatar((Bitmap)null);
        return false;
    }

    public void setCheckDisabled(boolean disabled) {
        this.mCheckbox.setEnabled(!disabled);
    }

    public void setCheckVisible(boolean visible) {
        this.mCheckbox.setVisibility(visible ? 0 : 8);
    }

    public void setShowPresence(boolean show) {
        this.mShowPresence = show;
        this.loadPresenceStatus();
    }

    public void setHidePresencePanel(boolean isHide) {
        this.mIsHidePresencePanel = isHide;
        if (isHide) {
            this.mPresenceStateView.setVisibility(8);
        } else {
            this.mPresenceStateView.setVisibility(0);
        }
    }
}

